/*
 * Decompiled with CFR 0.152.
 */
package lambda.ast;

import java.util.HashSet;
import java.util.Set;
import lambda.Environment;
import lambda.ast.ASTApply;
import lambda.ast.ASTLiteral;
import lambda.ast.IDContext;
import lambda.ast.Lambda;
import lambda.ast.RenameGenerator;
import lambda.ast.VariableCollector;
import util.Pair;

public class ASTAbstract
extends Lambda {
    public final String originalName;
    public final String name;
    public final Lambda e;
    public static int varid = 0;

    public ASTAbstract(String originalName, String name, Lambda e) {
        this.originalName = originalName;
        this.name = name;
        this.e = e;
    }

    @Override
    public boolean isAbstraction() {
        return true;
    }

    @Override
    public int getPrec() {
        return 3;
    }

    @Override
    public Pair<Boolean, Lambda> betaReduction(IDContext context, Environment env) {
        IDContext nc = IDContext.deriveContext(context);
        nc.addBoundedName(this.name);
        Pair<Boolean, Lambda> p = this.e.betaReduction(nc, env);
        if (((Boolean)p._1).booleanValue()) {
            return p.snd(new ASTAbstract(this.originalName, this.name, (Lambda)p._2));
        }
        return p.snd(this);
    }

    @Override
    public Pair<Boolean, Lambda> etaReduction() {
        if (this.e instanceof ASTApply) {
            ASTApply app = (ASTApply)this.e;
            if (app.rexpr instanceof ASTLiteral) {
                ASTLiteral x = (ASTLiteral)app.rexpr;
                VariableCollector vc = new VariableCollector(app.lexpr);
                Set<String> fv = vc.getFreeVariables();
                if (!fv.contains(x.name)) {
                    return Pair.of(true, app.lexpr);
                }
            }
        }
        return new Pair<Boolean, Lambda>(false, this);
    }

    @Override
    protected Lambda apply(IDContext context, Lambda lambda) {
        IDContext nc = IDContext.deriveContext(context);
        nc.addBoundedName(this.name);
        Lambda e2 = this.e.substitute(nc, this.name, lambda);
        return e2;
    }

    protected Lambda substitute2(IDContext context, String name, Lambda lambda) {
        String v = "$" + varid++;
        ASTLiteral fresh = new ASTLiteral(this.originalName, v);
        return new ASTAbstract(this.originalName, v, this.e.substitute(context, this.name, fresh).substitute(context, name, lambda));
    }

    @Override
    protected Lambda substitute(IDContext context, String name, Lambda lambda) {
        if (this.name.equals(name)) {
            return this;
        }
        VariableCollector vc = new VariableCollector(lambda);
        Set<String> fv = vc.getFreeVariables();
        ASTAbstract l = this;
        if (!fv.isEmpty()) {
            l = this.rename(context, fv);
        }
        IDContext nc = IDContext.deriveContext(context);
        nc.addBoundedName(l.name);
        Lambda e2 = l.e.substitute(nc, name, lambda);
        return l == this && e2 == this.e ? this : new ASTAbstract(this.originalName, l.name, e2);
    }

    private ASTAbstract rename(IDContext context, Set<String> fv) {
        VariableCollector vc = new VariableCollector(this);
        RenameGenerator renamer = new RenameGenerator(fv);
        HashSet<String> bv = new HashSet<String>(context.getBoundedNames());
        bv.addAll(vc.getBoundedVariables());
        return (ASTAbstract)renamer.rename(bv, this);
    }

    @Override
    public <T, U> T accept(Lambda.Visitor<T, U> visitor, U param) {
        return visitor.visitAbstract(this, param);
    }
}

