/*
 * Decompiled with CFR 0.152.
 */
package lambda;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Scanner;
import lambda.Environment;
import lambda.LambdaInterpreter;
import lambda.ast.ASTAbstract;
import lambda.ast.Lambda;
import lambda.ast.MacroExpander;
import lambda.ast.parser.Lexer;
import lambda.ast.parser.Parser;
import lambda.ast.parser.ParserException;
import lambda.conversion.Converter;
import lambda.system.CommandDelegate;
import lambda.system.CommandProcessor;
import util.nullable.NullableBool;
import util.nullable.NullableInt;

public class Main {
    private static final Environment env = Environment.load("properties.txt");
    private static final CommandProcessor commands = new CommandProcessor();

    private static char readChar() {
        String line;
        char c = ' ';
        Scanner scan = new Scanner(System.in);
        if (scan.hasNext() && (line = scan.nextLine().trim()).length() > 0) {
            c = Character.toLowerCase(line.charAt(0));
        }
        return c;
    }

    /*
     * Unable to fully structure code
     */
    private static Lambda parse(String text) {
        parser = new Parser(new Lexer(text));
        try {
            return parser.parse();
        }
        catch (ParserException e) {
            s = "";
            i = 0;
            ** while (i < e.column)
        }
lbl-1000:
        // 1 sources

        {
            s = String.valueOf(s) + ' ';
            ++i;
            continue;
        }
lbl11:
        // 1 sources

        System.out.println(text);
        System.out.println(String.valueOf(s) + '^');
        System.out.println("- " + e.getMessage());
        return null;
    }

    private static void defineMacro(String name, String expr) {
        Lambda lambda = Main.parse(expr);
        if (lambda != null) {
            env.defineMacro(name, lambda);
            String s = String.format("- <%s> is defined as %s", name, lambda);
            System.out.println(s);
        }
    }

    private static void readMacroDefinition(String s, int line) {
        if (s.contains("=")) {
            String[] v = s.split("\\s*=\\s*");
            if (v.length == 2) {
                Main.defineMacro(v[0], v[1]);
            } else {
                System.out.println("- Invalid macro definition: " + s + " at line " + line);
            }
        } else {
            System.out.println("- Line " + line + " is not a macro definition");
        }
    }

    private static void evalLine(String line) {
        if (line.contains("=")) {
            Main.readMacroDefinition(line, 1);
        } else {
            Lambda lambda = Main.parse(line);
            if (lambda == null) {
                return;
            }
            System.out.println(lambda);
            ASTAbstract.varid = 0;
            LambdaInterpreter interpreter = new LambdaInterpreter(lambda);
            int continueSteps = env.getInt("continue_steps", 500);
            int step = 1;
            boolean interrupted = false;
            while (interpreter.step(env)) {
                if (env.getBoolean("trace")) {
                    String s = interpreter.getLambda().toString();
                    if (env.getBoolean("short") && s.length() > 75) {
                        s = String.valueOf(s.substring(0, 35)) + " ... " + s.substring(s.length() - 35, s.length());
                    }
                    System.out.printf("%3d: ", step);
                    System.out.println("--> " + s);
                }
                if (continueSteps > 0 && step % continueSteps == 0) {
                    char c;
                    do {
                        System.out.printf("- (%d steps done) continue?(y/n): ", step);
                    } while ((c = Main.readChar()) != 'y' && c != 'n');
                    if (c != 'y') {
                        interrupted = true;
                        break;
                    }
                }
                ++step;
            }
            MacroExpander expander = new MacroExpander(env);
            System.out.print("--> " + expander.expand(interpreter.getLambda()));
            if (!interrupted) {
                System.out.print("    ");
                if (interpreter.isCyclic()) {
                    System.out.print("(cyclic reduction)");
                } else {
                    System.out.print("(normal form)");
                }
            }
            System.out.println();
            if (env.getBoolean("data_abstraction")) {
                NullableBool boolValue;
                NullableInt natValue = Converter.toNat(interpreter.getLambda());
                if (natValue.hasValue()) {
                    System.out.println("  = " + natValue + " (as nat)");
                }
                if ((boolValue = Converter.toBool(interpreter.getLambda())).hasValue()) {
                    System.out.println("  = " + boolValue + " (as bool)");
                }
            }
        }
    }

    private static void loadFile(String path) {
        if (!path.endsWith(".lm.txt")) {
            path = String.valueOf(path) + ".lm.txt";
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            System.out.println("- Load '" + path + "'");
            int lineNumber = 1;
            while ((line = reader.readLine()) != null) {
                int c = line.indexOf(35);
                if (c != -1) {
                    line = line.substring(0, c);
                }
                if (!(line = line.trim()).isEmpty()) {
                    Main.readMacroDefinition(line, lineNumber);
                }
                ++lineNumber;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("- Unable to open file \"" + path + "\"");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void initializeCommands() {
        commands.add(":l", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length == 0) {
                    File cd = new File(".");
                    File[] fileArray = cd.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isFile() && file.getName().endsWith(".lm.txt")) {
                            Main.loadFile(file.getName());
                        }
                        ++n2;
                    }
                } else {
                    String[] stringArray = params;
                    int n = params.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String fileName = stringArray[n3];
                        Main.loadFile(fileName);
                        ++n3;
                    }
                }
            }
        });
        commands.add(":f", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length >= 1) {
                    String expr = "";
                    String[] stringArray = params;
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        expr = String.valueOf(expr) + s + " ";
                        ++n2;
                    }
                    Parser parser = new Parser(new Lexer(expr));
                    MacroExpander expander = new MacroExpander(env);
                    try {
                        System.out.println(expander.expand(parser.parse()));
                    }
                    catch (ParserException e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        });
        commands.add(":s", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                block7: {
                    if (params.length >= 1) {
                        try {
                            int n = Integer.parseInt(params[0]);
                            if (n >= 0) {
                                env.set("continue_steps", n);
                                System.out.print("- set continuation steps to ");
                                if (n != 0) {
                                    System.out.println(n);
                                } else {
                                    System.out.println("infinite");
                                }
                                break block7;
                            }
                            System.out.println("- Negative number is not allowed");
                        }
                        catch (NumberFormatException e) {
                            System.out.println("- Illegal number format: " + params[0]);
                        }
                    } else {
                        System.out.println("- continuation steps is " + env.getInt("continue_steps", 500));
                    }
                }
            }
        });
        commands.add(":t", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                if (params.length >= 1) {
                    String s = params[0].toLowerCase();
                    if (s.equals("on") || s.equals("off")) {
                        boolean b = params[0].equals("on");
                        env.set("trace", b);
                        System.out.println("- set trace " + (b ? "on" : "off"));
                    } else {
                        System.out.println("- type 'on' or 'off' to set trace mode");
                    }
                } else {
                    System.out.println("- trace is " + (env.getBoolean("trace") ? "on" : "off"));
                }
            }
        });
        commands.add(":clear", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                env.clearMacros();
                System.out.println("- macros were cleared.");
            }
        });
        commands.add(":m", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                env.dumpMacros();
            }
        });
        commands.add(":pwd", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                System.out.println(new File("").getAbsolutePath());
            }
        });
        commands.add(":short", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                boolean b = !env.getBoolean("short");
                env.set("short", b);
                System.out.println("- set short mode " + (b ? "on" : "off"));
            }
        });
        commands.add(":conv", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                boolean b = !env.getBoolean("data_abstraction");
                env.set("data_abstraction", b);
                System.out.println("- set data conversion mode " + (b ? "on" : "off"));
            }
        });
        commands.add(":?", new CommandDelegate(){

            @Override
            public void commandInvoked(String[] params) {
                System.out.println("- :?            - show this help.");
                System.out.println("- :f <expr>     - expand macros.");
                System.out.println("- :l <name>     - load macro definitions from a text file.");
                System.out.println("- :l            - load *.lm.txt files in current directory.");
                System.out.println("- :s <n>        - set the number of continuation steps.");
                System.out.println("- :s            - show current number of continuation steps.");
                System.out.println("- :t (on|off)   - set trace mode. ");
                System.out.println("- :t            - show current trace mode. ");
                System.out.println("- :m            - list defined macros.");
                System.out.println("- :clear        - clear all macros.");
                System.out.println("- :pwd          - print working directory.");
                System.out.println("- :short        - toggle short print mode.");
                System.out.println("- :conv         - toggle data conversion mode.");
                System.out.println("- :q            - quit interpreter.");
            }
        });
    }

    private static void repl() {
        System.out.println("Lambda Magica version 3.00");
        System.out.println("- Type :? to see command help");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String line;
            System.out.print("> ");
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                System.err.println("- " + e.getMessage());
                break;
            }
            if (line == null) break;
            if ((line = line.trim()).isEmpty()) continue;
            if (line.charAt(0) == ':') {
                if (line.startsWith(":q")) break;
                commands.invokeCommand(line);
                continue;
            }
            Main.evalLine(line);
        }
    }

    public static void main(String[] args) {
        Main.initializeCommands();
        Main.repl();
    }
}

