#!/usr/bin/ruby

require 'find'
require 'uri'
require 'hikidoc.rb'


SED_LIST = ["title", "main", "main_wiki"]

system('rsync -av --delete --exclude=".svn" ./public_html ../')

main_frame_txt = ""
open("main_frame.html") do |f|
  main_frame_txt = f.read
end

base_url = URI::parse("file://" + File.expand_path('../public_html'))
Find.find('../public_html') do |f|
  if f =~ /^.*?\.html$/
    puts f

    base_path =  base_url.route_from("file://" + File.expand_path(f)).to_s
    base_path = "" if base_path == "./"

    sed_txt = Hash.new
    open(f, "r") do |target|
      target_txt = target.read
      SED_LIST.each do |item|
        item_txt = target_txt.scan(/<#{item}>(.*?)<\/#{item}>/m).to_s
        item_txt = HikiDoc.new(item_txt).to_html if item == "main_wiki"
        sed_txt[item] = item_txt
      end
    end

    open(f, "w") do |target|
      txt = main_frame_txt.dup
      SED_LIST.each do |item|
        txt.gsub!("<!-- @#{item}@ -->", sed_txt[item])
      end
      txt.gsub!("<!-- @base_path@ -->", base_path)
      
      target.puts txt
    end
  end
end
