	Evaluation Program for 'Solitaire Poker'  Version 1
					Sep. 11 1997 
					by  Eiji Sugino <sugino@jaist.ac.jp>

1. This package contains followings.

	% ls
	Makefile	README.j	test/		test.sh*
	README.e	dummy/		test.dat	

   (0) This file is 'README.e', and the Japanese version is 'README.j'.
   (1) 'dummy/' provides a dummy program of solitaire poker.
   (2) 'test/'  provides an evaluation program. 
   (3) 'Makefile' is a sample file to compile your program.
   (4) 'test.sh'  is a shell program to execute your program.
   (5) 'test.dat' is a sample data for testing.

2. You should put your program like as following steps.
  They are showed for the dummy program as an example.

   (1) Make a directory (with ANY name)

	% mkdir dummy; cd dummy

   (2) Put your program at the directory. 
       All files take the form of "*.kl1" will be compiled.

	% cp ~myself/*.kl1  .

   (3) Put a 'Makefile' there.
	You can put the same one included this package (see 1-(3)).

	% ln -s ../Makefile Makefile
	% ls 
	Makefile@	solitaire.kl1
                     
3. You can execute your program like followings.

	% ./test.sh  dummy

	'test.sh' requires a directory name, compiles your program 
	at the directory ('dummy/'), and execute it with default parameters. 
	Of course you can specify any value for the parameters as the 
	following.  
	
		% test.sh -seed 7 -time 60 dummy

	'test.sh' randomly generates some cards with the seed, and execute
	your program with the cards. 

    (1)	Execution Example

	When you execute it for 'dummy', you will see like followings.

	% ./test.sh dummy

	klic -v -o ./go  -x . ../test/main.kl1 ../test/dealer.kl1 ....
	KLIC compiler driver version 2.004 (Mon Nov 27 15:50:11 JST 1995)
	/usr/lang/klic-2.004/lib/klic/kl1cmp ../test/main.kl1 </dev/null
	.....
	gcc -o ./go  ./atom.o ./funct.o ./predicates.o ../test/main.o ....
	104  0  0  0  112  
	HT CA S5 D8 HA  ... 128
	S4 SJ H7 DT D5  ... 0
	D2 CT SQ S9 H6  ... 0
	S2 S8 H8 S7 DK  ... 116
	C8 CQ DJ C3 S6  ... 0
	  0 / 116
	 --------------------------- TOTAL=576 TIME=17
	......
	104  0  10812  124  916  
	S5 CA HT HA D8  ... 128
	S4 SJ H7 DT D5  ... 0
	D2 CT S9 SQ H6  ... 0
	S2 S8 H8 S7 C8  ... 2024
	DK C3 DJ CQ S6  ... 0
	  21538 / 116
	 --------------------------- TOTAL=35762 TIME=13484
	=-=-= Time out.
	% 

4. Options for 'test.sh'

	test.sh accepts following options.

	[-seed Seed]	Specify a Seed for the random number generator
			(Default value is 7).
	[-data File] 	Specify a File as initial cards instead of 
			random cards.

			ex.) % ./test.sh -data ../test.dat dummy

	[-time Second] 	Specify a timeout limit (sec).
			If you put anything but integer for Second, 
			you can eliminate timeout.
	[-clean] 	Specify to re-compile programs before the execution.
