		KLIC Programming Contest 97
Parallel Processing Section: "John Conway's Game of Life" Sample Program

							1997/07/30
				KLIC Programming Contest Secretariat

(1) Files in this distribution

Following files are included in this distribution.

README.e		This file

README			Japanese version

main.kl1		Main Routine of The Game of Life in KL1
			(For debugging aids)

Makefile		Makefile, which describes the procedure of compilation

test/			Directory which includes the testing environment
test/Makefile		Makefile for test
test/*.life		Sample input files
test/outputs/*.out	Outputs of sample inputs

game/			Graphical User Interface and other program
			so that you can enjoy The Game of Life


(2) Usage of Main Routine and The Testing Environment

Please implement life:compute/3 in the file "life.kl1", and place it
in the directory where this "README.e" resides.

Using the "make" utility, you can build the executable "life" and test
your program.


(2.1) Makefile

In the "Makefile", the procedure of compilation and invocation of test
is described.  Please edit some parameters such as KLIC and/or KFLAGS
if needed.


(2.2) Main routine "main.kl1"

The file "main.kl1" includes the main routine.  It's offered for
debugging aids. (It is not necessarily means that it is used for
evaluation.)


(2.3) Building the executable "life"

Typing
	% make

builds the executable "life" from the source files of "main.kl1" and
"life.kl1".


(2.4) Usage of the executable "life"

You can invoke the executable "life" in two forms:

	% life

will get input from standard input, when it is invoked with no
argument, while

	% life {file-name}

will get input from the file {file-name}, when the file is specified as
argument.

(2.4.1) Input Format

The format of input is the term of KL1 followed by the period.  The
structure of term is the functor of:
	life(HowManyGenerations,PointList)
where HowManyGenerations specifies the number of generations, and
PointList specifies the list of "on" cell sorted in ascending order.
(p(X0,Y0) < p(X1,Y1) iff Y0<Y1 or (Y0=Y1 and X0<X1)).

See the sample input files (test/*.life) for detail.


(2.4.2) Output Format

Output is the list of "on" cell.  See the sample output files
(test/outputs/*.out) for detail.


(2.5) Testing Environment

Type:
	% make test

in the directory where this "README.e" resides.  For each files in the
directory test/, the executable "life" is executed and output is
saved.  When all the execution ends, each output is compared with
the output prepared (test/outputs/).  "OK" means good computation,
"FAIL" means failure.


(3) Graphical User interface and support program

With Tcl/Tk, you can enjoy the Game of Life, running the program as
back-end, and the graphical user interface as front-end.  Tk 4.2 or
later is required.

Note that this is just an environment for fun, there is no relation
with the evaluation of your program.


(3.1) Preparation

Please change game/Makefile if needed.  Assumes there is "life.kl1"
already.


(3.2) Compilation

Changing directory to "game", please invoke "make".

	% cd game
	% make

The executable "life-backend" and the script "display.tcl" will be build.


(3.3) Invocation of GUI

Typing
	% wish -f display.tcl
you can invoke the Graphical User Interface.

Selecting "Open" in the menu-bar of "File", the dialog box is opened.
Please select the file you want to run.  Then, please select "Run" in
the menu-bar of "File", and input the number of generations.  The
button "Start" start the Game of Life.  You can't use the menu-bar
while the game.  The button "Kill" stops the back-end.
-- 
