	Sample Program to Evaluate Solitaire Poker 

			by Eiji Sugino (sugino@jaist.ac.jp) at Jul.17.1997

Functions: This program evaluate a board generated as a result 
	of the 'Solitaire Poker'.
	And this program includes a ordinary poker game additionally.

Files: This package contains following files;

	README.e	Now you are reading.
	README.j	Japanese version of this file.
	Makefile	make file for installation 
	main.kl1	program driver
	dealer.kl1	cards generation program
	eval.kl1	evaluation program

Installation: You complete with following command.

	% make 

Usage: You can start this program with just following command,

	% ./pk [Seed]

	where you can omit 'Seed' for the random number generator
	and start with a default value.
	Then you can put commands with '.' at the end after the prompt '>'.
	This program provide following commands.

	quit  or exit    : quits this program.
	open(N)		 : provides a new deck of cards with N as a random
			   number seed.
	5		 : deals five cards and you can play the ordinary 
			poker.
	25		 : deals twenty-five cards.
	[card(..),...]   : is set as the current cards.	(The notation is 
			based on the one in the problem material.)
	show		 : shows the current cards you have.
	ch(List)	 : changes cards specified in the 'List'.
			In the 'List', you can mark the first card, second 
			card and following cards as 0,1, and so on 
			respectively. 

Example Expression of Cards:

	Case 1: The ordinary poker (with five cards)

		C6 C2 C3 S4 H5   ... 10787 / straight(20)

		The cards, score and hand are displayed like the above.
		Every card is specified as the suit and rank. 
		The suits, spades,hearts,diamonds and clubs are specified as 
		'S','H','D' and 'C', and the rank, 10,jack,queen,king and ace
		as 'T','J','Q','K' and 'A' respectively.
		A number bracketed after a hand is used for counting the 
		additional score at the inside. 

	Case 2: The solitaire poker (with twenty five cards)

		104  0  0  118  112  				*1
		ST CA C6 H9 HA  ... 128				*2
		S4 SJ H7 DT D5  ... 0				
		D2 DQ SQ S9 H6  ... 124				
		S2 S8 H8 S7 DK  ... 116				
		C8 D7 H3 C3 S6  ... 106				
		  21546 / 116					*3
		 --------------------------- TOTAL=22470	*4

		(*1) It shows scores for the columns.
		(*2) It shows an each score after the line cards.
		(*3) It shows scores for diagonal lines;
			the back-slanting line and slanting line
		(*4) It shows the total score.

Example Usage: 

	% ./pk						opens a game. 
	> 5.						deals five cards.
	CK C2 C3 S4 H5   ... 0 / no_pair
	TIME=0
	> ch([0]).					changes a card (CK).
	D9 C2 C3 S4 H5   ... 0 / no_pair
	TIME=0
	.......
	> ch([0]).					
	C6 C2 C3 S4 H5   ... 10787 / straight(20)
	TIME=0
	=-=-=-=-=-=-=-=-=-
	> open(17).					opens a new deck
	TIME=0
	> 5.						deals five cards.
	SQ D8 SA HA HT   ... 128 / one_pair(14)
	TIME=0
	> ch([0,1,4]).					changes three cards
							(SQ,D8,HT).
	D2 D6 SA HA S9   ... 128 / one_pair(14)
	TIME=0
	> ch([0,1,4]).
	H5 DT SA HA D5   ... 926 / two_pairs(5,14)
	TIME=0
	> ch([1]).
	H5 H4 SA HA D5   ... 926 / two_pairs(5,14)
	TIME=0
	........
	> ch([1]).
	H5 C5 SA HA D5   ... 29376 / full_house(5,14)
	TIME=0
	=-=-=-=-=-=-=-=-=-

	> open(7).					opens a new deck.
	TIME=0
	> 25.						deals 25 cards.
	104  0  0  0  112  
	HT CA S5 D8 HA  ... 128
	S4 SJ H7 DT D5  ... 0
	D2 CT SQ S9 H6  ... 0
	S2 S8 H8 S7 DK  ... 116
	C8 CQ DJ C3 S6  ... 0
	  0 / 116
	 --------------------------- TOTAL=576
	TIME=0
	>  ch([0,2,3]). 				changes three cards
							(HT,S5,D8).
	104  0  0  118  112  
	ST CA C6 H9 HA  ... 128
	S4 SJ H7 DT D5  ... 0
	D2 CT SQ S9 H6  ... 0
	S2 S8 H8 S7 DK  ... 116
	C8 CQ DJ C3 S6  ... 0
	  21546 / 116
	 --------------------------- TOTAL=22240
	TIME=0
	> ch([11,21]).					changes two cards
							(CT,CQ).
	104  0  0  118  112  
	ST CA C6 H9 HA  ... 128
	S4 SJ H7 DT D5  ... 0
	D2 DQ SQ S9 H6  ... 124
	S2 S8 H8 S7 DK  ... 116
	C8 H4 DJ C3 S6  ... 0
	  21546 / 116
	 --------------------------- TOTAL=22364
	TIME=16


