/* << visualize rbs >>
 * vrbs.c       ver. 1.00
 * 96/10/29
 * By Kenta Cho(cho@ueda.info.waseda.ac.jp)
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define FONTNAME "-adobe-times-medium-r-normal--14-100-100-100-p-74-iso8859-1"
#define SCREENINTERVAL 1
#define SCREENSIZE 512

Display *disp;
Window win;
GC gc;
XSizeHints xsh;
XColor red,blue,green,back,white,def;
XFontStruct *fo;
Pixmap fgmap;

char fontname[256]={FONTNAME};
char windowtitle[256]={"vrbs"};
int xscsize,yscsize;
int xwinsize=-1,ywinsize;
int xwinoffset=-1,ywinoffset;

int screeninterval=SCREENINTERVAL;

char dpy[256]={NULL};

int dsin[360],dcos[360];

int gtime=0;

char rbname[16][256];
int rbsh[17];

typedef struct {
  int d,r;
} Rbform;

Rbform rf[8][8]={
  {0,8,150,8,210,8,-32768,0},
  {0,6,90,8,140,6,180,2,220,6,270,8,-32768,0},
  {0,8,45,6,135,6,225,6,315,6,-32768,0},
  {0,2,20,8,130,7,230,7,340,8,-32768,0},
  {0,8,130,8,180,2,230,8,-32768,0},
  {0,7,80,6,120,7,180,6,240,7,280,6,-32768,0},
  {0,8,90,1,130,8,230,8,270,1,-32768,0},
  {0,8,100,2,70,6,150,7,210,7,290,6,260,2,-32768,0},
};

/*
 * initializing
 */
initsc()
{
  int i;

  for ( i=0 ; i<360 ; i++ ) {
    dsin[i]=sin((float)i*3.1415/180)*256;
    dcos[i]=cos((float)i*3.1415/180)*256;
  }
}

initfirst()
{
  int i;
  for ( i=0 ; i<16 ; i++ ) rbname[i][0]='\0';
}

initall()
{
  int i;
  for ( i=0 ; i<16 ; i++ ) rbsh[i]=100;
  initsc();
  xscsize=768; yscsize=512;
  if ( xwinsize==-1 ) {
    xwinsize=ywinsize=SCREENSIZE;
  }
  xwinsize*=1.5;
}

/* 
 * display usage
 */
usage()
{
  fprintf(stderr,"Usage:  vrbs [-options ...]\n");
  fprintf(stderr,"\n");
  fprintf(stderr,"where options include:\n");
  fprintf(stderr,"    -display dpy            X server on which to display\n");
  fprintf(stderr,"    -geometry geom          size and location of window\n");
  fprintf(stderr,"    -si 0.1seconds          interval between screen updates\n");
  fprintf(stderr,"    -fn font                font to use\n");
  fprintf(stderr,"    -name n [name1 ...]     robot name\n");
}

/* 
 * parse options
 */
parseoptions(int argc,char **argv)
{
  int r,i,n;
  for ( r=1 ; r<argc ; r++ ) {
    if ( strcmp(argv[r],"-si")==0 && r<argc-1 ) {
      screeninterval=atoi(argv[r+1]); r++;
    }
    else if ( (strcmp(argv[r],"-display")==0 || strcmp(argv[r],"-d")==0) && r<argc-1 ) {
      strcpy(dpy,argv[r+1]); r++;
    }
    else if ( (strcmp(argv[r],"-geometry")==0 || strcmp(argv[r],"-g")==0) && r<argc-1 ) {
      XParseGeometry(argv[r+1],&xwinoffset,&ywinoffset,&xwinsize,&ywinsize);
      r++;
    }
    else if ( strcmp(argv[r],"-fn")==0 && r<argc-1 ) {
      strcpy(fontname,argv[r+1]); r++;
    }
    else if ( strcmp(argv[r],"-name")==0 && r<argc-1 ) {
      n=atoi(argv[r+1]); r+=2;
      for ( i=0 ; i<n ; i++,r++ )
	strcpy(rbname[i],argv[r]);
      r--;
    }
    else {
      usage(); exit(1);
    }
  }
}

/* 
 * open window
 */
openwindow(char *title)
{
  if ( NULL==(disp=XOpenDisplay(dpy)) ) {
    fprintf(stderr,"Error: I cannot open display: %s\n",dpy);
    exit(0);
  }
  if ( NULL==(fo=XLoadQueryFont(disp,fontname)) ) {
    fprintf(stderr,"Error: I cannot convert string \"%s\" to type FontStruct\n",fontname);
    exit(0);
  }

  win=XCreateSimpleWindow(disp,RootWindow(disp,0),xwinoffset,ywinoffset,xwinsize,ywinsize,1,WhitePixel(disp,0),BlackPixel(disp,0));
  XStoreName(disp,win,title);

  if ( xwinoffset!=-1 ) {
    xsh.flags=USPosition;
    xsh.x=xwinoffset; xsh.y=ywinoffset;
    XSetWMNormalHints(disp,win,&xsh);
  }

  XMapWindow(disp,win);
  XSelectInput(disp,win,StructureNotifyMask | ExposureMask);

  gc=XCreateGC(disp,win,0,NULL);
  XAllocNamedColor(disp,DefaultColormap(disp,0),"tomato",&red,&def);
  XAllocNamedColor(disp,DefaultColormap(disp,0),"dodger blue",&blue,&def);
  XAllocNamedColor(disp,DefaultColormap(disp,0),"darkgreen",&green,&def);
  XAllocNamedColor(disp,DefaultColormap(disp,0),"black",&back,&def);
  XAllocNamedColor(disp,DefaultColormap(disp,0),"white",&white,&def);
  XSetFont(disp,gc,fo->fid); 
}

/* 
 * draw line
 */
drawline(int x1,int y1,int x2,int y2)
{
  int sx1,sy1,sx2,sy2;
  sx1=x1*xwinsize/xscsize;
  sx2=x2*xwinsize/xscsize;
  sy1=y1*ywinsize/yscsize;
  sy2=y2*ywinsize/yscsize;
  XDrawLine(disp,fgmap,gc,sx1,sy1,sx2,sy2);
}

/* 
 * draw circle
 */
drawcircle(int x,int y,int xw,int yw)
{
  int sx,sy,swx,swy;
  sx=x*xwinsize/xscsize;
  swx=xw*xwinsize/xscsize;
  sy=y*ywinsize/yscsize;
  swy=yw*ywinsize/yscsize;
  XDrawArc(disp,fgmap,gc,sx-swx,sy-swy,swx*2,swy*2,0,23040);
}

/* 
 * draw string
 */
drawstring(int x,int y,char *str)
{
  int sx,sy;
  sx=x*xwinsize/xscsize;
  sy=y*ywinsize/yscsize;
  XDrawString(disp,fgmap,gc,sx,sy,str,strlen(str));
}

putwinner()
{
  XEvent ev;
  int i=0,ws=-1;
  while ( rbsh[i]!=-32768 ) {
    if ( rbsh[i]>0 ) { ws=i&1; break; }
    i++;
  }
  XSetForeground(disp,gc,white.pixel);
  switch (ws) {
  case 0:
    drawstring(256,256,"Blue Side Won.");
    break;
  case 1:
    drawstring(256,256,"Red Side Won.");
    break;
  case -1:
    drawstring(256,256,"Draw Game.");
    break;
  }
  XSetWindowBackgroundPixmap(disp,win,fgmap);
  XClearWindow(disp,win);
  XSelectInput(disp,win,ButtonPress);
  XNextEvent(disp,&ev);
  exit(1);
}

putback()
{
  int i;
  XSetForeground(disp,gc,green.pixel);
  drawline(128,0,128,512);
  for ( i=31 ; i<512 ; i+=32 )
    drawline(i+128,0,i+128,512);
  drawline(128,0,640,0);
  for ( i=31 ; i<512 ; i+=32 )
    drawline(128,i,640,i);
}

putstatus(int stx,int sty,int mx,int my,int d,int bt,int dt,int shield,int shote,char *command,int n,int color)
{
  int i,x,y;
  char ss[16];
  int strtx,strty,x1,y1,x2,y2,nd,sp;
  x=stx; y=sty;
  XSetForeground(disp,gc,green.pixel);
  x=stx;
  if ( stx==0 ) x+=128;
  drawline(stx,sty+63,stx+128,sty+63);
  drawline(stx,sty+16,stx+64,sty+16);
  strncpy(ss,command,15);
  ss[15]='\0';
  drawstring(stx,sty+36,ss);
  switch (color) {
  case 0:
    XSetForeground(disp,gc,white.pixel);
    break;
  case 1:
    XSetForeground(disp,gc,blue.pixel);
    break;
  case 2:
    XSetForeground(disp,gc,red.pixel);
    break;
  }
  drawstring(stx,sty+16,rbname[n]);
  x=stx+64; y=sty+32;
  i=0; sp=(n>>1);
  strtx=x1=x+((dsin[d]*rf[sp][i].r)>>8); strty=y1=y-((dcos[d]*rf[sp][i].r)>>8);
  i++;
  while ( rf[sp][i].d!=-32768 ) {
    nd=d+rf[sp][i].d;
    while ( nd>=360 ) nd-=360;
    x2=x+((dsin[nd]*rf[sp][i].r)>>8); y2=y-((dcos[nd]*rf[sp][i].r)>>8);
    drawline(x1,y1,x2,y2);
    x1=x2; y1=y2;
    i++;
  }
  drawline(x1,y1,strtx,strty);
  if ( bt>0 ) drawcircle(x,y,3+bt*2,7+bt);
  x=stx; y=sty+52;
  for ( i=0 ; i<shield/5 ; i++ ) {
    drawline(x,y,x,y+11);
    x+=5;
  }
  y=sty+48;
  sprintf(ss,"%d",shield);
  drawstring(stx+100,y+16,ss);
  drawstring(mx,my-16,ss);
  x=stx; y=sty+48;
  if ( dt>0 ) drawstring(x,y,"Dash");
  x=stx+96;
  for ( i=0 ; i<shote/10 ; i++ ) {
    drawstring(x,y,"S");
    x+=8;
  }
}

putrobot(char *rb)
{
  int n=0,i,cc;
  int x,y,d,dt,bt,se,shield;
  int sx,sy;
  int strtx,strty,x1,y1,x2,y2,nd,sp;
  char st[1024],co[1024];
  char *p;
  int stx=0,sty=0;
  int col;
  rb=(char*)index(rb,'(');
  while ( rb!=NULL ) {
    cc=1;
    rb++;
    i=0;
    while ( cc>0 ) {
      if ( rb[i]=='(' ) cc++;
      else if ( rb[i]==')' ) cc--;
      i++;
    }
    strncpy(st,rb,i-1);
    shield=-1;
    sscanf(st,"%d,%d,%d,%d,%d,%d,%d,%s",&x,&y,&d,&dt,&bt,&se,&shield,co);
    if ( shield==-1 ) {
      sscanf(st,"%d,%d,stop,%d,%d,%d,%d,%s",&x,&y,&dt,&bt,&se,&shield,co);
      if ( shield==-1 )
	sscanf(st,"%d,%d,end,%d,%d,%d,%d,%s",&x,&y,&dt,&bt,&se,&shield,co);
      d=-1;
    }
    rb+=i;
    rb=(char*)index(rb,'(');
    if ( shield>0 ) {
      if ( rbsh[n]-shield>=5 ) {
	XSetForeground(disp,gc,white.pixel); col=0;
      }
      else if ( (n&1)==0 ) {
	XSetForeground(disp,gc,blue.pixel);
	col=1;
      }
      else {
	XSetForeground(disp,gc,red.pixel);
	col=2;
      }
      rbsh[n]=shield;
      sx=x/(25600/512)+128; sy=y/(25600/512);
      
      if ( d==-1 ) d=0;
      i=0; sp=(n>>1);
      strtx=x1=sx+((dsin[d]*rf[sp][i].r)>>8); strty=y1=sy-((dcos[d]*rf[sp][i].r)>>8);
      i++;
      while ( rf[sp][i].d!=-32768 ) {
	nd=d+rf[sp][i].d;
	while ( nd>=360 ) nd-=360;
	x2=sx+((dsin[nd]*rf[sp][i].r)>>8); y2=sy-((dcos[nd]*rf[sp][i].r)>>8);
	drawline(x1,y1,x2,y2);
	x1=x2; y1=y2;
	i++;
      }
      drawline(x1,y1,strtx,strty);
      if ( bt>0 ) drawcircle(sx,sy,3+bt*2,7+bt);
      putstatus(stx,sty,sx,sy,d,bt,dt,shield,se,co,n,col);
    }
    else rbsh[n]=0;
    if ( stx==0 ) stx=640;
    else { stx=0; sty+=64; }
    n++;
  }
  rbsh[n]=-32768;
}
    
putshot(char *sh)
{
  int n,an,x,y,d;
  int sx,sy;
  int d1,d2;
  if ( sh[0]!='(' ) return;
  while ( sh!=NULL ) {
    sscanf(sh,"(%d,%d,%d,%d,%d)",&n,&an,&x,&y,&d);
    if ( (n&1)==0 ) XSetForeground(disp,gc,blue.pixel);
    else XSetForeground(disp,gc,red.pixel);
    sx=x/(25600/512)+128; sy=y/(25600/512);
    d1=d+170; if ( d1>=360 ) d1-=360;
    d2=d1+20; if ( d2>=360 ) d2-=360;
    drawline(sx+(dsin[d]>>6),sy-(dcos[d]>>6),sx+(dsin[d1]>>6),sy-(dcos[d1]>>6));
    drawline(sx+(dsin[d1]>>6),sy-(dcos[d1]>>6),sx+(dsin[d2]>>6),sy-(dcos[d2]>>6));
    drawline(sx+(dsin[d2]>>6),sy-(dcos[d2]>>6),sx+(dsin[d]>>6),sy-(dcos[d]>>6));
    sh=(char*)index(sh,')');
    sh=(char*)index(sh,'(');
  }
}
    
/* 
 * main routine
 */
main(int argc,char **argv)
{
  int r;
  int time1=0;
  XEvent ev;
  char hn[256];
  char rb[5120],sh[10240];
  char si[10240];

  initfirst();
  parseoptions(argc,argv);
  initall();
  openwindow(windowtitle);
  fgmap=XCreatePixmap(disp,win,xwinsize,ywinsize,DefaultDepth(disp,DefaultScreen(disp)));

  while (1) {
    while ( XEventsQueued(disp,QueuedAfterFlush)>0 ) {
      XNextEvent(disp,&ev);
      if ( ev.type==ConfigureNotify ) {
	XFreePixmap(disp,fgmap);
        xwinsize=ev.xconfigure.width;
	ywinsize=ev.xconfigure.height;
	fgmap=XCreatePixmap(disp,win,xwinsize,ywinsize,DefaultDepth(disp,DefaultScreen(disp)));
      }
    }
    fgets(si,10240,stdin);
    if ( feof(stdin) ) putwinner();
    sscanf(si,"{%s [%s",rb,sh);
    usleep(100000);
    time1++;
    if ( time1>=screeninterval ) {
      XSetForeground(disp,gc,BlackPixel(disp,0));
      XFillRectangle(disp,fgmap,gc,0,0,xwinsize,ywinsize);
      putback();
      putrobot(rb);
      putshot(sh);
      XSetWindowBackgroundPixmap(disp,win,fgmap);
      XClearWindow(disp,win);
      time1=0;
      gtime++;
    }
  }
  XFreePixmap(disp,fgmap);
}
