/* ---------------------------------------------------------- 
%   (C) 1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
#include <klic/basic.h>

#include <stdio.h>
#include <errno.h>

#ifdef STDDEFH
#include <stddef.h>
#else
#ifndef _SIZE_T
typedef unsigned int   size_t;
#define _SIZE_T
#endif
#endif

int klic_getc(f)
     FILE *f;
{
  while (1) {
    int result = getc(f);
    if (result!=EOF || feof(f) || errno != EINTR) {
      return result;
    }
  }
}

int klic_fread(pt, size, items, f)
     void *pt;
     size_t size, items;
     FILE *f;
{
  return fread(pt, size, items, f);
}

char *klic_fgets(buf, length, f)
     char *buf;
     size_t length;
     FILE *f;
{
  while (1) {
    char *result = fgets(buf, length, f);
    if (result!=NULL || feof(f) || errno != EINTR) {
      return result;
    }
  }
}

extern int klic_putc(c, f)
     int c;
     FILE *f;
{
  while (1) {
    int result = putc(c, f);
    if (result!=EOF || feof(f) || errno != EINTR) {
      return result;
    }
  }
}

int klic_fwrite(pt, size, items, f)
     Const void *pt;
     size_t size, items;
     FILE *f;
{
  return fwrite(pt, size, items, f);
}

int klic_fflush(f)
     FILE *f;
{
  while (1) {
    int result = fflush(f);
    if (result!=EOF || errno != EINTR) {
      return result;
    }
  }
}
