/* ---------------------------------------------------------- 
%   (C)1993,1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
%   (C)1996, 1997 Japan Information Processing Development Center
%       (Read COPYRIGHT-JIPDEC for detailed information.)
----------------------------------------------------------- */
#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include <errno.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/atomstuffs.h>
#include <klic/functorstuffs.h>

#ifdef DIST
#include <klic/distio.h>
#include <klic/interpe.h>
#endif

#ifdef SHM
#include <klic/shm.h>
#endif

extern struct predicate topsucceed_pred;
extern jmp_buf klic_topmost;

void fatal(message)
     char *message;
{
  declare_globals;
#ifdef DIST
  iosprintf("Fatal Error: %s\n", message);
  iosprintf("Node %d Going to dump core\n", my_node);

  ERROR_STOP;

  DetachIO();
  EmergencyStop();
#else
  klic_fprintf(stderr, "Fatal Error: %s\n", message);
#endif
  if (postmortem_pred !=0 && postmortem_args !=0) {
    longjmp(klic_topmost, 1);
  }
#ifdef DIST
  Close_net();
#endif
#ifdef SHM
  abend("");
#endif
  exit(-1);
}


klic_exit(N)
int N;
{
#ifdef DIST

#endif
#ifdef SHM
  abend("");
#endif
  exit(N);
}

void fatalf(format, a0, a1, a2, a3, a4, a5, a6, a7)
     char *format;
     long a0, a1, a2, a3, a4, a5, a6, a7;
{
  char buf[4096];
  (void) sprintf(buf, format, a0, a1, a2, a3, a4, a5, a6, a7);
  fatal(buf);
}

void fatalp(where, format, a0, a1, a2, a3, a4, a5, a6, a7)
     char *where, *format;
     long a0, a1, a2, a3, a4, a5, a6, a7;
{
#ifdef DIST
  char buf[4096];
  char *bufp;
#ifdef DECL_SYS_ERRLIST
  extern char *sys_errlist[];
#endif
  (void) sprintf(buf, "%s: %s\n", where, sys_errlist[errno]);
  bufp = buf + strlen(buf);
  (void) sprintf(bufp, format, a0, a1, a2, a3, a4, a5, a6, a7);
  fatal(buf);
#else
  perror(where);
  fatalf(format, a0, a1, a2, a3, a4, a5, a6, a7);
#endif
}

#ifdef DIST

void
#ifdef USE_STDARG
ioprintf(char *format, ...)
#else
ioprintf(format, va_alist)
char *format;
va_dcl
#endif
{
    va_list args;
    char io_buf[2048];
    declare_globals;
    VA_START(args, format);
    vsprintf(io_buf, format, args);
    if ( Node_type() ) {
      Print(io_buf);
    } else {
      fputs(io_buf, stdout );
    }
    va_end(args);
}

void
#ifdef USE_STDARG
ioeprintf(char *format, ...)
#else
ioeprintf(format, va_alist)
char *format;
va_dcl
#endif
{
    va_list args;
    char io_buf[2048];
    declare_globals;
    VA_START(args, format);
    vsprintf(io_buf, format, args);

    if ( Node_type() ) {
      EPrint(io_buf);
    } else {
      fputs(io_buf, stderr );
    }
    va_end(args);
}

void
#ifdef USE_STDARG
iosprintf(char *format, ...)
#else
iosprintf(format, va_alist)
char *format;
va_dcl
#endif
{
    va_list args;
    char io_buf[2048];
    declare_globals;

    VA_START(args, format);
    vsprintf(io_buf, format, args);
    if ( Node_type() ) {
      SystemPrint(io_buf);
    } else {
      fputs(io_buf, stderr );
    }
    va_end(args);
}
#endif /* DIST */

void debug_fprintf(out, format,
		   a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab)
     FILE *out;
     char *format;
     long a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab;
{
  char *f;
#ifdef DIST
  char buf[4096];
  char *bufp = buf;
  declare_globals;
#endif
  long args[12], *argp;
  args[0] = a0; args[1] = a1; args[2] = a2; args[3] = a3;
  args[4] = a4; args[5] = a5; args[6] = a6; args[7] = a7;
  args[8] = a8; args[9] = a9; args[10] = aa; args[11] = ab;
  argp = &args[0];
  for (f = format; *f != '\0'; f++) {
    if (*f == '%') {
#ifdef DIST
      if (bufp != buf) {
	*bufp = '\0';
	if ( Node_type() ) {
	  SystemPrint(buf);
	} else {
	  fputs(buf, stderr );
	}
	bufp = buf;
      }
#endif
      f++;
      switch (*f) {
      case 'k':
#ifdef DIST
	iosprintf("???");
#else
#ifdef DEBUGLIB
	fprint_partially(out, (q)*argp, 3, 10);
#else
/*	klic_fprintf(out, "???"); */
	fprintf(out, "???");
#endif
#endif
	argp++;
	break;
      case 'F':
#ifdef DEBUGLIB
#ifdef DIST
	iosprintf("%s",
		atomname[functors[*argp-FUNCTORNUMBERBASE]-ATOMNUMBERBASE]);
#else
/*	klic_fprintf(out, "%s",
		     atomname[functors[*argp-FUNCTORNUMBERBASE]-
			      ATOMNUMBERBASE]); */
	fprintf(out, "%s",
		     atomname[functors[*argp-FUNCTORNUMBERBASE]-
			      ATOMNUMBERBASE]);
#endif
#else
#ifdef DIST
	iosprintf("???");
#else
	klic_fprintf(out, "???");
#endif
#endif
#ifdef DIST
	iosprintf("/%d",
		arities[*argp++ -FUNCTORNUMBERBASE]);
#else
/*	klic_fprintf(out, "/%d",
		     arities[*argp++ -FUNCTORNUMBERBASE]); */
	fprintf(out, "/%d",
		     arities[*argp++ -FUNCTORNUMBERBASE]);
#endif
	break;
      default:
	{
	  int k;
	  char fmtbuf[1024];
	  fmtbuf[0] = '%';
	  k=1;
	  while ((!isalpha(*f) || *f == 'l') && *f != 0) {
	    if (k>=1022) {
	      fatal("Too complicated format string for debug_printf");
	    }
	    fmtbuf[k++] = *f++;
	  }
	  fmtbuf[k++] = *f;
	  fmtbuf[k] = 0;
#ifdef DIST
	  iosprintf(fmtbuf, *argp++);
#else
/*	  klic_fprintf(out, fmtbuf, *argp++); */
	  fprintf(out, fmtbuf, *argp++);
#endif
	}
      }
    } else {
#ifdef DIST
      *bufp++ = *f;
#else
      klic_putc(*f, out);
#endif
    }
  }
#ifdef DIST
  if (bufp != buf) {
    *bufp = '\0';
    if ( Node_type() ) {
      SystemPrint(buf);
    } else {
      fputs(buf, stderr );
    }
  }
#endif
}

void debug_printf(format,
		  a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab)
     char *format;
     long a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab;
{
  debug_fprintf(stderr, format,
		a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, aa, ab);
}
