/* ---------------------------------------------------------- 
%   (C)1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <pvm3.h>
#include <stdio.h>
#include <signal.h>
#include <klic/basic.h>
#include <klic/rmon.h>

#define MAXNUM    256

main(argc,argv)
     int argc; char **argv;
{
  int i,j,mytid,histid,bufsize,msgtag,info,buf_id,n,disp_nodes;
  long nodes, ibuf[MAXNUM*5], s_times, i_times, gc_times, sm_times, rm_times;
  long prof_tag;

  if (argc == 1) {
      disp_nodes = 20;
  } else {
      disp_nodes = atoi(argv[1]);
  }

  mytid = pvm_mytid();
  fprintf(stderr, "Rmonitor Tid is %x\n", mytid);

  for (;;) {
      buf_id = pvm_recv(-1,-1);
      if (buf_id < 0 ){
	  fprintf(stderr, "Error in pvm_recv\n");
      }
      info = pvm_bufinfo(buf_id,&bufsize,&msgtag,&histid);
      if (info < 0 ){
	  fprintf(stderr, "Error in pvm_bufinfo\n");
      }

      pvm_upklong(&prof_tag, 1, 1);
      switch(prof_tag){
	case SHOEN_START_TAG:
	  for (j = 0; j < disp_nodes; j++) {
	      fprintf(stdout, " %d    0   0    0    0    0    0    0    0    0    0     0   0   0  0  100\n",j);
	  }	  
	  fflush(stdout);
	  break;

	case SHOEN_OUTPUT_PROF_TAG:

	  pvm_upklong(&nodes, 1, 1);
	  if(nodes > disp_nodes){
	      fprintf(stderr, "Please restart : rmon_server %d\n", nodes);
	      exit();
	  }

	  pvm_upklong(ibuf, nodes*5, 1);

	  fprintf(stdout, "CPU minf mjf xcal  intr ithr  csw icsw migr smtx  srw syscl  usr sys  wt idl\n");
	  n = 0;

	  for (j = 0; j<nodes; j++) {
	      s_times = ibuf[n];
	      i_times = ibuf[n+1];
	      gc_times = ibuf[n+2];
	      sm_times = ibuf[n+3];
	      rm_times = ibuf[n+4];
	      
	      fprintf(stdout, " %d    0   0    0    0    0    0    0    0    0    0     0 ",j);
	      if (s_times) { 
		  fprintf(stdout, " %d 0 0 %d\n",
			  s_times - (i_times + sm_times + rm_times),
			  i_times + sm_times + rm_times);
	      } else {
		  fprintf(stdout, " 0 0 0 100\n");
	      }
	      n+=5;
	  }

	  for(j = nodes ; j < disp_nodes ;j++){
	      fprintf(stdout, " %d    0   0    0    0    0    0    0    0    0    0     0   0   0  0  100\n",j);
	  }
	  fflush(stdout);
	  break;

	case SHOEN_TERMINATE_TAG:
	  for(i = 0; i < 2 ; i++){
	      fprintf(stdout, "CPU minf mjf xcal  intr ithr  csw icsw migr smtx  srw syscl  usr sys  wt idl\n");	  
	      for (j = 0; j < disp_nodes; j++) {
		  fprintf(stdout, " %d    0   0    0    0    0    0    0    0    0    0     0   0   0  0  100\n",j);
	      }	  
	      fflush(stdout);
	      sleep(2);
	    }
	  break;

	default:
	  fprintf(stderr, "rmon_server invalid msg from shoen\n");
	  exit();
	  break;
      }
  }
}
