% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)


do(UorS) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	(do(M, FLIS,LIS, DisjU,DisjO) -> UorS = unsat; UorS = sat).

%
%   do(+CurrentModel,
%        +LiteralInstanceStacksForFalseClauses,+LiteralInstanceStacksForOthers,
%        +DisjunctivesUnique,+DisjunctivesOther)
%
do(M, FLIS,LIS, [P|DisjU],DisjO) :- !,
    (member(P,M) -> do(M, FLIS,LIS, DisjU,DisjO);
	do1(M,P, FLIS,LIS, DisjU,DisjO)).
do(M, FLIS,LIS, [],[Dis|DisjO]) :-  !,
    (checkConsq(Dis,NDis, M) -> expand(NDis, M, FLIS,LIS, DisjO);
	do(M, FLIS,LIS, [],DisjO)).

do1(M,P, FLIS,LIS, DisjU,DisjO) :- do0([P|M],[P], FLIS,LIS, DisjU,DisjO).

do0(M,DM, FLIS,LIS, DisjU,DisjO) :-
    satisfyClauses(M,DM, FLIS,NFLIS, [],False, _,_),
    do0Decide(False, M,DM, NFLIS,LIS, DisjU,DisjO).

do0Decide([], M,DM, FLIS,LIS, DisjU,DisjO) :- !,
    satisfyClauses(M,DM, LIS,NLIS, DisjU,NDisjU, DisjO,NDisjO),
    do(M, FLIS,NLIS, NDisjU,NDisjO).
do0Decide(False, _,_, _,_, _,_). % False \= []

do2(M,P, FLIS,LIS, DisjU,DisjO) :- 
	append(P,M, PM),
	do0(PM,P, FLIS,LIS, DisjU,DisjO).

expand([], _, _,_, _) :- !.
expand([P|Ps], M, FLIS,LIS, DisjO) :-
    do2(M,P, FLIS,LIS, [],DisjO),
    expand(Ps, M, FLIS,LIS, DisjO).

satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
    satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
    satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

%satisfyClause(ID,LiS,NLiS, M,DM, Si,So, Di,Do) :- DM = [PAT], pc(ID,PAT), !,
%   satisfyAnte(ID,LiS,NLiS, M,DM, [[]],[], Si,So, Di,Do).
%satisfyClause(ID,LiS,LiS, M,DM, Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).
satisfyClause(ID,LiS,LiS, M,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(ID,LiS,LiS, M,PAT, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
    satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
    satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
    c(ID, [P|S], Si,Sm, Di,Dm),
    satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

%
%   Library
%
member(X,[X|_]) :- !.
member(X,[_|Xs]) :- member(X,Xs).

append([],Y, Y) :- !.
append([A|X],Y, [A|Z]) :- append(X,Y, Z).

checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).
