% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)

do(UorS) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	(do(M, FLIS,LIS, DisjU,DisjO) -> UorS = unsat; UorS = sat).

do(M, FLIS,LIS, DisjU,DisjO) :- doFalse(M,[], FLIS,LIS, DisjU,DisjO).

doFalse(M,DM, FLIS,LIS, [P|DisjU],DisjO) :- !,
	(member(P,M) -> doFalse(M,DM, FLIS,LIS, DisjU,DisjO);
	    doFalse1(M, P,DM, FLIS,LIS, DisjU,DisjO)).
doFalse(M,DM, FLIS,LIS, [],[Dis|DisjO]) :- !,
	(checkConsq(Dis,NDis, M) -> expandFalse(NDis, M,DM, FLIS,LIS, DisjO);
	    doFalse(M,DM, FLIS,LIS, [],DisjO)).
doFalse(M,DM, FLIS,LIS, [],[]) :- DM = [_|_],
    satisfyClauses(M,DM, LIS,NLIS, [],DisjU, [],DisjO),
    do(M, FLIS,NLIS, DisjU,DisjO).

doFalse1(M, P,DM, FLIS,LIS, DisjU,DisjO) :- M1 = [P|M], 
    satisfyClauses(M1,[P], FLIS,NFLIS, [],False, _,_),
%%    (\+ False = [] ;doFalse(M1,[P|DM], NFLIS,LIS, DisjU,DisjO)).
    (False = [] -> doFalse(M1,[P|DM], NFLIS,LIS, DisjU,DisjO);
	true).

expandFalse([P|Ps], M,DM, FLIS,LIS, DisjO) :- 
    doFalse(M,DM, FLIS,LIS, P,DisjO),
    expandFalse(Ps, M,DM, FLIS,LIS, DisjO).
expandFalse([], _,_, _,_, _).

satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
    satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
    satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

%satisfyClause(ID,LiS,NLiS, M,DM, Si,So, Di,Do) :- DM = [PAT], pc(ID,PAT), !,
%   satisfyAnte(ID,LiS,NLiS, M,DM, [[]],[], Si,So, Di,Do).
%satisfyClause(ID,LiS,LiS, M,DM, Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).
satisfyClause(ID,LiS,LiS, M,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(ID,LiS,LiS, M,PAT, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
    satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
    satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
    c(ID, [P|S], Si,Sm, Di,Dm),
    satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

%
%   Library
%
member(X,[X|_]) :- !.
member(X,[_|Xs]) :- member(X,Xs).

checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).
