% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)


%--------------------------------------------------------------
%	translate MGTP into Prolog			
%								
%	translate and compile :					
%		: mgtpcomp(+MGTP{FileName})
%		: mgtpcomp(+MGTP,?Prolog{FileName})
%		: mgtpcomp(+Mode,+MGTP,?Prolog)
%
%	translate :
%		: trans			: mgtp2pl
%		: trans(+MGTP)		: mgtp2pl(+MGTP)
%		: trans(+MGTP,?Prolog)	: mgtp2pl(+MGTP,?Prolog)
%
%--------------------------------------------------------------

%-------------------------------------------------------%
%	interface					%
%-------------------------------------------------------%

%-------< compile >-------------------------------------%

mgtpcomp :- !,
	mgtpcomp(_,_).

mgtpcomp(Mname) :- !,
	mgtpcomp(Mname,_).

mgtpcomp(Mname,Pname) :- !,
	mgtp2pl(Mname,Pname),
	mgtpcomp_case(compile,Pname).

mgtpcomp_case(compile,File) :-
	compile(File),!.
mgtpcomp_case(consult,File) :-
	consult(File),!.
mgtpcomp_case(reconsult,File) :-
	reconsult(File),!.
mgtpcomp_case(Mode,File) :- !,
	printf(['[ Can''t ',Mode,' file : ',File,'. ]']).

%-------< translate >-----------------------------------%

trans :- !,
	trans(_,_).

trans(Mname) :- !,
	mgtp2pl(Mname,_).

trans(Mname,Pname) :- !,
	mgtp2pl(Mname,Pname).

%-------< trnaslate main >------------------------------%

mgtp2pl :- !,
	mgtp2pl(_,_).

mgtp2pl(Mname) :- !,
	mgtp2pl(Mname,_).

mgtp2pl(Mname,Pname) :-
	var(Mname),!,
	repeat,
		printf('file name >> '),
		read(Mname),
		( Mname = exit
		; mgtp2pl(Mname,Pname),
		  fail ).
mgtp2pl(Mname,Pname) :-
	var(Pname),!,
	filename_to_name_ext(Mname,Pname,_),
	mgtp2pl(Mname,Pname).
mgtp2pl(Mname,Pname) :-
	Mname = [_|_],!,
	mgtp2pl_list(Mname,Pname).
mgtp2pl(Mname,Pname) :-
	can_file_open_msg(read,Mname,[dnhm,mgtp],MF),
	can_file_open_msg(write,Pname,[pl],PF),
	mgtp2pl_initialize,
	mgtp2pl_to(MF),
	mgtp2pl_out(PF),
	printf(['[ program saved in "',PF,'". ]',{nl}]),!.

mgtp2pl_list([],[]) :- !.
mgtp2pl_list([Mone|Mrem],[Pone|Prem]) :-
	mgtp2pl(Mone,Pone),!,
	mgtp2pl_list(Mrem,Prem).
mgtp2pl_list([_|Mrem],[_|Prem]) :- !,
	mgtp2pl_list(Mrem,Prem).
mgtp2pl_list(_,_) :- !,
	printf(['[ Bad filename list. ]',{nl}]).
	
%-------< initialize work >-----------------------------%

mgtp2pl_initialize :-
	mgtp2pl_initialize_data(Pred,Arity),
	abolish(Pred,Arity),
	fail.
mgtp2pl_initialize :- !,
	counter(init,clause).

mgtp2pl_initialize_data('CLAUSE',4) .
mgtp2pl_initialize_data('DISJUNCTIVE',2) .
mgtp2pl_initialize_data('LIS',2) .
mgtp2pl_initialize_data('PCLAUSE',2) .
mgtp2pl_initialize_data('PREDICATE',1) .

%-------< translate to clause >-------------------------%

mgtp2pl_to(File) :-
	see(File),
	repeat,
		read(Input),
%%		numbervars(Input,0,_),	%variable : A,B,C...
		mgtp2pl_to_loop(Input),
	seen,!.

mgtp2pl_to_loop('end_of_file') :- !.
mgtp2pl_to_loop(Input) :-
	mgtp2pl_to_case(Input),
	fail.

mgtp2pl_to_case((true --> Suc)) :- !,
	mgtp2pl_to_disjunctive(Suc),!.
mgtp2pl_to_case((Ant --> Suc)) :- !,
	mgtp2pl_to_clause(Ant,Suc),!.
mgtp2pl_to_case((:- problem(_))) :- !.
mgtp2pl_to_case(Predicate) :-
	mgtp2pl_to_predicate(Predicate),!.

%%%%%%% disjunctive %%%%%%%

mgtp2pl_to_disjunctive(';'(SucOne,SucRem)) :- !,
	to_OrList(';'(SucOne,SucRem),SucList),
	mgtp2pl_to_OrDisjunctive(other,SucList).
mgtp2pl_to_disjunctive(Suc) :-
	to_AndList(Suc,SucList),
	mgtp2pl_to_AndDisjunctive(unique,SucList).

mgtp2pl_to_OrDisjunctive(UorO,MedSuc) :-
	retract('DISJUNCTIVE'(UorO,Suc)),!,
	app_list(Suc,[MedSuc],NewSuc),
	assertz('DISJUNCTIVE'(UorO,NewSuc)).
mgtp2pl_to_OrDisjunctive(UorO,Suc) :-
	assertz('DISJUNCTIVE'(UorO,[Suc])).

mgtp2pl_to_AndDisjunctive(UorO,MedSuc) :-
	retract('DISJUNCTIVE'(UorO,Suc)),!,
	app_list(Suc,MedSuc,NewSuc),
	assertz('DISJUNCTIVE'(UorO,NewSuc)).
mgtp2pl_to_AndDisjunctive(UorO,Suc) :-
	assertz('DISJUNCTIVE'(UorO,Suc)).

%%%%%%% clause %%%%%%%

mgtp2pl_to_clause((One;Rem),Suc) :- !,
	mgtp2pl_to_clause(One,Suc),!,
	mgtp2pl_to_clause(Rem,Suc).
mgtp2pl_to_clause(Ant,Suc) :- !,
	counter(get,clause,C),
	mgtp2pl_to_clause_precede(C,Ant),
	mgtp2pl_to_clause_main(C,Ant,Suc).

%%%%%%% clause precede
mgtp2pl_to_clause_precede(C,Ant) :- !,
	mgtp2pl_to_clause_precede_list(Ant,AntList),
	mgtp2pl_to_clause_precede_sweep(AntList,AntRem),
	assertz('PCLAUSE'(C,AntRem)).

mgtp2pl_to_clause_precede_list(({_},Rem),NewRem) :- !,
	mgtp2pl_to_clause_precede_list(Rem,NewRem).
mgtp2pl_to_clause_precede_list((One,Rem),[NewOne|NewRem]) :- !,
	copy_term(One,NewOne),!,
	mgtp2pl_to_clause_precede_list(Rem,NewRem).
mgtp2pl_to_clause_precede_list({_},[]) :- !.
mgtp2pl_to_clause_precede_list(One,[NewOne]) :- !,
	copy_term(One,NewOne).

mgtp2pl_to_clause_precede_sweep(L,NewL) :- !,
	mgtp2pl_to_clause_precede_sweep_(L,MedL),
	delete_list(strong,[],MedL,NewL).

mgtp2pl_to_clause_precede_sweep_([],[]) :- !.
mgtp2pl_to_clause_precede_sweep_([One|Rem],[Lone|Lrem]) :- !,
	mgtp2pl_to_clause_precede_sweep_one(Rem,One,NewRem,Lone),
	mgtp2pl_to_clause_precede_sweep_(NewRem,Lrem).

mgtp2pl_to_clause_precede_sweep_one([],One,[],One) :- !.
mgtp2pl_to_clause_precede_sweep_one([X|Rem],One,NewRem,NewOne) :-
	not_not_match(One,X),!,
	mgtp2pl_to_clause_precede_sweep_one(Rem,One,NewRem,NewOne).
mgtp2pl_to_clause_precede_sweep_one([X|Rem],One,[X|Rem],[]) :-
	not_not_match(X,One),!.
mgtp2pl_to_clause_precede_sweep_one([X|Rem],One,[X|NewRem],NewOne) :- !,
	mgtp2pl_to_clause_precede_sweep_one(Rem,One,NewRem,NewOne).

%%%%%%% clause main
mgtp2pl_to_clause_main(C,Ant,Suc) :- !,
	mgtp2pl_to_clause_main_ant(Ant,[],NewAnt,LIS),
	mgtp2pl_to_clause_main_suc(Suc,NewSuc,P),
	mgtp2pl_to_lis(Suc,C,LIS),
	assertz('CLAUSE'(C,NewAnt,NewSuc,P)).

mgtp2pl_to_clause_main_ant(Ant,Ins,NewAnt,LIS) :- !,
	mgtp2pl_to_clause_main_ant1(Ant,MedAnt,_),
	mgtp2pl_to_clause_main_ant2(MedAnt,Ins,NewAnt,LIS).

mgtp2pl_to_clause_main_ant1(({One},Rem),Ant,[One|Prem]) :- !,
	mgtp2pl_to_clause_main_ant1(Rem,Ant,Prem).
mgtp2pl_to_clause_main_ant1((One,Rem),[(One,P)|AntRem],[]) :- !,
	mgtp2pl_to_clause_main_ant1(Rem,AntRem,P).
mgtp2pl_to_clause_main_ant1({One},[],[One]) :- !.
mgtp2pl_to_clause_main_ant1(One,[(One,[])],[]) :- !.

mgtp2pl_to_clause_main_ant2([(Aone,P)],Ins,Ant,[]) :- !,
	Ant = [([Aone|Ins],P,[])].
mgtp2pl_to_clause_main_ant2([(Aone,P)|Rem],Ins,Ant,[[]|LIS]) :- !,
	mgtp2pl_to_clause_main_ant_instance(Ins,dummy(Aone,P),NewIns),
	Ant = [([Aone|Ins],P,NewIns)|AntRem],!,
	mgtp2pl_to_clause_main_ant2(Rem,NewIns,AntRem,LIS).

mgtp2pl_to_clause_main_ant_instance([],Ant,NewIns) :- !,
	get_variables(Ant,[],NewVars),
        NewIns =.. [ins,1|NewVars].
mgtp2pl_to_clause_main_ant_instance(Ins,Ant,NewIns) :- !,
	Ins =.. [ins,No|Vars],
	NewNo is No + 1,
	get_variables(Ant,Vars,NewVars),
	NewIns =.. [ins,NewNo|NewVars].

mgtp2pl_to_clause_main_suc((One;Rem),or(S),P) :- !,
	mgtp2pl_to_clause_main_OrSuc((One;Rem),S,P).
mgtp2pl_to_clause_main_suc(Suc,and(S),P) :- !,
	mgtp2pl_to_clause_main_AndSuc(Suc,S,P,[]).

mgtp2pl_to_clause_main_OrSuc((One;Rem),[Sone|Srem],P) :- !,
	mgtp2pl_to_clause_main_AndSuc(One,Sone,P,Prem),!,
	mgtp2pl_to_clause_main_OrSuc(Rem,Srem,Prem).
mgtp2pl_to_clause_main_OrSuc(One,[Suc],P) :- !,
	mgtp2pl_to_clause_main_AndSuc(One,Suc,P,[]).

mgtp2pl_to_clause_main_AndSuc(({One},Rem),Suc,P,Prem) :- !,
	P = [One|Pmed],!,
	mgtp2pl_to_clause_main_AndSuc(Rem,Suc,Pmed,Prem).
mgtp2pl_to_clause_main_AndSuc((One,Rem),Suc,P,Prem) :- !,
	Suc = [One|SucRem],!,
	mgtp2pl_to_clause_main_AndSuc(Rem,SucRem,P,Prem).
mgtp2pl_to_clause_main_AndSuc({One},Suc,P,Prem) :- !,
	Suc = [], P = [One|Prem].
mgtp2pl_to_clause_main_AndSuc(One,Suc,P,Prem) :- !,
	Suc = [One], P = Prem.

%%%%%%% LIS %%%%%%%

mgtp2pl_to_lis(false,No,LIS) :- !,
	mgtp2pl_to_lis_one(false,No,LIS).
mgtp2pl_to_lis(_,No,LIS) :- !,
	mgtp2pl_to_lis_one(other,No,LIS).

mgtp2pl_to_lis_one(ForO,CNT,MedLIS) :-
	retract('LIS'(ForO,LIS)),!,
	app_list(LIS,[lis(CNT,MedLIS)],NewLIS),
	assertz('LIS'(ForO,NewLIS)).
mgtp2pl_to_lis_one(ForO,CNT,LIS) :- !,
	assertz('LIS'(ForO,[lis(CNT,LIS)])).

%%%%%%% Prolog predicate %%%%%%%

mgtp2pl_to_predicate(MedPredicate) :-
	retract('PREDICATE'(Predicate)),!,
	app_list(Predicate,[MedPredicate],NewPredicate),
	assertz('PREDICATE'(NewPredicate)).
mgtp2pl_to_predicate(Predicate) :- !,
	assertz('PREDICATE'([Predicate])).

%-------< write to a file >-----------------------------%

mgtp2pl_out(File) :-
	tell(File),
	mgtp2pl_out_model,
	mgtp2pl_out_lis,
	mgtp2pl_out_disjunctive,
	mgtp2pl_out_clause_precede,
	mgtp2pl_out_clause_main,
	mgtp2pl_out_predicate,
	told,!.

%%%%%%% model %%%%%%%

mgtp2pl_out_model :- !,
	printf([{nl},'model([]).',{nl(2)}]).

%%%%%%% LIS %%%%%%%%

mgtp2pl_out_lis :- !,
	mgtp2pl_out_lis(false),
	mgtp2pl_out_lis(other).

mgtp2pl_out_lis(ForO) :-
	retract('LIS'(ForO,LIS)),!,
	( ForO = false,	printf(['flis(',{quote(LIS)},').',{nl(2)}])
	; ForO = other, printf(['lis(',{quote(LIS)},').',{nl(2)}]) ).
mgtp2pl_out_lis(ForO) :- !,
	( ForO = false, printf(['flis([]).',{nl(2)}])
	; ForO = other, printf(['lis([]).',{nl(2)}]) ).

%%%%%%% disjunctive %%%%%%%

mgtp2pl_out_disjunctive :- !,
	mgtp2pl_out_disjunctive(unique),
	mgtp2pl_out_disjunctive(other).

mgtp2pl_out_disjunctive(UorO) :-
	retract('DISJUNCTIVE'(UorO,Disj)),!,
	( UorO = unique, printf(['disjU(',{quote(Disj)},').',{nl(2)}])
	; UorO = other,	 printf(['disjO(',{quote(Disj)},').',{nl(2)}]) ).
mgtp2pl_out_disjunctive(UorO) :- !,
	( UorO = unique, printf(['disjU([]).',{nl(2)}])
	; UorO = other,	 printf(['disjO([]).',{nl(2)}]) ).

%%%%%%%% clause precede %%%%%%%

mgtp2pl_out_clause_precede :-
	clause('PCLAUSE'(_,_),true),!,
	counter(refer,clause,C),
	mgtp2pl_out_clause_precede_interface(1,C),
	mgtp2pl_out_clause_precede_loop(1,C).
mgtp2pl_out_clause_precede :- !.

mgtp2pl_out_clause_precede_interface(C,C1) :-
	C > C1,!,nl.
mgtp2pl_out_clause_precede_interface(C,C1) :-
	C =< C1,!,
	printf(['pc(',C,',PAT) :- !,',{nl},
		{tab},'pc',C,'(PAT).',{nl}]),
	NewC is C + 1,!,
	mgtp2pl_out_clause_precede_interface(NewC,C1).

mgtp2pl_out_clause_precede_loop(C,C1) :-
	C > C1,!,nl.
mgtp2pl_out_clause_precede_loop(C,C1) :-
	C =< C1,!,
	mgtp2pl_out_clause_precede_one(C),
	NewC is C + 1,!,
	mgtp2pl_out_clause_precede_loop(NewC,C1).

mgtp2pl_out_clause_precede_one(C) :-
	retract('PCLAUSE'(C,Ant)),
	mgtp2pl_out_clause_precede_print(Ant,C),
	fail.
mgtp2pl_out_clause_precede_one(_) :- !.

mgtp2pl_out_clause_precede_print([],_) :- !.
mgtp2pl_out_clause_precede_print([One|Rem],C) :-
	printf(['pc',C,'(',{quote(One)},') :- !.',{nl}]),!,
	mgtp2pl_out_clause_precede_print(Rem,C).

%%%%%%%% clause main %%%%%%%

mgtp2pl_out_clause_main :-
	clause('CLAUSE'(_,_,_,_),true),!,
	counter(refer,clause,C),
	mgtp2pl_out_clause_main_interface(1,C),
	mgtp2pl_out_clause_main_loop(1,C).
mgtp2pl_out_clause_main :- !.

mgtp2pl_out_clause_main_interface(C,C1) :-
	C >  C1,!, nl.
mgtp2pl_out_clause_main_interface(C,C1) :-
	C =< C1,!,
	printf(['c(',C,',I,Si,So,Di,Do) :- !,',{nl},
    		{tab},'c',C,'(I,Si,So,Di,Do).',{nl}]),
	NewC is C + 1,!,
	mgtp2pl_out_clause_main_interface(NewC,C1).

mgtp2pl_out_clause_main_loop(C,C1) :-
	C >  C1,!, nl.
mgtp2pl_out_clause_main_loop(C,C1) :-
	C =< C1,!,
	mgtp2pl_out_clause_main_one(C),
	NewC is C + 1,!,
	mgtp2pl_out_clause_main_loop(NewC,C1).

mgtp2pl_out_clause_main_one(C) :-
	retract('CLAUSE'(C,Ant,Suc,P2)),
	mgtp2pl_out_clause_main_print(Ant,C,Suc,P2),
	fail.
mgtp2pl_out_clause_main_one(C) :- !,
	printf(['c',C,'(_,Si,Si,Di,Di) .',{nl(2)}]).

mgtp2pl_out_clause_main_print([(Ant,P1,_)],C,Suc,P2) :- !,
	printf(['c',C,'(',{quote(Ant)},',']),
	mgtp2pl_out_clause_main_suc(Suc),
	printf(') :-'),
	mgtp2pl_out_clause_main_predicate(P1,P2),
	printf(['.',{nl}]).
mgtp2pl_out_clause_main_print([(Ant,P1,NextIns)|Rem],C,Suc,P2) :- !,
	printf(['c',C,'(',{quote(Ant)},',Si,[NI|Si],Di,[NI|Di]) :-']),
	mgtp2pl_out_clause_main_predicate(P1,[]),
	printf([',',{nl},{tab},'NI = ',{quote(NextIns)},'.',{nl}]),!,
	mgtp2pl_out_clause_main_print(Rem,C,Suc,P2).

mgtp2pl_out_clause_main_suc(or(Suc)) :- !,
	printf(['Si,Si,Di,[',{quote(Suc)},'|Di]']).
mgtp2pl_out_clause_main_suc(and(Suc)) :- !,
	printf('Si,['),
	mgtp2pl_out_clause_main_suc(Suc,''),
	printf('|Si],Di,Di').

mgtp2pl_out_clause_main_suc([],_) :- !.
mgtp2pl_out_clause_main_suc([One|Rem],C) :-
	printf([C,{quote(One)}]),!,
	mgtp2pl_out_clause_main_suc(Rem,',').

mgtp2pl_out_clause_main_predicate([],[]) :- !,
	printf(' !').
mgtp2pl_out_clause_main_predicate([One|Rem],[]) :- !,
	mgtp2pl_out_clause_main_predicate_([One|Rem],''),
	printf(',!').
mgtp2pl_out_clause_main_predicate([],[One|Rem]) :- !,
	printf(' !,'),
	mgtp2pl_out_clause_main_predicate_([One|Rem],'').
mgtp2pl_out_clause_main_predicate(P1,P2) :- !,
	mgtp2pl_out_clause_main_predicate_(P1,''),
	printf(',!,'),
	mgtp2pl_out_clause_main_predicate_(P2,'').

mgtp2pl_out_clause_main_predicate_(P,C) :- !,
	to_flat_list(P,NewP),
	mgtp2pl_out_clause_main_predicate_loop(NewP,C).

mgtp2pl_out_clause_main_predicate_loop([],_) :- !.
mgtp2pl_out_clause_main_predicate_loop([(O1;O2)|Rem],C) :- !,
	printf([C,{nl},{tab},'(',{quote(O1)},' ; ',{quote(O2)},')']),
	mgtp2pl_out_clause_main_predicate_loop(Rem,',').
mgtp2pl_out_clause_main_predicate_loop([One|Rem],C) :-
	printf([C,{nl},{tab},{quote(One)}]),!,
	mgtp2pl_out_clause_main_predicate_loop(Rem,',').

%%%%%%% Prolog predicate %%%%%%%

mgtp2pl_out_predicate :-
	retract('PREDICATE'(Predicate)),!,
	mgtp2pl_out_predicate_loop(Predicate).
mgtp2pl_out_predicate :- !.

mgtp2pl_out_predicate_loop([]) :- !.
mgtp2pl_out_predicate_loop([One|Rem]) :-
	mgtp2pl_out_predicate_one(One),!,
	mgtp2pl_out_predicate_loop(Rem).

mgtp2pl_out_predicate_one((Head :- Body)) :- !,
	printf([{quote(Head)},' :- ']),
	mgtp2pl_out_predicate_body(Body,''),
	printf(['.',{nl}]).
mgtp2pl_out_predicate_one(Head) :-
	printf([{quote(Head)},'.',{nl}]).

mgtp2pl_out_predicate_body('!',C) :- !,
	printf([C,'!']).
mgtp2pl_out_predicate_body((One,Rem),C) :- !,
	mgtp2pl_out_predicate_body(One,C),
	mgtp2pl_out_predicate_body(Rem,',').
mgtp2pl_out_predicate_body((O1;O2),C) :- !,
	printf([C,{nl},{tab},'(',{quote(O1)},';',{quote(O2)},')']).
mgtp2pl_out_predicate_body(One,C) :- !,
	printf([C,{nl},{tab},{quote(One)}]).

%% for beta write
%%mgtp2pl_out_predicate_one((Head :- !,Body)) :- !,
%%	printf([{quote(Head)},' :- !,',{nl},
%%		{tab},{quote(Body)},'.',{nl}]).
%%mgtp2pl_out_predicate_one((Head :- Body)) :- !,
%%	printf([{quote(Head)},' :- ',{nl},
%%		{tab},{quote(Body)},'.',{nl}]).
%%mgtp2pl_out_predicate_one(Head) :-
%%	printf([{quote(Head)},'.',{nl}]).
