% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)

%%  mgtp4.pl: Ground-MGTP/pl Engine

:- public mgtp_version/1.
mgtp_version(mg4).

%% > prolog
%% ?- compile(mgtp4).
%% ?- save_mgtp(mgtp).
%% ...
%% > mgtp name
%%        name_mg4.pl will be compiled and executed.

:- public save_mgtp/1.
save_mgtp(Save) :-
        save(Save),
        unix(argv(Argv)),
        ( Argv=[F|_],
          name(F,FS), mgtp_version(Ver), name(Ver,VerS),
          concat([FS,"_",VerS],InFS), name(InF,InFS),
          compile(InF) ->
            concat([FS,"_",VerS,".trace"],OutFS), name(OutF,OutFS),
            tell(OutF),
            do1(Ans,Time),
		recorded(model_number,Model,_),
		recorded(fail_number,Fail,_),

		write('======================================'),nl,
		write(Ans),write('.'),nl,nl,
		write('- - - - - - - - - - - - - - - - - - - '),nl,
		write('Number of Models  : '),write(Model),nl,
		write('Failed Branches   : '),write(Fail),nl,
		write('Execution Runtime : '),write(Time),
		write(' seconds.'),nl,
		write('- - - - - - - - - - - - - - - - - - - '),nl,nl,

		display('===================================='),ttynl,
		display(Ans),display('.'),ttynl,ttynl,
		display('- - - - - - - - - - - - - - - - - - '),ttynl,
		display('Number of Models  : '),display(Model),ttynl,
		display('Failed Branches   : '),display(Fail),ttynl,
		display('Execution Runtime : '),display(Time),
		display(' seconds.'),ttynl,
		display('- - - - - - - - - - - - - - - - - - '),ttynl,ttynl,

                told
	 ;
          true ),
        halt.

concat([X],X) :- !.
concat([H|L],X) :- append(H,Y,X),!, concat(L,Y).

append([H|X],Y,[H|Z]) :- !, append(X,Y,Z).
append([],Y,Y).

%%%%

%%  no-delta-dup version

%%  :- refer
%%      tm_new/1, tm_member/2, tm_put/3,
%%      positive_horn_cls/1, positive_nonhorn_cls/1, 
%%      fire_testers/5, fire_horn_cls/5, fire_nonhorn_cls/5,
%%      problem_type/1.

:- dynamic satisfiable/0.
:- unknown(_,fail).

:- public do1/2, do1/0, do10/0.
do1(Ans,Time) :- time1(do(Ans),Time).
do1 :- time1(do(_)).
do10 :- time10(do(_)).

:-public do/1.
do(Ans) :-
	clear_fail_number,
	clear_model_number,
	abolish(satisfiable,0),
	tm_new(TM),
	emptyBuf(Buf0),
	positive_horn_cls(Us),
	positive_nonhorn_cls(Ds),
	add_buf(Us,Ds,Buf0,Buf1),
	do_while(Buf1,[],0,TM),
	( satisfiable -> Ans= satisfiable ; Ans= unsatisfiable ).

:- op( 800, xfx, (:)).

do_while(InBuf,Case,Msize,TM) :-
	pickup(InBuf,Next,Buf) ->
	  (Next={Disj} ->
	      test_disj(Disj,NewDisj,TM,Res),
	      ( Res=satisfied -> do_while(Buf,Case,Msize,TM) ;
		make_case(NewDisj,0,NewCases),
		case_split(NewCases,Buf,Case,Msize,TM) )
          ;
	    Next='ATOM'(Atom,Info,Tcall,Hcall,NHcall),
	    tm_put(Atom,TM,LEAF),
	    ( var(LEAF) ->
	       (Atom = not(F),!,
	        tm_member9(F,TM,Ans)
	       ;
	        !,tm_member9(not(Atom),TM,Ans)),
	       (Ans == included, !, add_fail_number
	        ;
		Msize1 is Msize+1, 
		( fire_testers(Tcall,Atom,Msize1,TM,FatomID) ->
		    add_fail_number,
		    note_goal(Case,Msize1,
		              ((Msize1=Info:Atom)-->(FatomID:false))) ;
		  fire_horn_cls(Hcall,Atom,Msize1,TM,NewUs),
		  fire_nonhorn_cls(NHcall,Atom,Msize1,TM,NewDs),
		  write(NewDs),nl,
		  negative_unit_refute(NewDs,TM,NewDs1),
		  positive_unit_refute(NewUs,TM,Ans,NewUs1),!,   %%%%% 
		  (Ans == false,!, add_fail_number
		  ;
		   LEAF='LEAF'(Msize1),
		   note_atom(Msize1,Atom,Info),
%		   note_atom_positive(Msize1,Atom,Info),
		   add_buf(NewUs1,NewDs1,Buf,NewBuf),
%		   display(Msize1),ttynl,
%		   deb(Msize1),
		   get_new_disj(Atom,NewBuf,NewBuf1,Flag),!,
		   (Flag == false,!, add_fail_number
		    ;
		    do_while(NewBuf1,Case,Msize1,TM))))) 
	      ;
	      do_while(Buf,Case,Msize,TM))) 
        ;
	assert(satisfiable),
	add_model_number,
%	display_model(TM),
	note_model(Case,Msize).

%%%%

make_case([Atoms|Ds],C,[C1:Atoms|Cs]) :- C1 is C+1,!,
	make_case(Ds,C1,Cs).
make_case([],_,[]).

case_split([CC:Atoms|_],(Uhd,Dhd)-(Utl,Dtl),Case,Msize,TM) :-
	add_atoms(Atoms,Utl,NewUtl),
	display_facts(Atoms),
	do_while((Uhd,Dhd)-(NewUtl,Dtl),[CC|Case],Msize,TM), fail.
case_split([_|Ds],Buf,Case,Msize,TM) :-
	case_split(Ds,Buf,Case,Msize,TM).
case_split([],_,_,_,_).

add_atoms([Atom|Atoms],[Atom|Utl],NewUtl) :- !,
	add_atoms(Atoms,Utl,NewUtl).
add_atoms([],Utl,Utl).

test_disj([Atoms|Disj],NewDisj,TM,Res) :-
	reduce_atoms(Atoms,NewAtoms,TM),!,
	( NewAtoms=[] -> Res=satisfied ;
	  NewDisj=[NewAtoms|NewDisj1],!,
	  test_disj(Disj,NewDisj1,TM,Res) ).
test_disj([],[],_,unsatisfied).

reduce_atoms([Atom1|Atoms],NewAtoms,TM):-
	Atom1='ATOM'(Atom,_,_,_,_),
	( tm_member(Atom,TM) -> NewAtoms=NewAtoms1 ;
	  NewAtoms=[Atom1|NewAtoms1] ),!,
        reduce_atoms(Atoms,NewAtoms1,TM).
reduce_atoms([],[],_).

%%%%

%note_goal(_,_,_).
note_goal(Case,Msize,((Msize=ID:Atom)-->(XX:false))) :-
    write((Msize=ID:Atom)),write('.'),nl,
  ( problem_type(horn) -> display(Msize*Atom),display('.'),ttynl ; true ),
    write(('*'=XX:false)),write('.'),nl,
  ( problem_type(horn) -> true ;
    display('closed case:'),display_case(Case),display(':'),
    display(size(Msize)),display('.'),ttynl ),
    write(closed(case(Case),size(Msize))),write('.'),nl.

note_model(Case,Msize) :-
 display('model case:'),display_case(Case),display(':'),
 display(size(Msize)),display('.'),ttynl,
	write(model(case(Case),size(Msize))),write('.'),nl.

note_atom(Msize1,Atom,Info) :-
%  ( problem_type(horn) -> display(Msize1:Atom),ttynl ; true ),
 display(Msize1:Atom),ttynl,
	write(Msize1=Info:Atom),write('.'),nl.

display_case([C1,C2|Cs]) :- display_case([C2|Cs]),display('.'),display(C1).
display_case([C1]) :- display(C1).
display_case([]) :- display([]).

time1(X,Time) :-
        statistics(runtime,[T1,_]),
        call(X),
        statistics(runtime,[T2,_]),
        Time is (T2 - T1) / 1000.0.

time1(X) :-
        statistics(runtime,[T1,_]),
        call(X),
        statistics(runtime,[T2,_]),
        Secs is (T2 - T1) / 1000.0,
        nl, write('runtime: '), write(Secs), write(' seconds'), nl.

time10(X) :-
        copy_term(X,X1), copy_term(X,X2), copy_term(X,X3), copy_term(X,X4),
	copy_term(X,X5), copy_term(X,X6), copy_term(X,X7), copy_term(X,X8),
	copy_term(X,X9), copy_term(X,X10),
        statistics(runtime,[T1,_]),
        call(X1), call(X2), call(X3), call(X4), call(X5),
        call(X6), call(X7), call(X8), call(X9), call(X10),
        statistics(runtime,[T2,_]),
        Secs is (T2 - T1) / 1000.0,
        nl, write('runtime: '), write(Secs), write(' seconds'), nl.

%%%%

emptyBuf((U,D)-(U,D)).

add_buf([],[{X}|Rest],HD-(Utl,[{X}|Dtl]),HD-(Utl1,Dtl1)) :- !,
	add_buf([],Rest,HD-(Utl,Dtl),HD-(Utl1,Dtl1)).
add_buf([X|Rest],Ds,HD-([X|Utl],Dtl),HD-(Utl1,Dtl1)) :-
	add_buf(Rest,Ds,HD-(Utl,Dtl),HD-(Utl1,Dtl1)).
add_buf([],[],Buf,Buf).

pickup((Uhd,Dhd)-(Utl,Dtl),Next,(Uhd,NewDhd)-(Utl,Dtl)) :-
	var(Uhd), nonvar(Dhd),
	selection(Dhd,Next,NewDhd),!.
%%	Dhd=[Next|NewDhd].

pickup((Uhd,Dhd)-(Utl,Dtl),Next,(NewUhd,Dhd)-(Utl,Dtl)) :-
	nonvar(Uhd),!,
	Uhd=[Next|NewUhd].

%%  mgtp4.pl  EOF

%%-------- added by Y.Shirai

tm_member9(A,TM,Ans) :- 
	tm_member(A,TM),!,
	Ans = included.
tm_member9(_,_,not_found) :- !.

clear_fail_number :- 
	recorded(fail_number,_,R),
	erase(R),
	fail.
clear_fail_number :- !,
	recorda(fail_number,0,_).

add_fail_number :- 
	recorded(fail_number,FN,R),
	erase(R),
	FN1 is FN+1,
	display('Failed Branch := '),display(FN1),ttynl,
	write('Failed Branch := '),  write(FN1),nl,
	recorda(fail_number,FN1,_).

clear_model_number :- 
	recorded(model_number,_,R),
	erase(R),
	fail.
clear_model_number :- !,
	recorda(model_number,0,_).

add_model_number :- 
	recorded(model_number,FN,R),
	erase(R),
	FN1 is FN+1,
	recorda(model_number,FN1,_).

negative_unit_refute(Var,_,Var) :- var(Var),!.
negative_unit_refute([],_,[]) :- !.
negative_unit_refute([{H}|T],TM,[{NewH}|NewT]) :- !,
	negative_unit_refute1(H,TM,NewH),
	negative_unit_refute(T,TM,NewT).

%negative_unit_refute1([],_,[]) :- !.
%negative_unit_refute1([['ATOM'(not(F),A,B,C,D)]|Rest],
%	                TM,[['ATOM'(not(F),A,B,C,D)]|Rest1]) :- !,
%        negative_unit_refute1(Rest,TM,Rest1).
%negative_unit_refute1([['ATOM'(F,A,B,C,D)]|Rest],TM,NewH) :- 
%	(tm_member(not(F),TM),!,
%	 negative_unit_refute1(Rest,TM,NewH)
%	;
%	 !,NewH = [['ATOM'(F,A,B,C,D)]|Rest1],
%	 negative_unit_refute1(Rest,TM,Rest1)).

negative_unit_refute1([],_,[]) :- !.
negative_unit_refute1([AtomList|Rest],TM,Rest1) :- !,
	negative_unit_refute2(AtomList,TM,Res),
	(Res=refute,!,
	 negative_unit_refute1(Rest,TM,Rest1)
 	;
	 !, Rest1=[AtomList|Rest2],
	 negative_unit_refute1(Rest,TM,Rest2)).

negative_unit_refute2([],TM,not_refute) :- !.
negative_unit_refute2(['ATOM'(not(F),A,B,C,D)|Rest],TM,Res) :-
	(tm_member(F,TM),!,
	 Res=refute
	;
	 !,negative_unit_refute2(Rest,TM,Res)).
negative_unit_refute2(['ATOM'(F,A,B,C,D)|Rest],TM,Res) :- 
	(tm_member(not(F),TM),!,
	 Res=refute
	;
	 !,negative_unit_refute2(Rest,TM,Res)).

positive_unit_refute(Var,_,_,Var) :- 
	var(Var),!.
positive_unit_refute([],_,_,[]) :- !.
positive_unit_refute([H|T],TM,Ans,New) :- 
	positive_unit_refute1(H,TM,Ans0),
	(Ans0 == neg,Ans = false
	;
	 Ans0 == notNew,!,
	 positive_unit_refute(T,TM,Ans,New)
	;
	 !, New = [H|New1],
	 positive_unit_refute(T,TM,Ans,New1)).

positive_unit_refute1('ATOM'(not(F),_,_,_,_),TM,Ans) :- 
	(tm_member(F,TM),!,Ans = neg
	;
	 !, true).

positive_unit_refute1('ATOM'(A,_,_,_,_),TM,Ans) :- 
	(tm_member(not(A),TM),!, Ans = neg
	;
	 !, true).

positive_unit_refute1('ATOM'(_,_,_,_,_),_,_) :- !.

get_new_disj(Atom,NewBuf,NewBuf1,Flag) :- 
	NewBuf = (Uhd,Dhd)-(Utl,Dtl),
	get_new_disj0(Atom,(Uhd,Utl,NUtl),(Dhd,NDhd),Flag),
	NewBuf1 = (Uhd,NDhd)-(NUtl,Dtl).

get_new_disj0(not(Fact),(Uhd,Utl,NUtl),(Dhd,NDhd),Flag) :- 
	rewrite(not(Fact),(Uhd,Utl,NUtl),(Dhd,NDhd),Flag).
get_new_disj0(_,(_,Utl,Utl),(Dhd,Dhd),_) :- !.

rewrite(not(_),(_,Utl,Utl),(Dhd,Dhd),_) :- 
	var(Dhd),!.
rewrite(not(Fact),(Uhd,Utl,NUtl),([{Disj}|DisjRest],NDhd),Flag) :- 
	get_new_disj1(not(Fact),Disj,NewDisj),
	(NewDisj == [],!,Flag = false
	 ;
	 NewDisj = [[A]],!, 
	 Utl = [A|MUtl],
	 rewrite(not(Fact),(Uhd,MUtl,NUtl),(DisjRest,NDhd),Flag)
	 ;
	 NDhd = [{NewDisj}|NDhdRest],
	 rewrite(not(Fact),(Uhd,Utl,NUtl),(DisjRest,NDhdRest), Flag)).

get_new_disj1(not(_),[],[]) :- !.
get_new_disj1(not(P),[H|T],New) :- 
%%	(member('ATOM'(P,_,_,_),H),!,
	(H = ['ATOM'(P,_,_,_,_)],!,     %% Specialized for Bennett problems
	 get_new_disj1(not(P),T,New)
	;
	 !, New = [H|NewT],
	 get_new_disj1(not(P),T,NewT)).

display_facts([]) :- !.
display_facts(['ATOM'(F,_,_,_,_)|Rest]) :- !,
	display('--> '),display(F),ttynl,display_facts(Rest).

deb(150) :- !,
	deb.
deb(_) :- !.
deb.

selection([{Disj}|Rest],Next,NewDhd) :- !,
	length(Disj,L),
	selection(Rest,Disj,L,Next,NewDhd).

selection(D,Next,_,{Next},D) :- 
	var(D),!.
selection([],Next,_,{Next},[]) :- !.
selection([{Disj}|Rest],MedDisj,MedL,Next,NewDhd) :- 
	length(Disj,L),
	(L =< MedL,!,
	 NewDhd = [{MedDisj}|NewDhd1],
	 selection(Rest,Disj,L,Next,NewDhd1)
	;
	 L > MedL,!,
	 NewDhd = [{Disj}|NewDhd1],
	 selection(Rest,MedDisj,MedL,Next,NewDhd1)).

note_atom_positive(Msize1,not(Atom),Info) :- !.
note_atom_positive(Msize1,Atom,Info) :- !,
	display(Atom),ttynl.

display_model(TM) :- 
	display_model_a(1,TM),
	display_model_b(1,TM),
	display_model_c(1,TM),
	display_model_d(1,TM).

display_model_a(10,TM) :- !.
display_model_a(N,TM) :- 
	(tm_member(p(a,N),TM),
	 !,display(p(a,N)),ttynl
	;
	 tm_member(not(p(a,N)),TM),
	 !,display(not(p(a,N))),ttynl
	;
	 !,true),
	 !,N1 is N+1,
	 display_model_a(N1,TM).

display_model_b(10,TM) :- !.
display_model_b(N,TM) :- 
	(tm_member(p(b,N),TM),
	 !,display(p(b,N)),ttynl
	;
	 tm_member(not(p(b,N)),TM),
	 !,display(not(p(b,N))),ttynl
	;
	 !,true),
	 !,N1 is N+1,
	 display_model_b(N1,TM).

display_model_c(10,TM) :- !.
display_model_c(N,TM) :- 
	(tm_member(p(c,N),TM),
	 !,display(p(c,N)),ttynl
	;
	 tm_member(not(p(c,N)),TM),
	 !,display(not(p(c,N))),ttynl
	;
	 !,true),
	 !,N1 is N+1,
	 display_model_c(N1,TM).

display_model_d(10,TM) :- !.
display_model_d(N,TM) :- 
	(tm_member(p(d,N),TM),
	 !,display(p(d,N)),ttynl
	;
	 tm_member(not(p(d,N)),TM),
	 !,display(not(p(d,N))),ttynl
	;
	 !,true),
	 !,N1 is N+1,
	 display_model_d(N1,TM).
