% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)


%%  QG5-7_mg4.pl  Ground-MGTP/pl User-clauses

%%  Given clauses:
%%
%%   c1)	true-->dom(1),dom(2),dom(3),dom(4),dom(5),dom(6),dom(7).
%%   c2)	true-->p(1,1,1),p(2,2,2),p(3,3,3),p(4,4,4),p(5,5,5),p(6,6,6),p(7,7,7).
%%   c3)	dom(A),dom(B),{{A\==B}} --> p(A,B,1);p(A,B,2);p(A,B,3);p(A,B,4);p(A,B,5);p(A,B,6);p(A,B,7).
%%   c4)	dom(A),dom(B),{{A\==B}} --> p(A,1,B);p(A,2,B);p(A,3,B);p(A,4,B);p(A,5,B);p(A,6,B);p(A,7,B).
%%   c5)	dom(A),dom(B),{{A\==B}} --> p(1,A,B);p(2,A,B);p(3,A,B);p(4,A,B);p(5,A,B);p(6,A,B);p(7,A,B).
%%   c6)	p(A,B,C),dom(D),{{D\==A}} --> not(p(D,B,C)).
%%   c7)	p(A,B,C),dom(D),{{D\==B}} --> not(p(A,D,C)).
%%   c8)	p(A,B,C),dom(D),{{D\==C}} --> not(p(A,B,D)).
%%   c9)	dom(A),dom(B),{{C is A-1,B<C}} --> not(p(A,7,B)).
%%   c10)	p(A,B,C),p(C,A,D) --> p(D,A,B).
%%   c11)	p(A,B,C),not(p(C,A,D)) --> not(p(D,A,B)).
%%   c12)	not(p(A,B,C)),p(C,A,D) --> not(p(D,A,B)).
%%   c13)	p(A,B,C),p(D,A,B) --> p(C,A,D).
%%   c14)	not(p(A,B,C)),p(D,A,B) --> not(p(C,A,D)).
%%   c15)	p(A,B,C),not(p(D,A,B)) --> not(p(C,A,D)).
%%   c16)	p(A,B,C),p(C,B,D) --> p(B,D,A).
%%   c17)	not(p(A,B,C)),p(C,B,D) --> not(p(B,D,A)).
%%   c18)	p(A,B,C),not(p(C,B,D)) --> not(p(B,D,A)).

%%  After conversion...

%%  Positive clauses:
%%
%%   c1)	1:true --> 2:dom(1),3:dom(2),4:dom(3),5:dom(4),6:dom(5),7:dom(6),8:dom(7).
%%   c2)	1:true --> 2:p(1,1,1),3:p(2,2,2),4:p(3,3,3),5:p(4,4,4),6:p(5,5,5),7:p(6,6,6),8:p(7,7,7).

%%  Negative clauses:
%%

%%  Neutral clauses:
%%
%%   c3_1)	1:dom(A),2:dom(B),{{A\==B}} -->
%%      3:p(A,B,1);4:p(A,B,2);5:p(A,B,3);6:p(A,B,4);7:p(A,B,5);8:p(A,B,6);9:p(A,B,7).
%%   c3_2)	2:dom(B),1:dom(A),{{A\==B}} -->
%%      3:p(A,B,1);4:p(A,B,2);5:p(A,B,3);6:p(A,B,4);7:p(A,B,5);8:p(A,B,6);9:p(A,B,7).
%%   c3_f1f2)	f1f2:dom(A),{{A\==A}} -->
%%      3:p(A,A,1);4:p(A,A,2);5:p(A,A,3);6:p(A,A,4);7:p(A,A,5);8:p(A,A,6);9:p(A,A,7).
%%   c4_1)	1:dom(A),2:dom(B),{{A\==B}} -->
%%      3:p(A,1,B);4:p(A,2,B);5:p(A,3,B);6:p(A,4,B);7:p(A,5,B);8:p(A,6,B);9:p(A,7,B).
%%   c4_2)	2:dom(B),1:dom(A),{{A\==B}} -->
%%      3:p(A,1,B);4:p(A,2,B);5:p(A,3,B);6:p(A,4,B);7:p(A,5,B);8:p(A,6,B);9:p(A,7,B).
%%   c4_f1f2)	f1f2:dom(A),{{A\==A}} -->
%%      3:p(A,1,A);4:p(A,2,A);5:p(A,3,A);6:p(A,4,A);7:p(A,5,A);8:p(A,6,A);9:p(A,7,A).
%%   c5_1)	1:dom(A),2:dom(B),{{A\==B}} -->
%%      3:p(1,A,B);4:p(2,A,B);5:p(3,A,B);6:p(4,A,B);7:p(5,A,B);8:p(6,A,B);9:p(7,A,B).
%%   c5_2)	2:dom(B),1:dom(A),{{A\==B}} -->
%%      3:p(1,A,B);4:p(2,A,B);5:p(3,A,B);6:p(4,A,B);7:p(5,A,B);8:p(6,A,B);9:p(7,A,B).
%%   c5_f1f2)	f1f2:dom(A),{{A\==A}} -->
%%      3:p(1,A,A);4:p(2,A,A);5:p(3,A,A);6:p(4,A,A);7:p(5,A,A);8:p(6,A,A);9:p(7,A,A).
%%   c6_1)	1:p(A,B,C),2:dom(D),{{D\==A}} -->
%%      3:not(p(D,B,C)).
%%   c6_2)	2:dom(D),1:p(A,B,C),{{D\==A}} -->
%%      3:not(p(D,B,C)).
%%   c7_1)	1:p(A,B,C),2:dom(D),{{D\==B}} -->
%%      3:not(p(A,D,C)).
%%   c7_2)	2:dom(D),1:p(A,B,C),{{D\==B}} -->
%%      3:not(p(A,D,C)).
%%   c8_1)	1:p(A,B,C),2:dom(D),{{D\==C}} -->
%%      3:not(p(A,B,D)).
%%   c8_2)	2:dom(D),1:p(A,B,C),{{D\==C}} -->
%%      3:not(p(A,B,D)).
%%   c9_1)	1:dom(A),2:dom(B),{{C is A-1,B<C}} -->
%%      3:not(p(A,7,B)).
%%   c9_2)	2:dom(B),1:dom(A),{{C is A-1,B<C}} -->
%%      3:not(p(A,7,B)).
%%   c9_f1f2)	f1f2:dom(A),{{B is A-1,A<B}} -->
%%      3:not(p(A,7,A)).
%%   c10_1)	1:p(A,B,C),2:p(C,A,D) --> 3:p(D,A,B).
%%   c10_2)	2:p(C,A,D),1:p(A,B,C) --> 3:p(D,A,B).
%%   c11_1)	1:p(A,B,C),2:not(p(C,A,D)) --> 3:not(p(D,A,B)).
%%   c11_2)	2:not(p(C,A,D)),1:p(A,B,C) --> 3:not(p(D,A,B)).
%%   c12_1)	1:not(p(A,B,C)),2:p(C,A,D) --> 3:not(p(D,A,B)).
%%   c12_2)	2:p(C,A,D),1:not(p(A,B,C)) --> 3:not(p(D,A,B)).
%%   c13_1)	1:p(A,B,C),2:p(D,A,B) --> 3:p(C,A,D).
%%   c13_2)	2:p(D,A,B),1:p(A,B,C) --> 3:p(C,A,D).
%%   c14_1)	1:not(p(A,B,C)),2:p(D,A,B) --> 3:not(p(C,A,D)).
%%   c14_2)	2:p(D,A,B),1:not(p(A,B,C)) --> 3:not(p(C,A,D)).
%%   c15_1)	1:p(A,B,C),2:not(p(D,A,B)) --> 3:not(p(C,A,D)).
%%   c15_2)	2:not(p(D,A,B)),1:p(A,B,C) --> 3:not(p(C,A,D)).
%%   c16_1)	1:p(A,B,C),2:p(C,B,D) --> 3:p(B,D,A).
%%   c16_2)	2:p(C,B,D),1:p(A,B,C) --> 3:p(B,D,A).
%%   c16_f1f2)	f1f2:p(A,B,A) --> 3:p(B,A,A).
%%   c17_1)	1:not(p(A,B,C)),2:p(C,B,D) --> 3:not(p(B,D,A)).
%%   c17_2)	2:p(C,B,D),1:not(p(A,B,C)) --> 3:not(p(B,D,A)).
%%   c18_1)	1:p(A,B,C),2:not(p(C,B,D)) --> 3:not(p(B,D,A)).
%%   c18_2)	2:not(p(C,B,D)),1:p(A,B,C) --> 3:not(p(B,D,A)).

%%%%

:- op( 800, xfx, (:)).

:- public problem_type/1.
problem_type(nonHorn).

:- public tm_new/1.
tm_new('ROOT'(_,_,_)).

:- public tm_put/3.

tm_put(dom(A),Root,Leaf) :- !, arg(1,Root,Node1),
    tm_put1(A,Node1,Leaf).
tm_put(p(A,B,C),Root,Leaf) :- !, arg(2,Root,Node1),
    tm_put1(A,Node1,Node2),
    tm_put1(B,Node2,Node3),
    tm_put1(C,Node3,Leaf).
tm_put(not(A),Root,Leaf) :- !, arg(3,Root,Node1),
    tm_put1(A,Node1,Leaf).

tm_put1(X,Node,NextNode) :- var(Node),!,
    Node='NODE'(_,_,_,_,_,_,_,_,_),
    tm_put1(X,Node,NextNode).
tm_put1(1,Node,NextNode) :- !, arg(2,Node,NextNode).
tm_put1(2,Node,NextNode) :- !, arg(3,Node,NextNode).
tm_put1(3,Node,NextNode) :- !, arg(4,Node,NextNode).
tm_put1(4,Node,NextNode) :- !, arg(5,Node,NextNode).
tm_put1(5,Node,NextNode) :- !, arg(6,Node,NextNode).
tm_put1(6,Node,NextNode) :- !, arg(7,Node,NextNode).
tm_put1(7,Node,NextNode) :- !, arg(8,Node,NextNode).
tm_put1(p(A,B,C),Node,NextNode) :- !, arg(9,Node,Node1),
    tm_put1(A,Node1,Node2),
    tm_put1(B,Node2,Node3),
    tm_put1(C,Node3,NextNode).

tm_put1(X,Node,NextNode) :- arg(1,Node,NodeList),
    tm_put_list(NodeList,X,NextNode).

tm_put_list(NodeList,X,NextNode) :- var(NodeList),!,
    NodeList=[(X->NextNode)|_].
tm_put_list([(X->NextNode)|_],X,NextNode) :- !.
tm_put_list([_|NodeList],X,NextNode) :-
    tm_put_list(NodeList,X,NextNode).

%%%%

:- public tm_member/2.
tm_member(X,TM) :- tm_member0(X,TM,Leaf),!, nonvar(Leaf).

tm_member0(dom(A),Root,Leaf) :- arg(1,Root,Node1),
    tm_member1(A,Node1,Leaf).
tm_member0(p(A,B,C),Root,Leaf) :- arg(2,Root,Node1),
    tm_member1(A,Node1,Node2),
    tm_member1(B,Node2,Node3),
    tm_member1(C,Node3,Leaf).
tm_member0(not(A),Root,Leaf) :- arg(3,Root,Node1),
    tm_member1(A,Node1,Leaf).

tm_member1(_,Node,_) :- var(Node),!.
tm_member1(1,Node,NextNode) :- arg(2,Node,NextNode).
tm_member1(2,Node,NextNode) :- arg(3,Node,NextNode).
tm_member1(3,Node,NextNode) :- arg(4,Node,NextNode).
tm_member1(4,Node,NextNode) :- arg(5,Node,NextNode).
tm_member1(5,Node,NextNode) :- arg(6,Node,NextNode).
tm_member1(6,Node,NextNode) :- arg(7,Node,NextNode).
tm_member1(7,Node,NextNode) :- arg(8,Node,NextNode).
tm_member1(p(A,B,C),Node,NextNode) :- arg(9,Node,Node1),
    tm_member1(A,Node1,Node2),
    tm_member1(B,Node2,Node3),
    tm_member1(C,Node3,NextNode).

tm_member1(X,Node,NextNode) :- arg(1,Node,NodeList),
    tm_member_list(NodeList,X,NextNode).

tm_member_list(NodeList,_,_) :- var(NodeList),!.
tm_member_list([(X->NextNode)|_],X,NextNode).
tm_member_list([_|NodeList],X,NextNode) :-
    tm_member_list(NodeList,X,NextNode).

%%%%

:- public positive_horn_cls/1.
positive_horn_cls(Cls) :- findall(X,pos_horn(X),Cls),!.

pos_horn(Res) :- 
  ( Res='ATOM'(dom(1),{c1:(1:true-->2)},t_1,h_1,nh_1) ;
    Res='ATOM'(dom(2),{c1:(1:true-->3)},t_1,h_1,nh_1) ;
    Res='ATOM'(dom(3),{c1:(1:true-->4)},t_1,h_1,nh_1) ;
    Res='ATOM'(dom(4),{c1:(1:true-->5)},t_1,h_1,nh_1) ;
    Res='ATOM'(dom(5),{c1:(1:true-->6)},t_1,h_1,nh_1) ;
    Res='ATOM'(dom(6),{c1:(1:true-->7)},t_1,h_1,nh_1) ;
    Res='ATOM'(dom(7),{c1:(1:true-->8)},t_1,h_1,nh_1) ).

pos_horn(Res) :- 
  ( Res='ATOM'(p(1,1,1),{c2:(1:true-->2)},t_1,h_2,nh_2) ;
    Res='ATOM'(p(2,2,2),{c2:(1:true-->3)},t_1,h_2,nh_2) ;
    Res='ATOM'(p(3,3,3),{c2:(1:true-->4)},t_1,h_2,nh_2) ;
    Res='ATOM'(p(4,4,4),{c2:(1:true-->5)},t_1,h_2,nh_2) ;
    Res='ATOM'(p(5,5,5),{c2:(1:true-->6)},t_1,h_2,nh_2) ;
    Res='ATOM'(p(6,6,6),{c2:(1:true-->7)},t_1,h_2,nh_2) ;
    Res='ATOM'(p(7,7,7),{c2:(1:true-->8)},t_1,h_2,nh_2) ).

:- public positive_nonhorn_cls/1.
positive_nonhorn_cls(Cls) :- findall(X,pos_nonhorn(X),Cls),!.

:- public fire_testers/6.
fire_testers(Tcall,Atom,Nbr,TM,FatomInfo) :-
    Call=..[Tcall,(Atom,Nbr,TM),FatomInfo],!, call(Call).

:- public fire_horn_cls/6.
fire_horn_cls(Hcall,Atom,Nbr,TM,NewCls) :-
    findall(New,(Call=..[Hcall,(Atom,Nbr,TM),New], call(Call)),
            NewCls),!.

:- public fire_nonhorn_cls/6.
fire_nonhorn_cls(NHcall,Atom,Nbr,TM,NewCls) :-
    findall(New,(Call=..[NHcall,(Atom,Nbr,TM),New], call(Call)),
            NewCls),!.

t_1(_,_):-!,fail.

h_1(X,Y):-c6_2(X,Y).
h_1(X,Y):-c7_2(X,Y).
h_1(X,Y):-c8_2(X,Y).
h_1(X,Y):-c9_1(X,Y).
h_1(X,Y):-c9_2(X,Y).
h_1(X,Y):-c9_f1f2(X,Y).
h_2(X,Y):-c6_1(X,Y).
h_2(X,Y):-c7_1(X,Y).
h_2(X,Y):-c8_1(X,Y).
h_2(X,Y):-c10_1(X,Y).
h_2(X,Y):-c10_2(X,Y).
h_2(X,Y):-c11_1(X,Y).
h_2(X,Y):-c12_2(X,Y).
h_2(X,Y):-c13_1(X,Y).
h_2(X,Y):-c13_2(X,Y).
h_2(X,Y):-c14_2(X,Y).
h_2(X,Y):-c15_1(X,Y).
h_2(X,Y):-c16_1(X,Y).
h_2(X,Y):-c16_2(X,Y).
h_2(X,Y):-c16_f1f2(X,Y).
h_2(X,Y):-c17_2(X,Y).
h_2(X,Y):-c18_1(X,Y).
h_3(X,Y):-c11_2(X,Y).
h_3(X,Y):-c12_1(X,Y).
h_3(X,Y):-c14_1(X,Y).
h_3(X,Y):-c15_2(X,Y).
h_3(X,Y):-c17_1(X,Y).
h_3(X,Y):-c18_2(X,Y).

nh_1(X,Y):-c3_1(X,Y).
nh_1(X,Y):-c3_2(X,Y).
nh_1(X,Y):-c3_f1f2(X,Y).
nh_1(X,Y):-c4_1(X,Y).
nh_1(X,Y):-c4_2(X,Y).
nh_1(X,Y):-c4_f1f2(X,Y).
nh_1(X,Y):-c5_1(X,Y).
nh_1(X,Y):-c5_2(X,Y).
nh_1(X,Y):-c5_f1f2(X,Y).
nh_2(_,_):-!,fail.

%%%%

c3_1((dom(A),Nbr,TM),Res) :- 
    tm_member0(dom(B),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    A\==B,
    Res={[ [ 'ATOM'(p(A,B,1),{c3:(1:Nbr,2:Nbr1-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,2),{c3:(1:Nbr,2:Nbr1-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,3),{c3:(1:Nbr,2:Nbr1-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,4),{c3:(1:Nbr,2:Nbr1-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,5),{c3:(1:Nbr,2:Nbr1-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,6),{c3:(1:Nbr,2:Nbr1-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,7),{c3:(1:Nbr,2:Nbr1-->9)},t_1,h_2,nh_2) ] ]}.

c3_2((dom(B),Nbr,TM),Res) :- 
    tm_member0(dom(A),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    A\==B,
    Res={[ [ 'ATOM'(p(A,B,1),{c3:(2:Nbr,1:Nbr1-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,2),{c3:(2:Nbr,1:Nbr1-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,3),{c3:(2:Nbr,1:Nbr1-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,4),{c3:(2:Nbr,1:Nbr1-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,5),{c3:(2:Nbr,1:Nbr1-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,6),{c3:(2:Nbr,1:Nbr1-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,B,7),{c3:(2:Nbr,1:Nbr1-->9)},t_1,h_2,nh_2) ] ]}.

c3_f1f2((dom(A),Nbr,_),Res) :- 
    A\==A,
    Res={[ [ 'ATOM'(p(A,A,1),{c3:(f1f2:Nbr-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,A,2),{c3:(f1f2:Nbr-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,A,3),{c3:(f1f2:Nbr-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,A,4),{c3:(f1f2:Nbr-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,A,5),{c3:(f1f2:Nbr-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,A,6),{c3:(f1f2:Nbr-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,A,7),{c3:(f1f2:Nbr-->9)},t_1,h_2,nh_2) ] ]}.

c4_1((dom(A),Nbr,TM),Res) :- 
    tm_member0(dom(B),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    A\==B,
    Res={[ [ 'ATOM'(p(A,1,B),{c4:(1:Nbr,2:Nbr1-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,2,B),{c4:(1:Nbr,2:Nbr1-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,3,B),{c4:(1:Nbr,2:Nbr1-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,4,B),{c4:(1:Nbr,2:Nbr1-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,5,B),{c4:(1:Nbr,2:Nbr1-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,6,B),{c4:(1:Nbr,2:Nbr1-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,7,B),{c4:(1:Nbr,2:Nbr1-->9)},t_1,h_2,nh_2) ] ]}.

c4_2((dom(B),Nbr,TM),Res) :- 
    tm_member0(dom(A),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    A\==B,
    Res={[ [ 'ATOM'(p(A,1,B),{c4:(2:Nbr,1:Nbr1-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,2,B),{c4:(2:Nbr,1:Nbr1-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,3,B),{c4:(2:Nbr,1:Nbr1-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,4,B),{c4:(2:Nbr,1:Nbr1-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,5,B),{c4:(2:Nbr,1:Nbr1-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,6,B),{c4:(2:Nbr,1:Nbr1-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,7,B),{c4:(2:Nbr,1:Nbr1-->9)},t_1,h_2,nh_2) ] ]}.

c4_f1f2((dom(A),Nbr,_),Res) :- 
    A\==A,
    Res={[ [ 'ATOM'(p(A,1,A),{c4:(f1f2:Nbr-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,2,A),{c4:(f1f2:Nbr-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,3,A),{c4:(f1f2:Nbr-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,4,A),{c4:(f1f2:Nbr-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,5,A),{c4:(f1f2:Nbr-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,6,A),{c4:(f1f2:Nbr-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(A,7,A),{c4:(f1f2:Nbr-->9)},t_1,h_2,nh_2) ] ]}.

c5_1((dom(A),Nbr,TM),Res) :- 
    tm_member0(dom(B),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    A\==B,
    Res={[ [ 'ATOM'(p(1,A,B),{c5:(1:Nbr,2:Nbr1-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(2,A,B),{c5:(1:Nbr,2:Nbr1-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(3,A,B),{c5:(1:Nbr,2:Nbr1-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(4,A,B),{c5:(1:Nbr,2:Nbr1-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(5,A,B),{c5:(1:Nbr,2:Nbr1-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(6,A,B),{c5:(1:Nbr,2:Nbr1-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(7,A,B),{c5:(1:Nbr,2:Nbr1-->9)},t_1,h_2,nh_2) ] ]}.

c5_2((dom(B),Nbr,TM),Res) :- 
    tm_member0(dom(A),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    A\==B,
    Res={[ [ 'ATOM'(p(1,A,B),{c5:(2:Nbr,1:Nbr1-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(2,A,B),{c5:(2:Nbr,1:Nbr1-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(3,A,B),{c5:(2:Nbr,1:Nbr1-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(4,A,B),{c5:(2:Nbr,1:Nbr1-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(5,A,B),{c5:(2:Nbr,1:Nbr1-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(6,A,B),{c5:(2:Nbr,1:Nbr1-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(7,A,B),{c5:(2:Nbr,1:Nbr1-->9)},t_1,h_2,nh_2) ] ]}.

c5_f1f2((dom(A),Nbr,_),Res) :- 
    A\==A,
    Res={[ [ 'ATOM'(p(1,A,A),{c5:(f1f2:Nbr-->3)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(2,A,A),{c5:(f1f2:Nbr-->4)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(3,A,A),{c5:(f1f2:Nbr-->5)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(4,A,A),{c5:(f1f2:Nbr-->6)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(5,A,A),{c5:(f1f2:Nbr-->7)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(6,A,A),{c5:(f1f2:Nbr-->8)},t_1,h_2,nh_2) ],
           [ 'ATOM'(p(7,A,A),{c5:(f1f2:Nbr-->9)},t_1,h_2,nh_2) ] ]}.

c6_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(dom(D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    D\==A,
    Res='ATOM'(not(p(D,B,C)),{c6:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c6_2((dom(D),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    D\==A,
    Res='ATOM'(not(p(D,B,C)),{c6:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c7_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(dom(D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    D\==B,
    Res='ATOM'(not(p(A,D,C)),{c7:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c7_2((dom(D),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    D\==B,
    Res='ATOM'(not(p(A,D,C)),{c7:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c8_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(dom(D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    D\==C,
    Res='ATOM'(not(p(A,B,D)),{c8:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c8_2((dom(D),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    D\==C,
    Res='ATOM'(not(p(A,B,D)),{c8:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c9_1((dom(A),Nbr,TM),Res) :- 
    tm_member0(dom(B),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    C is A-1,
B<C,
    Res='ATOM'(not(p(A,7,B)),{c9:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c9_2((dom(B),Nbr,TM),Res) :- 
    tm_member0(dom(A),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    C is A-1,
B<C,
    Res='ATOM'(not(p(A,7,B)),{c9:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c9_f1f2((dom(A),Nbr,_),Res) :- 
    B is A-1,
A<B,
    Res='ATOM'(not(p(A,7,A)),{c9:(f1f2:Nbr-->3)},t_1,h_3,nh_2).

c10_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(p(C,A,D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(p(D,A,B),{c10:(1:Nbr,2:Nbr1-->3)},t_1,h_2,nh_2).

c10_2((p(C,A,D),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(p(D,A,B),{c10:(2:Nbr,1:Nbr1-->3)},t_1,h_2,nh_2).

c11_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(not(p(C,A,D)),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(D,A,B)),{c11:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c11_2((not(p(C,A,D)),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(D,A,B)),{c11:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c12_1((not(p(A,B,C)),Nbr,TM),Res) :- 
    tm_member0(p(C,A,D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(D,A,B)),{c12:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c12_2((p(C,A,D),Nbr,TM),Res) :- 
    tm_member0(not(p(A,B,C)),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(D,A,B)),{c12:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c13_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(p(D,A,B),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(p(C,A,D),{c13:(1:Nbr,2:Nbr1-->3)},t_1,h_2,nh_2).

c13_2((p(D,A,B),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(p(C,A,D),{c13:(2:Nbr,1:Nbr1-->3)},t_1,h_2,nh_2).

c14_1((not(p(A,B,C)),Nbr,TM),Res) :- 
    tm_member0(p(D,A,B),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(C,A,D)),{c14:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c14_2((p(D,A,B),Nbr,TM),Res) :- 
    tm_member0(not(p(A,B,C)),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(C,A,D)),{c14:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c15_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(not(p(D,A,B)),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(C,A,D)),{c15:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c15_2((not(p(D,A,B)),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(C,A,D)),{c15:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c16_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(p(C,B,D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(p(B,D,A),{c16:(1:Nbr,2:Nbr1-->3)},t_1,h_2,nh_2).

c16_2((p(C,B,D),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(p(B,D,A),{c16:(2:Nbr,1:Nbr1-->3)},t_1,h_2,nh_2).

c16_f1f2((p(A,B,A),Nbr,_),Res) :- 
    Res='ATOM'(p(B,A,A),{c16:(f1f2:Nbr-->3)},t_1,h_2,nh_2).

c17_1((not(p(A,B,C)),Nbr,TM),Res) :- 
    tm_member0(p(C,B,D),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(B,D,A)),{c17:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c17_2((p(C,B,D),Nbr,TM),Res) :- 
    tm_member0(not(p(A,B,C)),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(B,D,A)),{c17:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

c18_1((p(A,B,C),Nbr,TM),Res) :- 
    tm_member0(not(p(C,B,D)),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(B,D,A)),{c18:(1:Nbr,2:Nbr1-->3)},t_1,h_3,nh_2).

c18_2((not(p(C,B,D)),Nbr,TM),Res) :- 
    tm_member0(p(A,B,C),TM,Leaf1),nonvar(Leaf1),Leaf1='LEAF'(Nbr1),
    Res='ATOM'(not(p(B,D,A)),{c18:(2:Nbr,1:Nbr1-->3)},t_1,h_3,nh_2).

%%  QG5-7_mg4.pl  EOF
