/* (C) 1992 Instisute for New Generation Computer Technology
  ۤCOPYRIGHTե򻲾ȤƲ
 (Read COPYRIGHT for detailed information.)

 1993.1 Check and refine ervery program for IFS (ICOT Free Software) release
*/
/*
 *	find.c
 *			(C) Copyright 1991, All rights reserved by ICOT
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "define.h"
#include "config.h"
#include "wchar.h"
#include "find.h"


FILE *root_fp, *path_fp, *info_fp;

static struct {
    long	offset;
    int		length;
} match[S_DEPTH];

static int n_match;


long path_offset(wch)
    w_char_t wch;
{
    long p_offset, r_offset;

    r_offset = (long)wch - ROOT_BASE;
    r_offset <<= 2;
    (void)fseek(root_fp, r_offset, 0);
    (void)fread((char *)&p_offset, sizeof(p_offset), 1, root_fp);
    return (long)ntohl((u_long)p_offset);
}

void byte_order(info, size)
    char *info;
    int size;
{
    register int i, length;
    u_short s;
    char *start;

    start = info;
    do {
	bcopy((char *)info, (char *)&s, sizeof(short));
	s = ntohs(s);
	bcopy((char *)&s, (char *)info, sizeof(short));
	info += sizeof(short);
	bcopy((char *)info, (char *)&s, sizeof(short));
	s = ntohs(s);
	length = (int)s;
	bcopy((char *)&s, (char *)info, sizeof(short));
	info += sizeof(short);
	for (i = 0; i < length; i++) {
	    bcopy((char *)info, (char *)&s, sizeof(short));
	    s = ntohs(s);
	    bcopy((char *)&s, (char *)info, sizeof(short));
	    info += sizeof(short);
	}
    } while (info - start < size);
}


long bin_search(wch, path_tbl, length)
    w_char_t wch;
    char *path_tbl;
    long length;
{
    register char *path;
    register long n;
    w_char_t code;
    long long_buf;

    if (length == 0)
        return NULL;
    n = length / 2;
    path = path_tbl + n * PATH_REC_SIZE;
    bcopy((char *)(path + FILE_OFFSET_SIZE), (char *)&code, sizeof(code));
    code = ntohs(code);
    if (code == wch) {
	bcopy((char *)path, (char *)&long_buf, sizeof(long));
	return (long)ntohl((u_long)long_buf);
    } else if (n == 0)
        return NULL;
    else if (wch < code)
	return bin_search(wch, path_tbl, n);
    return bin_search(wch, path + PATH_REC_SIZE, n - 1 + length % 2);
}

void search_word(offset, ibuf, n)
    long offset;
    w_char_t *ibuf;
    int n;
{
    long length, child, long_buf;
    w_char_t code;
    register char *path;
    static long path_tbl_buf[MAX_PATH_TBL/sizeof(long)];
    char *path_tbl = (char *)path_tbl_buf;

    (void)fseek(path_fp, offset, 0);
    (void)fread((char *)&length, sizeof(length), 1, path_fp);
    length = (long)ntohl((u_long)length);
    (void)fread(path_tbl, PATH_REC_SIZE, (int)length, path_fp);
    path = path_tbl;
    bcopy((char *)(path + FILE_OFFSET_SIZE), (char *)&code, sizeof(code));
    code = ntohs(code);
    if (code == 0) {
	bcopy((char *)path, (char *)&long_buf, sizeof(long));
	match[n_match].offset = (long)ntohl((u_long)long_buf);
	match[n_match++].length = n;
	path += PATH_REC_SIZE;
	--length;
    }
    if (ibuf[n] != 0) {
	if ((child = bin_search(ibuf[n], path, length)) != NULL)
	    search_word(child, ibuf, n + 1);
    }
}

int read_info(offset, poses, yomi, depth)
    long offset;
    short poses[][S_WIDTH];
    w_char_t yomi[][S_WIDTH][S_STRL];
    register int depth;
{
    register int n, i, y_len;
    short size;
    short *info;
    static long info_buffer[MAX_INFO_TBL/sizeof(long)];
    char *info_buf = (char *)info_buffer;

    (void)fseek(info_fp, offset, 0);
    (void)fread((char *)&size, sizeof(size), 1, info_fp);
    size = (short)ntohs((u_short)size) - INFO_HEAD_SIZE;
    (void)fread(info_buf, size, 1, info_fp);
    byte_order(info_buf, size);
    info = (short *)info_buffer;
    n = 0;
    do {
	poses[depth][n] = *info++;
	y_len = *info++;
	for (i = 0 ; i < y_len; i++)
	    yomi[depth][n][i] = *info++;
	yomi[depth][n][i] = 0;
	++n;
    } while ((((char *)info) - info_buf) < size);
    return n;
}

void searchw(word, count, inn, num, poses, yomi)
    w_char_t word[];
    int *count, inn[], num[];
    short poses[][S_WIDTH];
    w_char_t yomi[][S_WIDTH][S_STRL];
{
    register int i, j;
    long root;

    n_match = 0;
    if ((root = path_offset(word[0])) != NULL) {
	search_word(root, word, 1);
	if (n_match > 0) {
	    for (i = 0, j = n_match - 1; j >= 0; i++, j--) {
		inn[i] = read_info(match[j].offset, poses, yomi, i);
		num[i] = match[j].length;
	    }
	}
    } 
    *count = n_match;
}
