% (C) 1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information)

%
% file name :   pst.spec
%
% (01) 91. 1.26 by S.K. create moduole pst
% (02) 91. 1.30 by T.S. remove suppressor definition
% (03) 91. 1.30 by T.S. change suppressor ` to $
% (04) 91. 2. 5 by T.S. change all level suppressor from $ to $$
% (05) 91. 2. 6 by T.S. change = to predicate_syntax
% (06) 91. 2. 6 by T.S. change syntax from use kl0 to environment kl0
% (07) 91. 2. 7 by S.K. change head_unification predicate
% (08) 91. 2. 7 by S.K. change syntax =
% (09) 91. 2. 8 by T.S. replace mk_assoc/2 with mk_pst/2
% (10) 91. 2.13 by S.K. view assoc/3 for tst
% (11) 91. 2.25 by S.K. change suppressor from ` to $
% (12) 91. 4. 4 by S.K. add syntax :
 

%
% PST environment
%   specifies meta_esp_call,esp_call as environments
%   uses kl0/builtin
%

:- define pst.

%
%
% pst builtin
%
:-define pst/builtin.
:-environment meta_esp_call.

%   unification
:-view head_unify/2,unify_cil/2.

%   equality
:-view same/2.

%   copy
:-view fullCopy/2.

%   partial
:-view partial/1,mk_assoc/2,role/3,locate/3,getRole/3,
        setOfKeys/2,record/2,buffer/2.

%   control partial
:-view glue/2,merge/2,t_merge/2,d_merge/2,delete/3,masked_merge/3,
        subpat/3,t_subpat/2,extend/3,meet/3,frontier/3,match/3.

%   for dif/2 in constraint module
:- view same_gr/2.

%   view for meta predicate
:-view role_gr/3.

%   view for tst
:-view assoc/3.

%   for compiling optimize
%:-view u_tr/2,u_x/2,u_nv_v/2,u_nv_nv/2,u_s_s/2,u_tr_tr/2,
%     u_v_x/2,u_x_x/2,u_list/2,u_atom/2,u_nil/2.
%:-view same_nv/2,same_x/2,same_nv_nv/2,same_tr_tr/2,
%     same_x_x/2,same_s_s/2,difAtom/2,sameAtom/2.
%:-view role1/3,role_gr/3,record/3,buffer1/2,buffer/3.
%:-view subpat1/3,t_subpat/2,extend1/3.

%
% partial/1
%
partial(X):-
    unbound(X),!,fail.
partial(X):-
    stack_vector(X,3),
    first(X,F),
    F == x,!.

%
% role/3
%
role(K,S,V):-
    unbound(K),!,
    when(K,role_gr(K,S,V)).
role(K,S,V):-
    atomic(K),!,
    role1(S,K,V).
role(X,S,V):-
    when(X,role_gr(X,S,V)).

role_gr(X,S,V) :-
    ground(X,Gr), role1(S,Gr,V).

role1(x(A,S),K,V):-
    unbound(A),!,
    assoc(S,K,V).
role1(x(A,_),K,V):-!,
    role1(A,K,V).

assoc(X,K,V):-
    unbound(X),!,
    X = t((K,V),_,_).
assoc(t((K,U),_,_),K,V):-!,
    unify_cil(U,V).
assoc(t((K,_),_,R),N,V):-   % right
    K < N,!,
    assoc(R,N,V).
assoc(t(_,L,_),N,V):-   % left
    assoc(L,N,V).

%
%   locate/3
%
locate(x(P,L),Y,Z):-
    unbound(P),!,
    ground(Y,G),
    locate1(L,G,Z).
locate(x(P,_),Y,Z):-
    locate(P,Y,Z).

locate1(Y,_,_):-
    unbound(Y),!,
    fail.
locate1(t((K,V),_,_),K,U):-!,
    unify_cil(U,V).
locate1(t((K,_),_,R),J,U):-
    K < J,!,
    locate1(R,J,U).
locate1(t(_,L,_),J,U):-
    locate1(L,J,U).

ground(A,_):-
    unbound(A),!,fail.
ground([X|R],[Y|S]):-!,
    ground(X,Y),!,
    ground(R,S).
ground(X,Y):-
    stack_vector(X,N),!,
    new_stack_vector(Y,N),
    ground(N,X,Y).
ground(X,X).    % atomic,string,heap,etc

ground(0,_,_):-!.
ground(I,X,Y):-
    J is I - 1,
    vector_element(X,J,A),
    vector_element(Y,J,B),
    ground(A,B),
    ground(J,X,Y).

%
% getRole/3
%
getRole(X,_,_):-
    unbound(X),!,
    fail.
getRole(x(P,T),K,V):-
    unbound(P),!,
    getRole1(T,K,V).
getRole(x(P,_),K,V):-
    getRole(P,K,V).

getRole1(X,_,_):-
    unbound(X),!,
    fail.
getRole1(t((K,U),_,_),R,V):-
    unify_cil(K,R),
    unify_cil(U,V).
getRole1(t(_,L,_),N,V):-
    getRole1(L,N,V).
getRole1(t(_,_,R),N,V):-
    getRole1(R,N,V).

%
% setOfKeys/2
%
setOfKeys(X,S):-
    unbound(X),!,
    S = [].
setOfKeys(x(P,T),S):-
    unbound(P),!,
    setOfKeys(T,A,[]),
    unify_cil(S,A).
setOfKeys(x(P,_),S):-
    setOfKeys(P,S).

setOfKeys(X,A,A):-
    unbound(X),!.
setOfKeys(t((K,_),L,R),A,B):-
    setOfKeys(L,A,[K|C]),
    setOfKeys(R,C,B).

%
% record/2
%
record(X,Y):-
    unbound(X),!,
    Y = [].
record(x(P,T),Y):-
    unbound(P),!,
    record(T,Y,[]).
record(x(P,_),Y):-
    record(P,Y).

record(X,P,Q):-
    unbound(X),!,
    unify_cil(P,Q).
record(t(A,L,R),P,Q):-
    record(L,P,M),
    unify_cil(M,[A|N]),
    record(R,N,Q).

%
% buffer/2 for no_debug
%
buffer(X,Y):-
    bind_hook(Y,buffer1(X,Y)).

buffer1(X,Y):-
    unbound(X),!,
    unify_cil(Y,[end|_]).
buffer1(x(P,T),Y):-
    unbound(P),!,
    buffer(T,[],Y).
buffer1(x(P,_),Y):-
    buffer1(P,Y).

buffer(_,_,[]):-!.
buffer(X,[],Q):-
    unbound(X),!,
    unify_cil([end|_],Q).
buffer(X,[P|R],Q):-
    unbound(X),!,
    buffer(P,R,Q).
buffer(t(A,L,R),P,Q):-
    unify_cil(Q,[A|S]),
    bind_hook(S,buffer(L,[R|P],S)).

%
% mk_pst/2 for partial term since spec v1
%
:-view mk_pst/2.
mk_pst([],   x(_,_)):-!.
mk_pst({},   x(_,_)):-!.
mk_pst(X, x(P,T)):-unbound(P),!,
    mk_pst1(X, T).
mk_pst(X, x(P,_)):-!,
    mk_pst(X,P).

mk_pst1([], _):-!.
mk_pst1([X|Y], Z):-
    mk_pst1(X, Z),!,
    mk_pst1(Y, Z).
mk_pst1((L,V), Z):-assoc(Z,L,V).

%
% mk_assoc/2 partial term for CIL V3 compatibility
%
mk_assoc({},x(_,_)):-!.
mk_assoc('{}',x(_,_)):-!.
mk_assoc(X,x(P,T)):-unbound(P),!,
    mk_assoc1(X,T).
mk_assoc(X,x(P,_)):-!,
    mk_assoc(X,P).

mk_assoc1((X,Y),Z):-!,
    mk_assoc1(X,Z), mk_assoc1(Y,Z).
mk_assoc1(`(X / Y),Z):-assoc(Z,X,Y).

% :-public subpat/3.
subpat(x(P,_),Y,D):-
    bound(P),!,
    subpat(P,Y,D).
subpat(X,x(P,_),D):-
    bound(P),!,
    subpat(X,P,D).
subpat(x(_,L),x(_,R),D):-
    subpat1(L,R,D).

%:-public subpat1/3.
subpat1(X,_,`(A - A)):-
    unbound(X),!.
subpat1(void,_,`(A - A)):-!.
subpat1(_,Y,_):-
    unbound(Y),!,fail.
subpat1(t((K,U),P,Q),t((K,V),L,R),`([(K,U,V)|C] - B)):-!,
    subpat1(P,L,`(C - D)),
    subpat1(Q,R,`(D - B)).
subpat1(t((K,U),P,Q),t((J,V),S,T),`(A - B)):-
    K < J,!,
    subpat1(P,S,`(A - C)),
    subpat1(Q,t((J,V),S,T),`(C - [(K,U,W)|B])),
    locate1(S,K,W).
subpat1(t((K,U),P,Q),t((J,V),S,T),`(A - B)):-
    subpat1(Q,T,`(A - C)),
    subpat1(P,t((J,V),S,T),`(C - [(K,U,W)|B])),
    locate1(T,K,W).

% :-public extend/3.
extend(x(P,_),Y,D):-
    bound(P),!,
    extend(P,Y,D).
extend(X,x(P,_),D):-
    bound(P),!,
    extend(X,P,D).
extend(x(_,L),x(_,R),D):-
    extend1(L,R,D).

% :-public extend1/3.
extend1(X,_,`(A - A)):-
    unbound(X),!.
extend1(void,_,`(A - A)):-!.
extend1(t((K,U),P,Q),t((K,V),L,R),`([(K,U,V)|C] - B)):-!,
    extend1(P,L,`(C - D)),
    extend1(Q,R,`(D - B)).
extend1(t((K,U),P,Q),t((J,V),S,T),`(A - B)):-
    K < J,!,
    extend1(P,S,`(A - C)),
    extend1(Q,t((J,V),S,T),`(C - [(K,U,W)|B])),
    assoc(S,K,W).
extend1(t((K,U),P,Q),t((J,V),S,T),`(A - B)):-
    extend1(Q,T,`(A - C)),
    extend1(P,t((J,V),S,T),`(C - [(K,U,W)|B])),
    assoc(T,K,W).

% :-public match/3.
match(X,Y,``([(X = Y)|R] - R)):-
    unbound(X),!.
match(X,Y,``([(X = Y)|R] - R)):-
    unbound(Y),!.
match(x(X,T),x(Y,S),``([(x(X,T) = x(Y,S))|R] - R)):-!.
match(X,Y,L):-
    list(X),!,
    list(Y),
    match_list(X,Y,L).
match(X,Y,L):-
    stack_vector(X,N),
    stack_vector(Y,N),!,
    match(N,X,Y,L).
match(X,Y,`(L - L)):-  % atomic,string,heap,etc
    X = Y,!.
match(X,Y,``([(X = Y)|R] - R)).

match_list([X|A],[Y|B],`(L - R)):-!,
    match(X,Y,`(L - T)),!,
    match(A,B,`(T - R)).

match(0,_,_,`(L - L)):-!.
match(I,X,Y,`(L - R)):-
    J is I - 1,
    vector_element(X,J,A),
    vector_element(Y,J,B),
    match(A,B,`(L - P)),
    match(J,X,Y,`(P - R)).

%
% glue two records.
%
% :-public glue/2.
glue(x(P,_),Y):-
    bound(P),!,
    glue(P,Y).
glue(X,x(P,_)):-
    bound(P),!,
    glue(X,P).
glue(x(X,_),x(Y,_)):-
    X == Y,!.
glue(x(_,X),x(_,Y)):-
    glue1(X,Y).

glue1(X,_):-
    unbound(X),!.
glue1(_,Y):-
    unbound(Y),!.
glue1(t((K,U),A,B),t((K,V),C,D)):-!,
    unify_cil(U,V),
    glue1(A,C),!,
    glue1(B,D).
glue1(t((K,U),A,B),t((J,V),C,D)):-
    K < J,!,
    glue1(A,C),
    glue1_unify(K,U,C),!,
    glue1(B,t((J,V),C,D)).
glue1(t((K,U),A,B),t((J,V),C,D)):-!,
    glue1(C,A),
    glue1_unify(J,V,A),!,
    glue1(D,t((K,U),A,B)).
glue1(_,_).

glue1_unify(K,U,T):-
    locate1(T,K,W),!,
    unify_cil(U,W).
glue1_unify(_,_,_).

% merging two assignments to the right.
% :-public merge/2.
merge(x(P,_),Y):-
    bound(P),!,
    merge(P,Y).
merge(X,x(P,_)):-
    bound(P),!,
    merge(X,P).
merge(x(_,S),x(_,T)):-
    merge1(S,T).

merge1(X,_):-
    unbound(X),!.
merge1(void,_):-!.
merge1(t((K,U),P,Q),t((K,V),L,R)):-!,
    unify_cil(U,V),
    merge1(P,L),!,
    merge1(Q,R).
merge1(t((K,U),P,Q),t((J,V),S,T)):-
    K < J,!,
    merge1(P,S),
    merge1(Q,t((J,V),S,T)),
    assoc(S,K,W),
    unify_cil(U,W).
merge1(t((K,U),P,Q),t((J,V),S,T)):-
    merge1(Q,T),
    merge1(P,t((J,V),S,T)),
    assoc(T,K,W),
    unify_cil(U,W).

% :- public d_merge/2.
d_merge(x(P,_),Y):-
    bound(P),!,
    d_merge(P,Y).
d_merge(X,x(P,_)):-
    bound(P),!,
    d_merge(X,P).
d_merge(x(_,S),x(_,T)):-
    d_merge1(S,T).

d_merge1(X,_):-
    unbound(X),!.
d_merge1(void,_):-!.
d_merge1(t((K,U),P,Q),t((K,V),L,R)):-!,
    d_merge1_unify(U,V),
    d_merge1(P,L),!,
    d_merge1(Q,R).
d_merge1(t((K,U),P,Q),t((J,V),S,T)):-
    K < J,!,
    d_merge1(P,S),
    d_merge1(Q,t((J,V),S,T)),
    assoc(S,K,W),
    d_merge1_unify(U,W).
d_merge1(t((K,U),P,Q),t((J,V),S,T)):-
    d_merge1(Q,T),
    d_merge1(P,t((J,V),S,T)),
    assoc(T,K,W),
    d_merge1_unify(U,W).

d_merge1_unify(X,Y):-
    unify_cil(X,Y),!.
d_merge1_unify(_,_).

% :- public t_subpat/2.
t_subpat(A,_):-
    unbound(A),!.
t_subpat(x(P,Q),X):-
    unbound(X),!,
    t_subpat1(x(P,Q),X).
t_subpat(A,B):-
    t_subpat1(A,B).

% :- public t_subpat1/2.
t_subpat1(x(A,B),x(C,D)):-!,
    subpat(x(A,B),x(C,D),`(L - [])),
    t_subpat1(L).
t_subpat1(X,Y):-
    unbound(Y),!,
    t_subpat1_v(X,Y).
t_subpat1(X,Y):-
    frontier(X,Y,`(Z - [])),
    t_subpat2(Z). 

t_subpat1_v(X,Y):-
    list(X),!,
    frontier_list(X,U,`(Z - [])),
    t_subpat2(Z),
    unify(Y,U).
t_subpat1_v(X,Y):-
    stack_vector(X,N),!,
    new_stack_vector(U,N),
    frontier(N,X,U,`(Z - [])),
    t_subpat2(Z),
    Y = U.
t_subpat1_v(X,X).   % atomic,string,heap,etc

% :- public t_subpat1/1.
t_subpat1([]):-!.
t_subpat1([(_,X,Y)|W]):-!,
    t_subpat(X,Y),
    t_subpat1(W).

% :- public t_subpat2/1.
t_subpat2([]):-!.
t_subpat2([`(X = Y)|W]):-!,
    t_subpat(X,Y),t_subpat2(W).

%% :-public delete/3.
delete(K,x(P,_),Y):-
    stack_vector(P,3),!,
    delete(K,P,Y).
delete(K,x(_,T),Y):-
    ground(K,K1),
    mask1(T,t((K1,_),_,_),Z),
    u_x(Y,x(_,Z)).
    
%
% entry for head unification option
%
head_unify(X,Y):-
    unify_cil(X,Y).

%
% cil unification
%
unify_cil(X,Y):-
    unbound(X),
    unbound(Y),!,   % (-,-)
    X = Y.
unify_cil(X,Y):-
    unbound(X),!,   % (-,+)
    u_nv_v(Y,X).
unify_cil(X,Y):-
    unbound(Y),!,   % (+,-)
    u_nv_v(X,Y).
unify_cil(X,Y):-    % (+,+)
    u_nv_nv(X,Y).

u_x(X,Y):-
    unbound(X),!,
    u_v_x(X,Y).
u_x(X,Y):-
    u_x_x(X,Y).

u_nv_nv(X,Y):-
    X = {F,_,_},
    F == x,!,
    u_x_x(Y,X).
u_nv_nv(X,Y):-
    u_tr_tr(Y,X).

u_nv_v(X,Y):-
    X = {F,_,_},
    F == x,!,
    u_v_x(Y,X).
u_nv_v(X,X).

u_v_x(X,x(Y,Z)):-
    unbound(Y),!,
    X = x(Y,Z).
u_v_x(X,x(Y,_)):-
    u_v_x(X,Y).

u_x_x(U,V):-
    U = x(X,S),
    ( unbound(X),!,
      V = x(Y,T),
      ( unbound(Y),!,
        ( X == Y,!
        ; X = V,
          u_s_s(S,T)
        )
      ; u_x_x(Y,U)
      )
    ; u_x_x(X,V)
    ).

u_s_s(Y,X):-
    unbound(X),!,
    X = Y.
u_s_s(Y,_):-
    unbound(Y),!.
u_s_s(void,_):-!.
u_s_s(t((K,V),L,R),t((K,U),S,T)):-!,
    unify_cil(U,V),
    u_s_s(L,S),
    u_s_s(R,T).
u_s_s(t((K,V),L,R),t((J,U),S,T)):-
    K < J,!,
    u_s_s_max(K,V,L,S),
    u_s_s(R,t((J,U),S,T)).
u_s_s(t((K,V),L,R),t((J,U),S,T)):-
    u_s_s_min(K,V,R,T),
    u_s_s(L,t((J,U),S,T)).

u_s_s_max(K,V,L,t((K,U),P,_)):-!,
    unify_cil(V,U),
    u_s_s(L,P).
u_s_s_max(K,V,L,t((J,U),P,Q)):-
    J < K,!,
    assoc(Q,K,V),
    u_s_s(L,t((J,U),P,Q)).
u_s_s_max(K,V,L,t((_,_),P,_)):-
    u_s_s_max(K,V,L,P).

u_s_s_min(K,V,L,t((K,U),_,Q)):-!,
    unify_cil(V,U),u_s_s(L,Q).
u_s_s_min(K,V,L,t((J,U),P,Q)):-
    K < J,!,
    assoc(P,K,V),
    u_s_s(L,t((J,U),P,Q)).
u_s_s_min(K,V,L,t((_,_),_,Q)):-
    u_s_s_min(K,V,L,Q).

u_tr_tr([X|Y],[A|B]):-!,
    unify_cil(X,A),!,
    unify_cil(Y,B).
u_tr_tr(X,Y):-
    stack_vector(X,N),!,
    stack_vector(Y,N),
    u_tr_tr(0,N,X,Y).
u_tr_tr(X,X).

u_tr_tr(N,N,_,_):-!.
u_tr_tr(I,N,X,Y):-
    vector_element(X,I,A),
    vector_element(Y,I,B),
    unify_cil(A,B),
    J is I + 1,
    u_tr_tr(J,N,X,Y).

%
% same/2
%
same(X,Y):-
    ( unbound(X)
    ; unbound(Y) ),!,
    X == Y.
same(X,Y):-
    same_nv_nv(X,Y).

same_nv_nv(x(A,B),X):-!,
    same_x_x(X,x(A,B)).
same_nv_nv(X,Y):-
    same_tr_tr(Y,X).

same_tr_tr([X|Y],[A|B]):-!,
    same(X,A),
    same(Y,B).
same_tr_tr(X,Y):-
    stack_vector(X,N),
    stack_vector(Y,N),
    same_tr_tr(N,X,Y).
same_tr_tr(X,Y):-
    X == Y. % atomic,string,heap,etc

same_tr_tr(0,_,_):-!.
same_tr_tr(I,X,Y):-
    J is I - 1,
    vector_element(X,J,A),
    vector_element(Y,J,B),
    same(A,B),
    same_tr_tr(J,X,Y).

same_x_x(U,V):-
    U = x(X,S),
    ( unbound(X),!,
      V = x(Y,T),
      ( unbound(Y),!,
        ( X == Y,!
        ; bind_hook(A,bind_hook(B,same_s_s(A,B))),
          record(S,A,[]), 
          record(T,B,[])
        )
      ; same_x_x(Y,U)
      )
    ; same_x_x(X,V)
    ).

same_s_s([],[]):-!.
same_s_s([(A,B)|R],[(A,C)|S]):-!,
    same(B,C),
    bind_hook(R,bind_hook(S,same_s_s(R,S))).

% ammend atomic check
same_gr(X,_):-
    unbound(X),!,fail.
same_gr([X|A],[Y|B]):-!,
    same_gr(X,Y),!,
    same_gr(A,B).
same_gr(X,Y):-
    stack_vector(X,N),
    stack_vector(Y,N),
    same_gr(N,X,Y).
same_gr(X,Y):-
    X == Y.     % atomic,string,heap,etc

same_gr(0,_,_):-!.
same_gr(I,X,Y):-
    J is I - 1,
    vector_element(X,J,A),
    vector_element(Y,J,B),
    same_gr(A,B),
    same_gr(J,X,Y).

%
% copy predicate
%
fullCopy(X,Y):-
    fresh(X,_,Y).

fresh(X,M,Y):-
    unbound(X),!,
    mapvar(X,M,Y).
fresh(x(P,T),M,A):-!,
    mapAList(x(P,T),M,A).

fresh([A|X],M,[B|Y]):-!,
    fresh(A,M,B),!,
    fresh(X,M,Y).
fresh(X,M,Y):-
    stack_vector(X,N),!,
    ( stack_vector(Y,N),!
    ;
      new_stack_vector(Y,N) ),
    fresh(N,X,M,Y).
fresh(X,_,Y):-
    X = Y.  % atomic,heap,string,etc

fresh(0,_,_,_):-!.
fresh(I,X,M,Y):-!,
    J is I - 1,
    vector_element(X,J,A),
    vector_element(Y,J,B),
    fresh(A,M,B),!,
    fresh(J,X,M,Y).

mapvar(X,Y,Z):-
    unbound(Y),!,
    Y = ^(`(X - Z),_).
mapvar(X,^(`(Y - Z),_),Z):-
    X == Y,!.
mapvar(X,^(_,Y),Z):-!,
    mapvar(X,Y,Z).

mapAList(X,M,Q):-
    stack_vector(X,3),
    first(X,x),
    second(X,P),
    unbound(P),!,
    mapAList(X,M,M,Q).
mapAList(x(P,_),M,Y):-
    mapAList(P,M,Y).

mapAList(x(P,T),M,Y,x(Q,S)):-
    unbound(Y),!,
    Y = ^(`(P - x(Q,S)),_),
    fresh(T,M,S).
mapAList(x(P,_),_,^(`(R - U),_),U):-
    P == R,!.
mapAList(X,M,^(_,Y),Z):-
    mapAList(X,M,Y,Z).

% :- public t_mertge/2.
t_merge(A,_):-
    unbound(A),!.
t_merge(x(P,Q),X):-
    unbound(X),!,
    t_merge1(x(P,Q),X).
t_merge(A,B):-
    t_merge1(A,B).

% :- public t_merge1/2.
t_merge1(x(A,B),x(C,D)):-!,
    extend(x(A,B),x(C,D),`(L - [])),t_merge1(L).
t_merge1(X,Y):-
    unbound(Y),!,
    t_merge1_v(X,Y).
t_merge1(X,Y):-
    frontier(X,Y,`(Z - [])),
    t_merge2(Z).

t_merge1_v(X,Y):-
    list(X),!,
    frontier_list(X,U,`(Z - [])),
    t_merge2(Z),
    unify(Y,U).
t_merge1_v(X,Y):-
    stack_vector(X,N),!,
    new_stack_vector(U,N),
    frontier(N,X,U,`(Z - [])),
    t_merge2(Z),
    Y = U.
t_merge1_v(X,X).    % atomic,string,heap,etc

% :- public t_merge1/1.
t_merge1([]):-!.
t_merge1([(_,X,Y)|W]):- 
    t_merge(X,Y),t_merge1(W).

% :- public t_merge2/1.
t_merge2([]):-!.
t_merge2([`(X = Y)|W]):- 
    t_merge(X,Y),t_merge2(W).

% :-public masked_merge/3.
masked_merge(X,_,_):-
    unbound(X),!.
masked_merge(X,Y,Z):-
    unbound(Y),!,
    merge(X,Z).
masked_merge(x(A,_),M,C):-
    stack_vector(A,3),!,
    masked_merge(A,M,C).
masked_merge(A,x(P,_),C):-
    stack_vector(P,3),!,
    masked_merge(A,P,C).
masked_merge(x(_,P),x(_,Q),D):-
    mask1(P,Q,C),
    u_x(D,x(_,C)).

mask1(A,_,_):-
    unbound(A),!.
mask1(t((K,_),L,R),M,C):-
    locate1(M,K,_),!,
    mask1(L,M,C),
    mask1(R,M,C).
mask1(t((K,U),L,R),M,C):-
    assoc(C,K,U),
    mask1(L,M,C),
    mask1(R,M,C).

% The meet part of two assignments.
% :-public meet/3.
meet(x(X,_),Y,O):-
    stack_vector(X,3),!,
    meet(X,Y,O).
meet(X,x(Y,_),O):-
    stack_vector(Y,3),!,
    meet(X,Y,O).
meet(x(A,_),x(B,_),`(L - L)):-
    A == B,!.
meet(x(_,X),x(_,Y),O):-
    meet1(X,Y,O).

meet1(X,_,`(L - L)):-
    unbound(X),!.
meet1(_,Y,`(L - L)):-
    unbound(Y),!.
meet1(t((K,U),A,B),t((K,V),C,D),`(P - Q)):-!,
    meet1(A,C,`(P - [(K,U,V)|R])),
    meet1(B,D,`(R - Q)).
meet1(t((K,U),A,B),t((J,V),C,D),`(P - Q)):-
    K < J,!,
    meet1(A,C,`(P - R)),
    meet1(K,U,C,`(R - S)),
    meet1(B,t((J,V),C,D),`(S - Q)).
meet1(t((K,U),A,B),t((J,V),C,D),`(P - Q)):-!,
    meet1(C,A,`(P - R)),
    meet1(J,V,A,`(R - S)),
    meet1(D,t((K,U),A,B),`(S - Q)).
meet1(_,_,`(P - P)).

meet1(K,U,T,`([(K,U,W)|R] - R)):-
    locate1(T,K,W),!.
meet1(_,_,_,`(R - R)).

% Frontier of two terms.
% :- public frontier/3.
frontier(X,Y,``( [(X = Y)|R] - R)):-
    unbound(X),!.
frontier(X,Y,``( [(X = Y)|R] - R)):-
    unbound(Y),!.
frontier(x(X,T),x(Y,S),``([(x(X,T) = x(Y,S))|R] - R)):-!.
frontier(X,Y,L):-
    list(X),!,
    list(Y),
    frontier_list(X,Y,L).
frontier(X,Y,L):-
    stack_vector(X,N),!,
    stack_vector(Y,N),
    frontier(N,X,Y,L).
frontier(X,X,`(L - L)). % atomic,string,heap,etc

frontier_list([X|A],[Y|B],`(L - R)):-!,
    frontier(X,Y,`(L - T)),!,
    frontier(A,B,`(T - R)).


frontier(0,_,_,`(L - L)):-!.
frontier(I,X,Y,`(L - R)):-
    J is I - 1,
    vector_element(X,J,A),
    vector_element(Y,J,B),
    frontier(A,B,`(L - P)),
    frontier(J,X,Y,`(P - R)).

%
% pst syntax
%

:-define pst/syntax.
:-environment kl0.

:-view predicate_syntax/2.
predicate_syntax('='(X,Y),unify_cil(X,Y)):-!.

:-view syntax/3.
syntax(!(X,Y),T,role(Y,X,T)):-!.
syntax(#(X,Y),Z,('='(X,Z),'='(Y,Z))):-!.
syntax( :(X,Y), X, Y):-!.
syntax(X,E,G):-
    pst(X,E,G),!.

% spec v1
pst(X,P,C):-
    is_pst(X),!,
    mk_assoc_element(X,XX),
    unify(C,mk_pst(XX,P)).

%pst(X,P,C):-
%    is_pst(X),!,
%    mk_assoc_element(X,XX),
%    unify(C,mk_assoc(XX,P)).

is_pst(X):-
    stack_vector(X,N),
    is_pst(N,X),!.

is_pst(0,_):-!.
is_pst(N,X):-
    subtract(N,1,M),
    vector_element(X,M,E),
    stack_vector(E,3),
    first(E,F),
    equal(F,(/)),!,
    is_pst(M,X).

% spec v1
mk_assoc_element({}, []):-!.
mk_assoc_element(X,Y):-
    stack_vector(X,N),
    subtract(N,1,N1),
    assoc_element(0,N1,X,Y),!.

assoc_element(N,N,X,[Y]):-!,
    vector_element(X,N,E),
    add_bq(E,Y).
assoc_element(M,N,X,[A|B]):-!,
    vector_element(X,M,E),
    add_bq(E,A),
    add(M,1,M1),!,
    assoc_element(M1,N,X,B).

add_bq(X,Y):-
    unify(X, `(L/V)),
    unify(Y, (L,V)),!.

%mk_assoc_element({}, '{}'):-!.    % {} is null partial term
%mk_assoc_element(X,Y):-
%    stack_vector(X,N),
%    subtract(N,1,N1),
%    assoc_element(0,N1,X,Y),!.

%assoc_element(N,N,X,Y):-!,
%    vector_element(X,N,E),
%    add_bq(E,Y).
%assoc_element(M,N,X,(A,B)):-!,
%    vector_element(X,M,E),
%    add_bq(E,A),
%    add(M,1,M1),!,
%    assoc_element(M1,N,X,B).

%add_bq((X,Y),(A,B)):-!,
%    add_bq(X,A),!,
%    add_bq(Y,B).
%add_bq(X,Y):-
%    stack_vector(X,3),
%    first(X,(/)),
%    unify(Y, `(`(X))),!.

%
% pst operator
%
:-define pst/operator.
:-view op/3.
op(200,yfx,(!)).
op(90,yfx,(#)).
op(300,yfx,(:)).


%
% pst portray
%
:-define pst/portray.
:-environment esp_call.

transform(Term,New_term):-
    pseudo(Term,[],Pseudo,_,[],[],PI),
    pst_form(Pseudo,New_term),
    infinite(New_term,New_term,PI).

pst_form(X,X):-
    unbound(X),!.
pst_form([X|R],[Y|S]):-!,
    pst_form(X,Y),!,
    pst_form(R,S).
pst_form({F,V,T},New):-
    F == x,!,
    new_partial(x(V,T),New).
pst_form(Term,New):-
    stack_vector(Term,N),!,
    new_stack_vector(New,N),
    transforms(N,Term,New).
pst_form(Term,Term):-!.

transforms(0,_,_):-!.
transforms(M,Term,New):-
    N = M - 1,
    vector_element(Term,N,E1),
    vector_element(New,N,E2),
    pst_form(E1,E2),!,
    transforms(N,Term,New).

new_partial(x(V,T),New):-
    unbound(V),!,
    new_p_t(T,{},New).
new_partial(x(V,_),New):-
    new_partial(V,New).

new_p_t(T,Part,Part):-
    unbound(T),!.
new_p_t({T,(P,A),L,R},Part,New):-
    T == t,!,
    new_p_t(L,Part,Part1),
    stack_vector(Part1,N),
    new_stack_vector(Part2,N + 1),
    subvector(Part2,0,N,Part1),
    vector_element(Part2,N,`(P / Arg)),
    pst_form(A,Arg),!,
    new_p_t(R,Part2,New).


% pseudo(Infinite,SI,^Pseudo,^NSI,NI,PI,^NPI)
% A infinite term will be replaced by a pseudo term.
% Infinite : infinite term
% SI        : structure information
% Pseudo    : pseudo term
% NSI       : new structure information
% NI        : node path information
% PI        : pseudo information [{replaced variable,node,infinite term},...]
% NPI       : new pseudo information
% loop

pseudo(A,SI,A,SI,_,PI,PI):-
    unbound(A),!.
% unbound functor
pseudo(A,SI,B,NSI,NI,PI,NPI):-
    stack_vector(A,N),
    N > 0,
    first(A,F),
    unbound(F),!,
    new_stack_vector(B,N),
    first(B,F),
    TSI = SI,
    pseudoes(1,N,A,TSI,B,NSI,NI,PI,NPI).
% pst x(_,_)
pseudo(A,SI,B,NSI,NI,PI,NPI):-
    is_x_partial(A),!,
    pseudo_x_partial(A,B,SI,NSI,NI,PI,NPI).
% list
pseudo(A,SI,B,NSI,NI,PI,NPI):-
    A = [E|R],!,
    B = [F|S],  % Don't use head unification !!
    TSI = SI,
    pseudo(E,TSI,F,SI1,[l(0)|NI],PI,TPI),!,
    pseudo('$$list$$'(1,R),SI1,S,NSI,NI,TPI,NPI).
pseudo('$$list$$'(M,A),SI,B,NSI,NI,PI,NPI):-
    bound(A),
    A = [E|R],!,
    B = [F|S],
    pseudo(E,SI,F,TSI,[l(M)|NI],PI,TPI),
    MM is M + 1,!,
    pseudo('$$list$$'(MM,R),TSI,S,NSI,NI,TPI,NPI).
pseudo('$$list$$'(M,A),SI,B,NSI,NI,PI,NPI):-!,
    pseudo(A,SI,B,NSI,[l(M)|NI],PI,NPI).
% stack_vector
pseudo(A,SI,B,NSI,NI,PI,NPI):-
    stack_vector(A,N),!,
    new_stack_vector(B,N),
    TSI = SI,
    pseudoes(0,N,A,TSI,B,NSI,NI,PI,NPI).
% others - atomic,string,heap,object,etc.
pseudo(A,SI,A,SI,_,PI,PI):-!.

pseudoes(N,N,_,SI,_,SI,_,PI,PI):-!.
pseudoes(M,N,A,SI,B,NSI,NI,PI,NPI):-
    vector_element(A,M,E1),
    vector_element(B,M,E2),
    NNI = [v(M)|NI],
    pseudo(E1,SI,E2,TSI,NNI,PI,TPI),
    MM is M + 1,!,
    pseudoes(MM,N,A,TSI,B,NSI,NI,TPI,NPI).

pseudo_x_partial(A,B,SI,SI,_,PI,NPI):-
    identical_in_pst(t(N,A),SI),!,
    NPI = [{B,N,A}|PI].
pseudo_x_partial(A,x(L,NT),SI,NSI,NI,PI,NPI):-
    A = x(L,T),
    unbound(L),!,
    TSI = [t(NI,A)|SI],
    pseudo_tree(T,NT,TSI,NSI,NI,PI,NPI,0,_).
pseudo_x_partial(x(P,_),NP,SI,NSI,NI,PI,NPI):-
    pseudo(P,SI,NP,NSI,NI,PI,NPI).

pseudo_tree(A,A,SI,SI,_,PI,PI,N,N):-
    unbound(A),!.
pseudo_tree(t((F,E),L,R),t((F,EE),LL,RR),SI,NSI,NI,PI,NPI,M,N):-
    pseudo_tree(L,LL,SI,TSI1,NI,PI,TPI1,M,T),
    pseudo(E,TSI1,EE,TSI2,[p(T)|NI],TPI1,TPI2),
    TT is T + 1,!,
    pseudo_tree(R,RR,TSI2,NSI,NI,TPI2,NPI,TT,N).

identical_in(t(N,A),[t(NN,AA)|_]):-
    A =:= AA,!,
    N = NN.
identical_in(X,[_|Y]):-
    identical_in(X,Y).

identical_in_pst(t(N,x(A,_)),[t(NN,x(AA,_))|_]):-
    A =:= AA,!,
    N = NN.
identical_in_pst(X,[_|Y]):-
    identical_in_pst(X,Y).

% infinite(Term,Object,PI) 
infinite(_,_,[]):-!.
infinite(X,Obj,PI):-
    unbound(X),!,
    (   % reunify replaced variable
        replaced_variable(X,PI,NI),!,
        get_node_obj(Obj,NI,Self),
        X = Self
    ;   % normal variable
        true
    ).
infinite([X|R],Obj,PI):-!,
    infinite(X,Obj,PI),!,
    infinite(R,Obj,PI).
infinite(X,Obj,PI):-
    stack_vector(X,N),!,
    infinites(N,X,Obj,PI).
infinite(_,_,_):-!.


infinites(0,_,_,_):-!.
infinites(M,X,Obj,PI):-
    N = M - 1,
    vector_element(X,N,Ex),
    infinite(Ex,Obj,PI),!,
    infinites(N,X,Obj,PI).

is_x_partial(P):-
    stack_vector(P,3),
    first(P,F),
    F == x.

replaced_variable(V,[{RV,Node,_}|_],Node):-
    V =:= RV,!.
replaced_variable(V,[_|R],Node):-
    replaced_variable(V,R,Node).

replaced_variable(V,[{RV,_,_}|_]):-
    V =:= RV,!.
replaced_variable(V,[_|R]):-
    replaced_variable(V,R).

get_node_obj(X,[],X):-!.
get_node_obj(X,NI,Y):-
    reverse(NI,[],NNI),
    get_obj(X,NNI,Y).

get_obj(X,[],X):-!.
get_obj(X,[{Type,Node}|R],Y):-
    obj_element(Type,Node,X,E),!,
    get_obj(E,R,Y).

obj_element(v,Node,Vector, Element):-!,
    vector_element(Vector,Node,Element).
obj_element(p,Node,Partial,Element):-!,
    partial_element(Partial,Node,Element).
obj_element(l,Node,List,   Element):-!,
    list_element(List,Node,Element).

reverse([],X,X):-!.
reverse([H|T],R,Rev):-
    reverse(T,[H|R],Rev).

partial_element(P,N,E):-
    vector_element(P,N,E1),
    vector_element(E1,2,E).

list_element([],_,_):-!,fail.
list_element(L,N,E):-
    list_element(0,N,L,E).

list_element(_,_,[],_):-!,fail.
list_element(N,N,[H|_],H):-!.
list_element(M,N,[_|T],E):-
    (
        not(is_list(T)),!,
        N == M + 1,
        E = T
    ;
        list_element(M + 1,N,T,E)
    ).

is_list(X):-
    unbound(X),!,fail.
is_list(X):-
    list(X),!.
is_list([]):-!.
