#! /bin/sh
## /usr/local/bin/jtexpspr, landscape option supported
##			Apr.30, 1992, by ichiyoshi@icot.or.jp
## /usr/local/bin/jtexpspr, EPS is supported
##			Mar.8, 1991, by imai@icot22
## /usr/local/bin/jtexpspr, LaserPrep6.0 is available
##			 Aug.10,1990, by imai@icot22
##			Also continue to support LaserPrep4.0 (-4 option)
## /usr/local/bin/jtexpspr, BUG fix on Jun 19(MON)
## /usr/local/bin/jtexpspr, Jun 8 by imai@icot22
## /usr/local/bin/jtexpspr, Dec 13, 1990 by yashiro@icot.or.jp
##   This command for Mac & TeX printing
## This file is based on /usr/local/bin/jteximpr
## /usr/local/bin/jteximpr, Jul 13 19:24:04 1988, matsu@icot22 
JLATEX='/usr/local/bin/jlatex'
DVI2PS='/usr/local/bin/dvi2ps'
PRNTR='elf'			# Default printer is 'elf'.  1988-4-4 Matsumoto
COPIES=1			# Default number of copies is 1. 1988-7-7 A.M.
DUPLEX='pageduplex off'		# Default is single side printing. 1988-7-7 AM
REVERSAL='pagereversal on'	# DEfailt is reversal printing. 1988-7-7 A.M.
PAPERSIZE="a4"			# Default paper size is a4. 1988-4-14 Matsumoto
LANDSCAPE=''			# Default print mode is portrait 1992-4-21 N.I.
LASERPREP='-i /usr/local/lib/PostScript/laserprep6.0'
LANGUAGE='ultrascript'
TARGETFILE=
TEXFILES=
FROMPAGE=
TOPAGE=
EPSMACFIX=

# If environment PRINTER is not set, then default printer `elf' is used.
if [ -n "${PRINTER}" ]
then
    PRNTR="${PRINTER}"
fi

## Keyboard Interrupt (Control-C) Process definition
trap '
    echo "
Keyboard Interrupt - Abort."
    exit 1
' 1 2 3 13 15

## In case that there is no argument.
if [ $# = 0 ]
then
  echo 'Usage: jtexpspr file { related_files... } {-a4,-b4} {-c#} {-d} {-r} {-Pname}'
  echo 'Example1: jtexpspr filename		; Normal usage'
  echo 'Example2: jtexpspr filename -d		; Page duplexed on'
  echo 'Example3: jtexpspr filename -r		; Page reversal off'
  echo 'Example4: jtexpspr filename -c5		; 5 copies (Max ten copies)'
  echo 'Example5: jtexpspr filename -b4		; Use B4 paper'
  echo 'Example6: jtexpspr filename -Pwizard	; Use printer named wizard'
  echo 'Example7: jtexpspr filename *.tex *.sty	; Date of relfiles are checked'
  echo 'Example8: jtexpspr filename -s		; Do not include Mac depend file' 
  echo 'Example8: jtexpspr filename -4		; PostScript file under verion4.0'
  echo 'Example9: jtexpspr filename -f2	-t3	; Pring from page 2 to page 3'
  echo 'Example10:jtexpspr filename -e		; Pring usign EPS file'
  echo 'Example11: jteximpr filename -L		; Landscape mode'
  echo '                If you include Mac picture, do NOT use -m option.'
  echo '                Otherwise, a little bit faster.'
  echo '   Do you want to know how to insert Mac picture?'
  echo '   Type _m_a_c_p_r_m_a_n, and you will get Japanese manual printed.'
  exit 1
fi

TARGETFILE=$1
## shift arguments
shift
## Search all related xxx.tex files.
## If more than one of these files is updated, jlatex is forcibly executed.
for ARG in $*
do
    case "$ARG" in
	-a4)	PAPERSIZE="a4";;
	-b4)	PAPERSIZE="b4";;
	-c*)	COPIES=`echo "$ARG" | sed 's/-c//''`;;
	-P*)	PRNTR=`echo "$ARG" | sed 's/-P//''`;;
	-d)	DUPLEX='pageduplex on'
		REVERSAL='pagereversal off';;
	-r)	REVERSAL='pagereversal off';;
	-e)	EPSMACFIX='-i /usr/local/lib/PostScript/macfix.ps';;
	-s)	LASERPREP='';;
	-4)	LASERPREP='-i /usr/local/lib/PostScript/laserprep4.0';;
	-L)	LANDSCAPE='-o landscape';;
	-f*)	FROMPAGE='-f '`echo "$ARG"| sed 's/-f//''`;;
	-t*)	TOPAGE='-t '`echo "$ARG" | sed 's/-t//''`;;
	-*)	echo "Illegal option '$ARG'"
		exit 1;;
	*)	TEXFILES="${TEXFILES} `/bin/echo ${ARG}`"
    esac
done

## If a 'xxx.tex' file exists, then try to update a 'xxx.dvi' file.
## If only 'xxx.dvi' file exists, then it will be used.
if [ -r ${TARGETFILE}.tex ]
then
    echo "
${TARGETFILE}.dvi:	${TARGETFILE}.tex $TEXFILES
.SUFFIXES:	.tex .dvi
.tex.dvi:
	${JLATEX} \$*" | make -f -
    ## Check return code
    if [ $? != 0 ]
    then
        echo '
    !!!!! Gave up printing !!!!!'
        exit 1
    fi
else
    if [ ! -r ${TARGETFILE}.dvi ]
    then
	echo "ERROR: ${TARGETFILE}.dvi not found!!"
	exit 1
    fi
fi

## Check the number of copies	1988-7-7 Matsumoto
if [ ${COPIES} -gt 10 ]
then
    echo 'WARNING: The number of copies is forcibly set to 10.'
    echo "        Reprint remainig ${COPIES}-10 copies!"
    COPIES=10
fi

## Check Paper A4 or B4
if [ ${PAPERSIZE} = "b4" ]
then
	PAPEROPTION="-o legal"
else
	PAPEROPTION=""
fi

## Convert from 'xxx.dvi' to PostScript format and print out to imagen.
## Default printer is 'elf' that is located beside the 4th lab. # 880404 A.M.
## Used outputbin is right side one, and there is no job header.
## No temporary file is used.
echo '
Print phase starting .....'
echo ${DVI2PS} ${PAPEROPTION} ${LANDSCAPE} ${LASERPREP} ${EPSMACFIX} ${FROMPAGE} ${TOPAGE} ${TARGETFILE}
${DVI2PS} ${PAPEROPTION} ${LANDSCAPE} ${LASERPREP} ${EPSMACFIX} ${FROMPAGE} ${TOPAGE} ${TARGETFILE} 
##| \
##ipr -L${LANGUAGE} -P${PRNTR} -c${COPIES} -r \
##-D"paper ${PAPERSIZE},outputbin right,${DUPLEX},\
##${REVERSAL},jobheader off"
##echo "
##Sending to ${PRNTR} ....."

