/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* main routine */

#include <stdio.h>

#ifdef THINK_C
#include <console.h>
#include <unix.h>
#else
#include <unistd.h>
#endif

#include "mq.h"
#include "internal.h"
#include "tree.h"
#include "extern.h"

struct obstack *mm_current;
int temporary;
int interactive;
int interactive_orig;
int force_interactive;

int main (argc, argv)
     int argc;
     char *argv[];
{
  int i;

#ifdef THINK_C
  argc = ccommand (&argv);	/* simulate command-line arguments */
#endif

  interactive = FALSE;
  temporary = 0;
  init_options ();
  init_atom ();
  init_lex ();
  init_subrel ();
  init_lookup ();
  init_unify ();
  init_exec ();
  init_rule ();
  init_tree ();
  init_lattice ();
  init_command ();		/* must be last */

  number_of_errors = 0;
  show_version ();

  interactive_orig = isatty (0);
  for (i=argc-1; i>0; i--)
    pushfilename (argv[i], FALSE);

  yyparse ();

  return 0;
}

void begin_tmp ()
{
  temporary = 1;
  begin_temp_alloc_rule ();
  begin_temp_alloc_subrel ();
}

void end_tmp ()
{
  temporary = 0;
  end_temp_alloc_rule ();
  end_temp_alloc_subrel ();
}
