/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* interface to external computation */

#include <stdio.h>
#include "mq.h"
#include "internal.h"
#include "extern.h"
#include "tree.h"
#include "emit.h"

extern MQT_Obj input_object;

/* function prototype for debugging */
static int read_bool _P((void));
static MQ_Obj read_object _P((void));

int eval_ext_cnstr (cnstr)
     MQ_Obj cnstr;
{
  printf ("EXT CONSTRAINT?? ");
  print_obj ((MQ_Obj)cnstr->attr[0].vterm);
  printf (" %s ", cnstr->atom->name); /* Note: don't call print_atom. */
  print_obj ((MQ_Obj)cnstr->attr[1].vterm);
  printf (" ??> ");
  fflush (stdout);
  return read_bool ();
}

MQ_Obj eval_ext_expr (expr)
     MQ_Obj expr;
{
  printf ("EXT EXPRESSION?? ");
  print_obj ((MQ_Obj)expr);
  printf (" ??> ");
  fflush (stdout);
  return read_object ();
}

static
int read_bool ()
{
  if (!interactive)
    exec_error ("external invocation in non-interactive mode.\n");
  read_line_to_yytext ();
  if (yytext[0])
    return FALSE;
  else
    return TRUE;
}

static
MQ_Obj read_object ()
{
  struct obstack *mm_old;
  MQ_Obj o;
  MQ_VarList var_list = NULL;
  int c;

  if (!interactive)
    exec_error ("external invocation in non-interactive mode.\n");

  gobble_newline ();
  c = fetch_char ();
  if (c == '\n')
    return NULL;

  mm_old = mm_current;
  mm_current = mm_exec;
  reading_object = TRUE;
  if (yyparse ())
    exec_error ("Error in reading object.\n");
  reading_object = FALSE;
  emit_obj (input_object, &o, &var_list);
  if (var_list)
    exec_error ("Object includes variable(s).\n");
  mm_current = mm_old;
  return o;
}
