/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* subsumption constraint solver */

#include <stdio.h>
#include "mq.h"
#include "internal.h"
#include "extern.h"

static MQ_Constraints cnstrs_changed;

/* function prototype for debugging */
static void constraint_solve_sub _P((MQ_Constraints *));
static void constraint_solve_subsumption _P((MQ_Constraints *));
static MQ_Constraints constraint_solve_subsumption_1 _P((MQ_Constraints, MQ_Constraints, MQ_Constraints *));
static int cnstr_exists_in_cnstrs _P((MQ_Constraint, MQ_Constraints));
static MQ_Constraints add_cnstrs_if_not_any _P((MQ_Constraints, MQ_Constraints));
static int check_cnstr_in_sub_cnstrs_1 _P((MQ_Constraint));

void constraint_solve_sub_cnstrs ()
{
  constraint_solve_sub (&sub_cnstrs);
}

void constraint_solve_sub_asmpts ()
{
  constraint_solve_sub (&sub_asmpts);
}

void constraint_solve_sub_cnstrs_h ()
{
  constraint_solve_sub (&sub_cnstrs_h);
}

void add_cnstr_to_sub_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  cnstrs_changed = mQ_void_cnstrs;
  if (eval_subsumption ((MQ_VTerm)cnstr->term, cnstr->vterm, &cnstrs_changed))
    constraint_solve_subsumption (&sub_cnstrs);
  else
    constrain_failed = TRUE;
}

void add_cnstr_to_sub_asmpts (cnstr)
     MQ_Constraint cnstr;
{
  cnstrs_changed = mQ_void_cnstrs;
  if (eval_subsumption ((MQ_VTerm)cnstr->term, cnstr->vterm, &cnstrs_changed))
    constraint_solve_subsumption (&sub_asmpts);
  else
    constrain_failed = TRUE;
}

void add_cnstr_to_sub_cnstrs_h (cnstr)
     MQ_Constraint cnstr;
{
  cnstrs_changed = mQ_void_cnstrs;
  if (eval_subsumption ((MQ_VTerm)cnstr->term, cnstr->vterm, &cnstrs_changed))
    constraint_solve_subsumption (&sub_cnstrs_h);
  else
    constrain_failed = TRUE;
}

int check_cnstr_in_sub_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  MQ_Constraints cs;

  cs = mQ_void_cnstrs;
  if (eval_subsumption ((MQ_VTerm)cnstr->term, cnstr->vterm, &cs)==FALSE)
    return FALSE;

  for (; cs!=mQ_void_cnstrs; cs=cs->next)
    if (check_cnstr_in_sub_cnstrs_1 (cs->cnstr))
      return TRUE;
  return FALSE;
}

static
int check_cnstr_in_sub_cnstrs_1 (cnstr)
     MQ_Constraint cnstr;
{
  MQ_Constraints cs, cs1;
  MQ_VTerm vt11, vt12;
  MQ_VTerm vt21, vt22;

  vt11 = (MQ_VTerm)cnstr->term;
  vt12 = cnstr->vterm;

  switch (cnstr->rel)
    {
    case SubsumesVarVar:
      for (cs=sub_cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  vt21 = (MQ_VTerm)cs->cnstr->term;
	  vt22 = cs->cnstr->vterm;
	  if (equal (vt11, vt21) && equal (vt12, vt22))
	    return TRUE;
	}
      return FALSE;
      break;

    case SubsumesVarObj: /* X >= O <=  X >= P, P >= O */
      for (cs=sub_cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  vt21 = (MQ_VTerm)cs->cnstr->term;
	  vt22 = cs->cnstr->vterm;
	  if (equal (vt11, vt21))
	    if (equal (vt12, vt22))
	      return TRUE;
	    else
	      if (vt22->type == TT_Obj)
		{
		  cs1 = mQ_void_cnstrs;
		  if (eval_subsumption ((MQ_VTerm)vt12, vt22, &cs1) == FALSE)
		    continue;
		  for (; cs1!=mQ_void_cnstrs; cs1=cs1->next)
		    if (check_cnstr_in_sub_cnstrs_1 (cs1->cnstr) == FALSE)
		      continue;
		  return TRUE;
		}
	}
      return FALSE;
      break;

    case SubsumesObjVar: /* O >= X <=  P >= X, O >= P */
      for (cs=sub_cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  vt21 = (MQ_VTerm)cs->cnstr->term;
	  vt22 = cs->cnstr->vterm;
	  if (equal (vt11, vt21))
	    {
	      if (equal (vt12, vt22))
		return TRUE;
	    }
	  else if (equal (vt12, vt22))
	    if (vt21->type == TT_Obj)
	      {
		cs1 = mQ_void_cnstrs;
		if (eval_subsumption ((MQ_VTerm)vt11, vt21, &cs1) == FALSE)
		  continue;
		for (; cs1!=mQ_void_cnstrs; cs1=cs1->next)
		  if (check_cnstr_in_sub_cnstrs_1 (cs1->cnstr) == FALSE)
		    continue;
		return TRUE;
	      }
	}
      return FALSE;
      break;

    default:
      fatal ("check_cnstr_in_sub_cnstrs.\n");
      break;
    }
}

static
void constraint_solve_sub (cs_p)
     MQ_Constraints *cs_p;
{
  MQ_Constraints cs;

  cnstrs_changed = mQ_void_cnstrs;
  for (cs=*cs_p; cs!=mQ_void_cnstrs; cs=cs->next)
    {
      switch (cs->cnstr->rel)
	{
	case SubsumesVarVar:
	  if (cs->cnstr->term->type == TT_Obj
	      || cs->cnstr->vterm->type == TT_Obj
	      || (cs->cnstr->term->type == TT_Var
		  && cs->l_var_list != ((MQ_Var)cs->cnstr->term)->var_list)
	      || (cs->cnstr->vterm->type == TT_Var
		  && cs->r_var_list != ((MQ_Var)cs->cnstr->vterm)->var_list))
	    {
	      if (eval_subsumption ((MQ_VTerm)cs->cnstr->term,
				    cs->cnstr->vterm,
				    &cnstrs_changed) == FALSE)
		{
		  constrain_failed = TRUE;
		  return;
		}

	      /* delete cs */
	      if (cs->prev == NULL) /* cs == *cs_p */
		{
		  *cs_p = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = NULL;
		}
	      else
		{
		  cs->prev->next = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = cs->prev;
		}
	    }
	  break;

	case SubsumesVarObj:
	  if (cs->cnstr->term->type == TT_Obj
	      || (cs->cnstr->term->type == TT_Var
		  && cs->l_var_list != ((MQ_Var)cs->cnstr->term)->var_list))
	    {
	      if (eval_subsumption ((MQ_VTerm)cs->cnstr->term,
				    cs->cnstr->vterm,
				    &cnstrs_changed) == FALSE)
		{
		  constrain_failed = TRUE;
		  return;
		}

	      /* delete cs */
	      if (cs->prev == NULL) /* cs == *cs_p */
		{
		  *cs_p = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = NULL;
		}
	      else
		{
		  cs->prev->next = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = cs->prev;
		}
	    }
	  else if (cs->r_var_list)
	    {
	      cs->r_var_list = delete_bound_var_in_var_list (cs->r_var_list);
	      if (cs->r_var_list == NULL)
		{
		  /* delete cs */
		  if (cs->prev == NULL) /* cs == *cs_p */
		    {
		      *cs_p = cs->next;
		      if (cs->next != mQ_void_cnstrs)
			cs->next->prev = NULL;
		    }
		  else
		    {
		      cs->prev->next = cs->next;
		      if (cs->next != mQ_void_cnstrs)
			cs->next->prev = cs->prev;
		    }
		  cs->next = cnstrs_changed;
		  cs->prev = NULL;
		  if (cnstrs_changed != mQ_void_cnstrs)
		    cnstrs_changed->prev = cs;
		  cnstrs_changed = cs;
		}
	    }
	  break;

	case SubsumesObjVar:
	  if (cs->cnstr->vterm->type == TT_Obj
	      || (cs->cnstr->vterm->type == TT_Var
		  && cs->r_var_list != ((MQ_Var)cs->cnstr->vterm)->var_list))
	    {
	      if (eval_subsumption ((MQ_VTerm)cs->cnstr->term,
				    cs->cnstr->vterm,
				    &cnstrs_changed) == FALSE)
		{
		  constrain_failed = TRUE;
		  return;
		}

	      /* delete cs */
	      if (cs->prev == NULL) /* cs == *cs_p */
		{
		  *cs_p = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = NULL;
		}
	      else
		{
		  cs->prev->next = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = cs->prev;
		}
	    }
	  else if (cs->l_var_list)
	    {
	      cs->l_var_list = delete_bound_var_in_var_list (cs->l_var_list);
	      if (cs->l_var_list == NULL)
		{
		  /* delete cs */
		  if (cs->prev == NULL) /* cs == *cs_p */
		    {
		      *cs_p = cs->next;
		      if (cs->next != mQ_void_cnstrs)
			cs->next->prev = NULL;
		    }
		  else
		    {
		      cs->prev->next = cs->next;
		      if (cs->next != mQ_void_cnstrs)
			cs->next->prev = cs->prev;
		    }
		  cs->next = cnstrs_changed;
		  cs->prev = NULL;
		  if (cnstrs_changed != mQ_void_cnstrs)
		    cnstrs_changed->prev = cs;
		  cnstrs_changed = cs;
		}
	    }
	  break;

	default:
	  fatal ("constraint_solve_sub.\n");
	  break;
	}
    }

  constraint_solve_subsumption (cs_p);
}

static
void constraint_solve_subsumption (cnstrs_p)
     MQ_Constraints *cnstrs_p;
{
  MQ_Constraints new_cnstrs, cs, c_cs;

  new_cnstrs = *cnstrs_p;
  while (1)
    {
      c_cs = mQ_void_cnstrs;
      for (cs=cnstrs_changed; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  new_cnstrs = constraint_solve_subsumption_1 (cs, new_cnstrs, &c_cs);
	  if (new_cnstrs == NULL)
	    {
	      constrain_failed = TRUE;
	      return;
	    }
	}
      cnstrs_changed = c_cs;
      if (cnstrs_changed==mQ_void_cnstrs)
	break;
    }
  *cnstrs_p = new_cnstrs;
}

static
MQ_Constraints constraint_solve_subsumption_1 (a_cs, cnstrs, cs_p)
     MQ_Constraints a_cs, cnstrs, *cs_p;
{
  MQ_Constraint new_cnstr;
  MQ_Constraints new_cnstrs, cs, another_cs;
  MQ_Obj obj;
  int dont_add_new_cnstr;

  new_cnstrs = mQ_void_cnstrs;
  another_cs = *cs_p;
  dont_add_new_cnstr = FALSE;

  switch (a_cs->cnstr->rel)
    {
    case SubsumesVarVar:
      for (cs=cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  if (equal ((MQ_VTerm)a_cs->cnstr->term, (MQ_VTerm)cs->cnstr->term))
	    if (equal (a_cs->cnstr->vterm, cs->cnstr->vterm))
	      /* X >= Y, X >= Y */ /* found same cnstr */
	      ;
	    else /* X >= Y, X >= Z */
	      {
		new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		new_cnstrs->l_var_list = cs->l_var_list;
		new_cnstrs->r_var_list = cs->r_var_list;
	      }
	  else if (equal ((MQ_VTerm)a_cs->cnstr->term, cs->cnstr->vterm))
	    if (equal (a_cs->cnstr->vterm, (MQ_VTerm)cs->cnstr->term))
	      { /* X >= Y, Y >= X */
		unify ((MQ_VTerm *)&a_cs->cnstr->term, &a_cs->cnstr->vterm);
		dont_add_new_cnstr = TRUE;
	      }
	    else
	      { /* X >= Y, Z >= X */
		new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		new_cnstrs->l_var_list = cs->l_var_list;
		new_cnstrs->r_var_list = cs->r_var_list;
		if (cs->cnstr->term->type == TT_Var)
		  new_cnstr = make_cnstr (SubsumesVarVar,
					  cs->cnstr->term, a_cs->cnstr->vterm);
		else
		  new_cnstr = make_cnstr (SubsumesObjVar,
					  cs->cnstr->term, a_cs->cnstr->vterm);
		if (!cnstr_exists_in_cnstrs (new_cnstr, cnstrs))
		  {
		    another_cs = make_cnstrs (new_cnstr, another_cs);
		    another_cs->l_var_list = cs->l_var_list;
		    another_cs->r_var_list = a_cs->r_var_list;
		  }
	      }
	  else if (equal (a_cs->cnstr->vterm, (MQ_VTerm)cs->cnstr->term))
	    { /* X >= Y, Y >= Z */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	      new_cnstr = make_cnstr (SubsumesVarVar,
				      a_cs->cnstr->term, cs->cnstr->vterm);
	      if (!cnstr_exists_in_cnstrs (new_cnstr, cnstrs))
		{
		  another_cs = make_cnstrs (new_cnstr, another_cs);
		  another_cs->l_var_list = a_cs->l_var_list;
		  another_cs->r_var_list = cs->r_var_list;
		}
	    }
	  else if (equal (a_cs->cnstr->vterm, cs->cnstr->vterm))
	    { /* X >= Y, Z >= Y */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	    }
	  else
	    { /* X >= Y, Z >= W */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	    }
	}
      break;

    case SubsumesVarObj:
      for (cs=cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  if (equal ((MQ_VTerm)a_cs->cnstr->term, (MQ_VTerm)cs->cnstr->term))
	    if (equal (a_cs->cnstr->vterm, cs->cnstr->vterm))
	      /* X >= Y, X >= Y */ /* found same cnstr */
	      ;
	    else /* X >= Y, X >= Z */
	      if (cs->cnstr->rel == SubsumesVarObj
		  && a_cs->r_var_list == NULL && cs->r_var_list == NULL)
		{
		  obj = join ((MQ_Obj)a_cs->cnstr->vterm,
			      (MQ_Obj)cs->cnstr->vterm);
		  new_cnstr = make_cnstr (SubsumesVarObj,
					  a_cs->cnstr->term, (MQ_VTerm)obj);
		  another_cs = make_cnstrs (new_cnstr, another_cs);
		  another_cs->l_var_list = a_cs->l_var_list;
		  another_cs->r_var_list = NULL;
		  dont_add_new_cnstr = TRUE;
		}
	      else
		{
		  new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		  new_cnstrs->l_var_list = cs->l_var_list;
		  new_cnstrs->r_var_list = cs->r_var_list;
		}
	  else if (equal ((MQ_VTerm)a_cs->cnstr->term, cs->cnstr->vterm))
	    if (equal (a_cs->cnstr->vterm, (MQ_VTerm)cs->cnstr->term))
	      { /* X >= Y, Y >= X */
		bind ((MQ_Var)a_cs->cnstr->term, a_cs->cnstr->vterm);
		dont_add_new_cnstr = TRUE;
	      }
	    else
	      { /* X >= Y, Z >= X */
		new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		new_cnstrs->l_var_list = cs->l_var_list;
		new_cnstrs->r_var_list = cs->r_var_list;
		if (cs->cnstr->rel == SubsumesVarVar)
		  {
		    new_cnstr = make_cnstr (SubsumesVarObj,
					    cs->cnstr->term,
					    a_cs->cnstr->vterm);
		    if (!cnstr_exists_in_cnstrs (new_cnstr, cnstrs))
		      {
			another_cs = make_cnstrs (new_cnstr, another_cs);
			another_cs->l_var_list = cs->l_var_list;
			another_cs->r_var_list = a_cs->r_var_list;
		      }
		  }
		else /* SubsumesObjVar */
		  {
		    if (eval_subsumption ((MQ_VTerm)cs->cnstr->term,
					  a_cs->cnstr->vterm,
					  &another_cs) == FALSE)
		      return NULL;
		  }
	      }
	  else if (equal (a_cs->cnstr->vterm, (MQ_VTerm)cs->cnstr->term))
	    { /* X >= Y, Y >= Z */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	      new_cnstr = make_cnstr (SubsumesVarVar,
				      a_cs->cnstr->term, cs->cnstr->vterm);
	      if (!cnstr_exists_in_cnstrs (new_cnstr, cnstrs))
		{
		  another_cs = make_cnstrs (new_cnstr, another_cs);
		  another_cs->l_var_list = a_cs->l_var_list;
		  another_cs->r_var_list = cs->r_var_list;
		}
	    }
	  else if (equal (a_cs->cnstr->vterm, cs->cnstr->vterm))
	    { /* X >= Y, Z >= Y */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	    }
	  else
	    { /* X >= Y, Z >= W */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	    }
	}
      break;

    case SubsumesObjVar:
      for (cs=cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  if (equal ((MQ_VTerm)a_cs->cnstr->term, (MQ_VTerm)cs->cnstr->term))
	    if (equal (a_cs->cnstr->vterm, cs->cnstr->vterm))
	      /* X >= Y, X >= Y */ /* found same cnstr */
	      ;
	    else /* X >= Y, X >= Z */
	      {
		new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		new_cnstrs->l_var_list = cs->l_var_list;
		new_cnstrs->r_var_list = cs->r_var_list;
	      }
	  else if (equal ((MQ_VTerm)a_cs->cnstr->term, cs->cnstr->vterm))
	    if (equal (a_cs->cnstr->vterm, (MQ_VTerm)cs->cnstr->term))
	      { /* X >= Y, Y >= X */
		bind ((MQ_Var)a_cs->cnstr->vterm, (MQ_VTerm)a_cs->cnstr->term);
		dont_add_new_cnstr = TRUE;
	      }
	    else
	      { /* X >= Y, Z >= X */
		new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		new_cnstrs->l_var_list = cs->l_var_list;
		new_cnstrs->r_var_list = cs->r_var_list;
		new_cnstr = make_cnstr (SubsumesVarVar,
					cs->cnstr->term, a_cs->cnstr->vterm);
		if (!cnstr_exists_in_cnstrs (new_cnstr, cnstrs))
		  {
		    another_cs = make_cnstrs (new_cnstr, another_cs);
		    another_cs->l_var_list = cs->l_var_list;
		    another_cs->r_var_list = a_cs->r_var_list;
		  }
	      }
	  else if (equal (a_cs->cnstr->vterm, (MQ_VTerm)cs->cnstr->term))
	    { /* X >= Y, Y >= Z */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	      if (cs->cnstr->rel == SubsumesVarVar)
		{
		  new_cnstr = make_cnstr (SubsumesObjVar,
					  a_cs->cnstr->term, cs->cnstr->vterm);
		  if (!cnstr_exists_in_cnstrs (new_cnstr, cnstrs))
		    {
		      another_cs = make_cnstrs (new_cnstr, another_cs);
		      another_cs->l_var_list = a_cs->l_var_list;
		      another_cs->r_var_list = cs->r_var_list;
		    }
		}
	      else /* SubsumesVarObj */
		{
		  if (eval_subsumption ((MQ_VTerm)cs->cnstr->term,
					a_cs->cnstr->vterm,
					&another_cs) == FALSE)
		    return NULL;
		}
	    }
	  else if (equal (a_cs->cnstr->vterm, cs->cnstr->vterm))
	    /* X >= Y, Z >= Y */
	    if (cs->cnstr->rel == SubsumesObjVar
		&& a_cs->l_var_list == NULL && cs->l_var_list == NULL)
	      {
		obj = meet ((MQ_Obj)a_cs->cnstr->term,
			    (MQ_Obj)cs->cnstr->term);
		new_cnstr = make_cnstr (SubsumesObjVar,
					(MQ_Term)obj, a_cs->cnstr->vterm);
		another_cs = make_cnstrs (new_cnstr, another_cs);
		another_cs->l_var_list = NULL;
		another_cs->r_var_list = a_cs->r_var_list;
		dont_add_new_cnstr = TRUE;
	      }
	    else
	      {
		new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
		new_cnstrs->l_var_list = cs->l_var_list;
		new_cnstrs->r_var_list = cs->r_var_list;
	      }
	  else
	    {/* X >= Y, Z >= W */
	      new_cnstrs = make_cnstrs (cs->cnstr, new_cnstrs);
	      new_cnstrs->l_var_list = cs->l_var_list;
	      new_cnstrs->r_var_list = cs->r_var_list;
	    }
	}
      break;

    default:
      fatal ("constraint_solve_subsumption_1.\n");
      break;
    }

  if (!dont_add_new_cnstr)
    new_cnstrs = add_cnstrs_if_not_any (a_cs, new_cnstrs);

  *cs_p = another_cs;
  return new_cnstrs;
}

static
int cnstr_exists_in_cnstrs (cnstr, cnstrs)
     MQ_Constraint cnstr;
     MQ_Constraints cnstrs;
{
  MQ_Constraints cs;

  for (cs=cnstrs; cs != mQ_void_cnstrs; cs=cs->next)
    if (cs->cnstr->rel == cnstr->rel
	&& equal ((MQ_VTerm)cs->cnstr->term, (MQ_VTerm)cnstr->term)
	&& equal (cs->cnstr->vterm, cnstr->vterm))
      return TRUE;
  return FALSE;
}

static
MQ_Constraints add_cnstrs_if_not_any (a_cs, cnstrs)
     MQ_Constraints a_cs;
     MQ_Constraints cnstrs;
{
  MQ_Constraints cs, new;
  int exist_p = FALSE;

  for (cs=cnstrs; cs != mQ_void_cnstrs; cs=cs->next)
    if (cs->cnstr->rel == a_cs->cnstr->rel
	&& equal ((MQ_VTerm)cs->cnstr->term, (MQ_VTerm)a_cs->cnstr->term)
	&& equal (cs->cnstr->vterm, a_cs->cnstr->vterm))
      {
	exist_p = TRUE;
	break;
      }

  if (exist_p)
    new = cnstrs;
  else
    {
      new = make_cnstrs (a_cs->cnstr,cnstrs);
      new->l_var_list = a_cs->l_var_list;
      new->r_var_list = a_cs->r_var_list;
    }

  return new;
}

MQ_VarList delete_bound_var_in_var_list (vl)
     MQ_VarList vl;
{
  MQ_VarList next, new;

  if (vl == NULL)
    return NULL;

  next = delete_bound_var_in_var_list (vl->next);
  if (vl->var->value)
    new = next;
  else
    if (next == vl->next)
      new = vl;
    else
      new = make_var_list (vl->var, next);

  return new;
}
