/* Micro Quixote           */
/* Copyright (C) 1993 ICOT */
/* Written by gniibe       */

/* ext constraint solver */

#include <stdio.h>
#include "mq.h"
#include "internal.h"
#include "extern.h"

/* function prototype for debugging */
static void constraint_solve_ext _P((MQ_Constraints *));
static void add_cnstr_to_ext _P((MQ_Constraint, MQ_Constraints *));
static int search_ext _P((MQ_Constraint, MQ_Constraints));

void constraint_solve_ext_cnstrs ()
{
  constraint_solve_ext (&ext_cnstrs);
}

void add_cnstr_to_ext_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  add_cnstr_to_ext (cnstr, &ext_cnstrs);
}

int check_cnstr_in_ext_cnstrs (cnstr)
     MQ_Constraint cnstr;
{
  return search_ext (cnstr, ext_cnstrs);
}

void constraint_solve_ext_asmpts ()
{
  constraint_solve_ext (&ext_asmpts);
}

void add_cnstr_to_ext_asmpts (cnstr)
     MQ_Constraint cnstr;
{
  add_cnstr_to_ext (cnstr, &ext_asmpts);
}

void constraint_solve_ext_cnstrs_h ()
{
  constraint_solve_ext (&ext_cnstrs_h);
}

void add_cnstr_to_ext_cnstrs_h (cnstr)
     MQ_Constraint cnstr;
{
  add_cnstr_to_ext (cnstr, &ext_cnstrs_h);
}

static
void constraint_solve_ext (cs_p)
     MQ_Constraints *cs_p;
{
  MQ_Constraints cnstrs_changed, cs;
  int binding_changed_saved;
  MQ_Obj result;

  binding_changed_saved = binding_changed;
  while (1)
    {
      cnstrs_changed = mQ_void_cnstrs;
      for (cs=*cs_p; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  cs->r_var_list = delete_bound_var_in_var_list (cs->r_var_list);
	  if (cs->r_var_list == NULL)
	    {
	      if (cs->prev == NULL) /* cs == *cs_p */
		{
		  *cs_p = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = NULL;
		}
	      else
		{
		  cs->prev->next = cs->next;
		  if (cs->next != mQ_void_cnstrs)
		    cs->next->prev = cs->prev;
		}
	      cs->next = cnstrs_changed;
	      cs->prev = NULL;
	      if (cnstrs_changed != mQ_void_cnstrs)
		cnstrs_changed->prev = cs;
	      cnstrs_changed = cs;
	    }
	}

      binding_changed = FALSE;
      for (cs=cnstrs_changed; cs!=mQ_void_cnstrs; cs=cs->next)
	{
	  switch (cs->cnstr->rel)
	    {
	    case ExternalExpr:
	      result = eval_ext_expr ((MQ_Obj)cs->cnstr->vterm);
	      if (result == NULL)
		{ /* remain there */
		  *cs_p = make_cnstrs (cs->cnstr, *cs_p);
		  (*cs_p)->r_var_list = NULL;
		}
	      else
		if (unify ((MQ_VTerm *)&cs->cnstr->term, (MQ_VTerm *)&result)
		    == FAILURE)
		  {
		    constrain_failed = TRUE;
		    return;
		  }
	      break;
	    case ExternalCnstr:
	      if (!eval_ext_cnstr ((MQ_Obj)cs->cnstr->vterm))
		{
		  constrain_failed = TRUE;
		  return;
		}
	      break;

	    default:
	      fatal ("constraint_solve_ext.\n");
	      break;
	    }
	}
      if (!binding_changed)
	break;
      binding_changed_saved = TRUE;
    }
  binding_changed = binding_changed_saved;
}

static
void add_cnstr_to_ext (cnstr, cs_p)
     MQ_Constraint cnstr;
     MQ_Constraints *cs_p;
{
  MQ_VarList vl;
  MQ_Obj result;

  if (search_ext (cnstr, *cs_p))
    /* already there */
    return;

  if (cnstr->vterm->type == TT_Var)
    vl = make_var_list ((MQ_Var)cnstr->vterm, NULL);
  else
    vl = variables_in_obj ((MQ_Obj)cnstr->vterm);

  if (vl == NULL)
    switch (cnstr->rel)
      {
      case ExternalExpr:
	result = eval_ext_expr ((MQ_Obj)cnstr->vterm);
	if (result == NULL)
	  { /* remain there */
	    *cs_p = make_cnstrs (cnstr, *cs_p);
	    (*cs_p)->r_var_list = NULL;
	  }
	else
	  if (unify ((MQ_VTerm *)&cnstr->term, (MQ_VTerm *)&result) == FAILURE)
	    constrain_failed = TRUE;
	break;
      case ExternalCnstr:
	if (!eval_ext_cnstr ((MQ_Obj)cnstr->vterm))
	  constrain_failed = TRUE;
	break;

      default:
	fatal ("add_cnstr_to_ext.\n");
	break;
      }
  else
    switch (cnstr->rel)
      {
      case ExternalExpr:
      case ExternalCnstr:
	*cs_p = make_cnstrs (cnstr, *cs_p);
	(*cs_p)->r_var_list = vl;
	break;

      default:
	fatal ("add_cnstr_to_ext.\n");
	break;
      }
}

static
int search_ext (cnstr, cnstrs)
     MQ_Constraint cnstr;
     MQ_Constraints cnstrs;
{
  MQ_Constraints cs;

  for (cs=cnstrs; cs!=mQ_void_cnstrs; cs=cs->next)
    {
      if (cnstr->rel != cs->cnstr->rel)
	continue;
      if (cnstr->rel == ExternalExpr)
	{
	  if (equal ((MQ_VTerm)cnstr->term, (MQ_VTerm)cs->cnstr->term)
	      && equal (cnstr->vterm, cs->cnstr->vterm))
	    return TRUE;
	}
      else if (cnstr->rel == ExternalCnstr)
	{
	  if (equal (cnstr->vterm, cs->cnstr->vterm))
	    return TRUE;
	}
      else
	fatal ("search_ext\n");
    }
  return FALSE;
}
