/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	visual.c	---	Main routines for window handling.
 *
 */

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/keysym.h>
#include	<X11/cursorfont.h>

#define	PROTO_VISUAL_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
#undef	PROTO_VISUAL_C

#pragma segment	visual


/*	Command buttons...	*/
Button	GButton[NUM_OF_BUTTONS] = {
  {"## STATUS: -- STOPPED -- ##", FALSE,
     NULL, {0,0,0,0}, NULL, NULL, cb_ChangeParams},
  {"Spreading Activation", FALSE,
     NULL, {0,0,0,0}, NULL, NULL, cb_SpreadingActivation},
  {"Backpropagation", FALSE,
     NULL, {0,0,0,0}, NULL, NULL, cb_Backpropagation},
  {"Step Subsumption", FALSE,
     NULL, {0,0,0,0}, NULL, NULL, cb_StepSubsumption},
  {"Next Subsumption", FALSE,
     NULL, {0,0,0,0}, NULL, NULL, cb_NextSubsumption},
  {"Quit", FALSE,
     NULL, {0,0,0,0}, NULL, NULL, cb_Quit}
};


Boolean Initialize(argc, argv)
     int *argc;
     char *argv[];
{
  XSizeHints hint;
  unsigned long black, white;
  int dir, asc, desc;
  XColor c;
  int i, xpos;

  /*	Initialize Memory-Manager.	*/
  VNodeRec_c = GET_VNodeRec_chunk();
  VNodeRec_r = &VNodeRec_c->cell[0];

  if (!GetWindowArguments(argc, argv, &hint))
    return FALSE;

  /*	Create Drawing-window.	*/
  black = BlackPixel(Global.disp, 0);
  white = WhitePixel(Global.disp, 0);

  Global.wind =
    XCreateSimpleWindow(Global.disp, DefaultRootWindow(Global.disp),
			hint.x, hint.y,
			hint.width, hint.height,
			5, black, white);
  XSetStandardProperties(Global.disp, Global.wind, SYS_NAME, SYS_NAME,
			 None, argv, *argc, &hint);
  XSelectInput(Global.disp, Global.wind,
	       ButtonPressMask|ButtonReleaseMask|
	       OwnerGrabButtonMask|
	       ButtonMotionMask|ExposureMask);

  /*	Define Cursors.	*/
  Global.normcs = XCreateFontCursor(Global.disp, XC_left_ptr);
  Global.chngcs1 = XCreateFontCursor(Global.disp, XC_center_ptr);
  Global.chngcs2 = XCreateFontCursor(Global.disp, XC_right_ptr);

  /*	Create GCs.	*/
  Global.txt = XCreateGC(Global.disp, Global.wind, 0, 0);
  XSetForeground(Global.disp, Global.txt, black);
  XSetBackground(Global.disp, Global.txt, white);
  Global.xor = XCreateGC(Global.disp, Global.wind, 0, 0);
  XSetForeground(Global.disp, Global.xor, black);
  XSetBackground(Global.disp, Global.xor, white);
  XSetFunction(Global.disp, Global.xor, GXxor);
  Global.clear = XCreateGC(Global.disp, Global.wind, 0, 0);
  XSetForeground(Global.disp, Global.clear, white);
  XSetBackground(Global.disp, Global.clear, black);
  Global.mark = XCreateGC(Global.disp, Global.wind, 0, 0);

  /*	Get font-information.	*/
  FntInfo.fs = XLoadQueryFont(Global.disp, DEFFONT);
  XSetFont(Global.disp, Global.txt, FntInfo.fs->fid);
  XTextExtents(FntInfo.fs, "X", 1, &dir,
	       &asc, &desc, &FntInfo.cs);
  FntInfo.ch = asc + desc;
  FntInfo.cw = FntInfo.cs.width;

  /*	Create color-map.	  */
  Global.cm = XDefaultColormap(Global.disp, 0);
  for (i = 0; i < RESOLUTION; i++) {
    c.red = 0xffffL / RESOLUTION * i;
    c.green = 0x4000L;
    c.blue = 0xffffL - c.red;
    XAllocColor(Global.disp, Global.cm, &c);
    Global.color[i] = XCreateGC(Global.disp, Global.wind, 0, 0);
    XSetForeground(Global.disp, Global.color[i], c.pixel);
    XSetBackground(Global.disp, Global.color[i], white);
    XSetFont(Global.disp, Global.color[i], FntInfo.fs->fid);
    XSetLineAttributes(Global.disp, Global.color[i],
		       2, LineSolid, CapButt, JoinMiter);
  }
  /*	Colorize marker's GC	  */
  c.red = 0x4000L;
  c.green = 0x8000L;
  c.blue = 0x4000L;
  XAllocColor(Global.disp, Global.cm, &c);
  XSetForeground(Global.disp, Global.mark, c.pixel);
  XSetBackground(Global.disp, Global.mark, black);
  XSetFunction(Global.disp, Global.mark, GXxor);

  /*	Calculate total width of buttons.	*/
  for (xpos = 5, i = 0; i < NUM_OF_BUTTONS; i++) {
    xpos += FOCUS_WIDTH;
    GButton[i].gmtry.x = xpos;
    GButton[i].gmtry.y = FOCUS_WIDTH;
    GButton[i].gmtry.width =
      XTextWidth(FntInfo.fs, GButton[i].name, strlen(GButton[i].name))
	+ BUTTON_H_MARGIN*2;
    GButton[i].gmtry.height = FntInfo.ch + BUTTON_V_MARGIN*2;
    xpos += GButton[i].gmtry.width + FOCUS_WIDTH;
  }

  /*	Create button-frame-window.	*/
  GButtonFrame =
    XCreateSimpleWindow(Global.disp, Global.wind,
			0, 0,
			xpos + 5 + 2,
			FntInfo.ch + BUTTON_V_MARGIN*2 + FOCUS_WIDTH*2 + 2,
			FOCUS_WIDTH, black, white);

  /*	Create button-windows.	*/
  for (xpos = FOCUS_WIDTH, i = 0; i < NUM_OF_BUTTONS; i++) {
    GButton[i].wind =
      XCreateSimpleWindow(Global.disp, GButtonFrame,
			  GButton[i].gmtry.x, GButton[i].gmtry.y,
			  GButton[i].gmtry.width,
			  GButton[i].gmtry.height,
			  1, black, white);
    XSelectInput(Global.disp, GButton[i].wind,
		 ButtonPressMask|ButtonReleaseMask|
		 OwnerGrabButtonMask|ButtonMotionMask|
		 EnterWindowMask|LeaveWindowMask|ExposureMask);
    GButton[i].normalGC = XCreateGC(Global.disp, GButton[i].wind, 0, 0);
    XSetForeground(Global.disp, GButton[i].normalGC, black);
    XSetBackground(Global.disp, GButton[i].normalGC, white);
    GButton[i].inverseGC = XCreateGC(Global.disp, GButton[i].wind, 0, 0);
    XSetForeground(Global.disp, GButton[i].inverseGC, white);
    XSetBackground(Global.disp, GButton[i].inverseGC, black);
  }

  /*	Map Drawing-window and buttons.	*/
  XMapRaised(Global.disp, Global.wind);
  XMapSubwindows(Global.disp, Global.wind);
  XMapSubwindows(Global.disp, GButtonFrame);

  Global.prev.x = 10;
  Global.prev.y = 50;
  Global.linkmode = SUBSMD_LINK;
  Global.clauses = NULL;

  SetUpParamWindow();
  GInfoWindowsList = NULL;

  return TRUE;
}


void DoWindowEventLoop()
{
  XEvent event;

  if (Gparams.state == PREPARING)
    GButton[0].name = "## STATUS: - PREPARING - ##";
  else if (Gparams.state == STOPPED)
    GButton[0].name = "## STATUS: -- STOPPED -- ##";
  else
    GButton[0].name = "## STATUS: -- ABORTED -- ##";
  XDefineCursor(Global.disp, Global.wind, Global.normcs);
  while (TRUE) {
    XNextEvent(Global.disp, &event);
    DoDrawingWindow(event);
    DoButtonWindows(event);
    DoParamWindow(event);
    DoInfoWindows(event);
  }
}


void DisposeLiteralVNode(ltrl)
     litrlrec *ltrl;
{
  InfoWindow *iw;

  if (ltrl == NULL || ltrl->vnode == NULL)
    return;
  ltrl->vnode->begin = NULL;
  if (ltrl->vnode->ctrl.nxt != NULL)
    ltrl->vnode->ctrl.nxt->ctrl.prv = ltrl->vnode->ctrl.prv;
  if (ltrl->vnode->ctrl.prv != NULL)
    ltrl->vnode->ctrl.prv->ctrl.nxt = ltrl->vnode->ctrl.nxt;
  else
    Global.clauses = ltrl->vnode->ctrl.nxt;
  for (iw = GInfoWindowsList; iw != NULL; iw = iw->next)
    if (iw->type == LTRL_INFO && iw->body.literal == ltrl) {
      DisposeInfoWindow(iw);
      break;
    }
  FREE_VNodeRec(ltrl->vnode);
  ltrl->vnode = NULL;
}


void DisposePPHandleVNode(pphndl)
     pphandle *pphndl;
{
  if (pphndl == NULL || pphndl->vnode == NULL)
    return;
  pphndl->vnode->next = NULL;
  if (pphndl->vnode->ctrl.nxt != NULL)
    pphndl->vnode->ctrl.nxt->ctrl.prv = pphndl->vnode->ctrl.prv;
  if (pphndl->vnode->ctrl.prv != NULL)
    pphndl->vnode->ctrl.prv->ctrl.nxt = pphndl->vnode->ctrl.nxt;
  else
    Global.clauses = pphndl->vnode->ctrl.nxt;
  FREE_VNodeRec(pphndl->vnode);
  pphndl->vnode = NULL;
}


void DisposeLinkVNode(lnk)
     linkrec *lnk;
{
  InfoWindow *iw;

  if (lnk == NULL || lnk->vnode == NULL)
    return;
  for (iw = GInfoWindowsList; iw != NULL; iw = iw->next)
    if (iw->type == LINK_INFO && iw->body.link == lnk) {
      DisposeInfoWindow(iw);
      break;
    }
  FREE_VNodeRec(lnk->vnode);
  lnk->vnode = NULL;
}


/*===== Private routines in window system =====*/


Boolean GetWindowArguments(argc, argv, hint)
     int *argc;
     char *argv[];
     XSizeHints *hint;
{
  Boolean wind;
  int i, j, fmask;
  char *geometry, *display;

  hint->x = 100;
  hint->y = 100;
  hint->flags = PSize;

  geometry = "";
  display = "";
  wind = TRUE;
  for (i = 1, j = 1; argv[j] != NULL; )
    if (strcmp(argv[j], "-geometry") == 0) {
      geometry = argv[++j];
      j++;
      *argc -= 2;
    } else if (strcmp(argv[j], "-display") == 0) {
      display = argv[++j];
      j++;
      *argc -= 2;
    } else if (strcmp(argv[j], "-nw") == 0) {
      wind = FALSE;
      j++;
      *argc--;
    } else
      argv[i++] = argv[j++];
  argv[i] = NULL;

  if (!wind)
    return FALSE;
  Global.disp = XOpenDisplay(display);
  if (Global.disp == NULL) {
    printf("### Can't open display `%s' (window option is disabled.)\n", display);
    printf("* Please check DISPLAY environment variable and   *\n");
    printf("* whether client is added to `xhost's in X server.*\n");
    putchar('\n');
    return FALSE;
  }

  fmask = XGeometry(Global.disp, 0, geometry, DEF_WIND_SIZE,
		    5, 1, 1, 0, 0,
		    &hint->x, &hint->y, &hint->width, &hint->height);
  if ((fmask & XValue) && (fmask & YValue))
    hint->flags = USSize | USPosition;
  else
    hint->flags = USSize;

  return TRUE;
}


void DoDrawingWindow(event)
     XEvent event;
{
  switch (event.type) {
  case ButtonPress:
    if (event.xbutton.window == Global.wind)
      switch (event.xbutton.button) {
      case 1:
	DoContent(event.xbutton.x, event.xbutton.y);
	break;
      case 2:
	switch (Global.linkmode) {
	case SUBSMD_LINK:
	  Global.linkmode = NOT_SUBSMD_LINK;
	  XDefineCursor(Global.disp, Global.wind, Global.chngcs1);
	  break;
	case NOT_SUBSMD_LINK:
	  Global.linkmode = HIGH_ACT_LINK;
	  XDefineCursor(Global.disp, Global.wind, Global.chngcs2);
	  break;
	case HIGH_ACT_LINK:
	  Global.linkmode = SUBSMD_LINK;
	  XDefineCursor(Global.disp, Global.wind, Global.normcs);
	  break;
	}
	XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
	break;
      case 3:
	ShowInformation(event.xbutton.x, event.xbutton.y);
	break;
      }
    break;
  case Expose:
    if (event.xexpose.window == Global.wind &&
	event.xexpose.count == 0) {
      ShowCandidate(TRUE);
      DrawContent();
      ShowCandidate(FALSE);
    }
    break;
  }
}


void DoButtonWindows(event)
     XEvent event;
{
  int i;

  switch (event.type) {
  case ButtonPress:
    for (i = 0; i < NUM_OF_BUTTONS; i++)
      if (event.xbutton.window == GButton[i].wind) {
	PressButton(i, event.xbutton.x, event.xbutton.y);
	break;
      }
    break;
  case ButtonRelease:
    for (i = 0; i < NUM_OF_BUTTONS; i++)
      if (event.xbutton.window == GButton[i].wind) {
	ReleaseButton(i, event.xbutton.x, event.xbutton.y);
	break;
      }
    break;
  case EnterNotify:
    for (i = 0; i < NUM_OF_BUTTONS; i++)
      if (event.xmotion.window == GButton[i].wind) {
	EnterButton(i);
	break;
      }
    break;
  case LeaveNotify:
    for (i = 0; i < NUM_OF_BUTTONS; i++)
      if (event.xmotion.window == GButton[i].wind) {
	LeaveButton(i);
	break;
      }
    break;
  case Expose:
    if (event.xexpose.count == 0)
      for (i = 0; i < NUM_OF_BUTTONS; i++)
	if (event.xexpose.window == GButton[i].wind) {
	  ExposeButton(i);
	  break;
	}
    break;
  }
}


void DoParamWindow(event)
     XEvent event;
{
  KeySym key;
  XComposeStatus cs;
  char str[20];

  if (! GParamWindow.mapped)
    return;
  switch (event.type) {
  case KeyPress:
    if (event.xkey.window == GParamWindow.wind &&
	XLookupString((XKeyEvent*)&event, str, 20, &key, &cs) == 1)
      switch (key) {
      case XK_Return:
	GParamWindow.buffer[GParamWindow.p] = '\0';
	ProcessCommand(GParamWindow.buffer, TRUE);
	if (Gparams.state == PREPARING)
	  GButton[0].name = "## STATUS: - PREPARING - ##";
	else if (Gparams.state == STOPPED)
	  GButton[0].name = "## STATUS: -- STOPPED -- ##";
	else if (Gparams.state == UNCONVERGED)
	  GButton[0].name = "## STATUS: NOT CONVERGED ##";
	else if (Gparams.state == FINISHED)
	  GButton[0].name = "## STATUS: -- FINISHED -- ##";
	else
	  GButton[0].name = "## STATUS: -- ABORTED -- ##";
	XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
	GParamWindow.dirty = TRUE;
	XClearArea(Global.disp, GParamWindow.wind, 0, 0, 0, 0, TRUE);
	GParamWindow.p = 0;
	GParamWindow.buffer[0] = '_';
	GParamWindow.buffer[1] = '\0';
	break;
      case XK_BackSpace:
      case XK_Delete:
	if (GParamWindow.p > 0) {
	  GParamWindow.buffer[GParamWindow.p--] = '\0';
	  GParamWindow.buffer[GParamWindow.p] = '_';
	}
	break;
      case XK_Control_R:
      case XK_Control_L:
      case XK_Shift_R:
      case XK_Shift_L:
	break;
      default:
	if (!IsCursorKey(key) && !IsFunctionKey(key)) {
	  if (str[0] == 'H' - '@') {
	    if (GParamWindow.p > 0) {
	      GParamWindow.buffer[GParamWindow.p--] = '\0';
	      GParamWindow.buffer[GParamWindow.p] = '_';
	    }
	  } else if (GParamWindow.p < BUFFSIZE-2) {
	    GParamWindow.buffer[GParamWindow.p] = str[0];
	    GParamWindow.buffer[++GParamWindow.p] = '_';
	    GParamWindow.buffer[GParamWindow.p+1] = '\0';
	  }
	}
	break;
      }
    RedrawCommandLine();
    break;
  case ButtonPress:
    if (event.xbutton.window == GParamWindow.wind) {
      XUnmapWindow(Global.disp, GParamWindow.wind);
      GParamWindow.mapped = FALSE;
    }
    break;
  case Expose:
    if (event.xexpose.window == GParamWindow.wind &&
	event.xexpose.count == 0)
      ExposeParamWindow();
    break;
  }
}


void DoInfoWindows(event)
     XEvent event;
{
  InfoWindow *iw;

  switch (event.type) {
  case ButtonPress:
    for (iw = GInfoWindowsList; iw != NULL; iw = iw->next)
      if (event.xbutton.window == iw->wind) {
	DisposeInfoWindow(iw);
	break;
      }
    break;
  case Expose:
    if (event.xexpose.count == 0)
      for (iw = GInfoWindowsList; iw != NULL; iw = iw->next)
	if (event.xexpose.window == iw->wind) {
	  ExposeInfoWindow(iw);
	  break;
	}
    break;
  }
}


/*=====	High-level memory management routines =====*/


VNodeRec *new_node()
{
  VNodeRec *new;

  new = NEW_VNodeRec();
  new->title[0] = '\0';
  new->begin = NULL;
  new->next = NULL;
  new->ctrl.prv = NULL;
  new->ctrl.nxt = Global.clauses;
  if (new->ctrl.nxt != NULL)
    new->ctrl.nxt->ctrl.prv = new;
  Global.clauses = new;
  return new;
}


void dispose_node(node)
     VNodeRec *node;
{
  if (node == NULL)
    return;
  if (node->ctrl.nxt != NULL)
    node->ctrl.nxt->ctrl.prv = node->ctrl.prv;
  if (node->ctrl.prv != NULL)
    node->ctrl.prv->ctrl.nxt = node->ctrl.nxt;
  else
    Global.clauses = node->ctrl.nxt;
  FREE_VNodeRec(node);
}


/*=====	Low-level memory management routines =====*/


VNodeRec_chunk *GET_VNodeRec_chunk()
{
  int i;
  VNodeRec_chunk *newchunk;

  newchunk = (VNodeRec_chunk *) malloc(sizeof(VNodeRec_chunk));
  if (newchunk == NULL) {
    fprintf(stderr, "Can't get more chunk ! (GET_VNodeRec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_VNODEREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_VNODEREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_VNODEREC-1].mm.nxt = NULL;
  return newchunk;
}



VNodeRec *NEW_VNodeRec()
{
  VNodeRec *newobj;
  VNodeRec_chunk *newchunk;

  if (VNodeRec_r == NULL) {
    newchunk = GET_VNodeRec_chunk();
    newchunk->nxt = VNodeRec_c;
    VNodeRec_c = newchunk;
    VNodeRec_r = &newchunk->cell[0];
  }
  newobj = VNodeRec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_VNodeRec ---\n");
  }
  newobj->mm.mark = USED;
  VNodeRec_r = VNodeRec_r->mm.nxt;
  return newobj;
}



void FREE_VNodeRec(cell)
     VNodeRec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_VNodeRec ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = VNodeRec_r;
  VNodeRec_r = cell;
}
