/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	mark.c	---	Marking candidate position of the next subsumption.
 *
 */

#include	<stdio.h>
#include	<math.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#define	PROTO_MARK_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
#undef	PROTO_MARK_C

#pragma segment	visual


void ShowArrow(clear, top0, top1, j0, j1)
     Boolean clear;
     VNodeRec *top0, *top1;
     jointrec *j0, *j1;
{
  XPoint p0, p1;

  p0.x = top0->region.x + j0->ltrl->vnode->region.x + FntInfo.cw/2;
  p0.y = top0->region.y + j0->ltrl->vnode->region.y + FntInfo.ch/2;
  p1.x = top1->region.x + j1->ltrl->vnode->region.x + FntInfo.cw/2;
  p1.y = top1->region.y + j1->ltrl->vnode->region.y + FntInfo.ch/2;
  if (top0 == top1)
    VerticalArrow(clear, p0, p1, ARC_WIDTH);
  else {
    if (p0.x == p1.x)
      VerticalArrow(clear, p0, p1, 0);
    else
      TangentArrow(clear, p0, p1);
  }
}


/* VerticalArrow() and TangentArrow() set the cordinates
   of the arrow as follows:

                        /\ arrow[0]
                       /  \
           arrow[1]__ /    \ __arrow[6]
                      -+  +-
           arrow[2]---/|  |\---arrow[5]
           arrow[3]    +--+    arrow[4]
*/
void VerticalArrow(clear, p0, p1, offset)
     Boolean clear;
     XPoint p0, p1;
     int offset;
{
  XPoint pp, arrow[8];

  pp.x = (p0.x+p1.x)/2;
  pp.y = (p0.y+p1.y)/2;
  if (p0.y > p1.y) {
    arrow[0].x = pp.x - offset;
    arrow[0].y = pp.y - CAND_ARROW_LENGTH1;
    arrow[1].x = pp.x - CAND_ARROW_LENGTH2 - offset;
    arrow[1].y = pp.y;
    arrow[2].x = pp.x - CAND_ARROW_LENGTH3 - offset;
    arrow[2].y = pp.y;
    arrow[3].x = pp.x - CAND_ARROW_LENGTH3 - offset;
    arrow[3].y = pp.y + CAND_ARROW_LENGTH2;
    arrow[4].x = pp.x + CAND_ARROW_LENGTH3 - offset;
    arrow[4].y = pp.y + CAND_ARROW_LENGTH2;
    arrow[5].x = pp.x + CAND_ARROW_LENGTH3 - offset;
    arrow[5].y = pp.y;
    arrow[6].x = pp.x + CAND_ARROW_LENGTH2 - offset;
    arrow[6].y = pp.y;
  } else {
    arrow[0].x = pp.x - offset;
    arrow[0].y = pp.y + CAND_ARROW_LENGTH1;
    arrow[1].x = pp.x - CAND_ARROW_LENGTH2 - offset;
    arrow[1].y = pp.y;
    arrow[2].x = pp.x - CAND_ARROW_LENGTH3 - offset;
    arrow[2].y = pp.y;
    arrow[3].x = pp.x - CAND_ARROW_LENGTH3 - offset;
    arrow[3].y = pp.y - CAND_ARROW_LENGTH2;
    arrow[4].x = pp.x + CAND_ARROW_LENGTH3 - offset;
    arrow[4].y = pp.y - CAND_ARROW_LENGTH2;
    arrow[5].x = pp.x + CAND_ARROW_LENGTH3 - offset;
    arrow[5].y = pp.y;
    arrow[6].x = pp.x + CAND_ARROW_LENGTH2 - offset;
    arrow[6].y = pp.y;
  }
  arrow[7] = arrow[0];
  if (clear)
    XFillPolygon(Global.disp, Global.wind,
		 Global.clear,
		 arrow, 8, Nonconvex, CoordModeOrigin);
  else {
    XFillPolygon(Global.disp, Global.wind,
		 Global.mark,
		 arrow, 8, Nonconvex, CoordModeOrigin);
    XDrawLines(Global.disp, Global.wind,
	       Global.txt,
	       arrow, 8, CoordModeOrigin);
  }
}


void TangentArrow(clear, p0, p1)
     Boolean clear;
     XPoint p0, p1;
{
  XPoint pp, arrow[8];
  double ta, ta2, co, si;

  ta = (double)(p1.y-p0.y)/(double)(p1.x-p0.x);
  ta2 = sqrt(1.0 + ta*ta);
  ta2 *= (p0.x < p1.x) ? 1.0 : -1.0;
  co = 1/ta2;
  si = ta/ta2;
  pp.x = (p0.x+p1.x)/2;
  pp.y = (p0.y+p1.y)/2;
  arrow[0].x = (short)(pp.x + co*CAND_ARROW_LENGTH1);
  arrow[0].y = (short)(pp.y + si*CAND_ARROW_LENGTH1);
  arrow[1].x = (short)(pp.x - si*CAND_ARROW_LENGTH2);
  arrow[1].y = (short)(pp.y + co*CAND_ARROW_LENGTH2);
  arrow[2].x = (short)(pp.x - si*CAND_ARROW_LENGTH3);
  arrow[2].y = (short)(pp.y + co*CAND_ARROW_LENGTH3);
  arrow[3].x = (short)(pp.x - co*CAND_ARROW_LENGTH1 - si*CAND_ARROW_LENGTH3);
  arrow[3].y = (short)(pp.y - si*CAND_ARROW_LENGTH1 + co*CAND_ARROW_LENGTH3);
  arrow[4].x = (short)(pp.x - co*CAND_ARROW_LENGTH1 + si*CAND_ARROW_LENGTH3);
  arrow[4].y = (short)(pp.y - si*CAND_ARROW_LENGTH1 - co*CAND_ARROW_LENGTH3);
  arrow[5].x = (short)(pp.x + si*CAND_ARROW_LENGTH3);
  arrow[5].y = (short)(pp.y - co*CAND_ARROW_LENGTH3);
  arrow[6].x = (short)(pp.x + si*CAND_ARROW_LENGTH2);
  arrow[6].y = (short)(pp.y - co*CAND_ARROW_LENGTH2);
  arrow[7] = arrow[0];
  if (clear)
    XFillPolygon(Global.disp, Global.wind,
		 Global.clear,
		 arrow, 8, Nonconvex, CoordModeOrigin);
  else {
    XFillPolygon(Global.disp, Global.wind,
		 Global.mark,
		 arrow, 8, Nonconvex, CoordModeOrigin);
    XDrawLines(Global.disp, Global.wind,
	       Global.txt,
	       arrow, 8, CoordModeOrigin);
  }
}


void MarkArgument(clear, top, j, sw)
     Boolean clear;
     VNodeRec *top;
     jointrec *j;
     int sw;
{
  char *title;
  int n, x, y, width, dir, asc, desc;
  XCharStruct overall;

  if (j->ltrl->tag == SYMBOL ||
      j->ltrl->tag == NUMBER ||
      j->ltrl->tag == PSTERM)
    return;
  title = j->ltrl->vnode->title;
  switch (j->ltrl->tag) {
  case FUNCTION:
    if (j->nth == LEFTHAND) {
      n = count_until(title, '=', 1);
      XTextExtents(FntInfo.fs,
		   title, n,
		   &dir, &asc, &desc, &overall);
      x = FntInfo.cw;
      width = overall.width - x;
      break;
    }
    if (strcmp(j->ltrl->body.afm.name, CONS_NAME) == 0) {
      if (j->nth == 0) {
	n = count_until(title, '[', 1) + 1;
	XTextExtents(FntInfo.fs,
		     title, n,
		     &dir, &asc, &desc, &overall);
	x = overall.width;
	n = count_until(title, '|', 1);
	XTextExtents(FntInfo.fs,
		     title, n,
		     &dir, &asc, &desc, &overall);
	width = overall.width - x;
      } else {
	n = count_until(title, '|', 1) + 1;
	XTextExtents(FntInfo.fs,
		     title, n,
		     &dir, &asc, &desc, &overall);
	x = overall.width;
	n = count_until(title, ']', 1);
	XTextExtents(FntInfo.fs,
		     title, n,
		     &dir, &asc, &desc, &overall);
	width = overall.width - x;
      }
      break;
    }
  case CONSTRAINT:
    if (j->nth == 0) {
      n = count_until(title, '(', 1) + 1;
      XTextExtents(FntInfo.fs,
		   title, n,
		   &dir, &asc, &desc, &overall);
    } else {
      n = count_until(title, ',', j->nth) + 1;
      XTextExtents(FntInfo.fs,
		   title, n,
		   &dir, &asc, &desc, &overall);
    }
    x = overall.width;
    if (j->nth == j->ltrl->body.afm.arity-1) {
      n = count_until(title, ')', 1);
      XTextExtents(FntInfo.fs,
		   title, n,
		   &dir, &asc, &desc, &overall);
    } else {
      n = count_until(title, ',', j->nth+1);
      XTextExtents(FntInfo.fs,
		   title, n,
		   &dir, &asc, &desc, &overall);
    }
    width = overall.width - x;
    break;
  case FEATURE:
    n = count_until(title, '(', 1) + 1;
    XTextExtents(FntInfo.fs,
		 title, n,
		 &dir, &asc, &desc, &overall);
    x = overall.width;
    n = count_until(title, ')', 1);
    XTextExtents(FntInfo.fs,
		 title, n,
		 &dir, &asc, &desc, &overall);
    width = overall.width - x;
    break;
  }
  x += FntInfo.cw + top->region.x + j->ltrl->vnode->region.x;
  y = top->region.y + j->ltrl->vnode->region.y;
  if (clear) {
    if (sw)
      XFillArc(Global.disp, Global.wind, Global.clear,
	       x, y, width, FntInfo.ch, 0, 360*64);
    else
      XFillRectangle(Global.disp, Global.wind, Global.clear,
		     x, y, width, FntInfo.ch);
  } else {
    if (sw) {
      XFillArc(Global.disp, Global.wind, Global.mark,
	       x, y, width, FntInfo.ch, 0, 360*64);
      XDrawArc(Global.disp, Global.wind, Global.txt,
	       x, y, width, FntInfo.ch, 0, 360*64);
    } else {
      XFillRectangle(Global.disp, Global.wind, Global.mark,
		     x, y, width, FntInfo.ch);
      XDrawRectangle(Global.disp, Global.wind, Global.txt,
		     x, y, width, FntInfo.ch);
    }
  }
}


int count_until(str, ch, cnt)
     char *str;
     int ch, cnt;
{
  char *p;
  int n, c;

  for (p = str, n = 0, c = 0; c < cnt && *p != '\0'; p++, n++, c++)
    for ( ; *p != '\0' && *p != ch; n++, p++)
      ;
  return (n-1);
}
