/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	draw3.c	---	Main draw routines part 3.
 *			(show information of literal and link)
 *
 */

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#define	PROTO_DRAW3_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
#undef	PROTO_DRAW3_C

#pragma segment	visual


void SetUpParamWindow()
{
  XSizeHints hint;
  Font font;

  GParamWindow.lines = SetStatus(GParamWindow.text);
  GParamWindow.dirty = FALSE;

  hint.x = 0;
  hint.y = 0;
  hint.width = PARAM_WIDTH;
  hint.height = FntInfo.ch * (GParamWindow.lines+2) + PARAM_V_MARGIN*2;
  hint.flags = PSize;

  GParamWindow.wind
    = XCreateSimpleWindow(Global.disp, DefaultRootWindow(Global.disp),
			  hint.x, hint.y,
			  hint.width, hint.height,
			  2,
			  BlackPixel(Global.disp, 0),
			  WhitePixel(Global.disp, 0));
  XSetStandardProperties(Global.disp, GParamWindow.wind, COM_NAME, COM_NAME,
			 None, NULL, 0, &hint);
  XSelectInput(Global.disp, GParamWindow.wind,
	       ButtonPressMask|KeyPressMask|ExposureMask);

  GParamWindow.tl = XCreateGC(Global.disp, GParamWindow.wind, 0, 0);
  GParamWindow.cl = XCreateGC(Global.disp, GParamWindow.wind, 0, 0);
  XSetForeground(Global.disp, GParamWindow.tl, BlackPixel(Global.disp, 0));
  XSetForeground(Global.disp, GParamWindow.cl, WhitePixel(Global.disp, 0));
  XSetBackground(Global.disp, GParamWindow.cl, BlackPixel(Global.disp, 0));
  font = XLoadFont(Global.disp, DEFFONT);
  XSetFont(Global.disp, GParamWindow.tl, font);
  XSetFont(Global.disp, GParamWindow.cl, font);

  GParamWindow.p = 0;
  GParamWindow.buffer[0] = '_';
  GParamWindow.buffer[1] = '\0';
}


void ExposeParamWindow()
{
  int l, h;

  if (GParamWindow.dirty) {
    GParamWindow.lines = SetStatus(GParamWindow.text);
    GParamWindow.dirty = FALSE;
  }
  for (l = 0, h = FntInfo.ch; l < GParamWindow.lines; l++, h += FntInfo.ch)
    XDrawString(Global.disp, GParamWindow.wind,
		GParamWindow.tl, FntInfo.cw, h,
		GParamWindow.text[l], strlen(GParamWindow.text[l]));
  RedrawCommandLine();
}


void RedrawCommandLine()
{
  XFillRectangle(Global.disp, GParamWindow.wind,
		 GParamWindow.tl,
		 PARAM_H_MARGIN, FntInfo.ch*(GParamWindow.lines+1),
		 PARAM_WIDTH-PARAM_H_MARGIN*2, FntInfo.ch+2);
  XDrawString(Global.disp, GParamWindow.wind,
	      GParamWindow.cl,
	      PARAM_H_MARGIN+2, FntInfo.ch*(GParamWindow.lines+2),
	      GParamWindow.buffer, GParamWindow.p+1);
}


void ShowInformation(x, y)
     int x, y;
{
  XPoint pt;
  VNodeRec *vnode;
  linkrec *lnk;
  InfoWindow *infoW;

  pt.x = x;
  pt.y = y;
  vnode = PickLiteral(pt);
  if (vnode != NULL) {
    infoW = (InfoWindow *) malloc(sizeof(InfoWindow));
    infoW->type = LTRL_INFO;
    infoW->dirty = FALSE;
    infoW->body.literal = vnode->body;
    infoW->lines = SetLiteralInformation(infoW->text, infoW->body.literal);
    SetUpInfoWindow(pt, infoW);
    return;
  }
  lnk = PickLink(Gcontrol.links, pt);
  if (lnk != NULL) {
    infoW = (InfoWindow *) malloc(sizeof(InfoWindow));
    infoW->type = LINK_INFO;
    infoW->dirty = FALSE;
    infoW->body.link = lnk;
    infoW->lines = SetLinkInformation(infoW->text, infoW->body.link, 0);
    SetUpInfoWindow(pt, infoW);
    return;
  }
}


void SetUpInfoWindow(pt, infoW)
     XPoint pt;
     InfoWindow *infoW;
{
  XSizeHints hint;

  hint.x = pt.x + FntInfo.cw;
  hint.y = pt.y + FntInfo.ch;
  hint.width = INFO_WIDTH;
  hint.height = FntInfo.ch * (infoW->lines+1);
  hint.flags = PSize;

  infoW->wind = XCreateSimpleWindow(Global.disp, DefaultRootWindow(Global.disp),
				    hint.x, hint.y,
				    hint.width, hint.height,
				    2,
				    BlackPixel(Global.disp, 0),
				    WhitePixel(Global.disp, 0));
  switch (infoW->type) {
  case LTRL_INFO:
    XSetStandardProperties(Global.disp, infoW->wind,
			   LTRL_INFO_NAME, LTRL_INFO_NAME,
			   None, NULL, 0, &hint);
    break;
  case LINK_INFO:
    XSetStandardProperties(Global.disp, infoW->wind,
			   LINK_INFO_NAME, LINK_INFO_NAME,
			   None, NULL, 0, &hint);
  }
  XSelectInput(Global.disp, infoW->wind, ButtonPressMask|ExposureMask);

  infoW->font = XCreateGC(Global.disp, infoW->wind, 0, 0);
  XSetForeground(Global.disp, infoW->font, BlackPixel(Global.disp, 0));
  XSetFont(Global.disp, infoW->font, XLoadFont(Global.disp, DEFFONT));

  infoW->prev = NULL;
  infoW->next = GInfoWindowsList;
  if (infoW->next != NULL)
    infoW->next->prev = infoW;
  GInfoWindowsList = infoW;

  XMapWindow(Global.disp, infoW->wind);
}


void DisposeInfoWindow(infoW)
     InfoWindow *infoW;
{
  if (infoW == NULL)
    return;
  if (infoW->prev != NULL)
    infoW->prev->next = infoW->next;
  else
    GInfoWindowsList = infoW->next;
  if (infoW->next != NULL)
    infoW->next->prev = infoW->prev;
  XDestroyWindow(Global.disp, infoW->wind);
  free(infoW);
}


void ExposeInfoWindow(infoW)
     InfoWindow *infoW;
{
  int l, h;

  if (infoW->dirty) {
    switch (infoW->type) {
    case LTRL_INFO:
      infoW->lines = SetLiteralInformation(infoW->text, infoW->body.literal);
      break;
    case LINK_INFO:
      infoW->lines = SetLinkInformation(infoW->text, infoW->body.link, 0);
      XResizeWindow(Global.disp, infoW->wind,
		    INFO_WIDTH, FntInfo.ch * (infoW->lines+1));
      break;
    }
    infoW->dirty = FALSE;
  }
  for (l = 0, h = FntInfo.ch; l < infoW->lines; l++, h += FntInfo.ch)
    XDrawString(Global.disp, infoW->wind,
		infoW->font, FntInfo.cw, h,
		infoW->text[l], strlen(infoW->text[l]));
}


void CheckDirty()
{
  InfoWindow *iw;

  for (iw = GInfoWindowsList; iw != NULL; iw = iw->next) {
    iw->dirty = TRUE;
    XClearArea(Global.disp, iw->wind, 0, 0, 0, 0, TRUE);
  }
  GParamWindow.dirty = TRUE;
  XClearArea(Global.disp, GParamWindow.wind, 0, 0, 0, 0, TRUE);
}
