/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	draw2.c	---	Main draw routines part 2.
 *			(draw links and move a clause)
 *
 */

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#define	PROTO_DRAW2_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
#undef	PROTO_DRAW2_C

#pragma segment	visual


void DrawLink(link)
     linkrec *link;
{
  int i;
  double avrg;
  jointrec *j0, *j1;
  VNodeRec *top0, *top1;
  XPoint p0, p1;

  j0 = link->ptr[0]->joint;
  j1 = link->ptr[1]->joint;
  if (j0 == NULL || j1 == NULL)
    panic("dungling link!! (`DrawLines')", 0);
  top0 = j0->ltrl->vnode;
  top1 = j1->ltrl->vnode;
  if (top0 == NULL || top1 == NULL)
    return;
  top0 = top0->begin;
  top1 = top1->begin;
  if (top0 == NULL || top1 == NULL)
    return;
  avrg = 0.0;
  if (link->n > 0) {
    for (i = 0; i < link->n; i++)
      avrg += link->coeff[i].body.act;
    avrg /= link->n;
  }
  if (link->vnode == NULL) {
    link->vnode = NEW_VNodeRec();
    link->vnode->title[0] = '\0';
    link->vnode->body = NULL;
    link->vnode->begin = NULL;
    link->vnode->next = NULL;
    link->vnode->ctrl.nxt = NULL;
  }
  p0.x = top0->region.x + j0->ltrl->vnode->region.x + FntInfo.cw/2;
  p0.y = top0->region.y + j0->ltrl->vnode->region.y + FntInfo.ch/2;
  p1.x = top1->region.x + j1->ltrl->vnode->region.x + FntInfo.cw/2;
  p1.y = top1->region.y + j1->ltrl->vnode->region.y + FntInfo.ch/2;
  if (top0 == top1) {
    if (p0.y < p1.y)
      XDrawArc(Global.disp, Global.wind,
	       Global.color[(int)(avrg*(RESOLUTION-1)+0.5)],
	       p0.x-ARC_WIDTH, p0.y,
	       ARC_WIDTH*2, p1.y-p0.y, 90*64, 180*64);
    else
      XDrawArc(Global.disp, Global.wind,
	       Global.color[(int)(avrg*(RESOLUTION-1)+0.5)],
	       p0.x-ARC_WIDTH, p1.y,
	       ARC_WIDTH*2, p0.y-p1.y, 90*64, 180*64);
    link->vnode->region.x = p0.x - ARC_WIDTH - FntInfo.cw/2;
    link->vnode->region.y = (p0.y + p1.y)/2 - FntInfo.ch/2;
    link->vnode->region.width = FntInfo.cw;
    link->vnode->region.height = FntInfo.ch;
  } else {
    XDrawLine(Global.disp, Global.wind,
	      Global.color[(int)(avrg*(RESOLUTION-1)+0.5)],
	      p0.x, p0.y, p1.x, p1.y);
    link->vnode->region.x = (p0.x + p1.x)/2 - FntInfo.cw/2;
    link->vnode->region.y = (p0.y + p1.y)/2 - FntInfo.ch/2;
    link->vnode->region.width = FntInfo.cw;
    link->vnode->region.height = FntInfo.ch;
  }
  XFillArc(Global.disp, Global.wind, Global.txt,
	   link->vnode->region.x,
	   link->vnode->region.y,
	   FntInfo.cw, FntInfo.ch, 0, 360*64);
}


void ShowCandidate(clear)
     Boolean clear;
{
  jointrec *j0, *j1;
  VNodeRec *top0, *top1;

  if (Gcontrol.candidate.link == NULL)
    return;
  j0 = Gcontrol.candidate.link->ptr[1-Gcontrol.candidate.dir]->joint;
  j1 = Gcontrol.candidate.link->ptr[Gcontrol.candidate.dir]->joint;
  if (j0 == NULL || j1 == NULL)
    panic("dungling link!! (`ShowCandidate')", 0);
  top0 = j0->ltrl->vnode;
  top1 = j1->ltrl->vnode;
  if (top0 != NULL)
    top0 = top0->begin;
  if (top1 != NULL)
    top1 = top1->begin;
  if (Gcontrol.candidate.link->tag == INFERENCE) {
    if (top0 == NULL || top1 == NULL)
      return;
    ShowArrow(clear, top0, top1, j0, j1);
    DrawLink(Gcontrol.candidate.link);
  } else {
    if (top0 != NULL)
      MarkArgument(clear, top0, j0, TRUE);
    if (top1 != NULL)
      MarkArgument(clear, top1, j1, FALSE);
  }
}


#define	PtInRgn(pt, rgn)\
  ((rgn).x<(pt).x && (pt).x<(rgn).x+(rgn).width &&\
   (rgn).y<(pt).y && (pt).y<(rgn).y+(rgn).height)

#define	AddPt(delta, pt)\
{ (pt).x += (delta).x; (pt).y += (delta).y;	}

#define	OffsetRgn(rgn, dx, dy)\
{ (rgn).x += (dx); (rgn).y += (dy);		}


void DoContent(x, y)
     int x, y;
{
  XPoint pt;
  VNodeRec *cls;
  XEvent e;

  pt.x = x;
  pt.y = y;
  cls = PickClause(pt);
  if (cls != NULL)
    MoveClause(cls, pt);
  else
    while(TRUE) {
      XNextEvent(Global.disp, &e);
      if (e.type == ButtonRelease)
	break;
    }
}


VNodeRec *PickClause(pt)
     XPoint pt;
{
  VNodeRec *cls;

  for (cls = Global.clauses; cls != NULL; cls = cls->ctrl.nxt)
    if (cls->body == NULL &&
	cls->begin == NULL &&
	PtInRgn(pt, cls->region))
      return cls;
  return NULL;
}


VNodeRec *PickLiteral(pt)
     XPoint pt;
{
  XPoint relPt;
  VNodeRec *cls, *ltrl;

  cls = PickClause(pt);
  if (cls == NULL)
    return NULL;
  relPt.x = pt.x - cls->region.x;
  relPt.y = pt.y - cls->region.y;
  for (ltrl = cls->next; ltrl != NULL; ltrl = ltrl->next)
    if (ltrl->body != NULL &&
	PtInRgn(relPt, ltrl->region))
      return ltrl;
  return NULL;
}


linkrec *PickLink(links, pt)
     linkrec *links;
     XPoint pt;
{
  linkrec *l;

  for (l = links; l != NULL; l = l->ctrl.nxt)
    if (l->ptr[0]->joint->ltrl->tag != NUMBER &&
	l->ptr[0]->joint->ltrl->tag != SYMBOL &&
	l->ptr[1]->joint->ltrl->tag != NUMBER &&
	l->ptr[1]->joint->ltrl->tag != SYMBOL &&
	l->vnode != NULL &&
	PtInRgn(pt, l->vnode->region)) {
      return l;
    }
  return NULL;
}


void MoveClause(cls, pt)
     VNodeRec *cls;
     XPoint pt;
{
  XPoint delta;

  if (!DragGrayRgn(&delta, &cls->region, pt))
    return;
  /* erase clause and links */
  /* ... */
  AddPt(delta, cls->region);
  /* redraw clause and links */
  /* ... */
  XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
}


Boolean DragGrayRgn(delta, region, pt)
     XPoint *delta;
     XRectangle *region;
     XPoint pt;
{
  XEvent e;
  int x, y, width, height;
  int lmrgn, tmrgn;

  x = region->x;
  y = region->y;
  width = region->width;
  height = region->height;
  lmrgn = pt.x - region->x;
  tmrgn = pt.y - region->y;
  XDrawRectangle(Global.disp, Global.wind, Global.xor,
		 x, y, width, height);
  for (;;) {
    XNextEvent(Global.disp, &e);
    switch (e.type) {
    case ButtonRelease:
      XDrawRectangle(Global.disp, Global.wind, Global.xor,
		     x, y, width, height);
      delta->x = x - region->x;
      delta->y = y - region->y;
      return TRUE;
      break;
    case MotionNotify:
      XDrawRectangle(Global.disp, Global.wind, Global.xor,
		     x, y, width, height);
      x = e.xbutton.x - lmrgn;
      y = e.xbutton.y - tmrgn;
      XDrawRectangle(Global.disp, Global.wind, Global.xor,
		     x, y, width, height);
      break;
    }
  }
}
