/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	callback.c	---	Various callback routines for button.c.
 *
 */

#include	<stdio.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>

#define	PROTO_CALLBACK_C
#include	"../main/define.h"
#include	"../main/typedef.h"
#include	"../main/global.h"
#include	"visual.h"
#include	"proto.h"
/* some functions defined in ../main are used. */
#include	"../main/proto.h"
#undef	PROTO_CALLBACK_C

#pragma segment	visual


void cb_SpreadingActivation()
{
  CheckDirty();
  SpreadingActivation();
  if (Gparams.state == STOPPED)
    GButton[0].name = "## STATUS: -- STOPPED -- ##";
  else if (Gparams.state == UNCONVERGED)
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
  XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
  XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
}


void cb_Backpropagation()
{
  CheckDirty();
  Backpropagation();
  if (Gparams.state == STOPPED)
    GButton[0].name = "## STATUS: -- STOPPED -- ##";
  else if (Gparams.state == UNCONVERGED)
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
  XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
  XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
}


void cb_StepSubsumption()
{
  int dir, nocopy;
  probe *prb;
  linkrec *link;
  double priority1, priority2;

  CheckDirty();
  /* ----- Spreading Activations ----- */
  SpreadingActivation();
  if (Gparams.state == UNCONVERGED) {
    Gparams.state = UNCONVERGED;
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
    XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
    XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
    return;
  }
  /* ----- Choosing a Candidate of Subsumption ----- */
  Backpropagation();
  if (Gparams.state == UNCONVERGED) {
    Gparams.state = UNCONVERGED;
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
    XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
    XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
    return;
  }
  /* ----- Subsumption ----- */
  Gparams.copiedp = FALSE;
  Gparams.deletedp = FALSE;
  if (! check_special_literal())
    Subsumption();
  if (Gparams.state == ERROR)
    GButton[0].name = "## STATUS: -- ABORTED -- ##";
  else if (Gparams.state == FINISHED)
    GButton[0].name = "## STATUS: -- FINISHED --##";
  else {
    Gparams.state = STOPPED;
    GButton[0].name = "## STATUS: -- STOPPED -- ##";
  }
  /* ----- Spreading Activations ----- */
  SpreadingActivation();
  if (Gparams.state == UNCONVERGED) {
    Gparams.state = UNCONVERGED;
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
    XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
    XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
    return;
  }
  /* ----- Choosing a Candidate of Subsumption ----- */
  Backpropagation();
  if (Gparams.state == UNCONVERGED) {
    Gparams.state = UNCONVERGED;
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
    XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
    XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
    return;
  }
  XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
  XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
}


void cb_NextSubsumption()
{
  int dir, nocopy;
  probe *prb;
  linkrec *link;
  double priority1, priority2;

  CheckDirty();
  while (TRUE) {
    /* ----- Spreading Activations ----- */
    SpreadingActivation();
    if (Gparams.state == UNCONVERGED) {
      Gparams.state = UNCONVERGED;
      GButton[0].name = "## STATUS: NOT CONVERGED ##";
      XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
      XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
      return;
    }
    /* ----- Choosing a Candidate of Subsumption ----- */
    Backpropagation();
    if (Gparams.state == UNCONVERGED) {
      Gparams.state = UNCONVERGED;
      GButton[0].name = "## STATUS: NOT CONVERGED ##";
      XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
      XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
      return;
    }
    /* ----- Subsumption ----- */
    Gparams.deletedp = FALSE;
    Gparams.copiedp = FALSE;
    if (! check_special_literal())
      Subsumption();
    if (Gparams.state == ERROR) {
      GButton[0].name = "## STATUS: -- ABORTED -- ##";
      break;
    } else if (Gparams.state == FINISHED) {
      GButton[0].name = "## STATUS: -- FINISHED --##";
      break;
    } else if (Gparams.deletedp || Gparams.copiedp) {
      Gparams.state = STOPPED;
      GButton[0].name = "## STATUS: -- STOPPED -- ##";
      break;
    }
  }
  /* ----- Spreading Activations ----- */
  SpreadingActivation();
  if (Gparams.state == UNCONVERGED) {
    Gparams.state = UNCONVERGED;
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
    XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
    XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
    return;
  }
  /* ----- Choosing a Candidate of Subsumption ----- */
  Backpropagation();
  if (Gparams.state == UNCONVERGED) {
    Gparams.state = UNCONVERGED;
    GButton[0].name = "## STATUS: NOT CONVERGED ##";
    XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
    XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
    return;
  }
  XClearArea(Global.disp, GButton[0].wind, 0, 0, 0, 0, TRUE);
  XClearArea(Global.disp, Global.wind, 0, 0, 0, 0, TRUE);
}


void cb_ChangeParams()
{
  if (GParamWindow.mapped) {
    XUnmapWindow(Global.disp, GParamWindow.wind);
    GParamWindow.mapped = FALSE;
  } else {
    XMapWindow(Global.disp, GParamWindow.wind);
    GParamWindow.mapped = TRUE;
    GParamWindow.dirty = TRUE;
  }
}


void cb_Quit()
{
  XCloseDisplay(Global.disp);
  exit(0);
}


void cb_Nothing()
{
}
