/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	subsume.c	---	Main routine for subsumption.
 *
 */

#include	<stdio.h>

#define	PROTO_SUBSUME_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_SUBSUME_C

#pragma segment	subsume


void subsume(prb)
     probe *prb;
{
  probe *preceding;
  handlerec *hndl;
	
  detach_probe(prb);
  if (prb->orgns == NULL) {
    FREE_probe(prb);
    return;
  }
  if (prb->link->tag == EQUATION)
    preceding = intra_clause(prb);
  else
    preceding = inter_clause(prb);
  if (preceding != NULL) {
    hndl = get_link_handle(prb->link);
    subsume(preceding);
    if (hndl->body.link != NULL)
      subsume(prb);
  }
}


probe *intra_clause(prb)
     probe *prb;
{
  litrlrec *targetliteral, *outputliteral;
  jointrec *targetjoint, *frontjoints, *joint;
  dependrec *linkend, *depend;

  linkend = prb->link->ptr[prb->dir];
  targetjoint = linkend->joint;
  targetliteral = targetjoint->ltrl;
  if (Gparams.subsume) {
    printf("\n===== intra-clausal subsumption =====");
    printf("\n======== (between arguments) ========");
    printf("\n input literal  : ");
    print_literal(prb->link->ptr[1-prb->dir]->joint->ltrl);
    printf("\n target literal : ");
    print_literal(targetliteral);
    printf("\n origin         : ");
    print_literal(prb->orgns->handle->body.ltrl);
    putchar('\n');
  }
  frontjoints = targetliteral->joint;
  prb->nth = targetjoint->nth;
  prb->ftr = targetjoint->ftr;
  if (dominate(targetjoint) || frontjoints == NULL) {
    /* === Unfolding (not copying) ===	*/
    if (Gparams.subsume)
      printf(" unfolding (not-copying)...\n");
    outputliteral = targetliteral;
    if (Gparams.fixact)
      prb->link->coeff[0].body.act = 1.0;
    prb->link->sub = 1.0;
    check_subsumption_mark(outputliteral);
  } else
    panic("equation joint isn't unit? (`intra_clause')", 0);
  if (targetjoint->nth == LEFTHAND) {
    /****** Absorption ******/
    if (Gparams.subsume) {
      printf("\n Absorption\n");
      printf(" output literal= ");
      print_literal(outputliteral);
      putchar('\n');
    }
    absorb(outputliteral, prb->orgns,
	   prb->link->ptr[1-prb->dir]->joint->ltrl);
  } else if (frontjoints != NULL) {
    /****** Propagate probe ******/
    for (joint = frontjoints; joint != NULL; joint = joint->nxt)
      for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	propagate_probe(depend->link, depend->dir, prb);
  } else {
    if (Gparams.subsume)
      printf(" Need not process...\n");
  }
  if (Gparams.subsume)
    printf("=====================================\n\n");
  dispose_llist(prb->orgns);
  FREE_probe(prb);
  return NULL;
}


probe *inter_clause(prb)
     probe  *prb;
{
  litrlrec *inputliteral, *targetliteral, *outputliteral;
  jointrec *targetjoint, *newjoint, *foldeejoint;
  jointrec *frontjoints, *joint;
  dependrec *linkend, *depend;
  probe *preceding;

  inputliteral = prb->link->ptr[1-prb->dir]->joint->ltrl;
  linkend = prb->link->ptr[prb->dir];
  targetjoint = linkend->joint;
  targetliteral = targetjoint->ltrl;
  if (Gparams.subsume) {
    printf("\n===== inter-clausal subsumption =====");
    printf("\n======== (between arguments) ========");
    printf("\n input literal  : ");
    print_literal(prb->link->ptr[1-prb->dir]->joint->ltrl);
    printf("\n target literal : ");
    print_literal(targetliteral);
    printf("\n origin         : ");
    print_literal(prb->orgns->handle->body.ltrl);
    putchar('\n');
  }
  if (foldable(targetjoint, prb->orgns, &foldeejoint)) {
    /****** Folding ******/
    if (Gparams.subsume) {
      litrllst	*l;
      printf(" folding :\n");
      printf("   origins are ... ");
      for (l = prb->orgns; l != NULL; l = l->nxt) {
	putchar('\t');
	print_literal(l->handle->body.ltrl);
	putchar('\n');
      }
      printf("   foldee literal is ");
      if (foldeejoint == NULL)
	printf("NULL");
      else
	print_literal(foldeejoint->ltrl);
      putchar('\n');
    }
    if (foldeejoint != NULL) {
      disconnect_dependency(linkend);
      connect_dependency(foldeejoint, linkend);
      if (Gparams.fixact) {
	if (prb->nth == PSTENTRY)
	  prb->link->coeff[0].body.act = 1.0;
	else if (prb->nth == LEFTHAND)
	  prb->link->coeff[prb->link->n-1].body.act = 1.0;
	else
	  prb->link->coeff[prb->nth].body.act = 1.0;
      }
      prb->link->sub = 1.0;
    } else
      delete_link(prb->link);
  } else {
    /****** Unfolding ******/
    frontjoints = get_joint(targetliteral, prb->nth);
    if (dominate(targetjoint) || frontjoints == NULL) {
      /* =*=*= Unfolding (not copying) =*=*= */
      if (Gparams.subsume)
	printf(" unfolding (not-copying)...\n");
      outputliteral = targetliteral;
      if (Gparams.fixact) {
	if (prb->nth == PSTENTRY)
	  prb->link->coeff[0].body.act = 1.0;
	else if (prb->nth == LEFTHAND)
	  prb->link->coeff[prb->link->n-1].body.act = 1.0;
	else
	  prb->link->coeff[prb->nth].body.act = 1.0;
      }
      prb->link->sub = 1.0;
    } else {
      /* =*=*= Unfolding (copying) =*=*= */
      if (Gparams.subsume)
	printf(" unfolding (copying)...\n");
      preceding = check_preceding_probes_equation(targetliteral, NULL);
      if (preceding != NULL)
	return preceding;
      newjoint = copy_clause(targetliteral, targetjoint);
      outputliteral = newjoint->ltrl;
      disconnect_dependency(linkend);
      connect_dependency(newjoint, linkend);
      add_folder(targetjoint, prb->orgns, newjoint);
      if (Gparams.fixact) {
	if (prb->nth == PSTENTRY)
	  prb->link->coeff[0].body.act = 1.0;
	else if (prb->nth == LEFTHAND)
	  prb->link->coeff[prb->link->n-1].body.act = 1.0;
	else
	  prb->link->coeff[prb->nth].body.act = 1.0;
      }
      prb->link->sub = 1.0;
      frontjoints = get_joint(outputliteral, prb->nth);
    }
    if (frontjoints != NULL) {
      /****** Propagate probe ******/
      for (joint = frontjoints; joint != NULL; joint = joint->nxt)
	for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	  propagate_probe(depend->link, depend->dir, prb);
    } else {
      if (Gparams.subsume)
	printf(" Need not process...\n");
    }
    check_subsumption_mark(outputliteral);
  }
  if (Gparams.subsume)
    printf("=====================================\n\n");
  dispose_llist(prb->orgns);
  FREE_probe(prb);
  return NULL;
}


void inter_clausal_subsumption(link, dir)
     linkrec *link;
     int dir;
{
  litrlrec *inputliteral, *targetliteral, *outputliteral;
  jointrec *targetjoint, *newjoint;
  dependrec *linkend;
  int i;

  inputliteral = link->ptr[1-dir]->joint->ltrl;
  linkend = link->ptr[dir];
  targetjoint = linkend->joint;
  targetliteral = targetjoint->ltrl;
  if (Gparams.option == SPEECH_RECOG) {
    if (inputliteral->tag == FEATURE &&
	inputliteral->body.pst.name[0] == '!' &&
	targetliteral->misc == 0) {
      if (Gparams.subsume) {
	printf("\n===== inter-clausal subsumption =====");
	printf("\n========== (execute HMM) ============");
	printf("\n input literal  : ");
	print_literal(link->ptr[1-dir]->joint->ltrl);
	printf("\n target literal : ");
	print_literal(targetliteral);
	printf("\n nth=%d", targetjoint->nth);
	putchar('\n');
      }
      advance_phoneme(link->ptr[1-dir]);
      link->sub = 1.0;
      Gparams.copiedp = TRUE;
      if (Gparams.subsume)
	printf("=====================================\n\n");
      return;
    }
  }
  if (Gparams.subsume) {
    printf("\n===== inter-clausal subsumption =====");
    printf("\n======= (between constraint) ========");
    printf("\n input literal  : ");
    print_literal(link->ptr[1-dir]->joint->ltrl);
    printf("\n target literal : ");
    print_literal(targetliteral);
    printf("\n nth=%d", targetjoint->nth);
    putchar('\n');
  }
  /****** Unfolding ******/
  if (dominate(targetjoint)) {
    /* =*=*= Unfolding (not copying) =*=*= */
    if (Gparams.subsume)
      printf(" unfolding (not-copying)...\n");
    outputliteral = targetliteral;
    if (Gparams.fixact)
      for (i = 0; i < link->n; i++)
	link->coeff[i].body.act = 1.0;
    link->sub = 1.0;
  } else {
    /* =*=*= Unfolding (copying) =*=*= */
    if (Gparams.subsume)
      printf(" unfolding (copying)...\n");
    newjoint = copy_clause(targetliteral, targetjoint);
    outputliteral = newjoint->ltrl;
    disconnect_dependency(linkend);
    connect_dependency(newjoint, linkend);
    if (Gparams.fixact)
      for (i = 0; i < link->n; i++)
	link->coeff[i].body.act = 1.0;
    link->sub = 1.0;
  }
  check_subsumption_mark(outputliteral);
  if (Gparams.subsume)
    printf("=====================================\n\n");
}


Boolean foldable(folderjoint, orgns, foldeejoint)
     jointrec *folderjoint;
     litrllst *orgns;
     jointrec **foldeejoint;
{
  foldrec *fld;

  for (fld = folderjoint->folder; fld != NULL; fld = fld->nxt)
    if (comp_llist(fld->orgns, orgns) == 0) {
      *foldeejoint = fld->joint;
      return TRUE;
    }
  *foldeejoint = NULL;
  return FALSE;
}


void add_folder(folderjoint, orgns, foldeejoint)
     jointrec *folderjoint;
     litrllst *orgns;
     jointrec *foldeejoint;
{
  foldrec *newfolder, *newfoldee, *folder, *foldee, *f;

  if (orgns == NULL)
    return;
  for (folder = folderjoint->foldee; folder != NULL; folder = folder->nxt)
    for (f = folder->joint->folder; f != NULL; f = f->nxt)
      if (f->joint == folderjoint) {
	newfolder = NEW_foldrec();
	newfolder->joint = foldeejoint;
	newfolder->orgns =
	  merge_llist(copy_llist(f->orgns), copy_llist(orgns));
	push_folder(folder->joint, newfolder);
	newfoldee = NEW_foldrec();
	newfoldee->joint = folder->joint;
	newfoldee->orgns = copy_llist(newfolder->orgns);
	push_foldee(foldeejoint, newfoldee);
	break;
      }
  for (foldee = foldeejoint->folder; foldee != NULL; foldee = foldee->nxt)
    if (foldee->joint != NULL)
      for (f = foldee->joint->foldee; f != NULL; f = f->nxt)
	if (f->joint == folderjoint) {
	  newfolder = NEW_foldrec();
	  newfolder->joint = foldee->joint;
	  newfolder->orgns =
	    diff_llist(copy_llist(f->orgns), orgns);
	  push_folder(foldeejoint, newfolder);
	  newfoldee = NEW_foldrec();
	  newfoldee->joint = foldeejoint;
	  newfoldee->orgns = copy_llist(newfolder->orgns);
	  push_foldee(foldee->joint, newfoldee);
	  break;
	}
  newfolder = NEW_foldrec();
  newfolder->joint = foldeejoint;
  newfolder->orgns = copy_llist(orgns);
  push_folder(folderjoint, newfolder);
  newfoldee = NEW_foldrec();
  newfoldee->joint = folderjoint;
  newfoldee->orgns = copy_llist(orgns);
  push_foldee(foldeejoint, newfoldee);
}


void push_folder(joint, folder)
     jointrec *joint;
     foldrec *folder;
{
  folder->prv = NULL;
  folder->nxt = joint->folder;
  if (folder->nxt != NULL)
    folder->nxt->prv = folder;
  joint->folder = folder;
}


void push_foldee(joint, foldee)
     jointrec *joint;
     foldrec *foldee;
{
  foldee->prv = NULL;
  foldee->nxt = joint->foldee;
  if (foldee->nxt != NULL)
    foldee->nxt->prv = foldee;
  joint->foldee = foldee;
}


/* OBSOLUTE */
probe *check_preceding_probes_inference(literal)
     litrlrec *literal;
{
  dependrec *depend;
  probe *prb;

  if (literal->joint != NULL &&
      literal->joint->prv == NULL && literal->joint->nxt == NULL)
    for (depend = literal->joint->depend; depend != NULL; depend = depend->nxt) {
      prb = find_preceding_probe(depend->link, depend->dir, literal);
      if (prb != NULL)
	return prb;
    }
  return NULL;
}


probe *check_preceding_probes_equation(literal, linkend)
     litrlrec *literal;
     dependrec *linkend;
{
  int i;
  jointrec *joint;
  dependrec *depend;
  probe *prb;

  if (literal->tag != CONSTRAINT && literal->tag != FEATURE)
    for (joint = literal->lefth; joint != NULL; joint = joint->nxt)
      for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	if (depend != linkend) {
	  prb = find_preceding_probe(depend->link, depend->dir, literal);
	  if (prb != NULL)
	    return prb;
	}
  switch (literal->tag) {
  case SYMBOL:
  case NUMBER:
  case PSTERM:
    break;
  case FUNCTION:
  case CONSTRAINT:
    for (i = 0; i < literal->body.afm.arity; i++)
      for (joint = literal->body.afm.arg[i].body.val;
	   joint != NULL; joint = joint->nxt)
	for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	  if (depend != linkend) {
	    prb = find_preceding_probe(depend->link,
				       depend->dir, literal);
	    if (prb != NULL)
	      return prb;
	  }
    break;
  case FEATURE:
    for (joint = literal->body.pst.val; joint != NULL; joint = joint->nxt)
      for (depend = joint->depend; depend != NULL; depend = depend->nxt)
	if (depend != linkend) {
	  prb = find_preceding_probe(depend->link,
				     depend->dir, literal);
	  if (prb != NULL)
	    return prb;
	}
    break;
  default:
    panic("unknown type of literal (%d) (`check_preceding_probes_equation')",
	  literal->tag);
    break;
  }
  return NULL;
}


probe *find_preceding_probe(link, dir, literal)
     linkrec *link;
     int dir;
     litrlrec *literal;
{
  probe *p, *tmp;

  for (p = link->probe[dir]; p != NULL; p = tmp) {
    tmp = p->nxt;
    p->orgns = remove_llist(p->orgns, literal);
    if (p->orgns != NULL)
      return p;
    else {
      detach_probe(p);
      FREE_probe(p);
    }
  }
  return NULL;
}


void check_subsumption_mark(outputliteral)
     litrlrec *outputliteral;
{
  pphandle *ltrl;

  if (outputliteral == NULL || outputliteral->pphndl == NULL)
    return;
  for (ltrl = outputliteral->pphndl->begin;
       ltrl != NULL; ltrl = ltrl->next) {
    if (ltrl->body->tag == SYMBOL || ltrl->body->tag == NUMBER)
      continue;
    ltrl->body->sbsm = TRUE;
  }
}
