/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	probe.c	---	Probe management routines.
 *
 */

#include	<stdio.h>

#define	PROTO_PROBE_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_PROBE_C

#pragma segment	subsume


probe *detach_probe(prb)
     probe *prb;
{
  if (prb == NULL)
    return NULL;
  if (prb->prv != NULL)
    prb->prv->nxt = prb->nxt;
  else
    prb->link->probe[prb->dir] = prb->nxt;
  if (prb->nxt != NULL)
    prb->nxt->prv = prb->prv;
  if (prb->ctrl.prv != NULL)
    prb->ctrl.prv->ctrl.nxt = prb->ctrl.nxt;
  else
    Gcontrol.probes = prb->ctrl.nxt;
  if (prb->ctrl.nxt != NULL)
    prb->ctrl.nxt->ctrl.prv = prb->ctrl.prv;
  prb->prv = NULL;
  prb->nxt = NULL;
  prb->ctrl.prv = NULL;
  prb->ctrl.nxt = NULL;
  return prb;
}


probe *put_probe(link, orgns, dir, nth, ftr)
     linkrec *link;
     litrllst *orgns;
     int dir;
     int nth;
     char *ftr;
{
  probe *prb1, *prb2;
  litrllst *l1, *l2;

/*
  for (prb1 = link->probe[1-dir]; prb1 != NULL; prb1 = prb2) {
    prb2 = prb1->nxt;
    if (link->tag == EQUATION || coupled(prb1->nth, prb1->ftr, nth, ftr)) {
      if (comp_llist(orgns, prb1->orgns) == 0) {
      remove_common(&orgns, &prb1->orgns);
      if (prb1->orgns == NULL) {
	detach_probe(prb1);
	dispose_llist(prb1->orgns);
	FREE_probe(prb1);
      }
      if (orgns == NULL)
	return NULL;
    }
  }
*/
  for (prb1 = link->probe[dir]; prb1 != NULL; prb1 = prb1->nxt)
    if (link->tag == EQUATION || coupled(prb1->nth, prb1->ftr, nth, ftr))
      break;
  if (prb1 == NULL) {
    prb1 = NEW_probe();
    prb1->orgns = NULL;
    prb1->link = link;
    prb1->dir = dir;
    prb1->nth = nth;
    prb1->ftr = ftr;
    prb1->prv = NULL;
    prb1->nxt = link->probe[dir];
    if (prb1->nxt != NULL)
      prb1->nxt->prv = prb1;
    link->probe[dir] = prb1;
    prb1->ctrl.prv = NULL;
    prb1->ctrl.nxt = Gcontrol.probes;
    if (prb1->ctrl.nxt != NULL)
      prb1->ctrl.nxt->ctrl.prv = prb1;
    Gcontrol.probes = prb1;
  }
  prb1->orgns = merge_llist(prb1->orgns, orgns);
  return prb1;
}


void propagate_probe(link, dir, prb)
     linkrec *link;
     int dir;
     probe *prb;
{
  litrllst *orgns;
  jointrec *jnt;

  if (prb->orgns == NULL)
    return;
  if (link->tag == INFERENCE && prb->orgns == NULL)
    return;
  orgns = prb->orgns;
  if (link->tag == INFERENCE)
    put_probe(link, copy_llist(orgns), dir, prb->nth, prb->ftr);
  else {
    jnt = link->ptr[dir]->joint;
    put_probe(link, copy_llist(orgns), dir, jnt->nth, jnt->ftr);
  }
}


void reset_probe(orgnalliteral, copiedliteral)
     litrlrec *orgnalliteral;
     litrlrec *copiedliteral;
{
  jointrec *jnt0, *jnt1;
  dependrec *dpnd;
  litrllst *orgns;

  if (orgnalliteral->tag == CONSTRAINT ||
      orgnalliteral->tag == PSTERM)
    return;
  if (Gparams.option == SPEECH_RECOG) {
    if (orgnalliteral->tag == FEATURE &&
	orgnalliteral->body.pst.name[0] == '!')
      return;
  }
  if (orgnalliteral->handle != NULL) {
    orgnalliteral->handle->body.ltrl = NULL;
    orgnalliteral->handle = NULL;
  }
  if (orgnalliteral->tag == FEATURE) {
    for (jnt0 = orgnalliteral->body.pst.root->lefth;
	 jnt0 != NULL; jnt0 = jnt0->nxt)
      for (dpnd = jnt0->depend; dpnd != NULL; dpnd = dpnd->nxt) {
	jnt1 = dpnd->link->ptr[dpnd->dir]->joint;
	orgns = addto_llist(NULL, orgnalliteral);
	put_probe(dpnd->link, orgns, dpnd->dir, jnt1->nth, jnt1->ftr);
      }
    for (jnt0 = copiedliteral->body.pst.root->lefth;
	 jnt0 != NULL; jnt0 = jnt0->nxt)
      for (dpnd = jnt0->depend; dpnd != NULL; dpnd = dpnd->nxt) {
	jnt1 = dpnd->link->ptr[dpnd->dir]->joint;
	orgns = addto_llist(NULL, copiedliteral);
	put_probe(dpnd->link, orgns, dpnd->dir, jnt1->nth, jnt1->ftr);
      }
  } else {
    for (jnt0 = orgnalliteral->lefth; jnt0 != NULL; jnt0 = jnt0->nxt)
      for (dpnd = jnt0->depend; dpnd != NULL; dpnd = dpnd->nxt) {
	jnt1 = dpnd->link->ptr[dpnd->dir]->joint;
	orgns = addto_llist(NULL, orgnalliteral);
	put_probe(dpnd->link, orgns, dpnd->dir, jnt1->nth, jnt1->ftr);
      }
    for (jnt0 = copiedliteral->lefth; jnt0 != NULL; jnt0 = jnt0->nxt)
      for (dpnd = jnt0->depend; dpnd != NULL; dpnd = dpnd->nxt) {
	jnt1 = dpnd->link->ptr[dpnd->dir]->joint;
	orgns = addto_llist(NULL, copiedliteral);
	put_probe(dpnd->link, orgns, dpnd->dir, jnt1->nth, jnt1->ftr);
      }
  }
}


void gc_probe(prb)
     probe *prb;
{
  litrllst *ll1, *ll2;

  for (ll1 = prb->orgns; ll1 != NULL; ll1 = ll2) {
    ll2 = ll1->nxt;
    if (ll1->handle->body.ltrl == NULL) {
      if (ll1->prv != NULL)
	ll1->prv->nxt = ll1->nxt;
      else
	prb->orgns = ll1->nxt;
      if (ll1->nxt != NULL)
	ll1->nxt->prv = ll1->prv;
      FREE_litrllst(ll1);
    }
  }
}
