/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	loop.c		---	Routines for loop-detection.
 *
 */

#include	<stdio.h>

#define	PROTO_LOOP_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_LOOP_C

#pragma segment	spread


static int Counter;
static index *Stack;


void detect_loops()
{
  linkrec *link;
  litrlrec *literal;
  int nth;
  index *loop, *elem, *temp1, *temp2;

  /* Initialization */
  for (link = Gcontrol.links; link != NULL; link = link->ctrl.nxt)
    if (link->tag == EQUATION)
      link->coeff[0].body.mark = FALSE;
    else
      for (nth = 0; nth < link->n; nth++)
	link->coeff[nth].body.mark = FALSE;
  for (literal = Gcontrol.signed_preds;
       literal != NULL; literal = literal->ctrl.nxt) {
    literal->mark = 0; /* mark on the left-hand */
    if (literal->tag == CONSTRAINT || literal->tag == FUNCTION)
      for (nth = 0; nth < literal->body.afm.arity; nth++)
	literal->body.afm.arg[nth].body.mark = 0;
    else if (literal->tag == FEATURE)
      literal->body.pst.mark = 0;
  }
  for (literal = Gcontrol.unsigned_preds;
       literal != NULL; literal = literal->ctrl.nxt) {
    literal->mark = 0; /* mark on the left-hand */
    if (literal->tag == CONSTRAINT || literal->tag == FUNCTION)
      for (nth = 0; nth < literal->body.afm.arity; nth++)
	literal->body.afm.arg[nth].body.mark = 0;
    else if (literal->tag == FEATURE)
      literal->body.pst.mark = 0;
  }
  for (loop = Gcontrol.loops; loop != NULL; loop = temp1) {
    temp1 = loop->others;
    for (elem = loop; elem != NULL; elem = temp2) {
      temp2 = elem->next;
      FREE_index(elem);
    }
  }
  Gcontrol.loops = NULL;
  Stack = NULL;
  Counter = 1;
  /* Detection */
  for (literal = Gcontrol.signed_preds;
       literal != NULL; literal = literal->ctrl.nxt) {
    if (literal->tag == SYMBOL || literal->tag == NUMBER ||
	literal->tag == FUNCTION || literal->tag == PSTERM)
      if (literal->mark == 0)
	visit(literal, LEFTHAND, FALSE);
    if (literal->tag == CONSTRAINT || literal->tag == FUNCTION)
      for (nth = 0; nth < literal->body.afm.arity; nth++)
	if (literal->body.afm.arg[nth].body.mark == 0)
	  visit(literal, nth, FALSE);
    else if (literal->tag == FEATURE)
      if (literal->body.pst.mark == 0)
	visit(literal, PSTENTRY, FALSE);
  }
  for (literal = Gcontrol.unsigned_preds;
       literal != NULL; literal = literal->ctrl.nxt) {
    if (literal->tag == SYMBOL || literal->tag == NUMBER ||
	literal->tag == FUNCTION || literal->tag == PSTERM)
      if (literal->mark == 0)
	visit(literal, LEFTHAND, FALSE);
    if (literal->tag == CONSTRAINT || literal->tag == FUNCTION)
      for (nth = 0; nth < literal->body.afm.arity; nth++)
	if (literal->body.afm.arg[nth].body.mark == 0)
	  visit(literal, nth, FALSE);
    else if (literal->tag == FEATURE)
      if (literal->body.pst.mark == 0)
	visit(literal, PSTENTRY, FALSE);
  }
}


void visit(literal, nth, infp)
     litrlrec *literal;
     int nth;
     Boolean infp;
{
  jointrec *jnt;

  push(literal, nth);
  switch (nth) {
  case LEFTHAND:
    literal->mark = Counter++;
    all_visit(literal->lefth, LEFTHAND, literal->mark, FALSE);
    all_visit(literal->joint, LEFTHAND, literal->mark, TRUE);
    break;
  case PSTENTRY:
    literal->body.pst.mark = Counter++;
    all_visit(literal->body.pst.val, PSTENTRY, literal->body.pst.mark, FALSE);
    all_visit(literal->joint, PSTENTRY, literal->body.pst.mark, TRUE);
    break;
  default:
    literal->body.afm.arg[nth].body.mark = Counter++;
    all_visit(literal->body.afm.arg[nth].body.val, nth,
	      literal->body.afm.arg[nth].body.mark, FALSE);
    all_visit(literal->joint, nth,
	      literal->body.afm.arg[nth].body.mark, TRUE);
    break;
  }
  pop();
}


void all_visit(joint, nth, mark, infp)
     jointrec *joint;
     int nth;
     int mark;
     Boolean infp;
{
  litrlrec *ltrl;
  jointrec *jnt;
  dependrec *dpnd;
  linkrec *lnk;
  int n;

  for (jnt = joint; jnt != NULL; jnt = jnt->nxt)
    for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt) {
      lnk = dpnd->link;
      ltrl = lnk->ptr[dpnd->dir]->joint->ltrl;
      if (lnk->tag == EQUATION)
	n = lnk->ptr[dpnd->dir]->joint->nth;
      else
	n = nth;
      /* add information of link to the top of the stack */
      Stack->link = lnk;
      if (ancestorp(ltrl, n, 1)) {
	/* node (ltrl,n) has not been visited. */
	if (lnk->tag == EQUATION)
	  lnk->coeff[0].body.mark = TRUE;
	else if (n == LEFTHAND || n == PSTENTRY)
	  lnk->coeff[lnk->n-1].body.mark = TRUE;
	else
	  lnk->coeff[n].body.mark = TRUE;
	visit(ltrl, n, infp);
      } else if (ancestorp(ltrl, n, mark) &&
		 ((lnk->tag == EQUATION && ! lnk->coeff[0].body.mark) ||
		  (lnk->tag == INFERENCE &&
		   ! ((n == LEFTHAND || n == PSTENTRY) ?
		      lnk->coeff[lnk->n-1].body.mark : lnk->coeff[n].body.mark))))
	record_loop(ltrl, n);
    }
}


Boolean ancestorp(literal, nth, mark)
     litrlrec *literal;
     int nth;
     int mark;
{
  switch (nth) {
  case LEFTHAND:
    return (literal->mark < mark);
    break;
  case PSTENTRY:
    return (literal->body.pst.mark < mark);
    break;
  default:
    return (literal->body.afm.arg[nth].body.mark < mark);
    break;
  }
}


void push(literal, nth)
     litrlrec *literal;
     int nth;
{
  index *newelem;

  newelem = NEW_index();
  newelem->nth = nth;
  newelem->node = literal;
  newelem->link = NULL;
  newelem->next = Stack;
  newelem->others = NULL;
  Stack = newelem;
}


void pop()
{
  index *top;

  top = Stack;
  Stack = Stack->next;
  FREE_index(top);
}


void record_loop(literal, nth)
     litrlrec *literal;
     int nth;
{
  index *elem, *newindex, *loop;

  loop = NULL;
  for (elem = Stack;
       !(elem->node == literal && elem->nth == nth);
       elem = elem->next) {
    newindex = NEW_index();
    newindex->nth = elem->nth;
    newindex->node = elem->node;
    newindex->link = elem->link;
    newindex->next = loop;
    newindex->others = NULL;
    loop = newindex;
  }
  newindex = NEW_index();
  newindex->nth = elem->nth;
  newindex->node = elem->node;
  newindex->link = elem->link;
  newindex->next = loop;
  newindex->others = NULL;
  loop = newindex;
  loop->others = Gcontrol.loops;
  Gcontrol.loops = loop;
}
