/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	literallist.c	---	Functions managing literal-list used in probe.c.
 *
 */

#include	<stdio.h>

#define	PROTO_NLIST_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_NLIST_C

#pragma segment	subsume


int comp_llist(llist1, llist2)
     litrllst *llist1;
     litrllst *llist2;
{
  for (; llist1 != NULL && llist2 != NULL;
       llist1 = llist1->nxt, llist2 = llist2->nxt)
    if (llist1->handle != llist2->handle)
      return (llist1->handle > llist2->handle ? 1 : -1);
  if (llist1 == NULL && llist2 == NULL)
    return 0;
  else
    return (llist1 == NULL ? -1 : 1);
}


litrllst *addto_llist(llist, literal)
     litrllst *llist;
     litrlrec *literal;
{
  litrllst *newlist, *l;
  handlerec *handle;

  if (literal == NULL)
    return llist;
  handle = get_literal_handle(literal);
  newlist = NEW_litrllst();
  newlist->handle = handle;
  if (llist == NULL) {
    newlist->prv = NULL;
    newlist->nxt = NULL;
    return newlist;
  }
  for (l = llist; l != NULL; l = l->nxt)
    if (handle < l->handle) {
      newlist->prv = l->prv;
      newlist->nxt = l;
      if (newlist->prv != NULL)
	newlist->prv->nxt = newlist;
      else
	llist = newlist;
      newlist->nxt->prv = newlist;
      return llist;
    } else if (handle == l->handle) {
      FREE_litrllst(newlist);
      return llist;
    } else if (l->nxt == NULL)
      break;
  l->nxt = newlist;
  newlist->prv = l;
  newlist->nxt = NULL;
  return llist;
}


litrllst *remove_llist(llist, literal)
     litrllst *llist;
     litrlrec *literal;
{
  litrllst *ll;

  if (literal == NULL || literal->handle == NULL)
    return llist;
  for (ll = llist; ll != NULL; ll = ll->nxt)
    if (ll->handle == literal->handle) {
      if (ll->prv != NULL)
	ll->prv->nxt = ll->nxt;
      else
	llist = ll->nxt;
      if (ll->nxt != NULL)
	ll->nxt->prv = ll->prv;
      FREE_litrllst(ll);
      break;
    }
  return llist;
}


litrllst *merge_llist(llist1, llist2)
     litrllst *llist1;
     litrllst *llist2;
{
  litrllst *tmp;

  if (llist1 == NULL)
    return llist2;
  if (llist2 == NULL)
    return llist1;
  if (llist1->handle < llist2->handle) {
    tmp = merge_llist(llist1->nxt, llist2);
    llist1->nxt = tmp;
    llist1->nxt->prv = llist1;
    return llist1;
  } else if (llist1->handle > llist2->handle) {
    tmp = merge_llist(llist1, llist2->nxt);
    llist2->nxt = tmp;
    llist2->nxt->prv = llist2;
    return llist2;
  } else
    return merge_llist(llist1, llist2->nxt);
}


litrllst *diff_llist(llist1, llist2)
     litrllst *llist1;
     litrllst *llist2;
{
  litrllst *tmp;

  if (llist1 == NULL)
    return NULL;
  if (llist2 == NULL)
    return llist1;
  if (llist1->handle < llist2->handle) {
    tmp = diff_llist(llist1->nxt, llist2);
    llist1->nxt = tmp;
    if (llist1->nxt != NULL)
      llist1->nxt->prv = llist1;
    return llist1;
  } else if (llist1->handle > llist2->handle)
    return diff_llist(llist1, llist2->nxt);
  else {
    tmp = llist1->nxt;
    if (llist1->prv != NULL)
      llist1->prv->nxt = llist1->nxt;
    if (llist1->nxt != NULL)
      llist1->nxt->prv = llist1->prv;
    FREE_litrllst(llist1);
    return diff_llist(tmp, llist2->nxt);
  }
}


litrllst *copy_llist(llist)
     litrllst *llist;
{
  litrllst *ctop, *newlist, *clist, *cprev;

  if (llist == NULL)
    return NULL;
  ctop = NEW_litrllst();
  ctop->handle = llist->handle;
  ctop->prv = ctop->nxt = NULL;
  for (cprev = ctop, clist = llist->nxt;
       clist != NULL;
       clist = clist->nxt, cprev = newlist) {
    newlist = NEW_litrllst();
    newlist->handle = clist->handle;
    newlist->prv = cprev;
    newlist->prv->nxt = newlist;
    newlist->nxt = NULL;
  }
  return ctop;
}


void dispose_llist(llist)
     litrllst *llist;
{
  litrllst *tmp;

  for (; llist != NULL; llist = tmp) {
    tmp = llist->nxt;
    FREE_litrllst(llist);
  }
}


int intersect(literals1, literals2)
     litrllst *literals1;
     litrllst *literals2;
{
  if (literals1 == NULL || literals2 == NULL)
    return FALSE;
  if (literals1->handle < literals2->handle)
    return intersect(literals1->nxt, literals2);
  else if (literals1->handle > literals2->handle)
    return intersect(literals1, literals2->nxt);
  else
    return TRUE;
}


void remove_common(literals1, literals2)
     litrllst **literals1;
     litrllst **literals2;
{
  litrllst *tmp1, *tmp2;

  if (*literals1 == NULL || *literals2 == NULL)
    return;
  if ((*literals1)->handle < (*literals2)->handle)
    remove_common(&(*literals1)->nxt, literals2);
  else if ((*literals1)->handle > (*literals2)->handle)
    remove_common(literals1, &(*literals2)->nxt);
  else {
    tmp1 = *literals1;
    tmp2 = *literals2;
    if (tmp1->prv != NULL)
      tmp1->prv->nxt = tmp1->nxt;
    if (tmp1->nxt != NULL)
      tmp1->nxt->prv = tmp1->prv;
    if (tmp2->prv != NULL) 
      tmp2->prv->nxt = tmp2->nxt;
    if (tmp2->nxt != NULL)
      tmp2->nxt->prv = tmp2->prv;
    *literals1 = tmp1->nxt;
    *literals2 = tmp2->nxt;
    FREE_litrllst(tmp1);
    FREE_litrllst(tmp2);
    remove_common(literals1, literals2);
  }
}


handlerec *get_literal_handle(literal)
     litrlrec *literal;
{
  handlerec *handle;

  if (literal->handle == NULL)
    handle = new_literal_handle(literal);
  else
    handle = literal->handle;
  return handle;
}


handlerec *new_literal_handle(literal)
     litrlrec *literal;
{
  handlerec *handle;

  handle = NEW_handlerec();
  handle->mark = 0;
  handle->body.ltrl = literal;
  literal->handle = handle;
  return handle;
}


handlerec *get_link_handle(link)
     linkrec *link;
{
  handlerec *handle;

  if (link->handle == NULL)
    handle = new_link_handle(link);
  else
    handle = link->handle;
  return handle;
}


handlerec *new_link_handle(link)
     linkrec *link;
{
  handlerec *handle;

  handle = NEW_handlerec();
  handle->mark = 0;
  handle->body.link = link;
  link->handle = handle;
  return handle;
}
