/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	link.c	---	Dependency link management routines.
 *
 */

#include	<stdio.h>

#define	PROTO_LINK_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_LINK_C


#pragma segment	subsume


jointrec *get_joint(literal, nth)
     litrlrec *literal;
     int nth;
{
  if (literal == NULL)
    panic("literal == NULL (`get_joint')", 0);
  switch (nth) {
  case UNKNOWN:
    panic("nth == UNKNOWN ('get_joint')", 0);
    break;
  case INFERENCE:
    return literal->joint;
    break;
  case LEFTHAND:
    return literal->lefth;
    break;
  case PSTENTRY:
    return literal->body.pst.val;
    break;
  default:			/* one of the arguments of a function */
    if (literal->body.afm.arg == NULL)
      return NULL;
    else
      return literal->body.afm.arg[nth].body.val;
    break;
  }
  return NULL;
}


void connect_joint(literal, joint)
     litrlrec *literal;
     jointrec *joint;
{
  if (literal == NULL)
    panic("literal == NULL (`connect_joint')", 0);
  joint->ltrl = literal;
  switch (joint->nth) {
  case UNKNOWN:
    panic("nth == UNKNOWN (`connect_joint')", 0);
    break;
  case INFERENCE:
    push_joint(&literal->joint, joint);
    break;
  case LEFTHAND:
    push_joint(&literal->lefth, joint);
    break;
  case PSTENTRY:
    push_joint(&literal->body.pst.val, joint);
    break;
  default:			/* one of the arguments of a function */
    if (literal->body.afm.arg != NULL)
      push_joint(&literal->body.afm.arg[joint->nth].body.val, joint);
    else
      panic("try to connect zero-ary literal (`connect_joint')", 0);
    break;
  }
}


void push_joint(lst, joint)
     jointrec **lst;
     jointrec *joint;
{
  joint->prv = NULL;
  joint->nxt = *lst;
  if (joint->nxt != NULL)
    joint->nxt->prv = joint;
  *lst = joint;
}


jointrec *new_joint(literal, total, nth, ftr)
     litrlrec *literal;
     Boolean total;
     int nth;
     char *ftr;
{
  jointrec *newjoint;

  newjoint = NEW_jointrec();
  newjoint->total = total;
  newjoint->nth = nth;
  newjoint->ftr = ftr;
  newjoint->ltrl = literal;
  newjoint->depend = NULL;
  newjoint->folder = NULL;
  newjoint->foldee = NULL;
  newjoint->aux = NULL;
  switch (nth) {
  case INFERENCE:
    push_joint(&literal->joint, newjoint);
    break;
  case LEFTHAND:
    push_joint(&literal->lefth, newjoint);
    break;
  case PSTENTRY:
    push_joint(&literal->body.pst.val, newjoint);
    break;
  default:
    if (literal->body.afm.arg == NULL)
      panic("Panic in `new_joint'! (no argument)\n", 0);
    push_joint(&literal->body.afm.arg[nth].body.val, newjoint);
    break;
  }
  return newjoint;
}


void connect_dependency(joint, depend)
     jointrec *joint;
     dependrec *depend;
{
  depend->joint = joint;
  depend->prv = NULL;
  depend->nxt = joint->depend;
  if (depend->nxt != NULL)
    depend->nxt->prv = depend;
  joint->depend = depend;
}


dependrec *new_dependency(joint)
     jointrec *joint;
{
  dependrec *newdepend;

  newdepend = NEW_dependrec();
  newdepend->joint = joint;
  newdepend->dir = UNKNOWN;
  newdepend->link = NULL;
  newdepend->prv = NULL;
  newdepend->nxt = joint->depend;
  if (newdepend->nxt != NULL)
    newdepend->nxt->prv = newdepend;
  joint->depend = newdepend;
  return newdepend;
}


linkrec *new_link(tag, n, explct, depnd0, depnd1)
     int tag;
     int n;
     Boolean explct;
     dependrec *depnd0;
     dependrec *depnd1;
{
  int i;
  linkrec *newlink;

  newlink = NEW_linkrec();
  newlink->tag = tag;
  if (tag == EQUATION) {
    newlink->sub = EQUAL_SUBS_DEFAULT;
    newlink->n = 1;
    newlink->coeff = NEW_linkact(1);
    newlink->coeff[0].body.act = EQUAL_INIT;
    newlink->coeff[0].body.z = 0.0;
  } else {
    newlink->sub = 0.5;
    newlink->n = n;
    newlink->coeff = NEW_linkact(n);
    for (i = 0; i < n; i++) {
      newlink->coeff[i].body.act = LINK_INIT;
      newlink->coeff[i].body.z = 0.0;
    }
  }
  newlink->mark = FALSE;
  newlink->explct = explct;
  newlink->confuse = 1.0;
  newlink->probe[0] = NULL;
  newlink->probe[1] = NULL;
  newlink->press[0] = NULL;
  newlink->press[1] = NULL;
  newlink->handle = NULL;
  newlink->ctrl.prv = NULL;
  newlink->ctrl.nxt = Gcontrol.links;
  if (newlink->ctrl.nxt != NULL)
    newlink->ctrl.nxt->ctrl.prv = newlink;
  Gcontrol.links = newlink;
  newlink->vnode = NULL;
  depnd0->link = newlink;
  depnd1->link = newlink;
  depnd0->dir = 0;
  newlink->ptr[0] = depnd1;
  depnd1->dir = 1;
  newlink->ptr[1] = depnd0;
  return newlink;
}


linkrec *connect_literals(p, q, n, sub)
     litrlrec *p;
     litrlrec *q;
     int n;
     double sub;
{
  jointrec *j0, *j1;
  dependrec *i0, *i1;
  linkrec *newlink;

  j0 = new_inference_joint(p, FALSE);
  j1 = new_inference_joint(q, FALSE);
  i0 = new_dependency(j0);
  i1 = new_dependency(j1);
  newlink = new_inference_link(i0, i1, n);
  newlink->sub = sub;
  return newlink;
}
