/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	formula.c	---	Formula handling routines.
 *
 */

#include	<stdio.h>

#define	PROTO_FORMULA_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_FORMULA_C

#pragma segment	parser


pphandle *make_formula(name, args)
     char *name;
     arglst *args;
{
  int i, n;
  arglst *p;
  litrlrec *newaform;

  MAKE_FORMULA;
  newaform = NEW_litrlrec();
  for (n = 0, p = args; p != NULL; p = p->nxt, n++) {
    p->var->nth = n;
    p->var->paren = newaform;
  }
  if (strcmp(name, "true") == 0)
    Gbuffer.top = TRUE;
  newaform->tag = FUNCTION;
  newaform->pol = 0;
  newaform->rel = REL_DEFAULT;
  newaform->coeff.nOmega = 0.0;
  newaform->coeff.omegaN = 1.0;
  newaform->coeff.disj = DISJ_DEFAULT;
  newaform->coeff.excl = EXCL_DEFAULT;
  newaform->coeff.cmpl = CMPL_DEFAULT;
  newaform->coeff.assm = ASSM_DEFAULT;
  newaform->dfrc = 0.0;
  newaform->path = NULL;
  newaform->press = NULL;
  newaform->act = LITERAL_INIT;
  newaform->z = 0.0;
  newaform->imp = 0.0;
  newaform->body.afm.arity = n;
  newaform->body.afm.name = name;
  newaform->body.afm.arg = NEW_argument(n);
  for (i = 0, p = args; i < n; i++, p = p->nxt) {
    newaform->body.afm.arg[i].body.val = NULL;
    newaform->body.afm.arg[i].body.print.embedded = FALSE;
    newaform->body.afm.arg[i].body.print.varname = p->var->name;
  }
  newaform->lefth = NULL;
  newaform->print.varname = "";
  newaform->joint = NULL;
  newaform->handle = NULL;
  newaform->pphndl = NEW_pphandle();
  newaform->pphndl->body = newaform;
  newaform->pphndl->aux = NULL;
  newaform->pphndl->vnode = NULL;
  newaform->pphndl->next = NULL;
  newaform->lid = Gcontrol.lid++;
  newaform->mark = TRUE;
  newaform->sbsm = FALSE;
  newaform->misc = 0;
  newaform->vnode = NULL;
  return newaform->pphndl;
}


arglst *chain_args(arg, list)
     varblrec *arg;
     arglst *list;
{
  char *tmpname;
  varblrec *tmpvar;
  arglst *newarg;

  CHAIN_ARGS;
  newarg = NEW_arglst();
  if (arg->nth == UNKNOWN)
    newarg->var = arg;
  else {
    tmpname = new_name('X');
    tmpvar = var_node(tmpname);
    tmpvar->nth = UNKNOWN;
    tmpvar->ftr = "";
    make_binding(tmpname, arg, FALSE);
    tmpvar->name = arg->name;
    newarg->var = tmpvar;
  }
  newarg->nxt = list;
  return newarg;
}


pphandle *check_literal(ltrllist, ltrl, costed)
     pphandle *ltrllist;
     pphandle *ltrl;
     Boolean costed;
{
  pphandle *l0, *l1;

  CHECK_LITERAL;
  /* chain literal (ltrl) to literal list (ltrllist) */
  if (ltrl != NULL) {
    /* Check if ltrl is costed */
    if (costed) {
      for (l0 = Gbuffer.literals; l0 != NULL; l0 = l0->next)
	if (l0->body->tag != SYMBOL && l0->body->tag != NUMBER &&
	    l0->body->tag != PSTERM) {
	  if (l0->body->pol == POSITIVE)
	    l0->body->pol = COST_POSITIVE;
	  else if (l0->body->pol == NEGATIVE)
	    l0->body->pol = COST_NEGATIVE;
	}
      if (ltrl->body->tag != SYMBOL && ltrl->body->tag != NUMBER &&
	  ltrl->body->tag != PSTERM) {
	if (ltrl->body->pol == POSITIVE)
	  ltrl->body->pol = COST_POSITIVE;
	else if (ltrl->body->pol == NEGATIVE)
	  ltrl->body->pol = COST_NEGATIVE;
      } else
	yyerror("Binding to a constant cannot be costed.");
    }
    /* Check if ltrl is already registered in global buffer */
    for (l0 = Gbuffer.literals; l0 != NULL; l0 = l0->next)
      if (l0 == ltrl) {
	ltrl = ltrllist;
	break;
      }
    if (l0 == NULL)
      ltrl->next = ltrllist;
  } else
    ltrl = ltrllist;
  /* move bindings from global buffer (Gbuffer.literals)
     to literal list (ltrllist) */
  if (Gbuffer.literals == NULL)
    return ltrl;
  else {
    for (l0 = Gbuffer.literals; l0->next != NULL; l0 = l0->next)
      ;
    l0->next = ltrl;
    l1 = Gbuffer.literals;
    Gbuffer.literals = NULL;
    return l1;
  }
}


pphandle *set_rel_coeff(ltrl, sign, relcoeff)
     pphandle *ltrl;
     int sign;
     double relcoeff;
{
  litrlrec *ftr;

  if (ltrl == NULL || ltrl->body == NULL)
    return NULL;
  if (relcoeff < 0.0 || 1.0 < relcoeff) {
    printf("warning: relevance coeff. range over (1.0 is used)\n");
    relcoeff = 1.0;
  }
  if (ltrl->body->tag == PSTERM)
    for (ftr = ltrl->body->body.pst.nxt;
	 ftr != NULL; ftr = ftr->body.pst.nxt) {
      ftr->pol = sign;
      ftr->rel = relcoeff;
    }
  else {
    ltrl->body->pol = sign;
    ltrl->body->rel = relcoeff;
  }
  return ltrl;
}
