/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	feature.c	---	Feature handling routines.
 *
 */

#include	<stdio.h>

#define	PROTO_FEATURE_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_FEATURE_C

#pragma segment	parser


pphandle *add_feature(pstvar, ftr, val)
     char *pstvar;
     char *ftr;
     varblrec *val;
{
  litrlrec *newftr, *root;
  varblrec *pstent;
  char *tmpname;

  ADD_FEATURE;
  newftr = NEW_litrlrec();
  newftr->tag = FEATURE;
  newftr->pol = NEGATIVE;
  newftr->rel = REL_DEFAULT;
  newftr->coeff.nOmega = 0.0;
  newftr->coeff.omegaN = 1.0;
  newftr->coeff.disj = DISJ_DEFAULT;
  newftr->coeff.excl = EXCL_DEFAULT;
  newftr->coeff.cmpl = CMPL_DEFAULT;
  newftr->coeff.assm = ASSM_DEFAULT;
  newftr->dfrc = 0.0;
  newftr->path = NULL;
  newftr->press = NULL;
  newftr->act = LITERAL_INIT;
  newftr->z = 0.0;
  newftr->imp = 0.0;
  newftr->body.pst.name = ftr;
  newftr->body.pst.val = NULL;
  newftr->body.pst.prv = NULL;
  newftr->body.pst.nxt = NULL;
  newftr->lefth = NULL;
  newftr->print.varname = pstvar;
  newftr->joint = NULL;
  newftr->handle = NULL;
  newftr->pphndl = NEW_pphandle();
  newftr->pphndl->body = newftr;
  newftr->pphndl->aux = NULL;
  newftr->pphndl->vnode = NULL;
  newftr->pphndl->next = NULL;
  if (pstvar[0] == '\0')
    newftr->body.pst.root = NULL;
  else {
    root = get_psterm(pstvar);
    newftr->body.pst.root = root;
    root->body.pst.nxt = chain_feature(root->body.pst.nxt, newftr);
    root->print.varname = pstvar;
  }
  newftr->lid = Gcontrol.lid++;
  newftr->mark = TRUE;
  newftr->sbsm = FALSE;
  newftr->misc = 0;
  newftr->vnode = NULL;
  if (val->nth == UNKNOWN && val->paren == NULL) {
    val->nth = PSTENTRY;
    val->ftr = ftr;
    val->paren = newftr;
    newftr->body.pst.print.embedded = FALSE;
    newftr->body.pst.print.varname = val->name;
  } else {
    tmpname = new_name('X');
    pstent = var_node(tmpname);
    pstent->nth = PSTENTRY;
    pstent->ftr = ftr;
    pstent->paren = newftr;
    make_binding(tmpname, val, FALSE);
    pstent->name = val->name;
    newftr->body.pst.print.embedded = FALSE;
    newftr->body.pst.print.varname = val->name;
  }
  return newftr->pphndl;
}


litrlrec *chain_feature(ftrlist, new)
     litrlrec *ftrlist;
     litrlrec *new;
{
  if (new == NULL)
    return ftrlist;
  new->body.pst.prv = NULL;
  new->body.pst.nxt = ftrlist;
  if (new->body.pst.nxt != NULL)
    new->body.pst.nxt->body.pst.prv = new;
  return new;
}


litrlrec *get_psterm(varname)
     char *varname;
{
  varblrec *varbl, *body;
  bndngrec *bind;

  for (varbl = Gbuffer.variables; varbl != NULL; varbl = varbl->nxt)
    if (strcmp(varbl->name, varname) == 0)
      for (bind = varbl->brecs; bind != NULL; bind = bind->nxt) {
	body = bind->link->ptr[bind->dir]->var;
	if (body->paren->tag == PSTERM)
	  return body->paren;
      }
  varbl = pst_node(NULL);
  make_binding(varname, varbl, TRUE);
  return varbl->paren;
}
