/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	debug.h	---	Header file for debugging-macros.
 *				(see also config.h)
 *
 */


#ifdef CLAUSEDEBUG
/****** Macros from clause.c ******/
#define	MAKE_CLAUSE1                                  \
{                                                     \
   varblrec	*p;                                   \
   printf("\n=== make_clause() ===\n");               \
   printf("status of variable table\n");              \
   for (p = Gbuffer.variables; p != NULL; p = p->nxt) \
   if (p->name == NULL)                               \
     printf("?!?!");                                  \
   else                                               \
     show_var(p);                                     \
   printf("\nstatus of constant table\n");            \
   for (p = Gbuffer.constants; p != NULL; p = p->nxt) \
   if (p->paren != NULL)                              \
     show_literal(p->paren);                          \
   else                                               \
     printf("?!?!\t(nth=%d)\n", p->nth);              \
   printf("\nchecking bindings ...\n");               \
}
/****** Macros from clause.c ******/
#define	MAKE_CLAUSE2        \
{                           \
   printf("#Left Hand# ="); \
   show_var(p->var);        \
   BREAKP;                  \
}
/****** Macros from clause.c ******/
#define	MAKE_CLAUSE3\
{                            \
   printf("#Right Hand# ="); \
   show_var(q->var);         \
   BREAKP;                   \
}
/****** Macros from clause.c ******/
#define	CHECK_LITERAL                               \
{                                                   \
   printf("\ncheck_literal received...\n");         \
   printf("\tltrl (%s)= ",                          \
	  (costed ? "costed" : "non-costed"));      \
   if (ltrl != NULL)                                \
     show_literal(ltrl->body);                      \
   else                                             \
     printf("NULL\n");                              \
   printf("\tltrllist = ");                         \
   for (l0 = ltrllist; l0 != NULL; l0 = l0->next) { \
     show_literal(l0->body);                        \
     printf("\t\t");                                \
   }                                                \
   printf("\n\tGbuffer.literals =");                \
   for (l0 = Gbuffer.literals; l0 != NULL;          \
                               l0 = l0->next) {     \
     show_literal(l0->body);                        \
     printf("\t\t");                                \
   }                                                \
   putchar('\n');                                   \
}
#else
#define	MAKE_CLAUSE1
#define	MAKE_CLAUSE2
#define	MAKE_CLAUSE3
#define	CHECK_LITERAL
#endif


#ifdef YYDEBUG
/****** Macros from P/Smain.c ******/
#define	MAIN	extern int yydebug; yydebug = 1;
#else
#define	MAIN
#endif


#ifdef EXPRESSIONDEBUG
/****** Macros from expression.c ******/
#define	CONS_NODE                        \
{                                        \
   printf("\ncons_node received ...\n"); \
     show_var(exp1); show_var(exp2);     \
}
#else
#define	CONS_NODE
#endif


#ifdef FEATUREDEBUG
/****** Macros from feature.c ******/
#define	ADD_FEATURE                       \
{                                         \
   printf("\nadd_feature received...\n"); \
   printf("\tpsterm = %s\n", pstvar);     \
   printf("\tftr    = %s\n", ftr);        \
   printf("\tvalue  = ");                 \
   show_var(val);                         \
}
/****** Macros from expression.c ******/
#define	PST_NODE                          \
{                                         \
   printf("\npst_node received...\n");    \
   for (newpst = ftrlist; newpst != NULL; \
       newpst = newpst->body.pst.nxt)     \
   printf("%s ", newpst->body.pst.name);  \
   putchar('\n');                         \
}
#else
#define	ADD_FEATURE
#define	PST_NODE
#endif


#ifdef FORMULADEBUG
/****** Macros from formula.c ******/
#define	MAKE_FORMULA                           \
{                                              \
   printf("\nmake_formula received...\n");     \
   printf("\tname = %s\n", name);              \
   printf("\targs = ");                        \
   for (p = args; p != NULL; p = p->nxt)       \
   printf("%s ", p->var->name);                \
   putchar('\n');                              \
}
/****** Macros from formula.c ******/
#define	CHAIN_ARGS                         \
{                                          \
   printf("\nchain_args received...\n\t"); \
     show_var(arg);                        \
}
#else
#define	MAKE_FORMULA
#define	CHAIN_ARGS
#endif
