/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	debug.c	---	Debugging tools.
 *
 */

#include	<stdio.h>

#define	PROTO_DEBUG_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_DEBUG_C

#pragma segment	command

#define	EQ(a,b)	(strcmp((a),(b)) == 0)

static char buffer[BUFFSIZE];


int debug_monitor(s)
     char *s;
{
  int sw, itemp;
  litrlrec *ltrl;
  probe *prb;

  while (TRUE) {
    prompt("%s>", "MONITOR");
    gets(buffer);
    if (EQ(buffer, "l")) {
      for (ltrl = Gcontrol.signed_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt) {
	show_literal(ltrl);
	putchar('\n');
      }
    } else if (EQ(buffer, "lprb")) {
      for (prb = Gcontrol.probes; prb != NULL; prb = prb->ctrl.nxt)
	print_probe(prb, FALSE);
    } else if (EQ(buffer, "lprb_a")) {
      for (prb = Gcontrol.probes; prb != NULL; prb = prb->ctrl.nxt)
	print_probe(prb, TRUE);
    } else if (EQ(buffer, "lprss")) {
      printf("Literal ID=");
      itemp = 0;
      scanf("%d", &itemp);
      getchar();
      print_pressure(itemp);
    } else if ((sw=EQ(buffer, "Ptr_ltrl")) || EQ(buffer, "ptr_ltrl")) {
      check_pointers_literals(sw);
    } else if ((sw=EQ(buffer, "Ptr_lnk")) || EQ(buffer, "ptr_lnk")) {
      check_pointers_links(sw);
    } else if ((sw=EQ(buffer, "Ptr_prb")) || EQ(buffer, "ptr_prb")) {
      check_pointers_probes(sw);
    } else if (EQ(buffer, "exit")) {
      break;
    } else
      printf("Unknown command.\n");
  }
}


void show_var(var)
     varblrec *var;
{
  printf("var %s: ", (var->name == NULL ? "NULL" : var->name));
  switch (var->nth) {
  case UNKNOWN:
    printf("UNKNOWN, paren=%p\n", var->paren);
    break;
  case EQUATION:
    printf("EQUATION of ", var->paren);
    show_literal(var->paren);
    break;
  case PSTENTRY:
    printf("PSTENTRY(ftr=%s) of ", var->ftr);
    show_literal(var->paren->body.pst.root);
    break;
  case LEFTHAND:
    printf("lefthand of binding ");
    show_literal(var->paren);
    break;
  default:
    printf("%d%s argument of ",
	   var->nth,
	   (var->nth == 1 ? "st" :
	    (var->nth == 2 ? "nd" :
	     (var->nth == 3 ? "rd" : "th"))));
    show_literal(var->paren);
    break;
  }
}


void show_literal(ltrl)
     litrlrec *ltrl;
{
  litrlrec *ftr;

  if (ltrl == NULL)
    printf("\tNULL\n");
  else {
    if (ltrl->pol == POSITIVE || ltrl->pol == COST_POSITIVE)
      putchar('+');
    else if (ltrl->pol == NEGATIVE || ltrl->pol == COST_NEGATIVE)
      putchar('-');
    printf("%3.2lf", ltrl->act);
    switch (ltrl->tag) {
    case SYMBOL:
      printf("%s (SYMBOL)", ltrl->body.sym);
      break;
    case NUMBER:
      printf("%d (NUMBER)", ltrl->body.num);
      break;
    case FUNCTION:
      printf("%s (FUNCTION, arity=%d)",
	     ltrl->body.afm.name,
	     ltrl->body.afm.arity);
      break;
    case PSTERM:
      printf(" (PSTERM, ftr= ");
      for (ftr = ltrl->body.pst.nxt; ftr != NULL; ftr = ftr->body.pst.nxt)
	printf("%s ", ftr->body.pst.name);
      printf(")");
      break;
    case FEATURE:
      printf(" (FEATURE: %s)", ltrl->body.pst.name);
      break;
    case CONSTRAINT:
      printf("%s (CONSTRAINT, arity=%d)",
	     ltrl->body.afm.name,
	     ltrl->body.afm.arity);
      break;
    default:
      printf("??? (tag=%d, addr=%p)\n",
	     ltrl->tag, ltrl);
      break;
    }
    if (ltrl->pol == COST_POSITIVE || ltrl->pol == COST_NEGATIVE)
      putchar('$');
    printf("<%d>\n", ltrl->lid);
  }
}


probe *pick_probe(mprss)
     double *mprss;
{
  int line, n;
  probe *p, *pp;
  double prss;

  printf("\n------- status of probes -------\n");
  for (p = Gcontrol.probes; p != NULL; p = pp) {
    pp = p->ctrl.nxt;
    if (p->orgns == NULL) {
      detach_probe(p);
      FREE_probe(p);
      continue;
    }
  }
  line = 1;
  for (p = Gcontrol.probes; p != NULL; p = p->ctrl.nxt) {
    /*** OBSOLUTE ***/
    calc_pressure(&prss, p);
    if (prss > Gparams.subsTH) {
      printf("[%d]%s\n", line++, (p->orgns->handle->mark ? "SUSPENDED" : "FREE"));
      printf("Pressure: %lf\n\t", prss);
      print_probe(p, TRUE);
    }
  }
  printf("Select a probe\n");
  scanf("%d", &n);
  getchar();
  line = 1;
  *mprss = 0.0;
  for (p = Gcontrol.probes; p != NULL; p = p->ctrl.nxt) {
    /*** OBSOLUTE ***/
    calc_pressure(mprss, p);
    if (*mprss > Gparams.subsTH) {
      if (line == n)
	return p;
      else
	line++;
    }
  }
  return NULL;
}


void check_pointers_literals(filep)
     int filep;
{
  FILE *logfp;
  litrlrec *l;

  if (filep) {
    if ((logfp=fopen("LITERAL.LOG", "w")) == NULL)
      panic("Can't open LITERAL.LOG", 0);
  } else
    logfp = stdout;
  for (l = Gcontrol.unsigned_preds; l != NULL; l = l->ctrl.nxt)
    write_out(logfp, l);
  for (l = Gcontrol.signed_preds; l != NULL; l = l->ctrl.nxt)
    write_out(logfp, l);
  if (filep)
    fclose(logfp);
}


void check_pointers_links(filep)
     int filep;
{
  FILE *logfp;
  linkrec *lnk;

  if (filep) {
    if ((logfp=fopen("LINK.LOG", "w")) == NULL)
      panic("Can't open LINK.LOG", 0);
  } else
    logfp = stdout;
  for (lnk = Gcontrol.links; lnk != NULL; lnk = lnk->ctrl.nxt)
    fprintf(logfp, "LINK:%x, LTRL(0):%x, LTRL(1):%x\n",
	    lnk, lnk->ptr[0]->joint->ltrl,
	    lnk->ptr[1]->joint->ltrl);
}


void check_pointers_probes(filep)
     int filep;
{
  FILE *logfp;
  probe *prb;
  litrllst *ll;

  if (filep) {
    if ((logfp=fopen("PROBE.LOG", "w")) == NULL)
      panic("Can't open PROBE.LOG", 0);
  } else
    logfp = stdout;
  for (prb = Gcontrol.probes; prb != NULL; prb = prb->ctrl.nxt) {
    fprintf(logfp, "probe\n");
    for (ll = prb->orgns; ll != NULL; ll = ll->nxt)
      fprintf(logfp, "%x\n", ll);
  }
  if (filep)
    fclose(logfp);
}


void write_out(logfp, l)
     FILE *logfp;
     litrlrec *l;
{
  int i;
  litrlrec *ftr;
  jointrec *j;
  dependrec *d;

  switch (l->tag) {
  case SYMBOL:
    fprintf(logfp, "SYMBOL:%x, LeftHand:%x, ", l, l->lefth);
    fprintf(logfp, "VNode:%x\n", l->vnode);
    break;
  case NUMBER:
    fprintf(logfp, "NUMBER:%x, LeftHand:%x, ", l, l->lefth);
    fprintf(logfp, "VNode:%x\n", l->vnode);
    break;
  case FUNCTION:
    fprintf(logfp, "FUNCTION:%x, LeftHand:%x, ", l, l->lefth);
    fprintf(logfp, "Inferences:( ");
    for (j = l->joint; j != NULL; j = j->nxt)
      for (d = j->depend; d != NULL; d = d->nxt)
	fprintf(logfp, "%x ", d->link);
    fprintf(logfp, "), ");
    fprintf(logfp, "VNode:%x, ", l->vnode);
    fprintf(logfp, "Args:( ");
    for (i = 0; i < l->body.afm.arity; i++)
      for (j = l->body.afm.arg[i].body.val; j != NULL; j = j->nxt)
	for (d = j->depend; d != NULL; d = d->nxt)
	  fprintf(logfp, "%x ", d->link);
    fprintf(logfp, ")\n");
    break;
  case PSTERM:
    fprintf(logfp, "PSTERM:%x, LeftHand:%x, ", l, l->lefth);
    fprintf(logfp, "Inferences:( ");
    for (j = l->joint; j != NULL; j = j->nxt)
      for (d = j->depend; d != NULL; d = d->nxt)
	fprintf(logfp, "%x ", d->link);
    fprintf(logfp, "), ");
    fprintf(logfp, "VNode:%x, ", l->vnode);
    fprintf(logfp, "Features:( ");
    for (ftr = l->body.pst.nxt; ftr != NULL; ftr = ftr->body.pst.nxt)
      for (j = ftr->body.pst.val; j != NULL; j = j->nxt)
	for (d = j->depend; d != NULL; d = d->nxt)
	  fprintf(logfp, "%x ", d->link);
    fprintf(logfp, ")\n");
    break;
  case FEATURE:
    break;
  case CONSTRAINT:
    fprintf(logfp, "FUNCTION:%x, LeftHand:%x, ", l, l->lefth);
    fprintf(logfp, "Inferences:( ");
    for (j = l->joint; j != NULL; j = j->nxt)
      for (d = j->depend; d != NULL; d = d->nxt)
	fprintf(logfp, "%x ", d->link);
    fprintf(logfp, "), ");
    fprintf(logfp, "VNode:%x, ", l->vnode);
    fprintf(logfp, "Args:( ");
    for (i = 0; i < l->body.afm.arity; i++)
      for (j = l->body.afm.arg[i].body.val; j != NULL; j = j->nxt)
	for (d = j->depend; d != NULL; d = d->nxt)
	  fprintf(logfp, "%x ", d->link);
    fprintf(logfp, ")\n");
    break;
  default:
    fprintf(logfp, "??? %d ???:%x\n", l->tag, l);
    break;
  }
}


void print_pressure(lid)
     int lid;
{
  litrlrec *orgn;
  press *prss;

  for (orgn = Gcontrol.signed_preds; orgn != NULL; orgn = orgn->ctrl.nxt)
    if (orgn->lid == lid)
      break;
  if (orgn == NULL)
    return;
  for (prss = orgn->press; prss != NULL; prss = prss->ctrl.nxt) {
    print_literal(prss->link->ptr[0]->joint->ltrl);
    if (prss->dir == 0) {
      if (prss->nth < 0)
	printf(" <==[nth=%s,ftr=%s]==  ",
	       (prss->nth == LEFTHAND ? "LH" :
		(prss->nth == PSTENTRY ? "PSTENT" :
		 (prss->nth == INFERENCE ? "INF" : "??"))), prss->ftr);
      else
	printf(" <==[nth=%d,ftr=%s]==  ", prss->nth, prss->ftr);
    } else {
      if (prss->nth < 0)
	printf(" ==[nth=%s,ftr=%s]==>  ",
	       (prss->nth == LEFTHAND ? "LH" :
		(prss->nth == PSTENTRY ? "PSTENT" :
		 (prss->nth == INFERENCE ? "INF" : "??"))), prss->ftr);
      else
	printf(" ==[nth=%d,ftr=%s]==>  ", prss->nth, prss->ftr);
    }
    print_literal(prss->link->ptr[1]->joint->ltrl);
    printf("\n\t<<strng=%lf,dump=%d,dist=%d>>\n",
	   prss->strng, prss->dump, prss->dist);
  }
}
