/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	copy.c	---	Functions used in unfold translation.
 *
 */

#include	<stdio.h>

#define	PROTO_COPY_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_COPY_C

#pragma segment	subsume


/*---
  << Function >>
  Copies the clause in which `targetliteral' is included. Also copies
  joints and links except for `targetjoint'.
  << Return >>
  The joint which is not copied.
  ---*/
jointrec *copy_clause(targetliteral, targetjoint)
     litrlrec *targetliteral;
     jointrec *targetjoint;
{
  pphandle *top, *ctop, *ltrl, *cltrl, *cprev;
  jointrec *jnt, *retjoint;
  dependrec *dpnd;

  /* First, copy all literals in the clause and joints which belong
     to them. Return value `retjoint' is calculated in this phase. */
  top = targetliteral->pphndl->begin;
  ctop = NULL;
  for (ltrl = top; ltrl != NULL; ltrl = ltrl->next, cprev = cltrl) {
    /* In order not to change the order of literals in the clause,
       we use `cprev'. */
    cltrl = NEW_pphandle();
    ltrl->aux = cltrl;
    if (ctop == NULL)
      ctop = cltrl;
    else
      cprev->next = cltrl;
    cltrl->aux = NULL;
    cltrl->vnode = NULL;
    cltrl->top = ltrl->top;
    cltrl->body = copy_literal(ltrl->body);
    cltrl->begin = ctop;
    /* if `ltrl' is SYMBOL or NUMBER, copy_literal() doesn't copy
       given literal. (It simply returns the given `ltrl'.) */
    if (ltrl->body->tag == SYMBOL || ltrl->body->tag == NUMBER)
      cltrl->body->pphndl = NULL;
    else {
      cltrl->body->pphndl = cltrl;
      copy_equation_joints(ltrl->body, cltrl->body);
      if (ltrl->body == targetliteral)
	retjoint = copy_inference_joints(ltrl->body, cltrl->body, targetjoint);
      else
	copy_inference_joints(ltrl->body, cltrl->body, NULL);
    }
  }
  cprev->next = NULL;
  /* Second, copy all equation and unification links. */
  for (ltrl = top, cltrl = ctop;
       ltrl != NULL;
       ltrl = ltrl->next, cltrl = cltrl->next)
    if (ltrl->body->tag != SYMBOL && ltrl->body->tag != NUMBER) {
      copy_equation_links(ltrl->body);
      if (copy_inference_links(ltrl->body, targetjoint) &&
	  ltrl->body != targetliteral)
	/* If `ltrl' has any weak-equations, connect `ltrl' and `cltrl'. */
	switch (ltrl->body->tag) {
	case FUNCTION:
	  connect_literals(ltrl->body, cltrl->body,
			   ltrl->body->body.afm.arity + 1, Gparams.wsub/10);
	  break;
	case CONSTRAINT:
	  connect_literals(ltrl->body, cltrl->body,
			   ltrl->body->body.afm.arity, Gparams.wsub/10);
	  break;
	case FEATURE:
	  connect_literals(ltrl->body, cltrl->body, 2, Gparams.wsub/10);
	  break;
	default:
	  panic("0-ary predicate is copied? (`copy_clause')", 0);
	  break;
	}
    }
  /* Third, chain features and reset probes which have copied-origins. */
  for (ltrl = top, cltrl = ctop;
       ltrl != NULL;
       ltrl = ltrl->next, cltrl = cltrl->next) {
    if (ltrl->body->tag == FEATURE) {
      cltrl->body->body.pst.root =
	ltrl->body->body.pst.root->pphndl->aux->body;
      cltrl->body->body.pst.root->body.pst.nxt =
	chain_feature(cltrl->body->body.pst.root->body.pst.nxt, cltrl->body);
    }
    if (ltrl->body != cltrl->body)
      reset_probe(ltrl->body, cltrl->body);
  }
  return retjoint;
}


/*---
  << Function >>
  Copies a given literal except for `literal' is SYMBOL or NUMBER.
  << Return >>
  Literal which is copied, (`literal' is neither SYMBOL nor NUMBER.)
  or `literal'.
  ---*/
litrlrec *copy_literal(literal)
     litrlrec *literal;
{
  litrlrec *newliteral;
  int i;

  if (literal == NULL)
    return NULL;
  if (Gparams.copy) {
    printf("copy literal: ");
    print_literal(literal);
    putchar('\n');
  }
  Gparams.copiedp = TRUE;
  switch (literal->tag) {
  case SYMBOL:
  case NUMBER:
    return literal;
    break;
  case FUNCTION:
  case CONSTRAINT:
    newliteral = NEW_litrlrec();
    newliteral->tag = literal->tag;
    newliteral->body.afm.name = literal->body.afm.name;
    newliteral->body.afm.arity = literal->body.afm.arity;
    if (literal->body.afm.arity > 0) {
      newliteral->body.afm.arg =
	NEW_argument(literal->body.afm.arity);
      for (i = 0; i < literal->body.afm.arity; i++) {
	newliteral->body.afm.arg[i].body.val = NULL;
	newliteral->body.afm.arg[i].body.print =
	  literal->body.afm.arg[i].body.print;
      }
    } else
      newliteral->body.afm.arg = NULL;
    break;
  case PSTERM:
  case FEATURE:
    newliteral = NEW_litrlrec();
    newliteral->tag = literal->tag;
    newliteral->body.pst.name = literal->body.pst.name;
    newliteral->body.pst.val = NULL;
    newliteral->body.pst.root = NULL;
    newliteral->body.pst.prv = NULL;
    newliteral->body.pst.nxt = NULL;
    newliteral->body.pst.print = literal->body.pst.print;
    break;
  default:
    panic("unknown type of literal (%d) (`copy_literal')",
	  literal->tag);
    break;
  }
  newliteral->pol = literal->pol;
  newliteral->rel = literal->rel;
  newliteral->coeff.omegaN = literal->coeff.omegaN;
  newliteral->coeff.nOmega = literal->coeff.nOmega;
  newliteral->coeff.disj = literal->coeff.disj;
  newliteral->coeff.excl = literal->coeff.excl;
  newliteral->coeff.cmpl = literal->coeff.cmpl;
  newliteral->coeff.assm = literal->coeff.assm;
  newliteral->dfrc = 0.0;
  newliteral->path = NULL;
  newliteral->press = NULL;
  newliteral->act = LITERAL_INIT;
  newliteral->z = 0.0;
  newliteral->imp = 0.0;
  newliteral->lefth = NULL;
  newliteral->print = literal->print;
  newliteral->joint = NULL;
  newliteral->handle = NULL;
  newliteral->pphndl = NULL;
  newliteral->lid = Gcontrol.lid++;
  newliteral->mark = FALSE;
  newliteral->sbsm = literal->sbsm;
  newliteral->misc = literal->misc;
  newliteral->ctrl.prv = literal;
  newliteral->ctrl.nxt = literal->ctrl.nxt;
  literal->ctrl.nxt = newliteral;
  if (newliteral->ctrl.nxt != NULL)
    newliteral->ctrl.nxt->ctrl.prv = newliteral;
  newliteral->vnode = NULL;
  return newliteral;
}


/*---
  << Function >>
  Copies unification joints included in `srcliteral' into correspoding
  place of `dstliteral' to them except for `joint'. Connect each
  original and copied joint except for `joint'.
  << Return >>
  The copied joint corresponding to `joint'.
  ---*/
jointrec *copy_inference_joints(srcliteral, dstliteral, joint)
     litrlrec *srcliteral;
     litrlrec *dstliteral;
     jointrec *joint;
{
  jointrec *jnt, *retjoint;
  dependrec *dpnd;

  retjoint = NULL;
  for (jnt = srcliteral->joint; jnt != NULL; jnt = jnt->nxt)
    if (jnt != joint) {
      jnt->aux = new_inference_joint(dstliteral, jnt->total);
      /* clear marks of all links */
      for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
	dpnd->link->mark = FALSE;
    } else {
      jnt->aux = NULL;
      retjoint = new_inference_joint(dstliteral, TRUE);
    }
  return retjoint;
}


/*---
  << Function >>
  Copies equation joints included in `srcliteral' into correspoding
  place of `dstliteral' to them. Connect each original and copied joint.
  ---*/
void copy_equation_joints(srcliteral, dstliteral)
     litrlrec *srcliteral;
     litrlrec *dstliteral;
{
  int i;
  jointrec *jnt;
  dependrec *dpnd;

  if (srcliteral->tag != CONSTRAINT && srcliteral->tag != FEATURE) {
    for (jnt = srcliteral->lefth; jnt != NULL; jnt = jnt->nxt) {
      jnt->aux = new_equation_joint(dstliteral, LEFTHAND, "");
      for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
	dpnd->link->mark = FALSE;
    }
  }
  switch (srcliteral->tag) {
  case SYMBOL:
  case NUMBER:
  case PSTERM:
    break;
  case FUNCTION:
  case CONSTRAINT:
    for (i = 0; i < srcliteral->body.afm.arity; i++)
      for (jnt = srcliteral->body.afm.arg[i].body.val;
	   jnt != NULL; jnt = jnt->nxt) {
	jnt->aux = new_equation_joint(dstliteral, i, "");
	for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
	  dpnd->link->mark = FALSE;
      }
    break;
  case FEATURE:
    for (jnt = srcliteral->body.pst.val;
	 jnt != NULL; jnt = jnt->nxt) {
      jnt->aux = new_equation_joint(dstliteral, PSTENTRY,
				    srcliteral->body.pst.name);
      for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
	dpnd->link->mark = FALSE;
    }
    break;
  default:
    panic("unknown type of literal (%d) (`copy_equation_joints')",
	  srcliteral->tag);
    break;
  }
}


/*---
  << Function >>
  Copies all unification links.
  << Return >>
  TRUE, (`srcliteral' has any weak equation) or FALSE.
  ---*/
Boolean copy_inference_links(srcliteral, joint)
     litrlrec *srcliteral;
     jointrec *joint;
{
  jointrec *srcjnt0;
  int arity;
  Boolean weakeq;

  if (srcliteral == NULL)
    return FALSE;
  switch (srcliteral->tag) {
  case SYMBOL:
  case NUMBER:
  case PSTERM:
    return FALSE;
    break;
  case FUNCTION:
    arity = srcliteral->body.afm.arity + 1;
    break;
  case CONSTRAINT:
    arity = srcliteral->body.afm.arity;
    break;
  case FEATURE:
    arity = 2;
    break;
  default:
    panic("unknown type of literal (%d) (`copy_inference_links')",
	  srcliteral->tag);
    break;
  }
  weakeq = FALSE;
  for (srcjnt0 = srcliteral->joint; srcjnt0 != NULL; srcjnt0 = srcjnt0->nxt)
    if (srcjnt0 != joint)
      weakeq = copy_one_inference_link(srcjnt0, srcjnt0->aux, arity) || weakeq;
  /* the evaluation-order is IMPORTANT !!
     (`copy_inference' must be always evaluated.) */
  /* return weakeq; */
  return FALSE;/**** inhibit self-subsumption! ****/
}


/*---
  << Function >>
  Copies all links from `srcjnt0' into the joints from `dstjnt0'.

  case (1) strong unification link (inter-clausal)

    original clause  |            original clause  |  copied clause
                     |                             |
         srcjnt0     |    ==>          srcjnt0     |     dstjnt0
            |  	     | 	       	       	  \    	   |   	    /
    ________|________|            _________\_______|_______/_______
            |           		    \             /
            |                                \           /
        -srcjnt1                               -srcjnt1


  case (2) strong unification link (intra-clausal)

    original clause               original clause  |  copied clause
                                                   |
        -srcjnt0          ==>         -srcjnt0     |    -dstjnt0
            |                             |\  _____|________/|
            |                             | \/     |         |
            |                             | /\_____|________ |
            |                             |/       |        \|
         srcjnt1                       srcjnt1     |     dstjnt1
						   |

  case (3) weak unification link (inter-clausal)

    original clause  | 	     	  original clause  |  copied clause
                     | 	     	                   |
        -srcjnt0     |    ==>         -srcjnt0 ----+---	-dstjnt0
       	    |  	     | 	       	       	  \    	   |   	    /
    ________|________|            _________\_______|_______/_______
            |                               \             /
            |                                \           /
        -srcjnt1                          -srcjnt1 = -dstjnt1


  case (4) weak unification link (intra-clausal)

    original clause               original clause  |  copied clause
                                                   |
        -srcjnt0          ==>         -srcjnt0 ----+--- -dstjnt0
            |                             |  \  ___|______/  |
            |                             |   \/   |         |
            |                             |   /\___|______   |
            |                             |  /     |      \  |
        -srcjnt1                      -srcjnt1 ----+--- -dstjnt1
						   |

  If srcltrl1 is target literal, then remove all links from dstltrl1.
  << Return >>
  TRUE, (there are any weak link from `srcjnt0') or FALSE.
  ---*/
Boolean copy_one_inference_link(srcjnt0, dstjnt0, arity)
     jointrec *srcjnt0;
     jointrec *dstjnt0;
     int arity;
{
  jointrec *srcjnt1, *jnt0, *jnt1, *dstjnt1;
  dependrec *dpnd0, *dpnd1;
  linkrec *link;
  Boolean weakeq;

  if (srcjnt0 == NULL || dstjnt0 == NULL)
    return FALSE;
  weakeq = FALSE;
  for (dpnd0 = srcjnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
    link = dpnd0->link;
    dpnd1 = link->ptr[dpnd0->dir];
    srcjnt1 = dpnd1->joint;
    if (srcjnt0->total || srcjnt1->total) {
      /* ======= srcjnt0 - srcjnt1 is a strong-equation ====== */
      if (link->mark)		    /* this link is already copied. */
	continue;
      /*
       * case (1):
       *    generate link between dstjnt0<->srcjnt1 in the above figure.
       *
       * case (2):
       *    generate link between dstjnt0<->srcjnt1 in the above figure.
       *    This copied link is also copied when scanning srcjnt1 and
       *    link between dstjnt1<->dstjnt0 is generated.
       */
      copy_link(dstjnt0, srcjnt1, dpnd0, dpnd1, arity);
      link->mark = TRUE;
      /* check if each end of the links is in the same clause. */
      if (srcjnt0->ltrl->pphndl->begin == srcjnt1->ltrl->pphndl->begin)
	if (srcjnt1->aux != NULL)
	  /*
	   * if srcjnt1 != targetjoint, then dstjnt1 := srcjnt1->aux
	   *
	   * case (2):
	   *    generate link between srcjnt0<->dstjnt1 in the above figure.
	   */
	  copy_link(srcjnt0, srcjnt1->aux, dpnd0, dpnd1, arity);
    } else if (dpnd1->prv == NULL && dpnd1->nxt == NULL) {
      /* ======= srcjnt0 - srcjnt1 is a weak-equation ======== */
      weakeq = TRUE;
      if (link->mark)		    /* this link is already copied. */
	continue;
      /*
       * case (3):
       *    generate link between dstjnt0<->srcjnt1 in the above figure.
       *
       * case (4):
       *    generate link between dstjnt0<->srcjnt1 in the above figure.
       *    This copied link is also copied when scanning srcjnt1 and
       *    link between dstjnt1<->dstjnt0 is generated.
       */
      jnt1 = new_inference_joint(srcjnt1->ltrl, FALSE);
      copy_link(dstjnt0, jnt1, dpnd0, dpnd1, arity);
      link->mark = TRUE;
      /* check if each end of the links is in the same clause. */
      if (srcjnt0->ltrl->pphndl->begin == srcjnt1->ltrl->pphndl->begin)
	if (srcjnt1->aux != NULL) {
	  /*
	   * if srcjnt1 != targetjoint, then dstjnt1 := srcjnt1->aux
	   *
	   * case (4):
	   *    generate link between srcjnt0<->dstjnt1 in the above figure.
	   */
	  jnt0 = new_inference_joint(srcjnt0->ltrl, FALSE);
	  dstjnt1 = new_inference_joint(srcjnt1->aux->ltrl, FALSE);
	  copy_link(jnt0, srcjnt1->aux, dpnd0, dpnd1, arity);
	  jnt1->aux = dstjnt1;
	}
    } else
      panic("weak-equation isn't unit. (`copy_inference')", 0);
  }
  return weakeq;
}


void copy_link(dstjnt0, dstjnt1, srcdpnd0, srcdpnd1, arity)
     jointrec *dstjnt0;
     jointrec *dstjnt1;
     dependrec *srcdpnd0;
     dependrec *srcdpnd1;
     int arity;
{
  dependrec *newdpnd0, *newdpnd1;
  linkrec *newlink;
  litrllst *orgns;
  probe *prb;

  newdpnd0 = new_dependency(dstjnt0);
  newdpnd1 = new_dependency(dstjnt1);
  newlink = new_inference_link(newdpnd0, newdpnd1, arity);
  newlink->sub = srcdpnd0->link->sub;
  newlink->mark = FALSE;
  for (prb = srcdpnd0->link->probe[srcdpnd0->dir]; prb != NULL; prb = prb->nxt) {
    orgns = copy_llist(prb->orgns);
    put_probe(newlink, orgns, newdpnd0->dir, prb->nth, prb->ftr);
  }
  for (prb = srcdpnd1->link->probe[srcdpnd1->dir]; prb != NULL; prb = prb->nxt) {
    orgns = copy_llist(prb->orgns);
    put_probe(newlink, orgns, newdpnd1->dir, prb->nth, prb->ftr);
  }
}


void copy_equation_links(srcliteral)
     litrlrec *srcliteral;
{
  jointrec *srcjnt0;
  int i;

  if (srcliteral == NULL)
    return;
  if (srcliteral->tag != CONSTRAINT && srcliteral->tag != FEATURE) {
    for (srcjnt0 = srcliteral->lefth; srcjnt0 != NULL; srcjnt0 = srcjnt0->nxt)
      copy_one_equation_link(srcjnt0, srcjnt0->aux);
  }
  switch (srcliteral->tag) {
  case SYMBOL :
  case NUMBER :
  case PSTERM :
    break;
  case FUNCTION :
  case CONSTRAINT :
    for (i = 0; i < srcliteral->body.afm.arity; i++)
      for (srcjnt0 = srcliteral->body.afm.arg[i].body.val;
	   srcjnt0 != NULL; srcjnt0 = srcjnt0->nxt)
	copy_one_equation_link(srcjnt0, srcjnt0->aux);
    break;
  case FEATURE :
    for (srcjnt0 = srcliteral->body.pst.val;
	 srcjnt0 != NULL; srcjnt0 = srcjnt0->nxt)
      copy_one_equation_link(srcjnt0, srcjnt0->aux);
    break;
    default :
    panic("unknown type of literal (%d) (`copy_equation_links')",
	  srcliteral->tag);
    break;
  }
}


void copy_one_equation_link(srcjnt0, dstjnt0)
     jointrec *srcjnt0;
     jointrec *dstjnt0;
{
  jointrec *srcjnt1, *dstjnt1;
  dependrec *dpnd0, *dpnd1, *newdpnd0, *newdpnd1;
  linkrec *newlink;
  probe *prb;
  litrllst *orgns;

  if (srcjnt0 == NULL || dstjnt0 == NULL)
    return;
  for (dpnd0 = srcjnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
    dpnd1 = dpnd0->link->ptr[dpnd0->dir];
    srcjnt1 = dpnd1->joint;
    /* check if each end of the links is in the different clauses
       (i.e. the another end of srcjnt0's link is 0- or 1-ary predicate.) */
    if (srcjnt1->ltrl->pphndl == NULL ||
	srcjnt1->ltrl->tag == SYMBOL || srcjnt1->ltrl->tag == NUMBER)
      dstjnt1 = new_equation_joint(srcjnt1->ltrl, LEFTHAND, "");
    else if (srcjnt0->ltrl->pphndl->begin == srcjnt1->ltrl->pphndl->begin) {
      if (dpnd0->link->mark) {
	dpnd0->link->mark = FALSE;
	continue;
      } else {
	dpnd0->link->mark = TRUE;
	dstjnt1 = srcjnt1->aux;
      }
    } else
      panic("inter-clausal equation ?? (`copy_one_equation')", 0);
    newdpnd0 = new_dependency(dstjnt0);
    newdpnd1 = new_dependency(dstjnt1);
    newlink = new_equation_link(newdpnd0, newdpnd1, dpnd0->link->explct);
    for (prb = dpnd0->link->probe[dpnd0->dir]; prb != NULL; prb = prb->nxt) {
      orgns = copy_llist(prb->orgns);
      put_probe(newlink, orgns, newdpnd0->dir, srcjnt1->nth, srcjnt1->ftr);
    }
    for (prb = dpnd1->link->probe[dpnd1->dir]; prb != NULL; prb = prb->nxt) {
      orgns = copy_llist(prb->orgns);
      put_probe(newlink, orgns, newdpnd1->dir, srcjnt0->nth, srcjnt0->ftr);
    }
  }
}
