/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	command.h	---	Table of command names,
 *				pointers to the function and help messages
 *
 */

typedef struct _command {
  char *name;		/* command name */
  char *abbrev;		/* abbreviation of command name */
  int (*func)();	/* pointers to the function */
  char *help;		/* help message */
} command;

command ctable[] = {
  {"help", "?", print_help,	"                : This command"},
  {"backp", "b", backprop,	"                : Backpropagation only"},
  {"forceA", "fa", list_forceA,	"                : Display force to atomic formula"},
  {"forceS", "fs", list_forceS,	"                : Display force to strong-equation"},
  {"forceW", "fw", list_forceW,	"                : Display force to weak-equation"},
  {"info", "i", info_links,	"<literal-ID>    : Display information of links"},
  {"list", "l", list_prog,	"                : List program"},
  {"load", "lo", load_prog,	"<filename>      : Load program (no echo)"},
  {"load?", "lo?", load_prog_e,	"<filename>      : Load program (with echo)"},
  {"loop", NULL, list_loops,	"                : Display detected loops"},
  {"on", NULL, switch_on,	"<option>...     : Enable options"},
  {"off", NULL, switch_off,	"<option>...     : Disable options"},
  {"probe", "p", list_probes,   "[all]           : List probes"},
  {"quit", NULL, quit,		"                : Quit"},
  {"set", NULL, set_param,	"<param> <value> : Set parameter to value"},
  {"spread", "s", spreading,	"                : Spreading activation only"},
  {"status", NULL, print_status,"                : Display options and parameters"},
  {"<enter>", NULL, NULL,     	"                : Continue processing\n\t(Spreading activation, backpropagation and subsumption)"},
  {NULL, NULL, NULL, NULL},

  {"reset", NULL, reset_system,	"                : Reset the system"},
  {"mon", NULL, debug_monitor,	"                : Jump to the monitor for debugging"}
};





