/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	clause.c	---	Checking links in the clause.
 *					(arguments and structure links)
 *
 */

#include	<stdio.h>

#define	PROTO_CLAUSE_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_CLAUSE_C

#pragma segment	parser


int make_clause(literals, disj, excl)
     pphandle *literals;
     double disj;
     double excl;
{
  bndngrec *p, *q, *r;
  jointrec *jnt1, *jnt2;
  dependrec *dpnd1, *dpnd2;
  varblrec *temp;
  litrlrec *ftr0, *ftr1, *ftr2;
  pphandle *pp0, *pp1, *pp2;
  int n;
  double omegan;

  MAKE_CLAUSE1;			/* free all entries in variable table */
  for (; Gbuffer.variables != NULL; Gbuffer.variables = temp) {
    temp = Gbuffer.variables->nxt;
    for (p = Gbuffer.variables->brecs; p != NULL; p = r) {
      r = p->nxt;
      if (p->var == NULL || p->link == NULL ||
	  (p->dir != 0 && p->dir != 1))
	continue;
      q = p->link->ptr[p->dir];
      MAKE_CLAUSE2;		/**** get left-hand of binding.****/
      jnt1 = new_equation_joint(p->var->paren, p->var->nth, p->var->ftr);
      dpnd1 = new_dependency(jnt1);
      MAKE_CLAUSE3;		/**** get right-hand of binding.****/
      jnt2 = new_equation_joint(q->var->paren, q->var->nth, q->var->ftr);
      dpnd2 = new_dependency(jnt2);
      /* connect two joint */
      new_equation_link(dpnd1, dpnd2, p->link->explct);
      /* free link and binding record */
      q->var = NULL;
      q->link = NULL;
    }
  }

  /* make clean constant-table */
  for (temp = Gbuffer.constants; temp != NULL; temp = temp->nxt) {
    for (p = temp->brecs; p != NULL; p = q) {
      q = p->nxt;
      if (p->var != NULL || p->link != NULL)
	panic("couldn't clean up constant-table (`make_clause')", 0);
    }
    temp->brecs = NULL;
  }

  /* reverse list of literals */
  for (n = 0, omegan = 1.0, pp0 = literals, pp1 = NULL;
       pp0 != NULL; pp0 = pp2) {
    pp2 = pp0->next;
    pp0->next = pp1;
    pp1 = pp0;
    if (pp0->body->tag == PSTERM) {
      /* reverse list of features */
      for (ftr0 = pp0->body->body.pst.nxt, ftr1 = NULL;
	   ftr0 != NULL; ftr0 = ftr2) {
	ftr2 = ftr0->body.pst.nxt;
	ftr0->body.pst.prv = NULL;
	ftr0->body.pst.nxt = ftr1;
	if (ftr0->body.pst.nxt != NULL)
	  ftr0->body.pst.nxt->body.pst.prv = ftr0;
	ftr1 = ftr0;
      }
      pp0->body->body.pst.nxt = ftr1;
    } else if (pp0->body->tag != SYMBOL &&
	       pp0->body->tag != NUMBER) {
      n++;
      omegan *= OMEGA;
    }
  }
  /* add literals to Global literal-list and	*/
  /* set the beginning literal of the clause.	*/
  for (pp0 = pp1; pp0 != NULL; pp0 = pp0->next) {
    pp0->top = Gbuffer.top;
    pp0->begin = pp1;
    pp0->body->coeff.omegaN = omegan;
    pp0->body->coeff.nOmega = n*OMEGA;
    pp0->body->coeff.excl = excl;
    pp0->body->coeff.disj = disj;
    if (pp0->body->tag != SYMBOL && pp0->body->tag != NUMBER) {
      if (pp0->top)
	pp0->body->sbsm = TRUE;
      if (pp0->body->pol == UNSIGNED)
	push_literal(&Gcontrol.unsigned_preds, pp0->body);
      else
	push_literal(&Gcontrol.signed_preds, pp0->body);
    }
  }

  return 0;
}


void check_defined_pred_dependency()
{
  litrlrec *p, *q;
  jointrec *j0, *j1;
  dependrec *d0, *d1;
  linkrec *l;

  for (p = Gcontrol.unsigned_preds; p != NULL; p = p->ctrl.nxt)
    for (q = Gcontrol.signed_preds; q != NULL; q = q->ctrl.nxt)
      switch (p->tag) {
      case FUNCTION:
      case CONSTRAINT:
	if (p->tag == q->tag &&
	    strcmp(p->body.afm.name, q->body.afm.name) == 0 &&
	    p->body.afm.arity == q->body.afm.arity) {
	  if ((j0=p->joint) == NULL)
	    j0 = new_inference_joint(p, FALSE);
	  if ((j1=q->joint) == NULL)
	    j1 = new_inference_joint(q, TRUE);
	  d0 = new_dependency(j0);
	  d1 = new_dependency(j1);
	  if (p->tag == FUNCTION)
	    l = new_inference_link(d0, d1, p->body.afm.arity+1);
	  else
	    l = new_inference_link(d0, d1, p->body.afm.arity);
	  l->sub = Gparams.ssub;
	}
	break;
      case FEATURE:
	if (p->tag == q->tag &&
	    strcmp(p->body.pst.name, q->body.pst.name) == 0) {
	  if ((j0=p->joint) == NULL)
	    j0 = new_inference_joint(p, FALSE);
	  if ((j1=q->joint) == NULL)
	    j1 = new_inference_joint(q, TRUE);
	  d0 = new_dependency(j0);
	  d1 = new_dependency(j1);
	  l = new_inference_link(d0, d1, 2);
	  l->sub = Gparams.ssub;
	}
	break;
      default:
	break;
      }
}


void check_free_pred_dependency()
{
  litrlrec *p, *q;

  /* First, mark all free predicates */
  for (p = Gcontrol.signed_preds; p != NULL; p = p->ctrl.nxt)
    if (p->joint == NULL &&
	(p->tag == FUNCTION ||
	 p->tag == CONSTRAINT ||
	 p->tag == FEATURE))
      p->mark = MARKED;
    else
      p->mark = FALSE;
  /* make complete-graph */
  for (p = Gcontrol.signed_preds; p != NULL; p = p->ctrl.nxt)
    if (p->mark != MARKED)
      continue;
    else if (p->tag == FUNCTION) {
      for (q = p->ctrl.nxt; q != NULL; q = q->ctrl.nxt)
	if (p->tag == q->tag)
	  if (strcmp(p->body.afm.name, q->body.afm.name) == 0 &&
	      p->body.afm.arity == q->body.afm.arity)
	    connect_literals(p, q, p->body.afm.arity+1, Gparams.wsub);
    } else if (p->tag == CONSTRAINT) {
      for (q = p->ctrl.nxt; q != NULL; q = q->ctrl.nxt)
	if (p->tag == q->tag)
	  if (strcmp(p->body.afm.name, q->body.afm.name) == 0 &&
	      p->body.afm.arity == q->body.afm.arity)
	    connect_literals(p, q, p->body.afm.arity, Gparams.wsub);
    } else if (p->tag == FEATURE) {
      if (p->body.pst.name[0] == '!') /* efficiency for Speech Recognition */
	continue;
      for (q = p->ctrl.nxt; q != NULL; q = q->ctrl.nxt)
	if (p->tag == q->tag)
	  if (strcmp(p->body.pst.name, q->body.pst.name) == 0)
	    connect_literals(p, q, 2, Gparams.wsub);
    }
}
