/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	allocate.c	---	Memory Manager Routines
 *
 */

#include	<stdio.h>

#define	PROTO_ALLOCATE_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_ALLOCATE_C


/* lists of chunks */
static struct _Gchunks {
  litrlrec_chunk  *litrlrec_c;
  linkrec_chunk   *linkrec_c;
  jointrec_chunk  *jointrec_c;
  dependrec_chunk *dependrec_c;
  handlerec_chunk *handlerec_c;
  probe_chunk     *probe_c;
  press_chunk     *press_c;
  index_chunk     *index_c;
  litrllst_chunk  *litrllst_c;
  foldrec_chunk   *foldrec_c;
  pphandle_chunk  *pphandle_c;

  argument_chunk  *argument_cc;
  linkact_chunk   *linkact_cc;

  varblrec_chunk  *varblrec_c;
  bndngrec_chunk  *bndngrec_c;
  conctrec_chunk  *conctrec_c;
  arglst_chunk    *arglst_c;
} Gchunks;

/* root-pointers of free-lists */
static struct _Groots	{
  struct _litrlrec  *litrlrec_r;
  struct _linkrec   *linkrec_r;
  struct _jointrec  *jointrec_r;
  struct _dependrec *dependrec_r;
  struct _handlerec *handlerec_r;
  struct _probe     *probe_r;
  struct _press     *press_r;
  struct _index     *index_r;
  struct _litrllst  *litrllst_r;
  struct _foldrec   *foldrec_r;
  struct _pphandle  *pphandle_r;

  struct _argument_root *argument_rr;
  struct _linkact_root  *linkact_rr;
} Groots;

/* indices of used-block boundaries */
static struct	_Gindices {
  int varblrec_i;
  int bndngrec_i;
  int conctrec_i;
  int arglst_i;
} Gindices;


#pragma segment	main


litrlrec_chunk *GET_litrlrec_chunk()
{
  int i;
  litrlrec_chunk *newchunk;

  newchunk = (litrlrec_chunk *) malloc(sizeof(litrlrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_litrlrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_LITRLREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_LITRLREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_LITRLREC-1].mm.nxt = NULL;
  return newchunk;
}


linkrec_chunk *GET_linkrec_chunk()
{
  int i;
  linkrec_chunk *newchunk;

  newchunk = (linkrec_chunk *) malloc(sizeof(linkrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_linkrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_LINKREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_LINKREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_LINKREC-1].mm.nxt = NULL;
  return newchunk;
}


jointrec_chunk *GET_jointrec_chunk()
{
  int i;
  jointrec_chunk *newchunk;

  newchunk = (jointrec_chunk *) malloc(sizeof(jointrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_jointrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_JOINTREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_JOINTREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_JOINTREC-1].mm.nxt = NULL;
  return newchunk;
}


dependrec_chunk *GET_dependrec_chunk()
{
  int i;
  dependrec_chunk *newchunk;

  newchunk = (dependrec_chunk *) malloc(sizeof(dependrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_dependrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_DEPENDREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_DEPENDREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_DEPENDREC-1].mm.nxt = NULL;
  return newchunk;
}


handlerec_chunk *GET_handlerec_chunk()
{
  int i;
  handlerec_chunk *newchunk;

  newchunk = (handlerec_chunk *) malloc(sizeof(handlerec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_handlerec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_HANDLEREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_HANDLEREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_HANDLEREC-1].mm.nxt = NULL;
  return newchunk;
}


probe_chunk *GET_probe_chunk()
{
  int i;
  probe_chunk *newchunk;

  newchunk = (probe_chunk *) malloc(sizeof(probe_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_probe_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_PROBE-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_PROBE-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_PROBE-1].mm.nxt = NULL;
  return newchunk;
}


press_chunk *GET_press_chunk()
{
  int i;
  press_chunk *newchunk;

  newchunk = (press_chunk *) malloc(sizeof(press_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_press_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_PRESS-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_PRESS-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_PRESS-1].mm.nxt = NULL;
  return newchunk;
}


index_chunk *GET_index_chunk()
{
  int i;
  index_chunk *newchunk;

  newchunk = (index_chunk *) malloc(sizeof(index_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_index_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_INDEX-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_INDEX-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_INDEX-1].mm.nxt = NULL;
  return newchunk;
}


litrllst_chunk *GET_litrllst_chunk()
{
  int i;
  litrllst_chunk *newchunk;

  newchunk = (litrllst_chunk *) malloc(sizeof(litrllst_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_litrllst_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_LITRLLST-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_LITRLLST-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_LITRLLST-1].mm.nxt = NULL;
  return newchunk;
}


foldrec_chunk *GET_foldrec_chunk()
{
  int i;
  foldrec_chunk *newchunk;

  newchunk = (foldrec_chunk *) malloc(sizeof(foldrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_foldrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_FOLDREC-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_FOLDREC-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_FOLDREC-1].mm.nxt = NULL;
  return newchunk;
}


pphandle_chunk *GET_pphandle_chunk()
{
  int i;
  pphandle_chunk *newchunk;

  newchunk = (pphandle_chunk *) malloc(sizeof(pphandle_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_pphandle_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  for (i = 0; i < NUM_OF_PPHANDLE-1; i++) {
    newchunk->cell[i].mm.mark = FREED;
    newchunk->cell[i].mm.nxt = &newchunk->cell[i+1];
  }
  newchunk->cell[NUM_OF_PPHANDLE-1].mm.mark = FREED;
  newchunk->cell[NUM_OF_PPHANDLE-1].mm.nxt = NULL;
  return newchunk;
}


argument_chunk *GET_argument_chunk(cell_size)
     int cell_size;
{
  int cell_num;
  argument_chunk *chunk;
  argument_cell *newcell;

  for (chunk = Gchunks.argument_cc; chunk != NULL; chunk = chunk->nxt)
    if (chunk->cell_size == cell_size)
      break;
  if (chunk == NULL) {
    chunk = (argument_chunk *) malloc(sizeof(argument_chunk));
    if (chunk == NULL) {
      printf("Can't get more chunk ! (GET_argument_chunk)\n");
      exit(1);
    }
    chunk->cell_size = cell_size;
    cell_num = (NUM_OF_ARGUMENT-1)/(cell_size+1);
    chunk->chunk_size = (cell_size+1)*cell_num+1;
    chunk->argument_c = NULL;
    chunk->nxt = Gchunks.argument_cc;
    Gchunks.argument_cc = chunk;
  } else
    cell_num = (chunk->chunk_size-1)/(cell_size+1);
  newcell = GET_argument_cells(cell_size, cell_num);
  newcell[0].c_nxt = chunk->argument_c;
  chunk->argument_c = newcell;
  return chunk;
}


linkact_chunk *GET_linkact_chunk(cell_size)
     int cell_size;
{
  int cell_num;
  linkact_chunk *chunk;
  linkact_cell *newcell;

  for (chunk = Gchunks.linkact_cc; chunk != NULL; chunk = chunk->nxt)
    if (chunk->cell_size == cell_size)
      break;
  if (chunk == NULL) {
    chunk = (linkact_chunk *) malloc(sizeof(linkact_chunk));
    if (chunk == NULL) {
      printf("Can't get more chunk ! (GET_linkact_chunk)\n");
      exit(1);
    }
    chunk->cell_size = cell_size;
    cell_num = (NUM_OF_LINKACT-1)/(cell_size+1);
    chunk->chunk_size = (cell_size+1)*cell_num+1;
    chunk->linkact_c = NULL;
    chunk->nxt = Gchunks.linkact_cc;
    Gchunks.linkact_cc = chunk;
  } else
    cell_num = (chunk->chunk_size-1)/(cell_size+1);
  newcell = GET_linkact_cells(cell_size, cell_num);
  newcell[0].c_nxt = chunk->linkact_c;
  chunk->linkact_c = newcell;
  return chunk;
}


argument_cell *GET_argument_cells(size, num)
     int size;
     int num;
{
  int i;
  argument_cell *newcell;

  newcell = (argument_cell *) calloc((size+1)*num+1, sizeof(argument_cell));
  if (newcell == NULL) {
    printf("Can't get more cells ! (GET_arument_cells)\n");
    exit(1);
  }
  newcell[0].c_nxt = NULL;
  for (i = 0; i < num-1; i++) {
    newcell[i*(size+1)+1].mm.mark = -size;
    newcell[i*(size+1)+1].mm.nxt = &newcell[(i+1)*(size+1)+1];
  }
  newcell[(num-1)*(size+1)+1].mm.mark = -size;
  newcell[(num-1)*(size+1)+1].mm.nxt = NULL;
  return newcell;
}


linkact_cell *GET_linkact_cells(size, num)
     int size;
     int num;
{
  int i;
  linkact_cell *newcell;

  newcell = (linkact_cell *) calloc((size+1)*num+1, sizeof(linkact_cell));
  if (newcell == NULL) {
    printf("Can't get more cells ! (GET_arument_cells)\n");
    exit(1);
  }
  newcell[0].c_nxt = NULL;
  for (i = 0; i < num-1; i++) {
    newcell[i*(size+1)+1].mm.mark = -size;
    newcell[i*(size+1)+1].mm.nxt = &newcell[(i+1)*(size+1)+1];
  }
  newcell[(num-1)*(size+1)+1].mm.mark = -size;
  newcell[(num-1)*(size+1)+1].mm.nxt = NULL;
  return newcell;
}



varblrec_chunk *GET_varblrec_chunk()
{
  varblrec_chunk *newchunk;

  newchunk = (varblrec_chunk *) malloc(sizeof(varblrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_varblrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  return newchunk;
}


bndngrec_chunk *GET_bndngrec_chunk()
{
  bndngrec_chunk *newchunk;

  newchunk = (bndngrec_chunk *) malloc(sizeof(bndngrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_bndngrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  return newchunk;
}


conctrec_chunk *GET_conctrec_chunk()
{
  conctrec_chunk *newchunk;

  newchunk = (conctrec_chunk *) malloc(sizeof(conctrec_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_conctrec_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  return newchunk;
}


arglst_chunk *GET_arglst_chunk()
{
  arglst_chunk *newchunk;

  newchunk = (arglst_chunk *) malloc(sizeof(arglst_chunk));
  if (newchunk == NULL) {
    printf("Can't get more chunk ! (GET_arglst_chunk)\n");
    exit(1);
  }
  newchunk->nxt = NULL;
  return newchunk;
}



void FREE_varblrec_chunk()
{
  varblrec_chunk *chunk, *tmp;

  for (chunk = Gchunks.varblrec_c; chunk != NULL; chunk = tmp) {
    tmp = chunk->nxt;
    free(chunk);
  }
}


void FREE_bndngrec_chunk()
{
  bndngrec_chunk *chunk, *tmp;

  for (chunk = Gchunks.bndngrec_c; chunk != NULL; chunk = tmp) {
    tmp = chunk->nxt;
    free(chunk);
  }
}


void FREE_conctrec_chunk()
{
  conctrec_chunk *chunk, *tmp;

  for (chunk = Gchunks.conctrec_c; chunk != NULL; chunk = tmp) {
    tmp = chunk->nxt;
    free(chunk);
  }
}


void FREE_arglst_chunk()
{
  arglst_chunk *chunk, *tmp;

  for (chunk = Gchunks.arglst_c; chunk != NULL; chunk = tmp) {
    tmp = chunk->nxt;
    free(chunk);
  }
}



int INIT_parser_mem()
{
  Gchunks.varblrec_c = GET_varblrec_chunk();
  Gchunks.bndngrec_c = GET_bndngrec_chunk();
  Gchunks.conctrec_c = GET_conctrec_chunk();
  Gchunks.arglst_c = GET_arglst_chunk();

  Gindices.varblrec_i = 0;
  Gindices.bndngrec_i = 0;
  Gindices.conctrec_i = 0;
  Gindices.arglst_i = 0;

  return TRUE;
}


void FREE_parser_mem()
{
  FREE_varblrec_chunk();
  FREE_bndngrec_chunk();
  FREE_conctrec_chunk();
  FREE_arglst_chunk();
}



int INIT_main_mem()
{
  Gchunks.litrlrec_c = GET_litrlrec_chunk();
  Gchunks.linkrec_c = GET_linkrec_chunk();
  Gchunks.jointrec_c = GET_jointrec_chunk();
  Gchunks.dependrec_c = GET_dependrec_chunk();
  Gchunks.handlerec_c = GET_handlerec_chunk();
  Gchunks.probe_c = GET_probe_chunk();
  Gchunks.press_c = GET_press_chunk();
  Gchunks.index_c = GET_index_chunk();
  Gchunks.litrllst_c = GET_litrllst_chunk();
  Gchunks.foldrec_c = GET_foldrec_chunk();
  Gchunks.pphandle_c = GET_pphandle_chunk();

  Gchunks.argument_cc = NULL;
  Gchunks.linkact_cc = NULL;

  Groots.litrlrec_r = &Gchunks.litrlrec_c->cell[0];
  Groots.linkrec_r = &Gchunks.linkrec_c->cell[0];
  Groots.jointrec_r = &Gchunks.jointrec_c->cell[0];
  Groots.dependrec_r = &Gchunks.dependrec_c->cell[0];
  Groots.handlerec_r = &Gchunks.handlerec_c->cell[0];
  Groots.probe_r = &Gchunks.probe_c->cell[0];
  Groots.press_r = &Gchunks.press_c->cell[0];
  Groots.index_r = &Gchunks.index_c->cell[0];
  Groots.litrllst_r = &Gchunks.litrllst_c->cell[0];
  Groots.foldrec_r = &Gchunks.foldrec_c->cell[0];
  Groots.pphandle_r = &Gchunks.pphandle_c->cell[0];

  Groots.argument_rr = NULL;
  Groots.linkact_rr = NULL;

  return TRUE;
}



litrlrec *NEW_litrlrec()
{
  litrlrec *newobj;
  litrlrec_chunk *newchunk;

  if (Groots.litrlrec_r == NULL) {
    newchunk = GET_litrlrec_chunk();
    newchunk->nxt = Gchunks.litrlrec_c;
    Gchunks.litrlrec_c = newchunk;
    Groots.litrlrec_r = &newchunk->cell[0];
  }
  newobj = Groots.litrlrec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_litrlrec ---\n");
  }
  newobj->mm.mark = USED;
  Groots.litrlrec_r = Groots.litrlrec_r->mm.nxt;
  return newobj;
}


linkrec *NEW_linkrec()
{
  linkrec *newobj;
  linkrec_chunk *newchunk;

  if (Groots.linkrec_r == NULL) {
    newchunk = GET_linkrec_chunk();
    newchunk->nxt = Gchunks.linkrec_c;
    Gchunks.linkrec_c = newchunk;
    Groots.linkrec_r = &newchunk->cell[0];
  }
  newobj = Groots.linkrec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_linkrec ---\n");
  }
  newobj->mm.mark = USED;
  Groots.linkrec_r = Groots.linkrec_r->mm.nxt;
  return newobj;
}


jointrec *NEW_jointrec()
{
  jointrec *newobj;
  jointrec_chunk *newchunk;

  if (Groots.jointrec_r == NULL) {
    newchunk = GET_jointrec_chunk();
    newchunk->nxt = Gchunks.jointrec_c;
    Gchunks.jointrec_c = newchunk;
    Groots.jointrec_r = &newchunk->cell[0];
  }
  newobj = Groots.jointrec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_jointrec ---\n");
  }
  newobj->mm.mark = USED;
  Groots.jointrec_r = Groots.jointrec_r->mm.nxt;
  return newobj;
}


dependrec *NEW_dependrec()
{
  dependrec *newobj;
  dependrec_chunk *newchunk;

  if (Groots.dependrec_r == NULL) {
    newchunk = GET_dependrec_chunk();
    newchunk->nxt = Gchunks.dependrec_c;
    Gchunks.dependrec_c = newchunk;
    Groots.dependrec_r = &newchunk->cell[0];
  }
  newobj = Groots.dependrec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_dependrec ---\n");
  }
  newobj->mm.mark = USED;
  Groots.dependrec_r = Groots.dependrec_r->mm.nxt;
  return newobj;
}


handlerec *NEW_handlerec()
{
  handlerec *newobj;
  handlerec_chunk *newchunk;

  if (Groots.handlerec_r == NULL) {
    newchunk = GET_handlerec_chunk();
    newchunk->nxt = Gchunks.handlerec_c;
    Gchunks.handlerec_c = newchunk;
    Groots.handlerec_r = &newchunk->cell[0];
  }
  newobj = Groots.handlerec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_handlerec ---\n");
  }
  newobj->mm.mark = USED;
  Groots.handlerec_r = Groots.handlerec_r->mm.nxt;
  return newobj;
}


probe *NEW_probe()
{
  probe *newobj;
  probe_chunk *newchunk;

  if (Groots.probe_r == NULL) {
    newchunk = GET_probe_chunk();
    newchunk->nxt = Gchunks.probe_c;
    Gchunks.probe_c = newchunk;
    Groots.probe_r = &newchunk->cell[0];
  }
  newobj = Groots.probe_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_probe ---\n");
  }
  newobj->mm.mark = USED;
  Groots.probe_r = Groots.probe_r->mm.nxt;
  return newobj;
}


press *NEW_press()
{
  press *newobj;
  press_chunk *newchunk;

  if (Groots.press_r == NULL) {
    newchunk = GET_press_chunk();
    newchunk->nxt = Gchunks.press_c;
    Gchunks.press_c = newchunk;
    Groots.press_r = &newchunk->cell[0];
  }
  newobj = Groots.press_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_press ---\n");
  }
  newobj->mm.mark = USED;
  Groots.press_r = Groots.press_r->mm.nxt;
  return newobj;
}


index *NEW_index()
{
  index *newobj;
  index_chunk *newchunk;

  if (Groots.index_r == NULL) {
    newchunk = GET_index_chunk();
    newchunk->nxt = Gchunks.index_c;
    Gchunks.index_c = newchunk;
    Groots.index_r = &newchunk->cell[0];
  }
  newobj = Groots.index_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_index ---\n");
  }
  newobj->mm.mark = USED;
  Groots.index_r = Groots.index_r->mm.nxt;
  return newobj;
}


litrllst *NEW_litrllst()
{
  litrllst *newobj;
  litrllst_chunk *newchunk;

  if (Groots.litrllst_r == NULL) {
    newchunk = GET_litrllst_chunk();
    newchunk->nxt = Gchunks.litrllst_c;
    Gchunks.litrllst_c = newchunk;
    Groots.litrllst_r = &newchunk->cell[0];
  }
  newobj = Groots.litrllst_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_litrllst ---\n");
  }
  newobj->mm.mark = USED;
  Groots.litrllst_r = Groots.litrllst_r->mm.nxt;
  return newobj;
}


foldrec *NEW_foldrec()
{
  foldrec *newobj;
  foldrec_chunk *newchunk;

  if (Groots.foldrec_r == NULL) {
    newchunk = GET_foldrec_chunk();
    newchunk->nxt = Gchunks.foldrec_c;
    Gchunks.foldrec_c = newchunk;
    Groots.foldrec_r = &newchunk->cell[0];
  }
  newobj = Groots.foldrec_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_foldrec ---\n");
  }
  newobj->mm.mark = USED;
  Groots.foldrec_r = Groots.foldrec_r->mm.nxt;
  return newobj;
}


pphandle *NEW_pphandle()
{
  pphandle *newobj;
  pphandle_chunk *newchunk;

  if (Groots.pphandle_r == NULL) {
    newchunk = GET_pphandle_chunk();
    newchunk->nxt = Gchunks.pphandle_c;
    Gchunks.pphandle_c = newchunk;
    Groots.pphandle_r = &newchunk->cell[0];
  }
  newobj = Groots.pphandle_r;
  if (newobj->mm.mark != FREED) {
    printf("--- NEW_pphandle ---\n");
  }
  newobj->mm.mark = USED;
  Groots.pphandle_r = Groots.pphandle_r->mm.nxt;
  return newobj;
}


argument_cell *NEW_argument(n)
     int n;
{
  argument_cell *newobj;
  argument_root *root;
  argument_chunk *newchunk;

  for (root = Groots.argument_rr; root != NULL; root = root->nxt)
    if (root->n == n)
      break;
  if (root == NULL) {
    root = (argument_root *) malloc(sizeof(argument_root));
    if (root == NULL) {
      printf("Can't get root pointer ! (NEW_argument)\n");
      exit(1);
    }
    root->n = n;
    root->argument_r = NULL;
    root->nxt = Groots.argument_rr;
    Groots.argument_rr = root;
  }
  if (root->argument_r == NULL) {
    newchunk = GET_argument_chunk(n);
    root->argument_r = &newchunk->argument_c[1];
  }
  newobj = root->argument_r;
  if (newobj[0].mm.mark > 0) {
    printf("--- NEW_argument (%d,%d) ---\n",
	   newobj[0].mm.mark, n);
  }
  newobj[0].mm.mark = n;
  root->argument_r = root->argument_r[0].mm.nxt;
  return &newobj[1];
}


linkact_cell *NEW_linkact(n)
     int n;
{
  linkact_cell *newobj;
  linkact_root *root;
  linkact_chunk *newchunk;

  for (root = Groots.linkact_rr; root != NULL; root = root->nxt)
    if (root->n == n)
      break;
  if (root == NULL) {
    root = (linkact_root *) malloc(sizeof(linkact_root));
    if (root == NULL) {
      printf("Can't get root pointer ! (NEW_linkact)\n");
      exit(1);
    }
    root->n = n;
    root->linkact_r = NULL;
    root->nxt = Groots.linkact_rr;
    Groots.linkact_rr = root;
  }
  if (root->linkact_r == NULL) {
    newchunk = GET_linkact_chunk(n);
    root->linkact_r = &newchunk->linkact_c[1];
  }
  newobj = root->linkact_r;
  if (newobj[0].mm.mark > 0) {
    printf("--- NEW_linkact (%d,%d) ---\n",
	   newobj[0].mm.mark, n);
  }
  newobj[0].mm.mark = n;
  root->linkact_r = root->linkact_r[0].mm.nxt;
  return &newobj[1];
}



varblrec *NEW_varblrec()
{
  varblrec *newobj;
  varblrec_chunk *newchunk;

  if (Gindices.varblrec_i >= NUM_OF_VARBLREC) {
    newchunk = GET_varblrec_chunk();
    newchunk->nxt = Gchunks.varblrec_c;
    Gchunks.varblrec_c = newchunk;
    Gindices.varblrec_i = 0;
  }
  newobj = &Gchunks.varblrec_c->cell[Gindices.varblrec_i++];
  return newobj;
}


bndngrec *NEW_bndngrec()
{
  bndngrec *newobj;
  bndngrec_chunk *newchunk;

  if (Gindices.bndngrec_i >= NUM_OF_BNDNGREC) {
    newchunk = GET_bndngrec_chunk();
    newchunk->nxt = Gchunks.bndngrec_c;
    Gchunks.bndngrec_c = newchunk;
    Gindices.bndngrec_i = 0;
  }
  newobj = &Gchunks.bndngrec_c->cell[Gindices.bndngrec_i++];
  return newobj;
}

conctrec *NEW_conctrec()
{
  conctrec *newobj;
  conctrec_chunk *newchunk;

  if (Gindices.conctrec_i >= NUM_OF_CONCTREC) {
    newchunk = GET_conctrec_chunk();
    newchunk->nxt = Gchunks.conctrec_c;
    Gchunks.conctrec_c = newchunk;
    Gindices.conctrec_i = 0;
  }
  newobj = &Gchunks.conctrec_c->cell[Gindices.conctrec_i++];
  return newobj;
}


arglst *NEW_arglst()
{
  arglst *newobj;
  arglst_chunk *newchunk;

  if (Gindices.arglst_i >= NUM_OF_ARGLST) {
    newchunk = GET_arglst_chunk();
    newchunk->nxt = Gchunks.arglst_c;
    Gchunks.arglst_c = newchunk;
    Gindices.arglst_i = 0;
  }
  newobj = &Gchunks.arglst_c->cell[Gindices.arglst_i++];
  return newobj;
}



void FREE_litrlrec(cell)
     litrlrec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_litrlrec ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.litrlrec_r;
  Groots.litrlrec_r = cell;
}


void FREE_linkrec(cell)
     linkrec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_linkrec ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.linkrec_r;
  Groots.linkrec_r = cell;
}


void FREE_jointrec(cell)
     jointrec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_jointrec ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.jointrec_r;
  Groots.jointrec_r = cell;
}


void FREE_dependrec(cell)
     dependrec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_dependrec ===\n");
  }
  cell->mm.mark= FREED;
  cell->mm.nxt = Groots.dependrec_r;
  Groots.dependrec_r = cell;
}


void FREE_handlerec(cell)
     handlerec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_handlerec ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.handlerec_r;
  Groots.handlerec_r = cell;
}


void FREE_probe(cell)
     probe *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_probe ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.probe_r;
  Groots.probe_r = cell;
}


void FREE_press(cell)
     press *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_press ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.press_r;
  Groots.press_r = cell;
}


void FREE_index(cell)
     index *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_index ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.index_r;
  Groots.index_r = cell;
}


void FREE_litrllst(cell)
     litrllst *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_litrllst ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.litrllst_r;
  Groots.litrllst_r = cell;
}


void FREE_foldrec(cell)
     foldrec *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_foldrec ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.foldrec_r;
  Groots.foldrec_r = cell;
}


void FREE_pphandle(cell)
     pphandle *cell;
{
  if (cell->mm.mark != USED) {
    printf("=== FREE_pphandle ===\n");
  }
  cell->mm.mark = FREED;
  cell->mm.nxt = Groots.pphandle_r;
  Groots.pphandle_r = cell;
}


void FREE_argument(cell)
     argument_cell *cell;
{
  int size;
  argument_root *root;

  cell--;
  size = cell[0].mm.mark;
  if (size < 0) {
    printf("=== FREE_argument (%d) ===\n", size);
  }
  for (root = Groots.argument_rr; root != NULL; root = root->nxt)
    if (root->n == size)
      break;
  if (root == NULL) {
    printf("+++ FREE_argument (%d) +++\n", size);
  }
  cell[0].mm.mark = -size;
  cell[0].mm.nxt = root->argument_r;
  root->argument_r = cell;
}


void FREE_linkact(cell)
     linkact_cell *cell;
{
  int size;
  linkact_root *root;

  cell--;
  size = cell[0].mm.mark;
  if (size < 0) {
    printf("=== FREE_linkact (%d) ===\n", size);
  }
  for (root = Groots.linkact_rr; root != NULL; root = root->nxt)
    if (root->n == size)
      break;
  if (root == NULL) {
    printf("+++ FREE_linkact (%d) +++\n", size);
  }
  cell[0].mm.mark = -size;
  cell[0].mm.nxt = root->linkact_r;
  root->linkact_r = cell;
}
