%{
#include "gram.h"
extern unsigned int yylval;
extern int mid_flg;
%}
char		(_|{upper}|{lower})
upper		[A-Z]
kanji		[\241-\376][\241-\376]
lower   	([0-9a-z]|{kanji})
/*
special		[&!#$%`()*+,\-./:;<=>?@@[\]^{|}~\\]
*/
special		[\&\!\#\$\%\`\(\)\*\+\,\-\.\/\:\;\<\=\>\?\@\[\]\^\{\|\}\~\\]
space		[\t\n\40]
strchar		({char}|{space}|{special}|\')
%%
{space} {};
\"({strchar}|\"\")*\"   {
			    yytext[strlen(yytext)-1] = '\0';
			    if (mid_flg)
			  	yylval = NewNode(&yytext[1], 1);
			    else
				yylval = NewRule(&yytext[1]);
			    return STRING; 
			}
"'&void'"		{ return VOID; }
"("         		{ return LPAR; }
")"        		{ return RPAR; }
"["         		{ return LSBRA; }
"]"         		{ return RSBRA; }
"{"         		{ return LCBRA; }
"}"         		{ return RCBRA; }
","         		{ return COMMA; }
%%

