/* Copyright	Massachusetts Institute of Technology	1987, 1988
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef _ModuleP_h
#define _ModuleP_h

#include "Module.h"
/* include superclass private header file */
#include <X11/ConstrainP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

typedef struct {
    int ignore;
} QxtModuleClassPart;

typedef struct _QxtModuleClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    QxtModuleClassPart	module_class;
} QxtModuleClassRec;

extern QxtModuleClassRec QxtmoduleClassRec;

typedef struct {
    Dimension	*array;
    int		size;
} ModuleOffset, *ModuleOffsetPtr;

typedef struct {
    /* resources */
    Dimension	hpad;
    Dimension	vpad;
    Dimension	line_width;
    Pixel	line_pixel;
    XtGravity	gravity;
    /* private state */
    GC		gc;
    Widget	module_root;
    Dimension	width;
    Dimension	height;
    ModuleOffsetPtr	horizontal;
    ModuleOffsetPtr	vertical;
} ModulePart;

typedef struct _QxtModuleRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    ModulePart		module;
} QxtModuleRec;

typedef struct _ModuleConstraintsPart {
    WidgetList	parents;
    int		level;
    int		n_parents;
    GC gc;				/* moduleGC/ModuleGC */
    WidgetList	children;
    int		n_children;
    int		max_children;
    Position	x, y;
} ModuleConstraintsPart;

typedef struct _ModuleConstraintsRec {
   ModuleConstraintsPart module;
} ModuleConstraintsRec, *ModuleConstraints;


/*
 * useful macros
 */

#define MODULE_CONSTRAINT(w) \
                   ((ModuleConstraints)((w)->core.constraints))

#define MODULE_HORIZONTAL_DEFAULT_SPACING 20
#define MODULE_VERTICAL_DEFAULT_SPACING 20

#endif /* _ModuleP_h */

