#include "lattice.h"

XtAppContext appContext;
Widget toplevel;

/*
 * fallback resources
 */
static char *fallbacks[] = {
"*highlightThickness:	    	0",
"*fontSet:		    	-*-fixed-medium-r-normal--14-*",
"*quit.label:			Quit",
"*close.label:			Close",
"*search.label:			Search",
"*RuleMenu.label:		Rules",
"*rule.justify:			left",
"*view.forceBars:		True",
"*view.width:			140",
"*view.height:			140",
"*view.forceBars:		True",
"*ListLocale.defaultColumns:	1",
"*ListLocale.borderWidth:	1",
"*ListLocale.forceColumns:	True",
"*ListLocale.pasteBuffer:	True",
"*searchList.defaultColumns:	1",
"*ruleList.height:		80",
"*box.orientation:		horizontal",
"*vPane.porthole.showGrip:	False",
"*hPane.orientation:		horizontal",
"*hPane.box.showGrip:             False",
"*vPane.Paned.preferredPaneSize:      80",
"*hPane.Panner.preferredPaneSize:      100",
"*ruleBox.defaultDistance:	0",
"*vPad: 40",
"*hPad: 10",
"*wrapCount: 10",
(char *)NULL,
};

/*
 * ץ
 */
static XrmOptionDescRec options[] = {
/* ֥̾ޤʤ֤λ */
    {"-wrap", 	  "*wrapCount",	XrmoptionSepArg, (caddr_t) NULL},
/* ֥̾κɽʸ */
    {"-max",      "*maxLength",	XrmoptionSepArg, (caddr_t) NULL},
};

#ifdef DEBUG
FILE *dbgfp;
#endif

main(argc, argv)
int argc;
char **argv;
{
#ifdef DEBUG
    dbgfp = fopen("/tmp/xlattice.log", "a");
    fprintf(dbgfp, "**** START xlattice ****\n");
    fflush(dbgfp);
#endif
#ifdef XI18N
    /* LANG  */
    (void)XtSetLanguageProc(NULL, NULL, NULL);
#endif
    toplevel = XtVaAppInitialize(&appContext, "Quixote", 
				 options, XtNumber(options),
				 &argc, argv, fallbacks, NULL);
    if (argc > 1) {
	XtDestroyApplicationContext(appContext);
	fprintf (stderr, "USAGE: \n");
	exit (1);
    }
    GetAppResources();

    /* ΡɥꥹȤν */
    InitNodeList();
    /* ɥκ */
    CreateWidgets();

    XtRealizeWidget(toplevel);

    /* ɥ礭Υå */
    CheckWindowSize();

    XtAppMainLoop(appContext);
}

CheckWindowSize()
{
    Arg args[4];
    int n = 0;
    Dimension width, height;
    Display *display = XtDisplay(toplevel);

    XtVaGetValues(toplevel, XtNwidth, &width, XtNheight, &height, NULL);

    if (width > DisplayWidth(display, DefaultScreen(display))) {
	XtSetArg(args[n], XtNwidth, 
		 DisplayWidth(display, DefaultScreen(display))); n++;
    }
    if (height > DisplayHeight(display, DefaultScreen(display))) {
	XtSetArg(args[n], XtNheight, 
		 DisplayHeight(display, DefaultScreen(display))); n++;
    }
    if (n > 0)
	XtSetValues(toplevel, args, n);

}

fatal(s)
char *s;
{
    fprintf(stderr, "%s!!!. \n", s);
    exit(-1);
}

