%{
#include "gram.h"
extern unsigned int yylval;
%}
char		(_|{upper}|{lower})
upper		[A-Z]
kanji		[\241-\376][\241-\376]
lower   	([0-9a-z]|{kanji})
/*
special		[&!#$%`()*+,\-./:;<=>?@@[\]^{|}~\\]
*/
special		[\&\!\#\$\%\`\(\)\*\+\,\-\.\/\:\;\<\=\>\?\@\[\]\^\{\|\}\~\\]
qatom		({char}|{special}|\")
%%
[\t\n\40] {};
{lower}{char}+		{ 
#ifdef DEBUG
			extern FILE *dbgfp;
			fprintf(dbgfp, "LEX: ATOM=%s\n", yytext);
#endif
    			yylval = pool(yytext, 1); 
			return ATOM; 
		        }
\'({qatom}|\'\')+\'     { 
			yylval = pool(yytext, 1); 
			return ATOM; 
			}
"("         		{ return LPAR; }
")"        		{ return RPAR; }
"["         		{ return LSBRA; }
"]"         		{ return RSBRA; }
"{"         		{ return LCBRA; }
"}"         		{ return RCBRA; }
","         		{ return COMMA; }
%%


