#include <stdio.h>
#include <X11/Xlocale.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/XawIm.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/LabelLc.h>
#include <X11/Xaw/CommandLc.h>
#include <X11/Xaw/MultiText.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>   
#include <X11/Xaw/Tree.h>   
#include <ctype.h>
#include "explanation.h"

static Widget tree, panner, porthole;

static void close(widget, closure, data)
    Widget widget;
    caddr_t closure;
    caddr_t data;
{
    XtUnmapWidget((Widget)closure);
    XtDestroyWidget((Widget)closure);
}

static void rule_callback(widget, closure, data)
    Widget widget;
    caddr_t closure;
    caddr_t data;
{
    extern Widget toplevel;
    Widget dialog, pane, box, text;
    Arg args[6];
    static XtCallbackRec callback_rec[2] = {{close, NULL }, {NULL, NULL}};
    char *get_rule(), *rule;

    rule = get_rule(closure);
    if (rule == NULL)
	return;
    dialog = XtCreatePopupShell(closure, wmShellWidgetClass, toplevel,
                                (ArgList)args, ZERO);
    pane = XtCreateManagedWidget("exp_pane", panedWidgetClass, dialog,
				 (ArgList) NULL, ZERO);
    box = XtCreateManagedWidget("exp_buttonbox", boxWidgetClass, pane,
				(ArgList) NULL, ZERO);
    callback_rec[0].closure = (XtPointer)dialog;
    XtSetArg(args[0], XtNcallback, callback_rec);
    XtSetArg(args[1], XtNlabel, "Close");
    (void) XtCreateManagedWidget("exp_close", commandLocaleWidgetClass, box,
				 args,TWO);

    XtSetArg(args[0], XtNstring, rule);
    XtSetArg(args[1], XtNscrollHorizontal, XawtextScrollWhenNeeded);
    XtSetArg(args[2], XtNscrollVertical, XawtextScrollWhenNeeded);
    XtSetArg(args[3], XtNheight, 200);
    XtSetArg(args[4], XtNwidth, 300);
    (void)XtCreateManagedWidget(NULL, multiTextWidgetClass, pane,
                                args, FIVE);
    XtPopup(dialog, XtGrabNone);
}

widget_addr create_node(tree, parent, label, rule_id, type)
    Widget tree, parent;
    String label;
    int type;
{
    Cardinal n;
    WidgetClass class;
    Arg args[6];
    static XtCallbackRec callback_rec[2] = {{rule_callback, NULL},
					    {NULL, NULL}};

    n = 0;
    XtSetArg(args[n], XtNtreeParent, parent); n++;
    switch (type) {
    case QxtSubgoal:
	XtSetArg(args[n], XtNlabel, label); n++;
	callback_rec[0].closure = (XtPointer)rule_id;
	XtSetArg(args[n], XtNcallback, callback_rec); n++;
	class = labelLocaleWidgetClass;
	break;
    case QxtRule:
	XtSetArg(args[n], XtNlabel, label); n++;
	callback_rec[0].closure = (XtPointer)rule_id;
	XtSetArg(args[n], XtNcallback, callback_rec); n++;
	XtSetArg(args[n], XtNshapeStyle, XmuShapeOval); n++;
	class = commandLocaleWidgetClass;
	break;
    case QxtFact:
	XtSetArg(args[n], XtNlabel, label); n++;
	callback_rec[0].closure = (XtPointer)rule_id;
	XtSetArg(args[n], XtNcallback, callback_rec); n++;
	XtSetArg(args[n], XtNshapeStyle, XmuShapeOval); n++;
	class = commandLocaleWidgetClass;
	break;
    case QxtInheritUp:
	XtSetArg(args[n], XtNlabel, " UP "); n++;
	XtSetArg(args[n], XtNshapeStyle, XmuShapeEllipse); n++;
	class = commandLocaleWidgetClass;
	break;
    case QxtInheritDown:
	XtSetArg(args[n], XtNlabel, "DOWN"); n++;
	XtSetArg(args[n], XtNshapeStyle, XmuShapeEllipse); n++;
	class = commandLocaleWidgetClass;
	break;
    case QxtMerge:
	XtSetArg(args[n], XtNlabel, "MEARGE"); n++;
	XtSetArg(args[n], XtNshapeStyle, XmuShapeEllipse); n++;
	class = commandLocaleWidgetClass;
	break;
    case QxtLookUp:
	XtSetArg(args[n], XtNlabel, label); n++;
	callback_rec[0].closure = (XtPointer)rule_id;
	XtSetArg(args[n], XtNcallback, callback_rec); n++;
	class = labelLocaleWidgetClass;
	break;
    default: /* use debug */
	fprintf(stderr, "illegal type in 'create_node():xexplanation.c'");
	return NULL;
    }
    return (widget_addr)XtCreateManagedWidget("node", class, tree, args, n);
}

static void 
PannerCallback(w, closure, report_ptr)
    Widget w;
    XtPointer closure, report_ptr;
{
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtVaSetValues(tree, XtNx, -report->slider_x,
                  XtNy, -report->slider_y, NULL);
}

static void 
PortholeCallback(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
{
    Arg args[10];
    Cardinal n = 0;
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtSetArg (args[n], XtNsliderX, report->slider_x); n++;
    XtSetArg (args[n], XtNsliderY, report->slider_y); n++;
    if (report->changed != (XawPRSliderX | XawPRSliderY)) {
        XtSetArg (args[n], XtNsliderWidth, report->slider_width); n++;
        XtSetArg (args[n], XtNsliderHeight, report->slider_height); n++;
        XtSetArg (args[n], XtNcanvasWidth, report->canvas_width); n++;
        XtSetArg (args[n], XtNcanvasHeight, report->canvas_height); n++;
    }
    XtSetValues (panner, args, n);
}

widget_addr create_explanation(tree_dialog)
    widget_addr *tree_dialog;
{
    Widget dialog, paned, pbox, mbox;
    Arg args[8];
    static XtCallbackRec callback_rec[2] = {{NULL, NULL }, {NULL, NULL}};
    extern Widget toplevel;

    dialog = XtCreatePopupShell("explanation", wmShellWidgetClass, toplevel,
                                (ArgList)args, ZERO);
    paned = XtCreateManagedWidget("exp_paned", panedWidgetClass, dialog,
				(ArgList) NULL, ZERO);
    XtSetArg(args[0], XtNorientation, XtorientHorizontal);
    XtSetArg(args[1], XtNborderWidth, 0);
    XtSetArg(args[2], XtNmin, 96);
    XtSetArg(args[3], XtNmax, 96);
    pbox = XtCreateManagedWidget("exp_pannerbox", panedWidgetClass, paned,
				args, FOUR);
    XtSetArg(args[0], XtNmin, 96);
    XtSetArg(args[1], XtNmax, 96);
    panner = XtCreateManagedWidget("exp_panner", pannerWidgetClass, pbox,
				   args, TWO);
    XtSetArg(args[0], XtNshowGrip, False);
    XtSetArg(args[1], XtNborderWidth, 0);
    mbox = XtCreateManagedWidget("exp_pannerbox", boxWidgetClass, pbox,
				 args, TWO);
    callback_rec[0].callback = (XtCallbackProc)close;
    callback_rec[0].closure = (XtPointer)dialog;
    XtSetArg(args[0], XtNcallback, callback_rec);
    XtSetArg(args[1], XtNlabel, "Close");
    (void)XtCreateManagedWidget("exp_close", commandLocaleWidgetClass, mbox,
				 args,TWO);

    XtSetArg(args[0], XtNshowGrip, False);
    porthole = XtCreateManagedWidget("porthole", portholeWidgetClass, paned,
				     args, ONE);
    XtSetArg(args[0], XtNborderWidth, 0);
    XtSetArg(args[1], XtNgravity, NorthGravity);
    tree = XtCreateManagedWidget("exp_tree", treeWidgetClass, porthole,
				 args, TWO);
    XtAddCallback(porthole,
		  XtNreportCallback, PortholeCallback, (XtPointer)panner);
    XtAddCallback(panner, 
                  XtNreportCallback, PannerCallback, (XtPointer)porthole);
    *tree_dialog = (widget_addr)dialog;
    return (widget_addr)tree;
}

void display_tree(dialog)
    widget_addr dialog;
{
    Dimension dialogWidth, dialogHeight, w, h;
    Screen *s;
    Cardinal n;
    Arg args[2];

    XtPopup((Widget)dialog, XtGrabNone);

    XtSetArg (args[0], XtNwidth, &dialogWidth);
    XtSetArg (args[1], XtNheight, &dialogHeight);
    XtGetValues(dialog, args, TWO);
    s = XtScreen(dialog);
    w = XWidthOfScreen(s)-64;
    h = XHeightOfScreen(s)-64;
    n = 0;
    if (dialogWidth > w) {
	XtSetArg(args[n], XtNwidth, w);
	n++;
    }
    if (dialogHeight > h) {
	XtSetArg (args[n], XtNheight, h);
	n++;
    }
    if (n > 0)
	XtSetValues(dialog, args, n);

}
