%{
#include "term.h"
#include "term_yacc.h"
extern char
	*strcpy(),
	*strncpy(),
	*strcat(),
	*strncat(),
	*strchr(),
	*strrchr(),
	*strpbrk(),
	*strtok(),
	*strdup();
extern char
	*memccpy(),
	*memchr(),
	*memcpy(),
	*memset();
extern int memcmp();
extern int
	strcmp(),
	strncmp(),
	strlen(),
	strspn(),
	strcspn();
%}
upper_char  [A-Z]
kanji       [\241-\376][\241-\376]
lower_char  [a-z0-9]|{kanji}
/*
lower_char  [a-z0-9]
*/
special     [\_\&\!\#\$\%\`\(\)\*\+\,\-\.\/\:\;\<\=\>\?\@\[\]\^\{\|\}\~\\]
white_space         [\t\n\40]
char_or_ws          {char}|{white_space}
special_without_dq  {special}|\'
special_without_q   {special}|\"
number      [0-9]
char        {upper_char}|{lower_char}
string_char  {char_or_ws}|{special_without_dq}
qatom_char   {char}|{special_without_q}
special_atom_char   [\&\!\#\$\*\+\/\-\:\<\=\>\?\@\^\~]
%%
{white_space}  {};
{number}+  { 
                        yylval.y_integer = new_integer(yytext); 
                        return INTEGER; }
{lower_char}({char}|_)*   {
                        yylval.y_atom = new_atom(yytext); 
                        return ATOM; }
_(_|{char})*   {
                        yylval.y_variable = new_variable(yytext); 
                        return VARIABLE; }
{upper_char}(_|{char})*   {
                        yylval.y_variable = new_variable(yytext); 
                        return VARIABLE; }
\"({string_char}|\"\")*\"   {
                        yylval.y_string = new_string(yytext); 
                        return STRING; }
\'({qatom_char}|\'\')+\' {
                        yylval.y_qatom = new_qatom(yytext); 
                        return QATOM; }
{special_atom_char}+      {
                        yylval.y_atom = new_atom(yytext); 
                        return ATOM; }

"("         { return LPAR; }
")"         { return RPAR; }
"["         { return LSBRA; }
"]"         { return RSBRA; }
"{"         { return LCBRA; }
"}"         { return RCBRA; }
","         { return COMMA; }
%%
