/*
Function
  "term.h" is included by Term access utility.

Modification History
  (01) 92.10.5 T.A.  created for term parser

Naming Convention
       Name      Expression   Example
	Identifier is_*          is_vector
	Type       [A-Z][a-z]+   Vector
	member     [a-z]+        vector
*/

/* term identifier */
typedef enum {
  is_vector=1, is_list, is_string, is_atom, is_qatom, is_integer, is_variable
  } Term_id;

/* Vector definition */

typedef struct Vector_tag {
  Term_id id;
  int     size;
  union Term_tag   *element;
} Vector;

extern Vector *new_vector();
extern Vector *list_to_vector();

/* List definition */
typedef struct List_tag {
  Term_id           id;
  union Term_tag    *head;
  struct List_tag   *tail;
} List;
#define NIL 0

extern List *new_list();
extern List *append_list();
extern int count_list();

/* string definition */
typedef struct String_tag {
  Term_id   id;
  int     size;
  char    *string;
} String;


extern String *new_string();

/* Atom definition */
typedef struct Atom_tag {
  Term_id  id;
  int     size;
  char    *string;
} Atom;

extern Atom *new_atom();

/* Qatom definition */
typedef struct Qatom_tag {
  Term_id  id;
  int     size;
  char    *string;
} Qatom;

extern Qatom *new_qatom();

/* Integer  Definition */
typedef struct Integer_tag {
  Term_id id;
  int     size;
  char    *string;
} Integer;

extern Integer *new_integer();

/* Variable Defintion */
typedef struct Variable_tag {
  Term_id id;
  int     size;
  char    *string;
} Variable;

extern Variable *new_variable();

/* Term definition */
typedef union Term_tag {
  Term_id id;
  Vector vector;
  List   list;
  String string;
  Atom   atom;
  Qatom  qatom;
  Integer integer;
  Variable variable;
} Term;
