/*
* 93. 1.11 by T.A add outputing \ before # and ? in print_atom
*/
#include "term.h"
extern char
	*strcpy(),
	*strncpy(),
	*strcat(),
	*strncat(),
	*strchr(),
	*strrchr(),
	*strpbrk(),
	*strtok(),
	*strdup();
extern char
	*memccpy(),
	*memchr(),
	*memcpy(),
	*memset();
extern int memcmp();
extern int
	strcmp(),
	strncmp(),
	strlen(),
	strspn(),
	strcspn();

print_lisp(term)
     Term *term;
{
  switch(term->id) {
  case is_vector:
    print_vector(term);
    break;
  case is_list:
    print_list(term);
    break;
  case is_string:
    print_string(term);
    break;
  case is_atom:
    print_atom(term);
    break;
  case is_qatom:
    print_qatom(term);
    break;
  case is_integer:
    print_integer(term);
    break;
  case is_variable:
    print_variable(term);
    break;
  default:
    printf("illegal input for unparse_term\n");
    break;
  };
}

print_vector(vector)
     Vector *vector;
{
  int i, size;
  size = vector->size;
  if(size == 0)
      printf("[]");
  else
    {
      printf("[");
      for(i=0; i < size-1;
	  print_lisp(vector->element+i),
	  i++,
	  printf(" ")
	  );
      print_lisp((vector->element)+size-1);
      printf("]");
    }
}

print_list(list)
     List *list;
{
  if(NIL==list->head)
    printf("()");
  else
    {
      printf("(");
      while(list->tail !=NIL)
	{ 
	  print_lisp(list->head);
	  printf(" ");
	  list = list->tail;
	};
      print_lisp(list->head);
      printf(")");
    };
}

print_integer(integer)
     Integer *integer;
{
  printf("%s", integer->string);
}

print_string(string)
     String *string;
{
  printf("%s", string->string);
}

print_atom(atom)
     Atom *atom;
{
  char*  c = atom->string;
  while (*c != '\0')
    {
      if ((*c == '#')|(*c =='?'))
	putchar('\\');
      putchar(*c);
     ++c;};
}

print_qatom(qatom)
     Qatom *qatom;
{
  char *string;
  string = (char *)malloc(qatom->size-1);
  *string = 0;
  strncat(string,  qatom->string+1, qatom->size-2);
  printf("%s", string);
  free(string);
}

print_variable(variable)
     Variable * variable;
{
  printf("%s", variable->string);
}
