typedef struct _ANY {
  char type;
  struct _ANY *prev_entry;
  struct _ANY *next_entry;

} ANY;

typedef enum { TYPE_WORD_LIST, TYPE_REDIRECT, TYPE_COMMAND } type_d;

typedef struct _WORD_LIST {
  char type;
  ANY *prev_entry;
  ANY *next_entry;

  char *word;
  struct _WORD_LIST *next;
} WORD_LIST;

typedef enum kind_of_redirect {input, output, output_append} input_mode;

typedef struct _REDIRECT {
  char type;
  ANY *prev_entry;
  ANY *next_entry;

  input_mode mode;
  char *file_name;
  struct _REDIRECT *next;
} REDIRECT;

typedef struct _COMMAND {
  char type;
  ANY *prev_entry;
  ANY *next_entry;

  int argc;
  char **argv;
  REDIRECT *redirect;
} COMMAND;

typedef struct _CommandEntry{
  char *name;
  char *path;
  char *doc1;
  char *doc2;
} CommandEntry;

#define QSHELL_DIRECTORY "/usr/local/qshell/"
#define QSHELL_CONFIG_FILE_NAME    "qsh.conf"

extern CommandEntry *command_table;
extern CommandEntry *ss_command_table, *db_command_table;
extern CommandEntry *ts_command_table, *is_command_table;

extern char *qshell_directory;
extern char *qshell_config_file_name;

extern int interactive;
extern COMMAND *command;

extern void qshell_timer_on ();
extern void qshell_timer_off ();
extern void qshell_quit ();
extern void qshell_help ();
extern void qshell_shell_command ();
extern void qshell_lcd ();
extern void qshell_take ();

extern int use_timer;
