#include <stdio.h>
#include <fcntl.h>
#include "qshell.h"
#include "qxt.h"

/*

  META COMMANDS

 */

CommandEntry metacommand_table[] = {
  {
    "help", NULL,
    "(this command). Try \"help command\" for long description",
    "Oh what a pity boy you are!\n\
I guess that you got a big problem and couldn't stop typing \"help help\".\n\
\n\
Unlucky for you, I haven't prepared any documents for such problems yet,\n\
because of my laziness. :-)\n\
\n\
Please send your message by e-mail.  Then, I could write FAQ for Qshell to\n\
show when user types \"help help\".\n\
\n\
My address is `m-gniibe@icot.or.jp'\n\
Thank you in advance."
  },
  {
    "lcd", NULL,
    "local change directory to DIRECTORY",
    "Change directory locally to DIRECTORY (first argument).\n\
To print local working directory, type \"shell pwd\""
  },
  {
    "quit", NULL,
    "Quit",
    "Disconnect server and quit qshell"
  },
  {
    "shell", NULL,
    "invoke Unix shell COMMAND",
    "Invoke Unix shell COMMAND (first argument)"
  },
  {
    "take", NULL,
    "run Qshell script in FILE",
    "run Qshell script in FILE.\n\
It is not possible to invoke this command with redirection."
  },
  {
    "timer-off", NULL,
    "timer off",
    "Timer off"
  },
  {
    "timer-on", NULL,
    "timer on",
    "Timer on"
  }
};

#define NUM_METACOMMANDS 7

void qshell_quit (command)
     COMMAND *command;
{
  close_connection ();
  exit (0);
}

void qshell_timer_on (command)
     COMMAND *command;
{
  use_timer = 1;
  putenv ("QXTTIMER=ON");
}

void qshell_timer_off (command)
     COMMAND *command;
{
  use_timer = 0;
  putenv ("QXTTIMER=OFF");
}

void qshell_help (command)
     COMMAND *command;
{
  char *topic;
  CommandEntry *ce;
  int i;

  if (command->argc > 1)
    {
      topic = command->argv[1];

      for (i=0; i<NUM_METACOMMANDS; i++)
	if (strcmp (metacommand_table[i].name, topic) == 0)
	  {
	    printf ("%s\n%s\n", metacommand_table[i].name,
		    metacommand_table[i].doc2);
	    return;
	  }

      for (ce = command_table; ce->name; ce++)
	if (strcmp (ce->name, topic) == 0)
	  printf ("%s\n%s\n", ce->name, ce->doc2);
    }
  else
    {
      for (i=0; i<NUM_METACOMMANDS; i++)
	printf ("%-15s\t%s\n", metacommand_table[i].name,
		metacommand_table[i].doc1);
      printf ("\n");
      for (ce = command_table; ce->name; ce++)
	printf ("%-15s\t%s\n", ce->name, ce->doc1);
    }
}

void qshell_take (command)
     COMMAND *command;
{
  FILE *stream;

  if (command->redirect)
    {
      fprintf (stderr, "It is prohibited to invoke take with redirection\n");
      return;
    }

  if (command->argc != 2)
    {
      fprintf (stderr, "Usage: take filename\n");
      return;
    }
  else
    {
      int old_interactive = interactive;

      stream = fopen (command->argv[1], "r");
      if (stream == NULL)
	{
	  fprintf (stderr, "Can't open file %s\n", command->argv[1]);
	  return;
	}

      interactive = 0;
      qshell_main_loop (stream);
      fclose (stream);
      interactive = old_interactive;
    }
}

void qshell_shell_command (command)
     COMMAND *command;
{
  int child_pid;
  int status;
  int stdin_fd=0, stdout_fd=0, stderr_fd=0;
  REDIRECT *redirect = command->redirect;

  while (redirect)
    {
      switch (redirect->mode)
	{
	case input:
	  stdin_fd = open (redirect->file_name, O_RDONLY);
	  if (stdin_fd < 0)
	    {
	      fprintf (stderr, "redirection failed: %s\n", redirect->file_name);
	      return;
	    }
	  break;
	case output:
	  stdout_fd = open (redirect->file_name, O_CREAT | O_TRUNC | O_WRONLY, 0666);
	  if (stdout_fd < 0)
	    {
	      fprintf (stderr, "redirection failed: %s\n", redirect->file_name);
	      return;
	    }
	  break;
	case output_append:
	  stdout_fd = open (redirect->file_name, O_CREAT | O_APPEND | O_WRONLY, 0666);
	  if (stdout_fd < 0)
	    {
	      fprintf (stderr, "redirection failed: %s\n", redirect->file_name);
	      return;
	    }
	  break;
	default:
	  abort ();
	  break;
	}

      redirect = redirect->next;
    }

  if (child_pid = fork ())
    { /* parent */
      if (child_pid < 0)
	fprintf (stderr, "Can't fork.\n");
      else
	{
	  wait (&status);
	  if (status & 0x0f)
	    fprintf (stderr, "Abnormal exit status.\n");
	}
    }
  else
    {
      if (stdin_fd)
	{
	  close (0);
	  dup (stdin_fd);
	  close (stdin_fd);
	}
      if (stdout_fd)
	{
	  close (1);
	  dup (stdout_fd);
	  close (stdout_fd);
	}
      if (stderr_fd)
	{
	  close (2);
	  dup (stderr_fd);
	  close (stderr_fd);
	}
      close (netin_fd);
      close (netout_fd);
      execvp (command->argv[1], (command->argv+1));
      fprintf (stderr, "Can't exec\n");
      exit (0);
    }
}

void qshell_lcd (command)
     COMMAND *command;
{
  char *directory;

  if (command->argc == 1)
    return; /* shuld go back to home directory ?? */
  else if (command->argc > 2)
    {
      fprintf (stderr, "lcd [directory]\n");
      return;
    }

  directory = command->argv[1];

  if (chdir (directory) < 0)
    {
      fprintf (stderr, "Can't chenge direcotry %s.\n");
    }
  return;
}
